from timeit import Timer

LOOPS = 25000

class f(object):

    def write(self, s):
        pass

    def flush(self):
        pass

    def readline(self):
        pass

class s(object):

    stdin = f()
    stdout = f()

_sys = s

def log(s):
    pass

def doit1(line):
    log(line)
    _sys.stdout.write(line)
    _sys.stdout.flush()
    log(line)

def doit2(line, write=_sys.stdout.write, flush=_sys.stdout.flush):
    log(line)
    write(line)
    flush()
    log(line)

out_write = _sys.stdout.write
out_flush = _sys.stdout.flush
def doit3(line):
    if 0:
        log(line)
    out_write(line)
    out_flush()
    if 0:
        log(line)

def test1():
    line = _sys.stdin.readline()
    for i in xrange(0, LOOPS):
        log(line)
        try:
            doit1(line)
        except:
            log('exception')
            raise
        line = _sys.stdin.readline()

def test2():
    readline = _sys.stdin.readline
    line = readline()
    for i in xrange(0, LOOPS):
        log(line)
        try:
            doit2(line)
        except:
            log('exception')
            raise
        line = readline()

in_readline = _sys.stdin.readline
def test3():
    line = in_readline()
    for i in xrange(0, LOOPS):
        if 0:
            log(line)
        try:
            doit3(line)
        except:
            if 0:
                log('exception')
            raise
        line = in_readline()

in_readline = _sys.stdin.readline
def test4():
    line = in_readline()
    try:
        for i in xrange(0, LOOPS):
            if 0:
                log(line)
            doit3(line)
            line = in_readline()
    except:
        if 0:
            log('exception')
        raise

if __name__ == '__main__':
    t = Timer('test1()', 'from __main__ import test1')
    print 'Results for test1'
    got = t.repeat(5, 1)
    print max(got), min(got)

    t = Timer('test2()', 'from __main__ import test2')
    print 'Results for test2'
    got = t.repeat(5, 1)
    print max(got), min(got)

    t = Timer('test3()', 'from __main__ import test3')
    print 'Results for test3'
    got = t.repeat(5, 1)
    print max(got), min(got)

    t = Timer('test4()', 'from __main__ import test4')
    print 'Results for test4'
    got = t.repeat(5, 1)
    print max(got), min(got)

    # Run again to make sure they didn't bomb and gone unnoticed
    test1()
    test2()
    test3()
    test4()
