# -*- coding: utf-8 -*-

#  SELF Platform: A distributed web application for collaborative
#  production of learning materials employing open standards.

#  Copyright (C) 2007, 2008 Free Software Foundation Europe e.V.

#  This file is part of the SELF Project, a project administered by the
#  SELF Consortium, for which FSFE acts as copyright holder.

#  The SELF Consortium are:
#    Internet Society Nederland
#    Universitat Oberta de Catalunya
#    Free Software Foundation Europe
#    University of Gothenburg
#    Internet Society Bulgaria
#    Fundacion Via Libre
#    Homi Bhabha Centre for Science Education

#  A complete list of authors can be found in the file AUTHORS.

#  This program is Free Software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.

#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
#  02110-1301, USA.

#  The licensor of SELF Platform is the Free Software Foundation
#  Europe (FSFE), Fiduciary Program, Sumatrastrasse 25, 8006 Zurich,
#  Switzerland, email:ftf@fsfeurope.org.

__docformat__ = 'plaintext'

from datetime import datetime
import os, sys
import psycopg2
import psycopg2.extensions
import psycopg2.extras
import difflib,string
from genericTable import *
from set_checks import *
from gbattributes import *
from gbattributetypes import *


class gbMethods:
    def __init__( self, conString ):

        self.conString = conString
        conString = self.conString
        self.conn = psycopg2.connect(conString)
        self.cur = self.conn.cursor()

    def updateDatatype( self, ssid, newDatatypeName ):
        gbat = gbattributetypes(self.conString)
        gbat.updateDatatype( ssid, newDatatypeName )
        return "suucess"

    def updateSSIDStatus( self, ssid, status ):

        query = "SELECT nodename FROM view_nidinidssid WHERE ssid=%s;" % ssid
        print query
        self.cur.execute( query )
        res = self.cur.fetchall()
        nodename = res[0][0]

        s = storageSpec()
        flddef = s.dictTNamesFDefs[ nodename ]['status']

        obj = tbl_nodetype( self.cur )
        ntid = obj.getntid( nodename )

        dtobj = tbl_datatypes( self.cur )
        dtid = dtobj.getdtid( 'varchar' )

        ft = tbl_field( self.cur, flddef )
        fid = ft.insert( { 'ntid':ntid, 'datatypeid':dtid, 'value':status } )

        updatequery = "UPDATE %s SET status=%s WHERE ssid=%s" % ( nodename, fid, ssid )
        print updatequery
        self.cur.execute( updatequery )
        self.conn.commit()

    def updateSSIDSubtypeOf( self, ssid, subtypeof ):

        query = "SELECT nodename FROM view_nidinidssid WHERE ssid=%s;" % ssid
        print query
        self.cur.execute( query )
        res = self.cur.fetchall()
        nodename = res[0][0]

        s = storageSpec()
        flddef = s.dictTNamesFDefs[ nodename ]['subtypeof']

        obj = tbl_nodetype( self.cur )
        ntid = obj.getntid( nodename )

        dtobj = tbl_datatypes( self.cur )
        dtid = dtobj.getdtid( 'int8[]' )

        print flddef
        ft = tbl_field( self.cur, flddef )
        fid = ft.insert( { 'ntid':ntid, 'datatypeid':dtid, 'value':subtypeof } )

        updatequery = "UPDATE %s SET subtypeof=%s WHERE ssid=%s" % ( nodename, fid, ssid )
        print updatequery
        self.cur.execute( updatequery )
        self.conn.commit()


    def getTitleFromSSID(self, ssid, nodetype):
		"""
		"""
		cur = self.cur
                if nodetype == 'gbusers':
                    queryResult = cur.execute("select title from djview_u where uid = " + str(ssid) + ";")
                elif nodetype == 'gbobjecttypes':
                    queryResult = cur.execute("select title from djview_ot where ssid = " + str(ssid) + ";")
                elif nodetype == 'gbobjects':
                    queryResult = cur.execute("select title from djview_o where ssid = " + str(ssid) + ";")
                else:
                    queryResult = []
                    return queryResult
	
		queryResult = cur.fetchall()

		try:
			queryResult = queryResult[0][0][0]
		except:
			queryResult = []

		return queryResult
            
    def geturifromSSID(self, ssid, nodetype):
		"""
		"""
		cur = self.cur
                if nodetype == 'gbusers':
                    queryResult = cur.execute("select uri from djview_u where uid = " + str(ssid) + ";")
                elif nodetype == 'gbobjecttypes':
                    queryResult = cur.execute("select uri from djview_ot where ssid = " + str(ssid) + ";")
                elif nodetype == 'gbobjects':
                    queryResult = cur.execute("select uri from djview_o where ssid = " + str(ssid) + ";")
                else:
                    queryResult = []
                    return queryResult
	
		queryResult = cur.fetchall()
                print queryResult
		try:
			queryResult = queryResult[0][0]
		except:
			queryResult = []

		return queryResult

    def getnidfromssid(self, ssid, nodetype):
		"""
		"""
		cur = self.cur
                if nodetype == 'gbusers':
                    queryResult = cur.execute("select uid from djview_u where uid = " + str(ssid) + ";")
                elif nodetype == 'gbobjecttypes':
                    queryResult = cur.execute("select nid from djview_ot where ssid = " + str(ssid) + ";")
                elif nodetype == 'gbobjects':
                    queryResult = cur.execute("select nid from djview_o where ssid = " + str(ssid) + ";")
                else:
                    queryResult = []
                    return queryResult
	
		queryResult = cur.fetchall()

		try:
			queryResult = queryResult[0][0]
		except:
			queryResult = []

		return queryResult

    def getUserIdfromUsername(self, uname):
		"""
		"""
		cur = self.cur
                
                username = "'"+uname+"'"
                fldname = 'inid'
                colname = 'nid'
                tblname = 'djview_u'
                
                querystr = "select %s from %s where %s=%s ;" %(fldname,tblname,colname,username)
                print querystr
                
                queryResult = cur.execute(querystr)

		queryResult = cur.fetchall()
                print queryResult

		try:
			queryResult = queryResult[0][0]
                        print queryResult
		except:
			queryResult = '1'

		return queryResult

    def getUsernamefromUserId(self, uid):
		"""
		"""
		cur = self.cur
                
                #username = "'"+uname+"'"
                userid=str(uid)
                fldname = 'nid'
                colname = 'inid'
                tblname = 'djview_u'
                
                querystr = "select %s from %s where %s=%s ;" %(fldname,tblname,colname,userid)
                print querystr
                
                queryResult = cur.execute(querystr)

		queryResult = cur.fetchall()
                print queryResult

		try:
			queryResult = queryResult[0][0]
                        print queryResult
		except:
			queryResult = '1'

		return queryResult

    def strValidate(self, valuestr):
		"""
		"""
                resultstr = ""
                for x in valuestr:
                    if x == "'":
                        resultstr = resultstr + x + "'"
                    else:
                        resultstr = resultstr + x

		return resultstr
            
    def getlatestVersion(self, nid):
		"""
		"""
                obj = def_set_checks()
                ssid = int(str(obj.get_ssid_from_nid(nid, self.cur)[-1]))

		return ssid
            
    def getAllsnapshots(self, ssid, nodeType):
		"""
		"""

                lstofssid = []
                
                obj = def_set_checks()
                nid = self.getnidfromssid(ssid, nodeType)
                
                lstofssid = obj.get_ssid_from_nid(nid, self.cur)

		return lstofssid
    
            
    def getAll(self, nodeType):
		"""
		"""
                if nodeType == 'gbusers':
                    viewname = 'djview_u'
                    
                elif nodeType == 'gbusertypes':
                    viewname = 'djview_ut'

                elif nodeType == 'gbobjecttypes':
                    viewname = 'djview_ot'

                elif nodeType == 'gbobjects':
                    viewname = 'djview_o'

                elif nodeType == 'gbattributetypes':
                    viewname = 'djview_at'

                elif nodeType == 'gbattributes':
                    viewname = 'djview_a'

                elif nodeType == 'gbrelations':
                    viewname = 'djview_r'

                elif nodeType == 'gbrelationtypes':
                    viewname = 'djview_rt'

                else:
                    print "Invalid Node Type Entered"
                    nl = {}
                    return nl
                    
                #get All Column
                
                query = "SELECT column_name FROM information_schema.columns WHERE table_name='%s';" % ( viewname )
                print query

                self.cur.execute( query )
                cols = self.cur.fetchall()
                
                lstColNames = []
                for fld in cols:
                    lstColNames.append( fld[0] )
                                                                                                         
                strSelCols = ", " . join( lstColNames )

                selectQuery = 'SELECT %s FROM %s ORDER BY ssid DESC;' % ( strSelCols, viewname )
                print selectQuery
                    
                self.cur.execute( selectQuery )
                res = self.cur.fetchall()
                resDict = []

                tmpdtobj = datetime.now()

                for r in res:
                    i=0
                    tmpDict = {}
                    for c in r:
                        val = c
                        # hack to prevent marshalling error
                        if type( c ) == type( tmpdtobj ):
#                             print "date time found!"
                            val = c.strftime( "%d %B %Y %I:%M:%S %p %Z" )

#                         if lstColNames[i] == 'content':
#                             val = unicode( c )

                        tmpDict[ lstColNames[i] ] = val
                        i=i+1
                    resDict.append( tmpDict )

		return resDict

    def xGetAll( self, nodeType ):
		"""
                Function specifically for XML RPC
                Gets all SSIDs
		"""
                tables = { 
                    'gbattributes':'a', 
                    'gbattributetypes':'at', 
                    'gbobjects':'o', 
                    'gbobjecttypes':'ot', 
                    'gbrelations':'r', 
                    'gbrelationtypes':'rt',
                    'gbusertypes':'ut',
                    'gbusers':'u',
                    'gbmetatypes':'mt',
                    }
                
                selCols = [ 'ssid', 'nid', 'title' ]
                strSelCols = ", " . join( selCols )
                selectQuery = 'SELECT %s FROM djview_%s ORDER BY ssid DESC;' % ( strSelCols, tables[ nodeType ] )
                print selectQuery

                self.cur.execute( selectQuery )
                res = self.cur.fetchall()
                resDict = []

                tmpdtobj = datetime.now()

                for r in res:
                    i=0
                    tmpDict = {}
                    for c in r:
                        tmpDict[ selCols[i] ] = c
                        i=i+1
                    resDict.append( tmpDict )

		return resDict

    
    def getinfoFromSSID(self, ssid, nodeType):
		"""
		"""
                if nodeType == 'gbusers':
                    viewname = 'djview_u'
                    
                elif nodeType == 'gbusertypes':
                    viewname = 'djview_ut'

                elif nodeType == 'gbobjecttypes':
                    viewname = 'djview_ot'

                elif nodeType == 'gbobjects':
                    viewname = 'djview_o'

                elif nodeType == 'gbattributetypes':
                    viewname = 'djview_at'

                elif nodeType == 'gbattributes':
                    viewname = 'djview_a'

                elif nodeType == 'gbrelations':
                    viewname = 'djview_r'

                elif nodeType == 'gbrelationtypes':
                    viewname = 'djview_rt'

                else:
                    print "Invalid Node Type Entered"
                    nl = {}
                    return nl
                    
                #get All Column
                
                query = "SELECT column_name FROM information_schema.columns WHERE table_name='%s';" % ( viewname )
                print query

                self.cur.execute( query )
                cols = self.cur.fetchall()
                
                lstColNames = []
                for fld in cols:
                    lstColNames.append( fld[0] )
                                                                                                         
                strSelCols = ", " . join( lstColNames )

                selectQuery = 'SELECT %s FROM %s where ssid=%s;' % ( strSelCols, viewname, ssid )
                print selectQuery
                    
                self.cur.execute( selectQuery )
                res = self.cur.fetchall()
                resDict = []

                tmpdtobj = datetime.now()
                for r in res:
                    i=0
                    tmpDict = {}
                    for c in r:
                        val = c
                        # hack to prevent marshalling error
                        if type( c ) == type( tmpdtobj ):
#                             print "date time found!"
                            val = c.strftime( "%d %B %Y %I:%M:%S %p %Z" )
                        
                        tmpDict[ lstColNames[i] ] = val
                        i=i+1
                    resDict.append( tmpDict )
                
		return resDict


    def getSubjects(self, ssid, relationType):
		"""
		"""
                cur = self.cur
                
                queryResult = cur.execute("select subject1,subject2,relationtypes from djview_r where ssid = " + str(ssid) + ";")
		queryResult = cur.fetchall()
                print queryResult

		try:
			queryResult = queryResult[0]
                        print queryResult
		except:
			queryResult = '1'

                print "From DB",str(int(queryResult[2][0]))
                

                reltype = self.getlatestVersion(relationType)
                print "From User",str(reltype)
                
                sublst = []
                if str(reltype) == str(int(queryResult[2][0])):
                    sublst.append(str(int(queryResult[0])))
                    sublst.append(str(int(queryResult[1])))
                    sublst.append(str(int(queryResult[2][0])))
                    return sublst
                else:
                    nf = []
                    return nf

    def getAllSubjects( self, lstSSID, relationType ):
		"""
                gets the subjects of all the SSIDs passed **must have the same relationType**
		"""
                cur = self.cur

                queryResult = self.getAllSSIDCols( lstSSID, [ 'subject1', 'subject2', 'relationtypes' ], 'gbrelations' )

                reltype = self.getlatestVersion( relationType )

                print queryResult

                lstRes = {}
                for r in queryResult.values():
                    lstRes[ str( r['ssid'] ) ] = [ r['subject1'], r['subject2'], r['relationtypes'] ]

                return lstRes
		
    def getVersiontree(self, ssid):
		"""
		"""
                
                lstofssid = []
                cvslst = []
                
                cur = self.cur
                nid = self.getnidfromssid(ssid, 'gbobjects')

                obj = def_set_checks()
                lstofssid = obj.get_ssid_from_nid(nid, cur)
                print lstofssid

                p = {}
                for x in lstofssid:

                    lsthistory = []
                    
                    p = self.getinfoFromSSID(str(int(x)),'gbobjects')[0]
                    lsthistory = p['history']
                    print lsthistory
                    cvslst.append([p['noofcommits'],p['noofchangesaftercommit'],lsthistory,x])
                    
                    # if int(p['noofcommits']) > 0:
#                         cvslst.append([p['noofcommits'],p['noofchangesaftercommit'],lsthistory,x])
                        
#                     if int(p['noofcommits']) == 0 and int(p['noofchangesaftercommit']) == 0:
#                         cvslst.append([p['noofcommits'],p['noofchangesaftercommit'],lsthistory,x])

                vflst = []
                k = []
                for y in cvslst:
                    k = y[2]
                    k.append(y[3])
                    vflst.append(k)

                
                cplst = []
                for z in vflst:
                    for p in range(len(z)-1):
                        tmp = []
                        print "child is",z[p+1]
                        print "parent is",z[p]
                        tmp.append(str(z[p+1]))
                        tmp.append(str(z[p]))
                        print tmp
                        if tmp not in cplst:
                            cplst.append(tmp)
                        print "Adding into final list",cplst
                        
                print "list ----", cplst
                if len(cplst) == 1:
                    return cplst
                
                pl = []
                for x in cplst:
                    for o in cplst:
                        if x[1] == o[0]:
                            if [x[1],o[1]] not in pl:
                                pl.append([x[1],o[1]])
        
                finallist = []
                
                for x in pl:
                    tmp = []
                    for y in cplst:
                        if y[1] == x[0]:
                            tmp.append(y[0])

    
                    finallist.append([x,tmp])

                
                treelst = []
                treelst.append(finallist[0][0])
                
                for ctr in finallist:
                    if len(ctr[1]) > 1:
                        for xl in ctr[1]:
                            tmp = []
                            tmp.append(xl)
                            tmp.append(ctr[0][0])
                            treelst.append(tmp)
                    else:
                        tmp = []
                        tmp.append(ctr[1][0])
                        tmp.append(ctr[0][1])
                        treelst.append(tmp)
                        
                print treelst
                return treelst
            
                                                
                
    def getAllCommitedVersions(self, ssid):

                """
		"""
                
                lstofssid = []
                cvslst = []
                
                cur = self.cur
                nid = self.getnidfromssid(ssid, 'gbobjects')

                obj = def_set_checks()
                lstofssid = obj.get_ssid_from_nid(nid, cur)
                print lstofssid

                p = {}
                for x in lstofssid:

                    lsthistory = []
                    
                    p = self.getinfoFromSSID(str(int(x)),'gbobjects')[0]
                    lsthistory = p['history']
                                                            
                    if int(p['noofcommits']) > 0 and int(p['noofchangesaftercommit']) == 0:
                        cvslst.append(x)
                        
                    if int(p['noofcommits']) == 0 and int(p['noofchangesaftercommit']) == 0:
                        cvslst.append(x)
                newlst = []
                cnt = len(cvslst)-1
                while cnt <> 0:
                    newlst.append(cvslst[cnt])
                    cnt = cnt -1
                    
                return newlst


    def isnidExists(self, nidStr):

                """
		"""
                vt = tbl_values( self.cur, '', 'varchar' )
                e = vt.exists( nidStr )

                if( e == 0 ):
                    """ doesn't exist """
                    return 0
                else:
                    """ exists """
                    return 1

    def getAllLatestSSIDsFromNids( self, lstNid ):
        gt = genericTable( self.cur, 'gbobjecttypes' )
        return gt.getLatestSSIDFromNid( lstNid )

    def getLatestSSIDFromNidNT( self, nid, nodetype ):
        gt = genericTable( self.cur, 'gbobjects' )
        return gt.getLatestSSIDFromNidNT( nid, nodetype )


    def getAllSSIDs( self, lstSSID, nodeType ):
        """
        Gets information of the entire list of SSIDs at once
        """
        nodeViewMap = { 
            'gbattributes':'a', 
            'gbattributetypes':'at', 
            'gbobjects':'o', 
            'gbobjecttypes':'ot', 
            'gbrelations':'r', 
            'gbrelationtypes':'rt',
            'gbusertypes':'ut',
            'gbusers':'u',
            'gbmetatypes':'mt',
        }

        if nodeType in nodeViewMap.keys():
            viewName = "djview_%s" % nodeViewMap[ nodeType ]
            gt = genericTable( self.cur, nodeType )
            return gt.getAllBySSID( viewName, lstSSID, nodeType )
        else:
            print "Error! Invalid nodetype passed: %s" % nodeType
            return 0

    def getAllSSIDCols( self, lstSSID, lstcols, nodeType ):
        """
        Gets information of the entire list of SSIDs at once BUT only
        the required columns
        """
        nodeViewMap = { 
            'gbattributes':'a', 
            'gbattributetypes':'at', 
            'gbobjects':'o', 
            'gbobjecttypes':'ot', 
            'gbrelations':'r', 
            'gbrelationtypes':'rt',
            'gbusertypes':'ut',
            'gbusers':'u',
            'gbmetatypes':'mt',
        }

        if nodeType in nodeViewMap.keys():
            viewName = "djview_%s" % nodeViewMap[ nodeType ]
            gt = genericTable( self.cur, nodeType )
            ret = gt.getAllBySSIDCols( viewName, lstcols, lstSSID, nodeType )
            print ret
            return ret
        else:
            print "Error! Invalid nodetype passed: %s" % nodeType
            return 0

    def getAllResourcesofUser( self, uid ):
        """
        Get SSID of the resource of given user
        """

        cur = self.cur

        imgresid = "'{" + str(self.getlatestVersion('image')) + "}'"
        audiresid ="'{" + str(self.getlatestVersion('audio')) + "}'"
        vidresid = "'{" + str(self.getlatestVersion('video')) + "}'"
        otherresid = "'{" + str(self.getlatestVersion('otherResources')) + "}'"
        
        queryResult = cur.execute("select nid from djview_o where uid = "+ str(uid) +" and (instanceof = "+imgresid+" or instanceof = "+audiresid+" or instanceof = "+vidresid+" or instanceof = "+otherresid+");")
        
        queryResult = cur.fetchall()

        finalreslst = []

        try:
            if queryResult <> []:
                for x in queryResult:
                    lv = self.getlatestVersion(x[0])
                    if lv not in finalreslst:
                        finalreslst.append(lv)
            else:
                finalreslst = []
        except:
            
            finalreslst = []

        return finalreslst
            

    def getNodetype( self, ssid ):
        """
        Get NodeType for a given ssid
        """

        cur = self.cur

        queryResult = cur.execute("select nodename from view_nidinidssid where ssid = "+ str(ssid) +";")
        
        queryResult = cur.fetchall()

        return queryResult[0][0]

    def make_string_safe( self, value ):
        if isinstance( value, str ):
            return value.replace( "'", "''" )

        return value

    
    def searchMaterial_new( self, searchstr, langcode):
        """
        modified search for Material Search
        """
        tmplst = []
        cur = self.cur
        

        newsearchstr = searchstr.lower()
        newsearchstr1 = newsearchstr.replace(' ','|')
        newsearchstr1 = self.make_string_safe( newsearchstr1 )

        newsearchstr2 = newsearchstr.replace(' ','%')
        newsearchstr2 = self.make_string_safe( newsearchstr2 )


        coursesid = "'{" + str(self.getlatestVersion('Courses')) + "}'"
        contentsid ="'{" + str(self.getlatestVersion('Content')) + "}'"

        gloassarysid ="'{" + str(self.getlatestVersion('Glossary')) + "}'"
        linksid ="'{" + str(self.getlatestVersion('Links')) + "}'"
        
        faqtopicsid ="'{" + str(self.getlatestVersion('FaqTopics')) + "}'"
        faqentriessid ="'{" + str(self.getlatestVersion('FaqEntries')) + "}'"
        
        testsid ="'{" + str(self.getlatestVersion('Tests')) + "}'"
        oquestsid ="'{" + str(self.getlatestVersion('ObjectiveQuestions')) + "}'"
        mcquestsid ="'{" + str(self.getlatestVersion('MultipleChoiceQuestions')) + "}'"
        tfquestsid ="'{" + str(self.getlatestVersion('TrueFalseQuestions')) + "}'"
        descquestsid ="'{" + str(self.getlatestVersion('DescriptiveQuestions')) + "}'"
        

        print coursesid, contentsid

        #queryResult = cur.execute("select ssid, title, description, nid, noofcommits, noofchangesaftercommit, instanceof from djview_o where (instanceof = "+coursesid+" or instanceof = "+contentsid+") and (lower(title[1]) similar to '%("+newsearchstr+")%' or lower(description) similar to '%("+newsearchstr+")%');")

        percent = "%"
        bracket1 = "("
        bracket2 = ")"

        #queryResult = cur.execute("select ssid, title, description, nid, noofcommits, noofchangesaftercommit, instanceof from djview_o WHERE (instanceof = "+coursesid+" or instanceof = "+contentsid+") and ((to_tsvector( '%s', lower(title[1]) || lower(description) ) @@ to_tsquery( '%s','%s' )) or (lower(title[1]) like '%s%s%s' or lower(description) like '%s%s%s'));" % (str(langcode), str(langcode), newsearchstr, percent, newsearchstr, percent, percent, newsearchstr, percent)) 
        
        queryResult = cur.execute("select ssid, title, description, nid, noofcommits, noofchangesaftercommit, instanceof from djview_o WHERE (instanceof = "+coursesid+" or instanceof = "+gloassarysid+" or instanceof = "+linksid+" or instanceof = "+faqtopicsid+" or instanceof = "+faqentriessid+" or instanceof = "+testsid+" or instanceof = "+mcquestsid+" or instanceof = "+tfquestsid+" or instanceof = "+descquestsid+") and ((to_tsvector( '%s', lower(title[1]) || lower(description) ) @@ to_tsquery( '%s','%s' )) or (lower(title[1]) similar to '%s%s%s%s%s' or lower(description) similar to '%s%s%s%s%s'));" % (str(langcode), str(langcode), newsearchstr2, percent, bracket1, newsearchstr1, bracket2, percent, percent, bracket1, newsearchstr1, bracket2, percent)) 

        queryResult = cur.fetchall()
        print "This is the Result:",queryResult
        
        # getting the latest versions of the searched elemnet

        lstofssid = []
        tmplst = []
        

        if queryResult <> []:
            for x in queryResult:
                print x[0]
                print x[1][0]
                vinfo = ""
                vinfo = str(x[4])+"."+str(x[5])
                lvs = self.getlatestVersion(str(x[3]))
                if lvs in tmplst:
                    print "its in tmplst"
                else:
                    lstofssid.append([x[0],x[1][0],vinfo])
                    tmplst.append(lvs)
        else:
            lstofssid = []
            return lstofssid

        print "Final List is :", lstofssid
        return lstofssid
    
    def searchResources_new( self, searchstr, langcode):
        """
        modified search for Resources
        """
        tmplst = []
        cur = self.cur

        newsearchstr = searchstr.lower()
        newsearchstr1 = newsearchstr.replace(' ','|')
        newsearchstr1 = self.make_string_safe( newsearchstr1 )

        newsearchstr2 = newsearchstr.replace(' ','%')
        newsearchstr2 = self.make_string_safe( newsearchstr2 )



        imgresid = "'{" + str(self.getlatestVersion('image')) + "}'"
        audiresid ="'{" + str(self.getlatestVersion('audio')) + "}'"
        vidresid = "'{" + str(self.getlatestVersion('video')) + "}'"
        otherresid = "'{" + str(self.getlatestVersion('otherResources')) + "}'"

        
        #queryResult = cur.execute("select ssid, title, description, nid, noofcommits, noofchangesaftercommit  from djview_o where (instanceof = "+imgresid+" or instanceof = "+audiresid+" or instanceof = "+vidresid+" or instanceof = "+otherresid+") and (to_tsvector( 'english', title[1] || description ) @@ to_tsquery( 'english','%s' ));" % self.make_string_safe( newsearchstr ) )         


        percent = "%"
        bracket1 = "("
        bracket2 = ")"

        
        queryResult = cur.execute("select ssid, title, description, nid, noofcommits, noofchangesaftercommit  from djview_o where (instanceof = "+imgresid+" or instanceof = "+audiresid+" or instanceof = "+vidresid+" or instanceof = "+otherresid+") and ((to_tsvector( '%s', lower(title[1]) || lower(description) ) @@ to_tsquery( '%s','%s' )) or (lower(title[1]) similar to '%s%s%s%s%s' or lower(description) similar to '%s%s%s%s%s'));" % (str(langcode), str(langcode), newsearchstr2, percent, bracket1, newsearchstr1, bracket2, percent, percent, bracket1, newsearchstr1, bracket2, percent)) 
        

        queryResult = cur.fetchall()
        print queryResult
        
        # getting the latest versions of the searched elemnet

        lstofssid = []
        tmplst = []
        

        if queryResult <> []:
            for x in queryResult:
                print x[0]
                print x[1][0]
                vinfo = ""
                vinfo = str(x[4])+"."+str(x[5])
                lvs = self.getlatestVersion(str(x[3]))
                if lvs in tmplst:
                    print "its in tmplst"
                else:
                    lstofssid.append([x[0],x[1][0],vinfo])
                    tmplst.append(lvs)
        else:
            lstofssid = []
            return lstofssid

        return lstofssid

    def globalsearchMaterial_new( self, searchstr, langcode ):
        """
        modified search for global material search
        """


        newsearchstr = searchstr.lower()
        newsearchstr1 = newsearchstr.replace(' ','|')
        newsearchstr1 = self.make_string_safe( newsearchstr1 )

        newsearchstr2 = newsearchstr.replace(' ','%')
        newsearchstr2 = self.make_string_safe( newsearchstr2 )

        percent = "%"
        bracket1 = "("
        bracket2 = ")"

        
        tmplst = []
        tmp2lst = []
        cur = self.cur

        imgresid = "'{" + str(self.getlatestVersion('image')) + "}'"
        audiresid ="'{" + str(self.getlatestVersion('audio')) + "}'"
        vidresid = "'{" + str(self.getlatestVersion('video')) + "}'"
        otherresid = "'{" + str(self.getlatestVersion('otherResources')) + "}'"

        queryResult2 = cur.execute("select ssid, title, description, nid, noofcommits, noofchangesaftercommit  from djview_o where (instanceof = "+imgresid+" or instanceof = "+audiresid+" or instanceof = "+vidresid+" or instanceof = "+otherresid+") and ((to_tsvector( '%s', lower(title[1]) || lower(description) ) @@ to_tsquery( '%s','%s' )) or (lower(title[1]) similar to '%s%s%s%s%s' or lower(description) similar to '%s%s%s%s%s'));" % (str(langcode), str(langcode), newsearchstr2, percent, bracket1, newsearchstr1, bracket2, percent, percent, bracket1, newsearchstr1, bracket2, percent)) 
        
        queryResult2 = cur.fetchall()

        coursesid = "'{" + str(self.getlatestVersion('Courses')) + "}'"
        contentsid ="'{" + str(self.getlatestVersion('Content')) + "}'"

        gloassarysid ="'{" + str(self.getlatestVersion('Glossary')) + "}'"
        linksid ="'{" + str(self.getlatestVersion('Links')) + "}'"
        
        faqtopicsid ="'{" + str(self.getlatestVersion('FaqTopics')) + "}'"
        faqentriessid ="'{" + str(self.getlatestVersion('FaqEntries')) + "}'"
        
        testsid ="'{" + str(self.getlatestVersion('Tests')) + "}'"
        oquestsid ="'{" + str(self.getlatestVersion('ObjectiveQuestions')) + "}'"
        mcquestsid ="'{" + str(self.getlatestVersion('MultipleChoiceQuestions')) + "}'"
        tfquestsid ="'{" + str(self.getlatestVersion('TrueFalseQuestions')) + "}'"
        descquestsid ="'{" + str(self.getlatestVersion('DescriptiveQuestions')) + "}'"

        queryResult = cur.execute("select ssid, title, description, nid, noofcommits, noofchangesaftercommit, instanceof from djview_o WHERE (instanceof = "+coursesid+" or instanceof = "+gloassarysid+" or instanceof = "+linksid+" or instanceof = "+faqtopicsid+" or instanceof = "+faqentriessid+" or instanceof = "+testsid+" or instanceof = "+mcquestsid+" or instanceof = "+tfquestsid+" or instanceof = "+descquestsid+") and ((to_tsvector( '%s', lower(title[1]) || lower(description) ) @@ to_tsquery( '%s','%s' )) or (lower(title[1]) similar to '%s%s%s%s%s' or lower(description) similar to '%s%s%s%s%s'));" % (str(langcode), str(langcode), newsearchstr2, percent, bracket1, newsearchstr1, bracket2, percent, percent, bracket1, newsearchstr1, bracket2, percent)) 

        queryResult = cur.fetchall()

        
        scossid ="'{" + str(self.getlatestVersion('SCO')) + "}'"
        CMssid ="'{" + str(self.getlatestVersion('CourseMaterial')) + "}'"
        PMssid ="'{" + str(self.getlatestVersion('PartMaterial')) + "}'"
        TQssid ="'{" + str(self.getlatestVersion('TestsQuestions')) + "}'"
        RCssid ="'{" + str(self.getlatestVersion('ResourceCategories')) + "}'"


        queryResult1 = cur.execute("select ssid, title, description, nid, noofcommits, noofchangesaftercommit, subtypeof from djview_ot where (subtypeof != "+scossid+" and subtypeof != "+CMssid+" and subtypeof != "+PMssid+" and subtypeof != "+TQssid+" and subtypeof != "+RCssid+") and ((to_tsvector( '%s', lower(title[1]) || lower(description) ) @@ to_tsquery( '%s','%s' )) or (lower(title[1]) similar to '%s%s%s%s%s' or lower(description) similar to '%s%s%s%s%s'));" % (str(langcode), str(langcode), newsearchstr2, percent, bracket1, newsearchstr1, bracket2, percent, percent, bracket1, newsearchstr1, bracket2, percent)) 

        queryResult1 = cur.fetchall()

        queryResult3 = cur.execute("select ssid, title, description, nid, noofcommits, noofchangesaftercommit, instanceof from djview_u where (to_tsvector( '%s', lower(title[1]) || lower(description) ) @@ to_tsquery( '%s','%s' )) or (lower(title[1]) similar to '%s%s%s%s%s' or lower(description) similar to '%s%s%s%s%s');" % (str(langcode), str(langcode), newsearchstr2, percent, bracket1, newsearchstr1, bracket2, percent, percent, bracket1, newsearchstr1, bracket2, percent))
        
        queryResult3 = cur.fetchall()

        fqlist = queryResult1 + queryResult + queryResult2 + queryResult3

        print queryResult
        
        # getting the latest versions of the searched elemnet

        lstofssid = []
        tmplst = []
        

        if fqlist <> []:
            for x in fqlist:
                print x[0]
                print x[1][0]
                vinfo = ""
                vinfo = str(x[4])+"."+str(x[5])
                lvs = self.getlatestVersion(str(x[3]))
                if lvs in tmplst:
                    print "its in tmplst"
                else:
                    lstofssid.append([x[0],x[1][0],vinfo])
                    tmplst.append(lvs)
        else:
            lstofssid = []
            return lstofssid


        return lstofssid

    def searchMaterial( self, searchstr):
        """
        search resource string in the database
        """
        tmplst = []
        cur = self.cur

        coursesid = "'{" + str(self.getlatestVersion('Courses')) + "}'"
        contentsid ="'{" + str(self.getlatestVersion('Content')) + "}'"

        
        queryResult = cur.execute("select ssid, title, description, nid, noofcommits, noofchangesaftercommit, instanceof from djview_o where instanceof = "+coursesid+" or instanceof = "+contentsid+";")
        
        queryResult = cur.fetchall()
        
        rmlst = ['to', 'a', 'an', 'the', 'this', 'that', 'these', 'those', 'there', 'their']

        print queryResult

        searchstr.replace(',','')
        searchstr.replace(':','')
        searchstr.replace(';','')
        searchstr.replace('?','')
        searchstr.replace('!','')
        searchstr.replace("'",'')


        newstr = searchstr.split(' ')
        

        lstofssid = []
        tmp2lst = []

        for x in queryResult:

            brtitle = []
            brdesc = []
            brnid = []
            
            if x[1][0].lower() == searchstr.lower():
                vinfo = ""                                                                                                                               
                vinfo = str(x[4])+"."+str(x[5])                                                                                                          
                lt1 = str(x[1][0]) + str(x[6][0])
                if lt1 in tmp2lst:
                    print "Present in search result"
                else:
                    lstofssid.append([x[0],x[1][0],vinfo])
                    tmp2lst.append(lt1)
            else:

                if x[1] <> None:
                    brtitle = x[1][0].split(' ')
                if x[2] <> None:
                    brdesc = x[2].split(' ')
                if x[3] <> None:
                    brnid = x[3].split(' ')
            
                finaldata = []
                finaldata = brnid + brtitle + brdesc
            
                finalchangecase=[]
                for cc in finaldata:
                    try:
                        finalchangecase.append(cc.lower())
                    except:
                        finalchangecase.append(cc)
            
            
                a = 0
                for y in newstr:
                    if y <> '':
                        if y not in rmlst:
                            try:
                                if y.lower() in finalchangecase:
                                    a = a + 1
                            except:
                                if y in finalchangecase:
                                    a = a + 1
                if a > 0:
                    print x[0]
                    print x[1][0]
                    vinfo = ""
                    vinfo = str(x[4])+"."+str(x[5])
                    lvs = self.getlatestVersion(str(x[3]))
                    if lvs in tmplst:
                        print "its in tmplst"
                    else:
                        lstofssid.append([x[0],x[1][0],vinfo])
                        tmplst.append(lvs)
                    a = 0

            
                
        return lstofssid

    def searchResources( self, searchstr):
        """
        search resource string in the database
        """

        cur = self.cur

        imgresid = "'{" + str(self.getlatestVersion('image')) + "}'"
        audiresid ="'{" + str(self.getlatestVersion('audio')) + "}'"
        vidresid = "'{" + str(self.getlatestVersion('video')) + "}'"
        otherresid = "'{" + str(self.getlatestVersion('otherResources')) + "}'"

        
        queryResult = cur.execute("select ssid, title, description, nid, noofcommits, noofchangesaftercommit  from djview_o where instanceof = "+imgresid+" or instanceof = "+audiresid+" or instanceof = "+vidresid+" or instanceof = "+otherresid+";")
        
        queryResult = cur.fetchall()
        
        rmlst = ['to', 'a', 'an', 'the', 'this', 'that', 'these', 'those', 'there', 'their']

        print queryResult

        searchstr.replace(',','')
        searchstr.replace(':','')
        searchstr.replace(';','')
        searchstr.replace('?','')
        searchstr.replace('!','')
        searchstr.replace("'",'')


        newstr = searchstr.split(' ')
        

        lstofssid = []
        flst = []

        if queryResult <> []:
            for x in queryResult:
                lv = self.getlatestVersion(str(x[3]))
                if lv not in flst:
                    flst.append(lv)
        else:
            lstofssid = []
            return lstofssid
        
        plst = []

        for ln in queryResult:
            if ln[0] in flst:
                plst.append([ln[0],ln[1],ln[2],ln[3],ln[4],ln[5]])

        for x in plst:

            brtitle = []
            brdesc = []
            brnid = []

            if x[1] <> None:
                brtitle = x[1][0].split(' ')
            if x[2] <> None:
                brdesc = x[2].split(' ')
            if x[3] <> None:
                brnid = x[3].split(' ')
            
            finaldata = []
            finaldata = brnid + brtitle + brdesc
            
            finalchangecase=[]
            for cc in finaldata:
                try:
                    finalchangecase.append(cc.lower())
                except:
                    finalchangecase.append(cc)
            
            
            a = 0
            for y in newstr:
                if y <> '':
                    if y not in rmlst:
                        try:
                            if y.lower() in finalchangecase:
                                a = a + 1
                        except:
                            if y in finalchangecase:
                                a = a + 1
            if a > 0:
                print x[0]
                print x[1][0]
                vinfo = ""
                vinfo = str(x[4])+"."+str(x[5])
                lstofssid.append([x[0],x[1][0],vinfo])
                a = 0

            
                
        return lstofssid
    
    def getRelationSSID( self, sub1, sub2):
        """
        get the relation's ssid
        """
        
        cur = self.cur

        queryResult = cur.execute("select ssid from djview_r where subject1 = "+str(sub1)+" and subject2 = "+str(sub2)+";")
        queryResult = cur.fetchall()[0][0]

        return queryResult


        

    def getSubscribers( self, objssid):
        """
        get all subscriber of LO
        """
        lstofuinfo = []
        lstofshelfobj = []

        cur = self.cur

        queryResult = cur.execute("select relations from djview_o where ssid = "+str(objssid)+";")

        queryResult = cur.fetchall()[0][0]
        
        if queryResult <> []:
            for x in queryResult:
                
                rt = cur.execute("select relationtypes from djview_r where ssid = "+str(x)+";")
                rt = cur.fetchall()[0][0][0]
                
                rtnid = cur.execute("select nid from djview_rt where ssid = "+str(rt)+";")
                rtnid = cur.fetchall()[0][0]
                
                if rtnid == 'contains':
                    sub = cur.execute("select subject1, subject2 from djview_r where ssid = "+str(x)+";")                                                  
                    sub = cur.fetchall()[0]
                    
                    if str(sub[0]) == str(objssid):
                        lstofshelfobj.append(sub[1])
                    if str(sub[1]) == str(objssid):
                        lstofshelfobj.append(sub[0])
        else:
            return lstofuinfo
        if lstofshelfobj <> []:
            for y in lstofshelfobj:
                shelfnid = cur.execute("select nid from djview_o where ssid = "+str(y)+";")             
                shelfnid = cur.fetchall()[0][0]
                
                username = shelfnid.replace('_shelf','')
            
                uinfo =  cur.execute("select nid, title, email from djview_u where nid = '"+username+"';")
                uinfo = cur.fetchall()[0]
            
                lstofuinfo.append(uinfo)
        else:
            return lstofuinfo

        return lstofuinfo


    def globalsearchMaterial( self, searchstr):
        """
        search resource string in the database
        """
        
        tmplst = []
        tmp2lst = []
        cur = self.cur

        imgresid = "'{" + str(self.getlatestVersion('image')) + "}'"
        audiresid ="'{" + str(self.getlatestVersion('audio')) + "}'"
        vidresid = "'{" + str(self.getlatestVersion('video')) + "}'"
        otherresid = "'{" + str(self.getlatestVersion('otherResources')) + "}'"

        queryResult2 = cur.execute("select ssid, title, description, nid, noofcommits, noofchangesaftercommit, instanceof from djview_o where instanceof = "+imgresid+" or instanceof = "+audiresid+" or instanceof = "+vidresid+" or instanceof = "+otherresid+";")
        
        queryResult2 = cur.fetchall()

        if queryResult2 <> []:
            for x in queryResult2:
                lv = self.getlatestVersion(str(x[3]))
                if lv <> x[0]:
                    queryResult2.remove(x)
        
        coursesid = "'{" + str(self.getlatestVersion('Courses')) + "}'"
        contentsid ="'{" + str(self.getlatestVersion('Content')) + "}'"

        scossid ="'{" + str(self.getlatestVersion('SCO')) + "}'"
        CMssid ="'{" + str(self.getlatestVersion('CourseMaterial')) + "}'"
        PMssid ="'{" + str(self.getlatestVersion('PartMaterial')) + "}'"
        TQssid ="'{" + str(self.getlatestVersion('TestsQuestions')) + "}'"
        RCssid ="'{" + str(self.getlatestVersion('ResourceCategories')) + "}'"


        queryResult = cur.execute("select ssid, title, description, nid, noofcommits, noofchangesaftercommit, instanceof from djview_o where instanceof = "+coursesid+" or instanceof = "+contentsid+";")
        
        queryResult = cur.fetchall()

        queryResult1 = cur.execute("select ssid, title, description, nid, noofcommits, noofchangesaftercommit, subtypeof from djview_ot where subtypeof != "+scossid+" and subtypeof != "+CMssid+" and subtypeof != "+PMssid+" and subtypeof != "+TQssid+" and subtypeof != "+RCssid+";")

        queryResult1 = cur.fetchall()

        fqlist = queryResult1 + queryResult + queryResult2
        
        rmlst = ['to', 'a', 'an', 'the', 'this', 'that', 'these', 'those', 'there', 'their']

        print fqlist

        searchstr.replace(',','')
        searchstr.replace(':','')
        searchstr.replace(';','')
        searchstr.replace('?','')
        searchstr.replace('!','')
        searchstr.replace("'",'')


        newstr = searchstr.split(' ')
        

        lstofssid = []
        
        for x in fqlist:

            brtitle = []
            brdesc = []
            brnid = []
            
            if x[1][0].lower() == searchstr.lower():
                vinfo = ""                                                                                                                               
                vinfo = str(x[4])+"."+str(x[5])                                                                                                          
                lt1 = str(x[1][0]) + str(x[6][0])
                if lt1 in tmp2lst:
                    print "Present in search result"
                else:
                    lstofssid.append([x[0],x[1][0],vinfo])
                    tmp2lst.append(lt1)
            else:

                if x[1] <> None:
                    brtitle = x[1][0].split(' ')
                if x[2] <> None:
                    brdesc = x[2].split(' ')
                if x[3] <> None:
                    brnid = x[3].split(' ')
            
                finaldata = []
                finaldata = brnid + brtitle + brdesc
            
                finalchangecase=[]
                for cc in finaldata:
                    try:
                        finalchangecase.append(cc.lower())
                    except:
                        finalchangecase.append(cc)
            
            
                a = 0
                for y in newstr:
                    if y <> '':
                        if y not in rmlst:
                            try:
                                if y.lower() in finalchangecase:
                                    a = a + 1
                            except:
                                if y in finalchangecase:
                                    a = a + 1
                if a > 0:
                    print x[0]
                    print x[1][0]
                    vinfo = ""
                    vinfo = str(x[4])+"."+str(x[5])
                    lvs = self.getlatestVersion(str(x[3]))
                    if lvs in tmplst:
                        print "its in tmplst"
                    else:
                        lstofssid.append([x[0],x[1][0],vinfo])
                        tmplst.append(lvs)
                    a = 0

            
                
        return lstofssid

        
    def html2list(self, x, b=0):
        mode = 'char'
        cur = ''
        out = []
        for c in x:
            if mode == 'tag':
                if c == '>':
                    if b: cur += ']'
                    else: cur += c
                    out.append(cur); cur = ''; mode = 'char'
                else: cur += c
            elif mode == 'char':
                if c == '<':
                    out.append(cur)
                    if b: cur = '['
                    else: cur = c
                    mode = 'tag'
                elif c in string.whitespace: out.append(cur+c); cur = ''
                else: cur += c
        out.append(cur)
        print out
        return filter(lambda x: x is not '', out)


    def isTag(x):
        return x[0] == "<" and x[-1] == ">"

    def textDiff(self, a, b):
        """Takes in strings a and b and returns a human-readable HTML diff."""
        
        out = []
        a, b = self.html2list(a), self.html2list(b)
        print 'value of a is ---', a
        print 'value of b is ---', b
        s = difflib.SequenceMatcher(None, a, b)
        print s.get_opcodes()
        for e in s.get_opcodes():
            print "value of e is--",e
            if e[0] == "replace":
                # @@ need to do something more complicated here
                # call textDiff but not for html, but for some html... ugh
                # gonna cop-out for now
                out.append('<strong class="diff_modified">'+''.join(a[e[1]:e[2]]) + '</strong><strong class="diff modified">'+''.join(b[e[3]:e[4]])+"</strong>")
                                                                                          
 
               #out.append("<b"+">"+''.join(a[e[1]:e[2]]) + +"</b"+" >"+"<b"+">"+''.join(b[e[3]:e[4]])++"</b"+" >")
            elif e[0] == "delete":
                out.append('<strike class="diff_deleted">'+ ''.join(a[e[1]:e[2]]) + "</strike>")
            elif e[0] == "insert":
                out.append('<strong class="diff_inserted">'+''.join(b[e[3]:e[4]]) + "</strong>")
            elif e[0] == "equal":
                out.append(''.join(b[e[3]:e[4]]))
            else:
                raise "Um,. I didn't expect a '" + `e[0]` + "'."
        print out
        return ''.join(out)


    def compare_changes(self, nodeid):
        """
        """
        node_ssid = nodeid.split('~')
        ssid1 = node_ssid[0]
        ssid2 = node_ssid[1]
        l = []
        print ssid1
        print ssid2
        x = self.getinfoFromSSID(ssid1, 'gbobjects')
        content1 = x[0]['content']
        print 'content one is - ', content1
        f1=open('/tmp/content1.txt','w')
        for line in content1:
            f1.write(line)
        f1.close();
        y = self.getinfoFromSSID(ssid2, 'gbobjects')
        content2 = y[0]['content']
        print 'content two is - ', content2
        f2=open('/tmp/content2.txt', 'w')
        for line in content2:
            f2.write(line)
        f2.close();
        diffp = self.textDiff(open('/tmp/content1.txt').read(), open('/tmp/content2.txt').read())
        return diffp
    
    def updateSSIDStructure( self, ssid, structure ):

        query = "SELECT nodename FROM view_nidinidssid WHERE ssid=%s;" % ssid
        print query
        self.cur.execute( query )
        res = self.cur.fetchall()
        nodename = res[0][0]

        s = storageSpec()
        flddef = s.dictTNamesFDefs[ nodename ]['structure']

        obj = tbl_nodetype( self.cur )
        ntid = obj.getntid( nodename )

        dtobj = tbl_datatypes( self.cur )
        dtid = dtobj.getdtid( 'varchar[]' )

        print flddef
        ft = tbl_field( self.cur, flddef )
        fid = ft.insert( { 'ntid':ntid, 'datatypeid':dtid, 'value':structure } )

        updatequery = "UPDATE %s SET structure=%s WHERE ssid=%s" % ( nodename, fid, ssid )
        print updatequery
        self.cur.execute( updatequery )
        self.conn.commit()


    def updateSSIDTitle( self, ssid, title ):

        query = "SELECT nodename FROM view_nidinidssid WHERE ssid=%s;" % ssid
        print query
        self.cur.execute( query )
        res = self.cur.fetchall()
        nodename = res[0][0]

        s = storageSpec()
        flddef = s.dictTNamesFDefs[ nodename ]['title']

        obj = tbl_nodetype( self.cur )
        ntid = obj.getntid( nodename )

        dtobj = tbl_datatypes( self.cur )
        dtid = dtobj.getdtid( 'varchar[]' )

        print flddef
        ft = tbl_field( self.cur, flddef )
        fid = ft.insert( { 'ntid':ntid, 'datatypeid':dtid, 'value':title } )

        updatequery = "UPDATE %s SET title=%s WHERE ssid=%s" % ( nodename, fid, ssid )
        print updatequery
        self.cur.execute( updatequery )
        self.conn.commit()


    def updateSSIDDescription( self, ssid, description ):

        query = "SELECT nodename FROM view_nidinidssid WHERE ssid=%s;" % ssid
        print query
        self.cur.execute( query )
        res = self.cur.fetchall()
        nodename = res[0][0]

        s = storageSpec()
        flddef = s.dictTNamesFDefs[ nodename ]['description']

        obj = tbl_nodetype( self.cur )
        ntid = obj.getntid( nodename )

        dtobj = tbl_datatypes( self.cur )
        dtid = dtobj.getdtid( 'varchar' )

        ft = tbl_field( self.cur, flddef )
        fid = ft.insert( { 'ntid':ntid, 'datatypeid':dtid, 'value':description } )

        updatequery = "UPDATE %s SET description=%s WHERE ssid=%s" % ( nodename, fid, ssid )
        print updatequery
        self.cur.execute( updatequery )
        self.conn.commit()

        
    def updateSSIDContent( self, ssid, content ):

        query = "SELECT nodename FROM view_nidinidssid WHERE ssid=%s;" % ssid
        print query
        self.cur.execute( query )
        res = self.cur.fetchall()
        nodename = res[0][0]

        s = storageSpec()
        flddef = s.dictTNamesFDefs[ nodename ]['content']

        obj = tbl_nodetype( self.cur )
        ntid = obj.getntid( nodename )

        dtobj = tbl_datatypes( self.cur )
        dtid = dtobj.getdtid( 'varchar' )

        ft = tbl_field( self.cur, flddef )
        fid = ft.insert( { 'ntid':ntid, 'datatypeid':dtid, 'value':content } )

        updatequery = "UPDATE %s SET content=%s WHERE ssid=%s" % ( nodename, fid, ssid )
        print updatequery
        self.cur.execute( updatequery )
        self.conn.commit()
    
    def getAllPossibleAT(self, otssid):
        """
        get all the possible attributes 
        """
        cur = self.cur
        print otssid
        lstofAT = []       
        queryResult = cur.execute("select attributetypes from djview_ot where ssid = "+otssid+";")
        queryResult = cur.fetchall()
        
        try:
            lstofAT = queryResult[0][0]
        
            finallstofAT = []
            for x in lstofAT:
                queryResult1 = cur.execute("select nid, title, description, ssid from djview_at where ssid = "+str(x)+";")
                queryResult1 = cur.fetchall()
                
                finallstofAT.append(queryResult1[0])
        except:
            finallstofAT = []

        return finallstofAT
                
    def getDatatypeNameFromAT( self, ssid ):
        at = gbattributes( self.conString )
        dtid = at.get_dtid_attributetype( ssid, self.cur )
        dtt = tbl_datatypes( self.cur )

        dtname = dtt.getdtnamefromid( dtid )

        if dtname == 0:
            print "error retrieving datatype name"
        else:
            return dtname

    def getlanguagefromcode( self, langcode ):
        """
        get all the possible attributes 
        """
        cur = self.cur
        
        langssid ="'{" + str(self.getlatestVersion('Languages')) + "}'"

        queryResult = cur.execute("select title[1], title[2] from djview_o WHERE instanceof = "+langssid+";" )
        queryResult = cur.fetchall()

        print queryResult

        print langcode


        for x in queryResult:
            if x[1].replace('\n','') == langcode:
                return str(x[0]).lower()
            elif x[1].replace('\n','') == 'en':
                return str(x[0]).lower()

        return "english"
    
    def getpercentofac(self, uid):
        """
        Percentage of author's Contribution
        """
        
        cur = self.cur
        

        queryResult = cur.execute("select ssid from djview_o WHERE uid = "+uid+";" )
        queryResult = cur.fetchall()
        
        countofauthorsLO = float(len(queryResult))

        queryResult1 = cur.execute("select count(ssid) from djview_o;" )
        queryResult1 = cur.fetchall()

        countofallLO = float(queryResult1[0][0])
        
        percentileofacontrib = ( countofauthorsLO / countofallLO ) * 100

        return round( percentileofacontrib, 2 )

    def getAuthorLO(self, uid):
        """
        Percentage of author's Contribution
        """
        
        cur = self.cur
        

        queryResult = cur.execute("select ssid from djview_o WHERE uid = "+uid+";" )
        queryResult = cur.fetchall()
        
        return queryResult


    def sitestats(self):
        """
        statistics of SELF
        """
        statdict = {}

        cur = self.cur

        coursesid = "'{" + str(self.getlatestVersion('Courses')) + "}'"
        contentsid ="'{" + str(self.getlatestVersion('Content')) + "}'"

        gloassarysid ="'{" + str(self.getlatestVersion('Glossary')) + "}'"
        linksid ="'{" + str(self.getlatestVersion('Links')) + "}'"
        
        faqtopicsid ="'{" + str(self.getlatestVersion('FaqTopics')) + "}'"
        faqentriessid ="'{" + str(self.getlatestVersion('FaqEntries')) + "}'"
        
        testsid ="'{" + str(self.getlatestVersion('Tests')) + "}'"
        oquestsid ="'{" + str(self.getlatestVersion('ObjectiveQuestions')) + "}'"
        mcquestsid ="'{" + str(self.getlatestVersion('MultipleChoiceQuestions')) + "}'"
        tfquestsid ="'{" + str(self.getlatestVersion('TrueFalseQuestions')) + "}'"
        descquestsid ="'{" + str(self.getlatestVersion('DescriptiveQuestions')) + "}'"
        
        
        queryResult1 = cur.execute("select distinct on (nid) nid from djview_o where instanceof = "+coursesid+";")
        queryResult1 = cur.fetchall()

        courselen = len(queryResult1)
        statdict.update({'Courses':courselen})

        queryResult2 = cur.execute("select distinct on (nid) nid from djview_o where instanceof = "+contentsid+";")
        queryResult2 = cur.fetchall()

        contlen = len(queryResult2)
        statdict.update({'Content':contlen})

        queryResult3 = cur.execute("select distinct on (nid) nid from djview_o where instanceof = "+gloassarysid+";")
        queryResult3 = cur.fetchall()

        glosslen = len(queryResult3)
        statdict.update({'Glossary':glosslen})
        
        queryResult4 = cur.execute("select distinct on (nid) nid from djview_o where instanceof = "+linksid+";")
        queryResult4 = cur.fetchall()

        linklen = len(queryResult4)
        statdict.update({'Links':linklen})

        queryResult5 = cur.execute("select distinct on (nid) nid from djview_o where instanceof = "+faqtopicsid+";")
        queryResult5 = cur.fetchall()

        FTlen = len(queryResult5)
        statdict.update({'FaqTopics':FTlen})

        queryResult6 = cur.execute("select distinct on (nid) nid from djview_o where instanceof = "+faqentriessid+";")
        queryResult6 = cur.fetchall()

        faqentrylen = len(queryResult6)
        statdict.update({'FaqEntries':faqentrylen})

        queryResult7 = cur.execute("select distinct on (nid) nid from djview_o where instanceof = "+testsid+";")
        queryResult7 = cur.fetchall()

        testlen = len(queryResult7)
        statdict.update({'Tests':testlen})
        
        queryResult8 = cur.execute("select distinct on (nid) nid from djview_o WHERE instanceof = "+oquestsid+" or instanceof = "+mcquestsid+" or instanceof = "+tfquestsid+" or instanceof = "+descquestsid+";")
        queryResult8 = cur.fetchall()

        questlen = len(queryResult8)
        statdict.update({'FaqEntries':questlen})

        return statdict
