# -*- coding: utf-8 -*- 
#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################


__author__ = """Jay Mehta <jay87.mehta@gmail.com>"""
__docformat__ = 'plaintext'
  

from GeneralMethods import *
from GetMethods import *
import cPickle
import psycopg2
from base64 import b64encode, b64decode

class Delete:

  def __init__(self , constring ,uid ):
      self.constring=constring
      self.conn = psycopg2.connect( constring )   
      self.curs = self.conn.cursor() 
      self.uid = uid

  def startchecks(self,subject_ssid):
    
      nodetype_list=get_nodetype_from_gbnidssid([subject_ssid],"ssid",self.curs)
      if nodetype_list==[]:
        print "subject_ssid not found"
        return -1
      else:
        #print "ssid exists"
        return nodetype_list 


  def derive_datatype(self,restrictionlist):
         #restrictionlist=[(restrictiontype1,restrctionref1,attrtypenid1,attrtypessid1,attrvalue),(restrictiontype2,restrctionref2,nid2,ssid2,avalue), ...]
         #print restrictionlist
         typename_list=[]
        
         for rl in range(len(restrictionlist)):
             if restrictionlist[rl][0]==0:
                sql="SELECT datatype FROM gbselectionlist WHERE selid=%s"%restrictionlist[rl][1]
             else:
                sql="SELECT datatype FROM gbvaluerestrictions WHERE restrictionid=%s;"%restrictionlist[rl][1]
             #print sql
             execute_query(sql,self.curs)
             typename=query_fetchall(self.curs)
             #print typename
             typename_list.append((typename[0][0],restrictionlist[rl][2],restrictionlist[rl][3],restrictionlist[rl][4] ))#for gbattributes table
             #print typename_list
         return typename_list


  def deleteAttribute(self,input,old_renderednbh): 

      new_renderednbh={}
      fieldschanged=[]
      deletenbh=[]
      #print old_renderednbh#{ 'attributes':{'attrtypenid':(attrssid,attrvalue), ...}, 'relations': ... }
      restrictionlist=[]
      if old_renderednbh.has_key('attributes'):
         #handling rendered_nbh for attributes-- start
         new_renderednbh['attributes'] = old_renderednbh['attributes']
         
         for attrtypenid in input['attributes']:
             if new_renderednbh['attributes'].has_key(attrtypenid):
                #print"subject has this attribute"
                deletenbh.append(new_renderednbh['attributes'][attrtypenid][0])
                new_renderednbh['attributes'].pop(attrtypenid)#this is for rendernbh
                fieldschanged.append(attrtypenid)

         final_dic={}
         final_dic['rendernbh_data'] = new_renderednbh['attributes'] #this is to straightly attach
         final_dic['nbh_data'] = deletenbh# this is attrssid to remove, for whichever values found in that particular ssid of the subject.
         final_dic['fieldschanged']=fieldschanged
         #print final_dic
         return final_dic

      else:
         return 1
      
    
  def validateRelation(self,input,old_renderednbh):
      """
      this function validates input['relation'] with relation data obtained from renderednbh.
      """
      #print old_renderednbh
      if old_renderednbh.has_key('relations'):
         #print input['relation']
         for tuple in input['relation']:#[(relntypenid,roleflag of subj1,[list of ssid])]
             if old_renderednbh['relations'].has_key(tuple[0]):
                if tuple[0]=='instanceof':
                   if input['nodetype'].endswith('type'):
                      if old_renderednbh['relations'][tuple[0]].has_key(tuple[1]):
                         if set(tuple[2])<= set(old_renderednbh['relations'] [tuple[0]] [tuple[1]] ) :
                            #print"all subject2 validated for this relntypenid"
                            pass
                         else:
                            print "invalid subject2 for the relntypeid"
                            return  -1
                      else:
                        print "No %s for relntypenid=%s .Invalid input.",tuple[0],tuple[1]
                        return -1
                   else:
                      if old_renderednbh['relations'][tuple[0]].has_key(tuple[1]):
                         if set(tuple[2])< set(old_renderednbh['relations'] [tuple[0]] [tuple[1]] ) :
                            #print"there exists few more classof given subject ssid . so this all relnssid can be deleted."
                            pass
                         elif input['status']=='deleted':
                              pass
                         else:
                             print"if all given relnssid are deleted there exists no more classof given subjectssid. cannot proceed."
                             return  -1
                      else:
                         print "No %s for relntypenid=%s .Invalid input.",tuple[0],tuple[1]
                         return -1

                else:
                    if old_renderednbh['relations'][tuple[0]].has_key(tuple[1]):
                       if set(tuple[2])<= set(old_renderednbh['relations'] [tuple[0]] [tuple[1]] ) :
                           #print"all subject2 validated for this relntypenid"
                           pass
                       else:
                           print "invalid subject2 for the relntypeid"
                           return  -1
                    else:
                      print "No %s for relntypenid=%s .Invalid input.",tuple[0],tuple[1]
                      return -1
             else:
                print"invalid input. subject doesnot have this relationtypenid."
                return  "invalid input. subject doesnot have this relationtypenid."
         return 1

      else:
         return"no relations to delete"

  def deleteRelation(self,input, nbhData_dic, rnbhData_dic):      
     
      """
      this function calls function to create new snapshot of subject2 that no longer would be in relation with input['subject']. 
      """
      # nbhData_dic={'s2ssid':[relns ssids ], ... }
      # rnbhData_dic={'s2ssid',[(relntypenid,roleflag of s1) ,...]}
      new_s2_dic={}
      

      
      for key in nbhData_dic:      
          #print "key",key
          new_subject2_ssid = get_next_sequence_value('ssid_seq',self.curs)#new ssid of s2
          nodetype_list = get_nodetype_from_gbnidssid([key],"ssid",self.curs)#nodetype of s2
          #print nodetype_list
          nid_inid_list= get_nidinid_from_ssid(key,self.curs)
          #print "nid_inid_list",nid_inid_list
          new_s2_dic[str(new_subject2_ssid)] = (nid_inid_list[0][0],str(nid_inid_list[0][1]),nodetype_list[0])
          removeRelation_4_newSnapshot(nodetype_list[0],input['uid'],key,str(new_subject2_ssid),nbhData_dic[key],rnbhData_dic[key],input['subject'],self.curs)
      return new_s2_dic    

  def calculate_nbhData(self,input):#for reln
      #input_reln=[(relntypenid,roleflag of subj1,[subject2 ssids]), (), ...]
      input_reln = input['relation']
      relntypenid_list=[]
      
      for tuple in input_reln:
          relntypenid_list.append(tuple[0])
      #print relntypenid_list    
      sql="select inid,nid from gbrelationtypes where nid in %s;"%(listofcharacter_2string(relntypenid_list))
      #print sql
      execute_query(sql,self.curs)
      rtype_inid_list = query_fetchall(self.curs)#[(relntypeinid,relntypenid),(), ...]

      rtype_nid_inid_dic={}
      for tuple in rtype_inid_list:
          rtype_nid_inid_dic[tuple[1]]= str (tuple[0])
      #print "rtype_nid_inid_dic    ",rtype_nid_inid_dic    

      rnbhData_dic={} #rnbhData_dic={'s2ssid',[(relntypenid,roleflag of s2) ,...]
      nbhData_dic={} #nbhData_dic={'s2ssid',[reln ssi] }
      allRelnssid_list=[]#nbh list for subject1.
      
      s2_ssid_inid_dic={}#it stores all subject2 ssid and its inid, so no requery to fetch inid from ssid.
      for tuple in input_reln:#[(relntypenid,roleflag of subj2,[subject2 ssids]), (), ...]
          if tuple[1]=='leftroles':
             for s2index in range( len ( tuple[2] ) ):
                 s2inid=""
                 if  s2_ssid_inid_dic.has_key( tuple[2][s2index] ):
                     s2inid= s2_ssid_inid_dic[ tuple[2][s2index] ]
                 else:
                     #print "get inid of ssid=",tuple[2][s2index]
                     s2inid = get_inid_from_ssid( [tuple[2][s2index]],self.curs)[0]  
                     #print "its inid=",s2inid
                     s2_ssid_inid_dic[tuple[2][s2index]]=s2inid
                 #print s2inid    
                 sql="select ssid from gbrelations where subject1=%s and subject2=%s and relationtype=%s;"                                                                                                 %(s2inid,input['subject_inid'],rtype_nid_inid_dic[ tuple[0] ])
                 #print sql
                 execute_query(sql,self.curs)
                 fetched_list= query_fetchall(self.curs) #[(ssid1,),(ssid2,), ...]
                 #print fetched_list
                 relnssid_list=[]
                 for f in fetched_list:
                     relnssid_list.append(str(f[0]))
                 
                 if nbhData_dic.has_key(tuple[2][s2index]):
                    nbhData_dic[tuple[2][s2index]] = nbhData_dic[tuple[2][s2index]] + relnssid_list 
                    rnbhData_dic[tuple[2][s2index]].append((tuple[0],'rightroles'))
                 else:
                    nbhData_dic[tuple[2][s2index]]=relnssid_list
                    rnbhData_dic[tuple[2][s2index]] = [(tuple[0],'rightroles')]
                   
                 allRelnssid_list = allRelnssid_list + relnssid_list #this is nbh data for subj1 
      

          else:
             for s2index in range( len ( tuple[2] ) ):
                 if  s2_ssid_inid_dic.has_key( tuple[2][s2index] ):
                     s2inid= s2_ssid_inid_dic[ tuple[2][s2index] ]
                     #print "s2 ssid=%s and its inid=%s"%( tuple[2][s2index], s2inid)
                 else:
                     s2inid = get_inid_from_ssid([ tuple[2][s2index]],self.curs)[0]  
                     s2_ssid_inid_dic[tuple[2][s2index]]=s2inid
                     #print "s2 ssid=%s and its inid=%s"%( tuple[2][s2index], s2inid)

                 sql="select ssid from gbrelations where subject1=%s and subject2=%s and relationtype=%s;"                                                                                         %(input['subject_inid'],s2inid,rtype_nid_inid_dic[ tuple[0]])

                 #print sql
                 execute_query(sql,self.curs)
                 fetched_list= query_fetchall(self.curs) #[(ssid1,),(ssid2,), ...]
                 #print fetched_list
                 relnssid_list=[]
                 for f in fetched_list:
                     relnssid_list.append(str( f[0] ))
                 #print relnssid_list
                 if nbhData_dic.has_key(tuple[2][s2index]):
                    nbhData_dic[tuple[2][s2index]] = nbhData_dic[tuple[2][s2index]] + relnssid_list 
                    rnbhData_dic[tuple[2][s2index]].append((tuple[0],'leftroles'))
                 else:
                    nbhData_dic[tuple[2][s2index]]=relnssid_list
                    rnbhData_dic[tuple[2][s2index]] = [(tuple[0],'leftroles')]

                 allRelnssid_list = allRelnssid_list + relnssid_list #this is nbh data for subj1                    
      
      final_dic={}
      final_dic['nbh_dic_4_s2']=nbhData_dic
      final_dic['rnbh_dic_4_s2']=rnbhData_dic
      final_dic['nbh_list_for_s1'] = allRelnssid_list
      #print final_dic
      return  final_dic

  def delete(self,input):
      input['uid'] = self.uid
      #print input       
      nodetype_list = self.startchecks(input['subject'])

      if nodetype_list!=-1:
         nid_inid_list= get_nidinid_from_ssid(input['subject'],self.curs)
         
         subject_nid= nid_inid_list[0][0]
         subject_inid= str(nid_inid_list[0][1])
         input['subject_inid']=subject_inid  
         #print subject_inid
         #print "INPUT===============",input
         input['nodetype']=nodetype_list[0]
  
         GetMethodsObj = GetMethods(self.constring)
         output_dic = GetMethodsObj.getNeighbourhood([input['subject']],'rendered_nbh')
         commitclose(GetMethodsObj.curs,GetMethodsObj.conn)
         #print "BEFORE MODIFICATION-------",output_dic
         old_renderednbh = output_dic[input['subject']]
         #print  old_renderednbh['relations'].values()

         for rtypenid in old_renderednbh['relations'].keys():
             #print rtypenid

             if old_renderednbh['relations'][rtypenid].has_key('leftroles'):
                rlist= old_renderednbh['relations'][rtypenid]['leftroles']
                templist=[]
                for values in rlist:
                    templist.append(str(values))
                old_renderednbh['relations'][rtypenid]['leftroles'] = templist

             if  old_renderednbh['relations'][rtypenid].has_key('rightroles'):
                rlist= old_renderednbh['relations'][rtypenid]['rightroles']
                templist=[]
                for values in rlist:
                    templist.append(str(values))
                old_renderednbh['relations'][rtypenid]['rightroles'] = templist

         #print "AFTER MODIFICATION___________",old_renderednbh       
         Attr_data_dic={}
         if input.has_key('attributes'):
            Attr_data_dic = self.deleteAttribute(input,old_renderednbh)
            if Attr_data_dic ==-1:
               return " invalid subject2 for the relntypeid"

         reln_Data_dic={}
         new_s2_dic = {}
         if input.has_key('relation'):
            validationStatus = self.validateRelation(input,old_renderednbh)
            if validationStatus==1:
               rDataDic={}   
               rDataDic = self.calculate_nbhData(input)               
               new_s2_dic = self.deleteRelation(input,rDataDic['nbh_dic_4_s2'],rDataDic['rnbh_dic_4_s2'])
            
               reln_Data_dic['nbh'] = rDataDic['nbh_list_for_s1']
               reln_Data_dic['rnbh'] = input['relation']

            else:
              return  validationStatus   

         """
         this function creates new snapshot of input['subject']
         """
         if ( (reln_Data_dic=={}) or (Attr_data_dic=={}) )and (input['status']=='delete'):
            print "nothing new to be done"
            return"nothing new to be done"
         else:
             if reln_Data_dic!={}:
                for key in new_s2_dic:
                    reset_ssid_2_latestssid(key,new_s2_dic[key][0],self.curs)#update subject's ssid
                    bind_nidssid(key,new_s2_dic[key][0],new_s2_dic[key][1],new_s2_dic[key][2],self.curs)#for new snapshot of subject   
              
             new_subject_ssid = get_next_sequence_value('ssid_seq',self.curs)           
             newsnapshot_4_delete(input, new_subject_ssid, self.curs,input['commit'],input['status'],reln_Data_dic,Attr_data_dic)
             reset_ssid_2_latestssid(new_subject_ssid,subject_nid,self.curs)#update subject's ssid
             bind_nidssid(new_subject_ssid,subject_nid,subject_inid,nodetype_list[0],self.curs)#for new snapshot of subject   

             #print  new_subject_ssid

             # handling case when subject is either process or processtypes. --- start  
             if input.has_key('priorstatedef'):
                handle_processtypes(input,new_subject_ssid, self.curs )
             if input.has_key('priorstate'):
                handle_process(input,new_subject_ssid, self.curs )
             # end ------
             commitclose(self.curs,self.conn)   
             return new_subject_ssid
         
      else:
          return "invalid subject"


if __name__=="__main__":
   constring="dbname=<postgres_databasename> user=<postgres_username> password=<postgres_password> host=localhost"
   

   uid = 1
   obj=Delete(constring,uid)
   input=   {
    'subject':'32',
    'status':'deleted',
    'uid':'1',
    'commit':'1'
   }
   
   print obj.delete(input)

"""
   input=   {
    'subject':'84',
    'status':'public',
    'uid':'1',
    'commit':'1',
    'relation':[('FOUNDER','rightroles', ['46'] )] #[(relntypenid,roleflag of subj2,[list of ssid])]
   }

   input=
   {'subject':'',#mandatory
    'attributes': []        #['attrtypenid1','attrtypenid2']
    'relation':[(  )]   ,#[(relntypenid,roleflag of subj1,[list of ssid])]
    'status':'public',#mandatory
    'uid':'1',
    
   }
   input=   {
    'subject':'23',
    'status':'public',
    'uid':'1',
    'commit':'1',
    'relation':[('FOUNDER','rightroles', ['26'] )] #[(relntypenid,roleflag of subj2,[list of ssid])],
    'attributes': ['title','content','project status']
   }

"""
#cheks to do more: to remove instanceof relation for given subject 
