# -*- coding: utf-8 -*- 
#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################

__author__ = """Jay Mehta <jay87.mehta@gmail.com>"""
__docformat__ = 'plaintext'



import cPickle
import  psycopg2
import psycopg2.extensions
import psycopg2.extras
from base64 import b64encode, b64decode

  
def modify_inputdic( dictionary):
          #this function appends mandatory fields from dictionary as attributes to the dictionary.
          #then for nid and each attribute value handling unicode.  

          if dictionary.has_key('mandatoryfields'):
             if dictionary.has_key('attributes'):   
                dictionary['attributes'].append(('mandatoryflds',dictionary['mandatoryfields']))   
             else:
                dictionary['attributes']=[ ('mandatoryflds',dictionary['mandatoryfields']) ]
                dictionary.pop('mandatoryfields')

          if 'nid' in dictionary.keys():
                    newnid = dictionary['nid']
                    newnid = newnid.replace("'","''")      
                    newnid = newnid.decode("utf-8")
                    newnid = newnid.encode("ascii", "xmlcharrefreplace")
                    dictionary['nid'] = newnid
          old_attr_list = []
          if dictionary['nodetype'].lower() == 'attribute' :
             old_attr_list = dictionary['instanceof']     
          elif dictionary.has_key('attributes'):
               old_attr_list = dictionary['attributes']   

          if old_attr_list != []:
             new_attr_list=[]  
             for tuple in old_attr_list:
                 if isinstance(tuple[1],list):
                    multivalued_attr_list=[]
                    for attrvalue in tuple[1]:
                        try:
                           newattrvalue = attrvalue.replace("'","''")  
                           newattrvalue = newattrvalue.decode("utf-8")  
                           newattrvalue = newattrvalue.encode("ascii", "xmlcharrefreplace")
                           multivalued_attr_list.append(newattrvalue)
                        except:
                           multivalued_attr_list.append(newattrvalue)
                    new_attr_list.append( (tuple[0],multivalued_attr_list) )
                 else:
                    try:
                       newattrvalue = tuple[1].replace("'","''")  
                       newattrvalue = newattrvalue.decode("utf-8")  
                       newattrvalue = newattrvalue.encode("ascii", "xmlcharrefreplace")
                       new_attr_list.append( (tuple[0], newattrvalue ) )
                    except:
                       new_attr_list.append( (tuple[0], tuple[1] ) )

             if dictionary['nodetype'].lower() == 'attribute' :
                dictionary['instanceof'] = new_attr_list
             else:
                dictionary['attributes'] = new_attr_list

          return dictionary      
            


def id_exists(id,id_value,tblname,curs ):
            sql="SELECT %s FROM %s WHERE %s='%s';"%(id,tblname,id,id_value)
            execute_query(sql,curs)
            rows=query_fetchall(curs) 
            if rows == []:
              return 0
            else:
              return 1

def check_statusfield(status):
            possible_statusvalues=['public','private','withheld','pending','deleted']
            if status in possible_statusvalues:
                 return 1
            else:
                 return 0  

def get_next_sequence_value(sequence_name,curs):
           sql="select nextval('%s');" %(sequence_name)
           execute_query(sql,curs)
           return str( curs.fetchall()[0][0] )


def get_current_sequence_value(sequence_name,curs):
           sql="select currval('%s');" %(sequence_name)
           execute_query(sql,curs)
           return str (curs.fetchall()[0][0])


def execute_query(sql,curs):
           curs.execute(sql)


def query_fetchall(curs):
          return curs.fetchall()
  
def list2string(llist):#llist=[ssid1,ssid2, ...] ,llist into format --> (ssid1,ssid2,...)
      sstring="("
      for elem_in_list in range(len(llist)):
          sstring=sstring+str(llist[elem_in_list])+","
      sstring= sstring.rstrip(",")
      sstring= sstring+")"
      return sstring

def listofcharacter_2string(llist):#llist=['nid1','nid2', ...] ,llist into format --> ('nid1','nid2',...)
      sstring="("
      for elem_in_list in range(len(llist)):
          sstring=sstring+"'"+str(llist[elem_in_list].replace("'","''"))+"',"
      sstring= sstring.rstrip(",")
      sstring= sstring+")"
      return sstring

def rearrange_list(singlevalue_list,multivalue_list ):
      rearranged_list=[]
      for i in singlevalue_list:
           for j in multivalue_list:
                 if str(j[1])==str(i):
                       rearranged_list.append(str(j[0] ))
      return rearranged_list


def get_attrtype_inid_from_nid(attrtype_nid,curs):
  
   sql="SELECT distinct inid,nid FROM gbattributetypes WHERE nid in %s;"%( listofcharacter_2string(attrtype_nid) )
   execute_query(sql,curs)
   multivalue_list = query_fetchall(curs)#multivalue_list=[(ssid,nid),(ssid2,nid2) ...]
   if len(multivalue_list) != len(attrtype_nid):
              return 0
   else:
     return rearrange_list(attrtype_nid,multivalue_list)

def get_attrtype_inid_latest_ssid_from_nid(attrtype_nid,curs):
  
   sql="SELECT inid, max(ssid), nid FROM gbattributetypes WHERE nid in %s group by nid,inid;"%( listofcharacter_2string(attrtype_nid) )
   execute_query(sql,curs)
   multivalue_list = query_fetchall(curs)#multivalue_list=[(inid,ssid,nid),(inid2,ssid2,nid2) ...]
   if len(multivalue_list) != len(attrtype_nid):
              return 0
   else:
     return multivalue_list


def relntype_nid_exists(relntype_nid,curs):
  
   sql="SELECT ssid,nid FROM gbrelationtypes WHERE nid in %s;"%( listofcharacter_2string(relntype_nid) )
   execute_query(sql,curs)
   multivalue_list=query_fetchall(curs)#multivalue_list=[(ssid,nid),(ssid2,nid2) ...]
   if len(multivalue_list) != len(relntype_nid):
              return 0
   else:
     return rearrange_list(relntype_nid,multivalue_list)


def get_nid_from_ssid(ssid_list,curs):
    sql="SELECT distinct nid,ssid from gbnidssid WHERE ssid in %s;"%(list2string(ssid_list))
    execute_query(sql,curs)
    multivalue_list=query_fetchall(curs)
    return rearrange_list(ssid_list,multivalue_list)



def get_inid_from_ssid(ssid_list,curs):
    sql="SELECT inid,ssid FROM gbnidssid WHERE ssid in %s;"%(list2string(ssid_list))
    execute_query(sql,curs)
    multivalue_list=query_fetchall(curs)
    return rearrange_list(ssid_list,multivalue_list)

def get_nidinid_from_ssid(ssid,curs):
    sql="SELECT nid,inid FROM gbnidssid WHERE ssid=%s;"%(ssid)
    execute_query(sql,curs)
    return query_fetchall(curs)


def get_inid_from_nid(nid_list,curs):
    sql="SELECT distinct inid,nid FROM gbnidssid WHERE nid in %s;"%( listofcharacter_2string(nid_list) )
    execute_query(sql,curs)
    multivalue_list=query_fetchall(curs)
    return rearrange_list(nid_list,multivalue_list)

def get_nodetype_from_gbnidssid(id_list,id,curs):#id can be ssid or nid and id_list is a list cooresponding to id
      id_string=list2string(id_list)
      sql="SELECT nodetype, %s from gbnidssid where %s in %s;"%(id,id, id_string)
      execute_query(sql,curs)
      nodetype_id_list=query_fetchall(curs)#nodetype_id=[(nodetype,id),(,), ...] where id =nid or id= ssid
      nodetype_list=rearrange_list(id_list,nodetype_id_list)
      return nodetype_list

def update_renderednbh(rendered_nbh,tablename,subject_ssid,curs):
    
    sql="update %s set rendered_nbh='%s' where ssid = %s; "%(tablename, b64encode (cPickle.dumps(rendered_nbh) ),subject_ssid)   
    execute_query(sql,curs)

def update_nbh_rnbh(nbh,rendered_nbh,tablename,subject_ssid,curs):

    sql="update %s set rendered_nbh='%s',nbh='%s' where ssid = %s; "%(tablename, b64encode (cPickle.dumps(rendered_nbh) ), b64encode (cPickle.dumps(nbh) ), subject_ssid)   
    execute_query(sql,curs)

def get_nbh_renderednbh(subject_ssid_list,nodetype_list,curs):
      sql="SELECT nbh, rendered_nbh, ssid FROM %s WHERE ssid in %s;"%(nodetype_list[0],list2string(subject_ssid_list))
      execute_query(sql,curs)
      multivalue_list=query_fetchall(curs)
      final_dic = {}
      for tuple in multivalue_list:
          final_dic[str(tuple[2])]={}
          final_dic[ str(tuple[2]) ]['nbh'] = cPickle.loads(b64decode(tuple[0]))
          final_dic[ str(tuple[2]) ]['rendered_nbh'] = cPickle.loads(b64decode(tuple[1]))

      return  final_dic


def get_renderednbh(subject_ssid_list,nodetype_list,curs):
      sql="SELECT rendered_nbh, ssid FROM %s WHERE ssid in %s;"%(nodetype_list[0],list2string(subject_ssid_list))
      execute_query(sql,curs)
      multivalue_list=query_fetchall(curs)
      return  rearrange_list(subject_ssid_list,multivalue_list)

def ssid_exists(ssid_list, tblname ,curs):#ssid_list=[ssid1,ssid2, ...]
      string_ssid=list2string(ssid_list)
      sql="select ssid from %s where ssid in %s;"%(tblname,string_ssid)
      execute_query(sql,curs)
      fetched_value = query_fetchall(curs)
      if fetched_value !=None:
         if len (fetched_value )==len(ssid_list):
           return 1
         else:
           return 0
      else:
        return 0

def bind_nidssid(ssid,nid,inid,tblname,curs):
           value_nid_vec="to_tsvector('"+str(nid)+"'::text)"
           sql="INSERT INTO gbnidssid values(%s,'%s',%s,'%s',%s);"%(ssid,nid,inid,tblname,value_nid_vec)
           execute_query(sql,curs)

def reset_ssid_2_latestssid(newssid,nid,curs):#-------multiple updation nedded to be done.
           sql="UPDATE gbnid_latestssid SET ssid=%s WHERE nid='%s';"%(newssid,nid)
           execute_query(sql,curs)

def bind_nidlatestssid(ssid,nid,curs):
           sql="INSERT INTO gbnid_latestssid values (%s,'%s');"%(ssid,nid)
           execute_query(sql,curs)

def commitclose(curs,conn):
           conn.commit()
           curs.close()
           conn.close()



def updateNeighbouhood_of_subject2(relntype_nid,subject1_ssid,subject2_ssid_list,subj2_snapshot_dic,subject2type,curs):
      newRelnssidList_4_subj2List = subj2_snapshot_dic['newRelnssidList_4_subj2List'] 

      sql="SELECT nbh,rendered_nbh FROM %s WHERE ssid in %s;"%(subject2type,list2string( subject2_ssid_list) )
      execute_query(sql,curs)
      pickled_list=query_fetchall(curs)#[('nbh for 1st subject2',rendered_nbh), ('nbh for 2nd subject2',rendered_nbh), ('',)]
      sql=""
      for subject2_index in range(len(subject2_ssid_list)):
          unpickled_nbh = cPickle.loads(b64decode(pickled_list[subject2_index][0] ) )
          unpickled_rnbh = cPickle.loads(b64decode(pickled_list[subject2_index][1] ) )
          if unpickled_nbh.has_key('relations'):
             unpickled_nbh['relations'] = unpickled_nbh['relations'] + newRelnssidList_4_subj2List[subject2_index] 
             if unpickled_rnbh['relations'].has_key( relntype_nid ):
                if unpickled_rnbh['relations'][relntype_nid].has_key('leftroles'):
                   unpickled_rnbh['relations'][relntype_nid]['leftroles'].append(subject1_ssid)
                else:
                   unpickled_rnbh['relations'][relntype_nid]['leftroles'] = [subject1_ssid]
             else:
                   unpickled_rnbh['relations'][relntype_nid]={}
                   unpickled_rnbh['relations'][relntype_nid]['leftroles'] = [subject1_ssid]

             
          else:
             unpickled_nbh['relations']  =  newRelnssidList_4_subj2List[subject2_index] 
             unpickled_rnbh['relations'] = {}
             unpickled_rnbh['relations'][relntype_nid]={}
             unpickled_rnbh['relations'][relntype_nid]['leftroles'] = [subject1_ssid]


          sql = sql + "UPDATE %s SET nbh='%s',rendered_nbh='%s' WHERE ssid=%s;"%(subject2type, b64encode( cPickle.dumps(unpickled_nbh)),b64encode( cPickle.dumps(unpickled_rnbh)) ,subject2_ssid_list[subject2_index]  )
      execute_query(sql,curs)



def handle_process(input,new_subject1_ssid,curs ):
      #this function writes into gbcatalogpriorstatedef, n poststatedef. 
      #writing in gbcatalogpriorstate
      priorstate_value_sql=""
      for prior_ssid in input['priorstate']:
          priorstate_value_sql=priorstate_value_sql+"("+str(new_subject1_ssid)+","+str(prior_ssid)+")"+","
            
      sql="INSERT INTO gbcatalogpriorstate VALUES %s;"%(priorstate_value_sql.rstrip(","))
      execute_query(sql,curs)
      #end of writing in  gbcatalogpriorstate

      #writing in gbcatalogpoststate
      poststate_value_sql=""
      for poststate_ssid in input['poststate']:
          poststate_value_sql=poststate_value_sql+"("+str(new_subject1_ssid)+","+str(poststate_ssid)+")"+","
          
      sql="INSERT INTO gbcatalogpoststate VALUES %s;"%(poststate_value_sql.rstrip(","))
      execute_query(sql,curs)
      #end of writing in gbcatalogpoststate

def handle_processtypes(input,new_subject1_ssid,curs ):
      #this function writes into gbcatalogpriorstatedef, n poststatedef. 
      #writing in gbcatalogpriorstatedef
      priorstatedef_value_sql=""
      for prior_ssid in input['priorstatedef']:
          priorstatedef_value_sql=priorstatedef_value_sql+"("+str(new_subject1_ssid)+","+str(prior_ssid)+")"+","

      sql="INSERT INTO gbcatalogpriorstatedef VALUES %s;"%(priorstatedef_value_sql.rstrip(","))
      execute_query(sql,curs)
      #end of writing in gbcatalogpriorstatedef

      #writing in gbcatalogpoststatedef
      poststatedef_value_sql=""
      for poststate_ssid in input['poststatedef']:
          poststatedef_value_sql=poststatedef_value_sql+"("+str(new_subject1_ssid)+","+str(poststate_ssid)+")"+","
          
      sql="INSERT INTO gbcatalogpoststatedef VALUES %s;"%(poststatedef_value_sql.rstrip(","))
      execute_query(sql,curs)
      #end of writing in gbcatalogpoststatedef
           
def istype(nodetype):
    typelist=['gbprocesstypes','gbattributetypes','gbrelationtypes','gbusertypes','gbobjecttypes','gbfunctions','gbmetatypes'] 
    if nodetype in typelist:
       return 1
    else:
       return 0


def check_relntypenid_listofsubjssid(curs,unknownrelation_list):#unknownrelation_list=[('reltypenid',['list of ssids']),()],
      list_of_relntype_nid=[]
      list_of_subjectssids=[]
      for tuple in unknownrelation_list:
          list_of_relntype_nid.append(tuple[0])
          list_of_subjectssids=list_of_subjectssids+tuple[1]

      relntype_ssid=relntype_nid_exists(list_of_relntype_nid,curs)#all relntype_nids existence validated at once.

      if relntype_ssid!=0:

         list_of_subjectssids = list(set(list_of_subjectssids))
         if ssid_exists(list_of_subjectssids,"gbnidssid",curs)==1:
             #print"reln input checks passed"
             return relntype_ssid
         else:
             return -1
      else:
          return -1

def set_attributes_4_rendered_nbh(input_attributes):#    input_attributes=input['attributes']=[(attrtype_ssid1,attrvalue),(,), ...]                   
    attrtypes_ssid_list=[attrtype_ssid[0] for attrtype_ssid in attributes]#attrtypes_ssid_list=[attrtype_ssid1,attrype_ssid2, ...]
    #validate all attrtype ssids exists                                                                                                                    
    if ssid_exists(attrtype_ssid_list,"gbattributetypes",self.curs)==0:#attrtype_ssid_list=[attrtype_ssid1,attrtype_ssid2, ...]                             
       #print"invalid attrtype_ssid."
       return -1
    #all attrtypes exists.validation over                                                                                                                   
    #fetch all attrtype_nid  corresponding to attrtype_ssids                                                                                                
    sql="select ssid,nid from gbattributetypes where ssid in %s;"%attrtypes_ssid_list
    general.execute_query(self,sql)
    attrtype_ssidnid_list=general.query_fetchall(self)
    #attrtype_ssidnid_list=[(atttrtype_ssid1,attrtype_nid1),(attrtype_ssid2,attrtype_nid2), ...]                                                            
    # creating attribute dictionary                                                                                                                         
    attributes_dic={}
    for attrtype_ssid in attrtype_ssidnid_list:
      for input_attrtype_ssid in input_attributes:
            if attrtype_ssid[0] in input_attrtype_ssid[0]:
               attributes_dic[attrtype_ssid[1]]=input_attrtype_ssid[1]

    return attributes_dic



def handle_renderednbh4_attr(rendernbh,Attrtype_nid_list,Attrvalue_list,attr_ssid_list,structure=0):

      for index in range(len(Attrtype_nid_list)):
          if rendernbh.has_key('attributes'):#nbh of a subject may not have attributes.
                  rendernbh['attributes'][Attrtype_nid_list[index]]= (attr_ssid_list[index],Attrvalue_list[index])#rendernbh has key 'attributes'
          else:#rendernbh has no key 'attributes'
                       nested_dic={}
                       nested_dic[Attrtype_nid_list[index]] = (attr_ssid_list[index],Attrvalue_list[index] )
                       rendernbh['attributes']=nested_dic
          if structure!=0:
             rendernbh['structure']=structure
      return rendernbh

              
def handle_renderednbh4_reln(rendernbh,Relntype_nid,reln_ssid_list,roleflag):
    if rendernbh.has_key('relations'):#rendernbh of a subject may not have relations.
       if rendernbh['relations'].has_key(Relntype_nid):
          if rendernbh['relations'][Relntype_nid].has_key(roleflag) :
              temp_list=[]
              temp_list = rendernbh['relations'][Relntype_nid][roleflag]
              rendernbh['relations'][Relntype_nid][roleflag]=list(set(temp_list)|set(reln_ssid_list))
          else:
              rendernbh['relations'][Relntype_nid][roleflag]=reln_ssid_list
       else:
          rendernbh['relations'][Relntype_nid]={}         
          rendernbh['relations'][Relntype_nid][roleflag]=reln_ssid_list
    else:
        rendernbh['relations']={}
        rendernbh['relations'][Relntype_nid]={}         
        rendernbh['relations'][Relntype_nid][roleflag]=reln_ssid_list
        

    return rendernbh  

def handle_rendernbh_4_inherit(rendernbh, inherit_rendernbh_dic):
    if rendernbh.has_key('attributetypes'):
       rendernbh['attributetypes'] = rendernbh['attributetypes']+ inherit_rendernbh_dic['attributetypes']
    else:
       rendernbh['attributetypes'] = inherit_rendernbh_dic['attributetypes']

    if rendernbh.has_key('relationtypes'):
       rendernbh['relationtypes'] = rendernbh['relationtypes']+ inherit_rendernbh_dic['relationtypes']
    else:
       rendernbh['relationtypes'] = inherit_rendernbh_dic['relationtypes']



def get_schema_sql(nodetype):
      if nodetype=='gbusers' or nodetype=='gbusertypes' or nodetype=='gbprocess' or nodetype=='gbprocesstypes' or nodetype=='gbobjects' or nodetype=='gbobjecttypes' or nodetype=='gbmetatypes' or nodetype == 'gbfunctions':
         return 'rendered_nbh,nbh,ssid,nid,uid,inid,status,fieldschanged,noofchanges,changetype,noofcommits,noofchangesaftercommit,history,gbtimestamp'

      elif nodetype=="gbrelationtypes":
         return 'rendered_nbh,nbh,ssid,nid,uid,inid,status,fieldschanged,noofchanges,changetype,noofcommits,noofchangesaftercommit,history,gbtimestamp,inversename,istransitive,isreflexive,issymmetrical'

      elif nodetype=="gbrelations":
         return 'rendered_nbh,nbh,ssid,nid,uid,inid,status,fieldschanged,noofchanges,changetype,noofcommits,noofchangesaftercommit,history,gbtimestamp,relationtype,subject1,subject2'

      elif nodetype=="gbattributes":
         return 'rendered_nbh,nbh,ssid,nid,uid,inid,status,fieldschanged,noofchanges,changetype,noofcommits,noofchangesaftercommit,history,gbtimestamp,attributetype,subjectid,datatype'

      elif nodetype=="gbattributetypes":
         return 'rendered_nbh,nbh,ssid,nid,uid,inid,status,fieldschanged,noofchanges,changetype,noofcommits,noofchangesaftercommit,history,gbtimestamp,restrictiontype,restrictionref'


def get_schema(nodetype):
      if nodetype=='gbusers' or nodetype=='gbusertypes' or nodetype=='gbprocess' or nodetype=='gbprocesstypes' or nodetype=='gbobjects' or nodetype=='gbobjecttypes' or nodetype=='gbmetatypes' or nodetype == 'gbfunctions':
         return ['rendered_nbh','nbh','ssid','nid','uid','inid','status','fieldschanged','noofchanges','changetype','noofcommits','noofchangesaftercommit','history','gbtimestamp']

      elif nodetype=="gbrelationtypes":
         return ['rendered_nbh','nbh','ssid','nid','uid','inid','status','fieldschanged','noofchanges','changetype','noofcommits','noofchangesaftercommit','history','gbtimestamp','inversename','istransitive','isreflexive','issymmetrical']

      elif nodetype=="gbrelations":
         return ['rendered_nbh','nbh','ssid','nid','uid','inid','status','fieldschanged','noofchanges','changetype','noofcommits','noofchangesaftercommit','history','gbtimestamp','relationtype','subject1','subject2']

      elif nodetype=="gbattributes":
         return ['rendered_nbh','nbh','ssid','nid','uid','inid','status','fieldschanged','noofchanges','changetype','noofcommits','noofchangesaftercommit','history','gbtimestamp','attributetype','subjectid','datatype']

      elif nodetype=="gbattributetypes":
         return ['rendered_nbh','nbh','ssid','nid','uid','inid','status','fieldschanged','noofchanges','changetype','noofcommits','noofchangesaftercommit','history','gbtimestamp','restrictiontype','restrictionref']

def get_oldsnapshotdata(curs,nodetype,ssid):
      sql="SELECT * from %s where ssid=%s;"%(nodetype,ssid)
      execute_query(sql,curs)
      old_snapshot_data=query_fetchall(curs)
      return old_snapshot_data


def get_inversename(relntype_nid,curs):
      sql="SELECT inversename FROM gbrelationtypes where nid='%s';"%relntype_nid
      execute_query(sql,curs)
      return query_fetchall(curs)[0][0]



def update2newsnapshot(input,new_subject_ssid,commit,curs,new_attrssid_list=[],attrvalue_list=[],A_attr_nid_list=[],U_attr_nid_list=[],listof_new_relnssid_list=[],new_subj2ssid_list=[],listof_relntype_nid=[]):

      nodetype = input['nodetype']
      uid = input['uid']
      old_subjectssid = input['subject']
      structure = input['structure']
       
      #---------------------for attributes-------------------------single subject to which multiple attributes can be attached all of diferent attrtype.
      #nodetype = ndtype of the subject to which the attr is about to get attached.
      #old_subjectssid = old ssid of subject--->single value
      #new_subjectssid = new ssid of subject--->singlevalue
      #type_nid_list= attrtype_nid_list---multivalue list--list of attrtype_nids. len(attrtype_nid_list]==no of attributes to attach
      #A_attr_nid_list=list of  attr_nid to attach
      #U_attr_nid_list= list of attr_nid to update.
      #new_attrssid_list = [new ssid of all the attributes].--->[new_s1,new_s2, ...]=[new attr ssid for update]+[new attr ssid for attach]
      #attrvalue_list = list of attribute values
        
      #-----------------------for relations------------------
      #listof_relntype_nid = [ 1st relntypenid, 2nd relntype_nid, ...]
      #listof_new_relnssid_list=[ [list of new relnssid for 1st relntypenid],[list of new relnssid for 2nd relntypenid], ....]
      #new_subj2ssid_list=[ {inherit dic},[list of new ssid of subj2 related with 1st relntypenid], [list of new ssid of subj2 related with 2nd relntypenid], ...]
      columns_schema=get_schema(nodetype)

      #columns_schema=['col1name','col2name', ...]
      #columns_schema[0]=col1name

      values_sql="("
      schema_sql=get_schema_sql(nodetype)

      sql="SELECT %s from %s where ssid=%s;"%(schema_sql,nodetype,old_subjectssid)

      execute_query(sql,curs)
      old_snapshot_data=query_fetchall(curs)

      #old_snapshot_data=[(ssid,nid,uid,...)]
      #old_snapshot_data[0][1]=nid , ...1

      changedtype=""
      noofchanges_count=0
      noofcommits=0
      fields_changed=""
      colindex=0

      #1) rendered_nbh 

      old_rendernbh={}                             
      if old_snapshot_data[0][colindex]==None or old_snapshot_data[0][colindex]=='':
                    #previous snapshot had no rendernbh
                    pass 
      else: 
                     old_rendernbh=cPickle.loads(  b64decode( old_snapshot_data[0][colindex] ) ) #rendernbh={}
                     
      if (A_attr_nid_list!=[] ) or ( U_attr_nid_list!=[]):#this is 4 attrs
                        attrtype_nid_list = U_attr_nid_list + A_attr_nid_list #order of addition of list is important
                        #print attrtype_nid_list
                        rendered_nbh=handle_renderednbh4_attr(old_rendernbh,attrtype_nid_list,attrvalue_list,new_attrssid_list,structure)

                        if new_subj2ssid_list!=[]:#this is 4 relns  
                           inherit_rendernbh_dic = new_subj2ssid_list.pop(0)
                           for index in range(len(new_subj2ssid_list )): 
                               #rendered_nbh is passed and not old_rendernbh as previous stage o/p dic is now to be modified
                               rendered_nbh = handle_renderednbh4_reln(rendered_nbh, listof_relntype_nid[index] ,new_subj2ssid_list[index],'rightroles')
                           if inherit_rendernbh_dic != {} : 
                              handle_rendernbh_4_inherit(rendered_nbh, inherit_rendernbh_dic)

      elif new_subj2ssid_list!=[]:  
                         inherit_rendernbh_dic = new_subj2ssid_list.pop(0)
                         rendered_nbh = old_rendernbh
                         for index in range(len(new_subj2ssid_list )): 
                             rendered_nbh = handle_renderednbh4_reln(rendered_nbh, listof_relntype_nid[index] ,new_subj2ssid_list[index],'rightroles')
                         if inherit_rendernbh_dic != {} : 
                              handle_rendernbh_4_inherit(rendered_nbh, inherit_rendernbh_dic)
      

      #start updating priorstate/def poststate/def.------
      if nodetype=='gbprocess':
         if input.has_key('priorstate'):
            rendered_nbh['priorstate'] = rendered_nbh['priorstate'] + input['priorstate']
            fields_changed = fields_changed + "priorstate," 
            changedtype=changedtype+"2,"
            noofchanges_count= noofchanges_count+1

         if input.has_key('poststate'):
            rendered_nbh['poststate'] = rendered_nbh['poststate'] + input['poststate']
            fields_changed = fields_changed + "poststate," 
            changedtype=changedtype+"2,"
            noofchanges_count= noofchanges_count+1

      if nodetype=='gbprocesstypes':
         if input.has_key('priorstatedef'):
            rendered_nbh['priorstatedef'] = rendered_nbh['priorstatedef'] + input['priorstatedef']
            fields_changed = fields_changed + "priorstatedef," 
            changedtype=changedtype+"2,"
            noofchanges_count= noofchanges_count+1
                        
         if input.has_key('poststatedef'):
            rendered_nbh['poststatedef'] = rendered_nbh['poststatedef'] + input['poststatedef']
            fields_changed = fields_changed + "poststatedef," 
            changedtype=changedtype+"2,"
            noofchanges_count= noofchanges_count+1
                        


      values_sql=values_sql+"'"+ b64encode( cPickle.dumps(rendered_nbh) )+"',"

      colindex = colindex + 1

      #2) handling 'nbh':

      nbh={}             
      a_nbh_list=[]
      r_nbh_list=[]
      if old_snapshot_data[0][colindex]==None or old_snapshot_data[0][colindex]=='':
                    pass
      else:   
                    nbh=cPickle.loads(  b64decode(old_snapshot_data[0][colindex] ) )#nbh={}
                    if nbh.has_key('attributes'):
                       a_nbh_list=nbh['attributes']#nbh_list=[list of attr ssid]
                    if nbh.has_key('relations'): 
                       r_nbh_list=nbh['relations']

      if new_attrssid_list != []:      
                    nbh['attributes']=a_nbh_list+new_attrssid_list

      if listof_new_relnssid_list != []:    
                    for new_relnssid_list in listof_new_relnssid_list:
                        r_nbh_list=r_nbh_list + new_relnssid_list
                    nbh['relations']=r_nbh_list
      values_sql=values_sql+"'"+ b64encode( cPickle.dumps(nbh) )+"',"

      colindex = colindex + 1

      # 3) calculating 'ssid':
      values_sql=values_sql+str(new_subject_ssid)+","
      colindex = colindex + 1

      #4) handling 'nid':
      nid= old_snapshot_data[0][colindex]
      values_sql=values_sql+"'"+str( old_snapshot_data[0][colindex])+"'," 
      colindex = colindex + 1

      #5) handling 'uid':
      values_sql=values_sql+str(uid)+"," 
      #print values_sql 
      colindex = colindex + 1

      #6)handling 'inid':
      values_sql=values_sql+str(old_snapshot_data[0][colindex])+", " 
      #print values_sql 
      colindex = colindex + 1

      #7)handling 'status':
      if commit == 1:
         values_sql=values_sql+"'public',"
      else:
         values_sql=values_sql+"'private',"

      colindex = colindex + 1

      #8)handling 'fieldschanged':
      values_sql=values_sql+"'{"
      if structure!=0:
         if 'structure' in old_snapshot_data[0][colindex]:
            fields_changed = fields_changed + 'structure' +','
            changedtype=changedtype+"2,"
            noofchanges_count= noofchanges_count+1
         else:
            fields_changed = fields_changed + 'structure' +','
            changedtype=changedtype+"1,"
            noofchanges_count= noofchanges_count+1
                       
      if U_attr_nid_list!=[]:           
         for u_attr_nid in U_attr_nid_list :
            fields_changed = fields_changed + u_attr_nid +','
            changedtype=changedtype+"2,"
            noofchanges_count= noofchanges_count+1

      if A_attr_nid_list!=[]:           
         for a_attr_nid in A_attr_nid_list:
            fields_changed = fields_changed + a_attr_nid +','
            changedtype=changedtype+"1,"
            noofchanges_count= noofchanges_count+1
            

      if listof_relntype_nid!=[] :    
         for relntype_nid in listof_relntype_nid :
             fields_changed = fields_changed + str(relntype_nid) +','
             noofchanges_count= noofchanges_count+1
             if relntype_nid in  old_snapshot_data[0][colindex]:
                changedtype=changedtype+"1,"
             else:
                changedtype=changedtype+"2,"

      values_sql=values_sql+ fields_changed.rstrip(",")+"}', " 
      colindex = colindex + 1

      # 9)handling 'noofchanges':
      values_sql=values_sql+str( noofchanges_count )+", " #1 is for structure
      #print values_sql 
      colindex = colindex + 1

      # 10)handling 'changetype':
      values_sql=values_sql+"'{"+changedtype.rstrip(",")+"}',"
      colindex = colindex + 1

      #11) handling 'noofcommits':
      sql="select max(noofcommits) from %s where nid='%s';"%(nodetype,nid)
      execute_query(sql,curs)
      noofcommits =query_fetchall(curs)[0][0]
      if commit == 1 :
                    noofcommits = noofcommits + 1
      values_sql=values_sql+str(noofcommits)+", " 
      colindex = colindex + 1

      #12)handling 'noofchangesaftercommit':
      if commit==0:
                    sql="select max(noofchangesaftercommit) from %s where nid = '%s' and noofcommits = %s;"%(nodetype,nid,noofcommits)
                    execute_query(sql,curs)
                    noofchangesaftercommit = query_fetchall(curs)[0][0]
                    noofchangesaftercommit = noofchangesaftercommit + 1
      else:
                    noofchangesaftercommit = 0
      values_sql=values_sql+str( noofchangesaftercommit )+", " 
      colindex = colindex + 1

      # 13)handling 'history':
      values_sql=values_sql+"'{"
      for noofelems in old_snapshot_data[0][colindex]:
                     values_sql=values_sql+str(noofelems)+","
      values_sql=values_sql+old_subjectssid+"}', " 
      colindex = colindex + 1

      # 14)handling 'gbtimestamp':
      values_sql=values_sql+"now()"+","        
      colindex = colindex + 1

      while (colindex < len(columns_schema) ):
            if isinstance( old_snapshot_data[0][colindex] , str):
               values_sql=values_sql+"'"+str(old_snapshot_data[0][colindex])+"'," 
            else:
               values_sql=values_sql+str(old_snapshot_data[0][colindex])+"," 
            colindex = colindex + 1 
                             
      values_sql=values_sql.rstrip(",")+")" 
      sql="INSERT INTO %s (%s) values %s;"%(nodetype,schema_sql,values_sql)
      execute_query(sql,curs)


def updatestructure(nodetype,uid,old_subjectssid,new_subject_ssid,structure,commit,curs):
      #nodetype = ndtype of the subject to which the attr is about to get attached.
      #old_subjectssid = old ssid of subject--->single value
      #new_subjectssid = new ssid of subject--->singlevalue
      columns_schema=get_schema(nodetype)

      #columns_schema=['col1name','col2name', ...]
      #columns_schema[0]=col1name

      columns_sql="("
      values_sql="("
      schema_sql=get_schema_sql(nodetype)
      sql="SELECT %s from %s where ssid=%s;"%(schema_sql,nodetype,old_subjectssid)
      execute_query(sql,curs)
      old_snapshot_data=query_fetchall(curs)

      #old_snapshot_data=[(ssid,nid,uid,...)]
      #old_snapshot_data[0][1]=nid , ...1

      changedtype=""
      noofchanges_count=0
      noofcommits=0
      colindex=0

      # 1)'rendered_nbh':
      old_rendernbh={}                             
      if old_snapshot_data[0][colindex]==None or old_snapshot_data[0][colindex]=='':
          pass 
      else:  
          old_rendernbh=cPickle.loads(  b64decode( old_snapshot_data[0][colindex] ) ) #rendernbh={}
      old_rendernbh['structure']=structure    
      values_sql=values_sql+"'"+ b64encode( cPickle.dumps(old_rendernbh) )+"',"
      colindex = colindex + 1 

      #2)'nbh'
      values_sql=values_sql+"'"+str( old_snapshot_data[0][colindex] )+"',"
      colindex = colindex + 1 

      #3)'ssid'
      values_sql=values_sql+str(new_subject_ssid)+","
      colindex = colindex + 1 

      #4)'nid'
      nid= old_snapshot_data[0][colindex]
      values_sql=values_sql+"'"+str( old_snapshot_data[0][colindex])+"'," 
      colindex = colindex + 1 

      #5)'uid'
      values_sql=values_sql+str(uid)+"," 
      colindex = colindex + 1 

      #6)'inid'
      values_sql=values_sql+str(old_snapshot_data[0][colindex])+", " 
      colindex = colindex + 1 

      #7)elif columns_schema[colindex]=='status':
      if commit == 1:
         values_sql=values_sql+"'public',"
      else:
         values_sql=values_sql+"'private',"


      colindex = colindex + 1 

      #8)'fieldschanged'
      values_sql=values_sql+"'{"

      for old_change_data in old_snapshot_data[0][colindex]:
                     values_sql = values_sql + str( old_change_data)+","
                     if old_change_data=='structure':
                        changedtype=changedtype+"2,"
                     else:
                        changedtype=changedtype+"0,"
      values_sql=values_sql.rstrip(",")+"}', " 
      colindex = colindex + 1 

      #9)'noofchanges'
                
      values_sql=values_sql+"1, " 
      colindex = colindex + 1 


      #10)'changetype'
      values_sql=values_sql+"'{"+changedtype.rstrip(",")+"}',"
      colindex = colindex + 1 

      #11)noofcommits
      sql="select max(noofcommits) from %s where nid='%s';"%(nodetype,nid)
      execute_query(sql,curs)
      noofcommits =query_fetchall(curs)[0][0]
      if commit == 1 :
                    noofcommits = noofcommits + 1
      values_sql=values_sql+str(noofcommits)+", " 
      colindex = colindex + 1 
                 
      #12)'noofchangesaftercommit'
      if commit==0:
                    sql="select max(noofchangesaftercommit) from %s where nid = '%s' and noofcommits = %s;"%(nodetype,nid,noofcommits)
                    execute_query(sql,curs)
                    noofchangesaftercommit = query_fetchall(curs)[0][0]
                    noofchangesaftercommit = noofchangesaftercommit + 1
      else:
                    noofchangesaftercommit = 0
      values_sql=values_sql+str( noofchangesaftercommit )+", " 
      colindex = colindex + 1 
 
      #13)'history'
      values_sql=values_sql+"'{"
      for noofelems in old_snapshot_data[0][colindex]:
                     values_sql=values_sql+str(noofelems)+","
      values_sql=values_sql+old_subjectssid+"}', " 
      colindex = colindex + 1 

      #14)'gbtimestamp'
      values_sql=values_sql+"now()"+","        
      colindex = colindex + 1 


      while (colindex < len(columns_schema) ):
            values_sql=values_sql+str(old_snapshot_data[0][colindex])+", " 
            colindex = colindex + 1 
                 
      values_sql=values_sql.rstrip(",")+")"                                      
     

      sql="INSERT INTO %s (%s) values %s;"%(nodetype,schema_sql,values_sql)

      execute_query(sql,curs)




def create_newsnapshot(render_what,nodetype_list,uid,old_subjectssid_list,new_subject_ssid_list,type_nid_list,listof_ssid_list,rendernbhData_list,curs):
    #modifying first_ssid to ssid_list i.e,([new_attr_ssid_list],[new_reln_ssid_list corr to each subjectssid])
    #---------------------for attributes-------------------------single subject to which multiple attributes can be attached all of diferent attrtype.
    #nodetype_list=[ndtype of the subject to which the attr is about to get attached.] --->singlevalue
    #old_subjectssid_list=list of old ssid of subject--->single value
    #new_subjectssid_list=list of new ssid of subject--->singlevalue
    #type_nid_list= attrtype_nid_list---multivalue list--list of attrtype_nids. len(attrtype_nid_list]==no of attributes to attach
    #ssid_list=[[new ssid of all the attributes]].--->[[new_s1,new_s2, ...]]
    #rendernbhData_list = list of attribute values


    #-------------------------for relations-------------------single relation of a relationtype between multiple subjects
    #nodetype_list=[ndtype4ssid1of subj1,ndtype4ssid2of sub1,ndtype4ssid3 for subj1, only subj1's ...] 
    #old_subjectssid_list=list of old ssid of subject1
    #new_subjectssid_list=list of new ssid of subject1
    #type_nid_list= relntype_nid_list---single value list
    #ssid_list=new ssid of the relation--->[[new_s1_ofsubj1,new_s2_ofsubj1, ...],[new_s1_ofsubj2,new_s1_ofsubj2, ...], ...]
    #rendernbhData_list=[renderednbh dic 4 inherit , subject2_ssid_list + appended(leftrole/rightrole) ]
    # rendernbhData_list=[{inherit} , new_s1_of_subj2ssid1,new_s2_ofsubj2ssid2,...,rightrole]--->for new snapshot of subj1_list
    # rendernbhData_list=[{blank always} , new_s1_of_subj1ssid1,new_s2_ofsubj1ssid2,...,leftrole]--->for new snapshot of subj2_list
    #select the previous record of the subject_ssid to create new snapshot of it.
    if render_what == 'relations':
              inherit_rendernbh_dic = rendernbhData_list.pop(0)
              roleflag = rendernbhData_list.pop()

    combined_sql=""
    for n in range(len(nodetype_list)):

      columns_schema=get_schema(nodetype_list[n])

      #columns_schema=['col1name','col2name', ...]
      #columns_schema[0]=col1name
      values_sql="("
      schema_sql=get_schema_sql(nodetype_list[n])

      sql="SELECT %s from %s where ssid=%s;"%(schema_sql,nodetype_list[n],old_subjectssid_list[n])

      execute_query(sql,curs)
      old_snapshot_data=query_fetchall(curs)

      #old_snapshot_data=[(ssid,nid,uid,...)]
      #old_snapshot_data[0][1]=nid , ...1

      changedtype_value=""
      noofchanges_count=0
      
      colindex=0

      #1)   rendered_nbh

      rendernbh={}                             
      if old_snapshot_data[0][colindex]==None or old_snapshot_data[0][colindex]=='':
         pass 
      else:  
         rendernbh=cPickle.loads(  b64decode( old_snapshot_data[0][colindex] ) ) #rendernbh={}
      #call to corresponding
      if render_what=="attributes":
               rendered_nbh=handle_renderednbh4_attr(rendernbh,type_nid_list,rendernbhData_list,listof_ssid_list[0],0)#this 0 is for 'structure'
               values_sql=values_sql+"'"+ b64encode( cPickle.dumps(rendered_nbh) )+"',"
      else: # render_what=="relations"
              new_rendered_nbh = handle_renderednbh4_reln(rendernbh,type_nid_list[0],rendernbhData_list,roleflag)
              if inherit_rendernbh_dic!={}:
                 handle_rendernbh_4_inherit(new_rendered_nbh, inherit_rendernbh_dic)

              values_sql=values_sql+"'"+ b64encode( cPickle.dumps(new_rendered_nbh) )+"',"


      #2 ) nbh
      colindex = colindex + 1 

      nbh={}             
      nbh_list=[]
      if old_snapshot_data[0][colindex]==None or old_snapshot_data[0][colindex]=='':
               pass
      else:   
               nbh=cPickle.loads(  b64decode(old_snapshot_data[0][colindex] ) )#nbh={}

      if nbh.has_key(render_what):
               nbh_list=nbh[render_what]#nbh_list=[list of attr/reln ssid]


      nbh[render_what]=nbh_list+listof_ssid_list[n]        

      values_sql=values_sql+"'"+ b64encode( cPickle.dumps(nbh) )+"',"


      #3) ssid
      colindex = colindex + 1 

      # writing new ssid
      values_sql=values_sql+str(new_subject_ssid_list[n])+","


      #4)nid
      colindex = colindex + 1 
      nid= old_snapshot_data[0][colindex]
      values_sql=values_sql+"'"+str( old_snapshot_data[0][colindex])+"'," 


      #5) uid
      colindex = colindex + 1 
      values_sql=values_sql+str(uid)+"," 


      #6) inid
      colindex = colindex + 1 
      #inid calculation
      values_sql=values_sql+str(old_snapshot_data[0][colindex])+", " 


      #7) status
      values_sql=values_sql+"'public',"
      colindex = colindex + 1 

      
      #8) fieldschanged
      colindex = colindex + 1 
      #fieldschanged calculation
      values_sql=values_sql+"'{"
      
                 
      if render_what=="relations": 
               if roleflag=="leftroles":
                  inversename=get_inversename(type_nid_list[0],curs)
                  values_sql=values_sql + str(inversename) + ","
                  changedtype_value= changedtype_value +"1,"
                  noofchanges_count=1
               else:
                  values_sql=values_sql + str(type_nid_list[0]) +","
                  changedtype_value= changedtype_value +"1,"
                  noofchanges_count=1
      else:   #this is for attributes.
         for type_nids in type_nid_list: 
             values_sql=values_sql + type_nids + ","
             changedtype_value= changedtype_value +"1,"
             noofchanges_count=noofchanges_count+1

      values_sql=values_sql.rstrip(',')+"}', " 


      #9) noofchanges
      colindex = colindex + 1 

      #'noofchanges' calculation
      values_sql=values_sql+str( noofchanges_count )+", " 


      #10) changetype
      colindex = colindex + 1 

      #'changetype': calculaion

      values_sql=values_sql+"'{"
      values_sql=values_sql+changedtype_value
      values_sql=values_sql.rstrip(",")+"}',"                                                   


      #11)noofcommits
      colindex = colindex + 1 

      #'noofcommits': calculation
      sql="select max(noofcommits) from %s where nid='%s';"%(nodetype_list[n],nid)
      execute_query(sql,curs)
      noofcommits =query_fetchall(curs)
      noofcommits = noofcommits[0][0] + 1                                                                                                       
      values_sql=values_sql+str(noofcommits)+", " 

      #12)noofchangesaftercommit
      colindex = colindex + 1 
      values_sql=values_sql+str(old_snapshot_data[0][colindex])+", " 
      colindex = colindex + 1 

      
      #13)
      #'history': calcuation

      values_sql=values_sql+"'{"
      for noofelems in old_snapshot_data[0][colindex]:
                values_sql=values_sql+str(noofelems)+","
      values_sql=values_sql+old_subjectssid_list[n]+"}', " 

      #14)timestamp
      colindex = colindex + 1 
      #'gbtimestamp': calculation
      values_sql=values_sql+"now()"+","        
      colindex = colindex + 1 
      while (colindex < len(columns_schema) ):
            values_sql = values_sql+str(old_snapshot_data[0][colindex])+", " 
            colindex = colindex + 1 

      values_sql=values_sql.strip()
      values_sql=values_sql.rstrip(",")
      values_sql=values_sql + ")"                                      
      
      sql="INSERT INTO %s (%s) values %s;"%(nodetype_list[n], schema_sql,values_sql)

      combined_sql=combined_sql+sql   

    execute_query(combined_sql,curs)



def newsnapshot_4_delete( input,new_subject_ssid,curs,commit=1,status='public',reln_Data_dic={},Attr_data_dic={}):
      # Attr_renderednbh_dic= new rendered_nbh with correct values for 'attributes'
      # reln_Data_dic['nbh'] = list of reln ssid to be removed
      # reln_Data_dic['rnbh'] = input['relation']= [('relntypenid','roleflag',[list of ssid of s2]), ...]
      # Attr_data_dic['rendernbh_data'] = new_renderednbh['attributes'] #this is to straightly attach
      # Attr_data_dic['nbh_data'] = attrssid_list# this is to remove 
      # Attr_data_dic['fieldschanged']= [list of attrtypenid]
      nodetype = input['nodetype']
      columns_schema=get_schema(nodetype)

      #columns_schema=['col1name','col2name', ...]
      #columns_schema[0]=col1name
      uid = input['uid']

      old_subjectssid = input['subject']
      
      values_sql="("
      schema_sql=get_schema_sql(nodetype)
      sql="SELECT %s from %s where ssid=%s;"%(schema_sql,nodetype,old_subjectssid)


      execute_query(sql,curs)
      old_snapshot_data=query_fetchall(curs)

      #old_snapshot_data=[(ssid,nid,uid,...)]
      #old_snapshot_data[0][1]=nid , ...1

      changedtype=""
      noofchanges_count=0
      noofcommits=0
      colindex=0
      fields_changed=""
      #1 ) 'rendered_nbh':
      old_rendernbh = cPickle.loads(  b64decode( old_snapshot_data[0][colindex] ) ) #rendernbh={}
      # deleting priorstatedef/poststatedef if given in input.--- start
      #if nodetype == 'gbprocesstypes':
      if input.has_key('priorstatedef'):
         old_renderednbh['priorstatedef'] = old_renderednbh['priorstatedef'] - input['priorstatedef']
         fields_changed = fields_changed + "priorstatedef," 
         noofchanges_count = noofchanges_count + 1
         if old_renderednbh['priorstatedef']==[]:
               changedtype = changedtype+"3,"
         else:
               changedtype = changedtype+"2,"

      if input.has_key('poststatedef'):
         old_renderednbh['poststatedef'] = old_renderednbh['poststatedef'] - input['poststatedef']
         fields_changed = fields_changed + "poststatedef," 
         noofchanges_count = noofchanges_count + 1
         if old_renderednbh['poststatedef']==[]:
               changedtype = changedtype+"3,"
         else:
               changedtype = changedtype+"2,"
            
      #if nodetype == 'gbprocess':
      if input.has_key('poststate'):
         old_renderednbh['poststate'] = old_renderednbh['poststate'] - input['poststate']
         fields_changed = fields_changed + "poststate," 
         noofchanges_count = noofchanges_count + 1
         if old_renderednbh['poststate']==[]:
               changedtype = changedtype+"3,"
         else:
               changedtype = changedtype+"2,"

      if input.has_key('priorstate'):
         old_renderednbh['priorstate'] = old_renderednbh['priorstate'] - input['priorstate']
         fields_changed = fields_changed + "priorstate," 
         noofchanges_count = noofchanges_count + 1
         if old_renderednbh['priorstate']==[]:
               changedtype = changedtype+'3,'
         else:
               changedtype = changedtype+'2,'
      #end ------
      


      if reln_Data_dic.has_key('rnbh'):#there are some reln to remove
                  for tuple in reln_Data_dic['rnbh']:
                      if old_rendernbh['relations'][tuple[0]][tuple[1]] == tuple[2]:#no of sub2 ssid to delete = 
                         old_rendernbh['relations'].pop(tuple[0])
                      else:
                         old_rendernbh['relations'][tuple[0]][tuple[1]]= list( set( old_rendernbh['relations'][tuple[0]][tuple[1]] ) - set(tuple[2]) )
                      fields_changed = fields_changed + str(tuple[0]) + "," 
                      changedtype = changedtype+"3,"
                      noofchanges_count = noofchanges_count + 1

      if Attr_data_dic.has_key('rendernbh_data'):          
                  old_rendernbh['attributes'] = Attr_data_dic['rendernbh_data']
                  for attr_nid_2_del in  Attr_data_dic['fieldschanged'] :
                      fields_changed = fields_changed + str( attr_nid_2_del) + "," 
                      changedtype = changedtype+"3,"
                      noofchanges_count = noofchanges_count + 1
         
      values_sql=values_sql+"'"+ b64encode( cPickle.dumps(old_rendernbh) )+"',"
      colindex = colindex + 1                

      #2) 'nbh'
      
      nbh=cPickle.loads(  b64decode(old_snapshot_data[0][colindex] ) )#nbh={}
      if reln_Data_dic.has_key('nbh'):
                    nbh['relations'] = list(set (nbh['relations'] )- set( reln_Data_dic['nbh'] ) )
      if Attr_data_dic.has_key('nbh_data'):
                    nbh['attributes'] = list(set (nbh['attributes'] )- set( Attr_data_dic['nbh_data'] ) )

      values_sql=values_sql+"'"+ b64encode( cPickle.dumps(nbh) )+"',"
      colindex = colindex + 1 

            
      #3)'ssid'
      values_sql=values_sql+str(new_subject_ssid)+","
      colindex = colindex + 1 

      #4)'nid'
      nid= old_snapshot_data[0][colindex]
      values_sql=values_sql+"'"+str( old_snapshot_data[0][colindex])+"'," 
      colindex = colindex + 1 

      #5)'uid':
      values_sql=values_sql+str(uid)+"," 
      colindex = colindex + 1 

      #6) 'inid'
      values_sql=values_sql+str(old_snapshot_data[0][colindex])+", " 
      colindex = colindex + 1 

      #7)'status'
      if commit == 1:
         values_sql=values_sql+"'public',"
      else:
         values_sql=values_sql+"'private',"


      colindex = colindex + 1 

      #8) 'fieldschanged':

      values_sql=values_sql+"'{" + fields_changed.rstrip(",")+"}', " 
      colindex = colindex + 1 

      #9) 'noofchanges' 
      values_sql=values_sql+str( noofchanges_count )+"," #1 is for structure
      colindex = colindex + 1 

      #10) 'changetype'
      values_sql=values_sql+"'{"+changedtype.rstrip(",")+"}',"
      colindex = colindex + 1 

      #11) noofcommits'
      sql="select max(noofcommits) from %s where nid='%s';"%(nodetype,nid)
      execute_query(sql,curs)
      noofcommits =query_fetchall(curs)[0][0]
      if commit == 1 :
                    noofcommits = noofcommits + 1
      values_sql=values_sql+str(noofcommits)+", " 
      colindex = colindex + 1 

      #12)'noofchangesaftercommit':
      if commit==0:
                    sql="select max(noofchangesaftercommit) from %s where nid = '%s' and noofcommits = %s;"%(nodetype,nid,noofcommits)
                    execute_query(sql,curs)
                    noofchangesaftercommit = query_fetchall(curs)[0][0]
                    noofchangesaftercommit = noofchangesaftercommit + 1
      else:
                    noofchangesaftercommit = 0
      values_sql=values_sql+str( noofchangesaftercommit )+", " 
      colindex = colindex + 1 
 
      #13)'history':
      values_sql=values_sql+"'{"
      for noofelems in old_snapshot_data[0][colindex]:
                     values_sql=values_sql+str(noofelems)+","
      values_sql=values_sql+old_subjectssid+"}', " 
      colindex = colindex + 1 

      #14)'gbtimestamp':
      values_sql=values_sql+"now()"+","        
      colindex = colindex + 1 


      while (colindex < len(columns_schema) ):
            values_sql=values_sql+str(old_snapshot_data[0][colindex])+", " 
            colindex = colindex + 1 
                 
      values_sql=values_sql.rstrip(",")+")"                                      
      
      sql="INSERT INTO %s (%s) values %s;"%(nodetype,schema_sql,values_sql)
      execute_query(sql,curs)



def removeRelation_4_newSnapshot(nodetype,uid,old_subjectssid,new_subject_ssid,nbhData_list,rnbhData_list,subject1_ssid,curs,commit=1):

      #rnbhData_list=[(relntypenid,roleflag of s1) ,...]


      columns_schema=get_schema(nodetype)

      #columns_schema=['col1name','col2name', ...]
      #columns_schema[0]=col1name

      fields_changed=""
      values_sql="("
      colindex=0
      schema_sql=get_schema_sql(nodetype)
      sql="SELECT %s from %s where ssid=%s;"%(schema_sql,nodetype,old_subjectssid)

      execute_query(sql,curs)
      old_snapshot_data=query_fetchall(curs)

      #old_snapshot_data=[(ssid,nid,uid,...)]
      #old_snapshot_data[0][1]=nid , ...1

      changedtype=""
      noofchanges_count=0
      noofcommits=0
      
      #1)' rendered_nbh'
      old_rendernbh={}                             
      old_rendernbh = cPickle.loads(  b64decode( old_snapshot_data[0][colindex] ) ) #rendernbh={}

      #rnbhData_list=[(relntypenid,roleflag of s1) ,...]
      for tuple in rnbhData_list:
                     fields_changed = fields_changed+ tuple[0]+","#this is req 4 fieldschanged calculation
                     changedtype = changedtype+"3,"
                     noofchanges_count = noofchanges_count + 1

                     v=old_rendernbh['relations'][tuple[0]][tuple[1]]

                     if str(subject1_ssid) in v:
                        v = list(set(v)-set([subject1_ssid]))

                        if v==[]:
                           if tuple[1]=='rightroles':
                              if old_rendernbh['relations'][tuple[0]].has_key('leftroles'):
                                 old_rendernbh['relations'][tuple[0]].pop( tuple[1] )
                              else:
                                 old_rendernbh['relations'].pop( tuple[0] )
                           else:      
                              if old_rendernbh['relations'][tuple[0]].has_key('rightroles'):
                                 old_rendernbh['relations'][tuple[0]].pop( tuple[1] )
                              else:
                                 old_rendernbh['relations'].pop( tuple[0] )
                     """            
                     old_rendernbh['relations'][tuple[0]][tuple[1]] = v   
                     if old_rendernbh['relations'][tuple[0]][tuple[1]]==[]:#if no values for that particular relntype delete relntype
                        old_rendernbh['relations'][tuple[0]].pop( tuple[1] )
                     """   

      values_sql=values_sql+"'"+ b64encode( cPickle.dumps(old_rendernbh) )+"',"
      colindex = colindex + 1 

      #2) 'nbh'
      nbh=cPickle.loads(  b64decode(old_snapshot_data[0][colindex] ) )#nbh={}
      nbh['relations'] = list ( set( nbh['relations'])-set(nbhData_list) )
      values_sql=values_sql+"'"+ b64encode( cPickle.dumps(nbh) )+"',"
      colindex = colindex + 1 
      
      #3) 'ssid':
      values_sql=values_sql+str(new_subject_ssid)+","
      colindex = colindex + 1 

      #4) 'nid'
      nid= old_snapshot_data[0][colindex]
      values_sql=values_sql+"'"+str( old_snapshot_data[0][colindex])+"'," 
      colindex = colindex + 1 

      #5)'uid'
      values_sql=values_sql+str(uid)+"," 
      colindex = colindex + 1 

      #6)   'inid'
      values_sql=values_sql+str(old_snapshot_data[0][colindex])+", " 
      colindex = colindex + 1 

      #7)'status'
      if commit == 1:
         values_sql=values_sql+"'public',"
      else:
         values_sql=values_sql+"'private',"

      
      colindex = colindex + 1 

      # 8) 'fieldschanged'
      
      values_sql=values_sql+"'{" + fields_changed.rstrip(",") + "}', " 
      colindex = colindex + 1 


      #9) 'noofchanges':
      values_sql=values_sql+str( noofchanges_count )+", " #1 is for structure
      colindex = colindex + 1 

      #10) changetype':
      values_sql=values_sql+"'{"+changedtype.rstrip(",")+"}',"
      colindex = colindex + 1 

      #11) 'noofcommits':
      sql="select max(noofcommits) from %s where nid='%s';"%(nodetype,nid)
      execute_query(sql,curs)
      noofcommits =query_fetchall(curs)[0][0]

      if commit == 1 :
                    noofcommits = noofcommits + 1
      values_sql=values_sql+str(noofcommits)+", " 
      colindex = colindex + 1 
                 
      #12) 'noofchangesaftercommit'
      if commit==0:
                    sql="select max(noofchangesaftercommit) from %s where nid = '%s' and noofcommits = %s;"%(nodetype,nid,noofcommits)
                    execute_query(sql,curs)
                    noofchangesaftercommit = query_fetchall(curs)[0][0]
                    noofchangesaftercommit = noofchangesaftercommit + 1
      else:
                    noofchangesaftercommit = 0
      values_sql=values_sql+str( noofchangesaftercommit )+", " 
      colindex = colindex + 1 
 
      #13) 'history':
      values_sql=values_sql+"'{"
      for noofelems in old_snapshot_data[0][colindex]:
               values_sql=values_sql+str(noofelems)+","
      values_sql=values_sql+old_subjectssid+"}', " 
      colindex = colindex + 1 

      #14) 'gbtimestamp':
      values_sql=values_sql+"now()"+","        
      colindex = colindex + 1 

      while (colindex < len(columns_schema) ):
            values_sql=values_sql+str(old_snapshot_data[0][colindex])+", " 
            colindex = colindex + 1 
                 
      values_sql=values_sql.rstrip(",")+")"                                      
      
      sql="INSERT INTO %s (%s) values %s;"%(nodetype,schema_sql,values_sql)
      execute_query(sql,curs)



def revise_fields(render_what,nodetype_list,uid,old_subjectssid_list,type_nid_list,listof_ssid_list,rendernbhData_list,curs):
    # ---------------------for attributes-------------------------single subject to which multiple attributes can be attached all of diferent attrtype.
    # nodetype_list=[ndtype of the subject to which the attr is about to get attached.] --->singlevalue
    # old_subjectssid_list=list of old ssid of subject--->single value
    # ---------------------------new_subjectssid_list=list of new ssid of subject--->singlevalue
    # type_nid_list= attrtype_nid_list---multivalue list--list of attrtype_nids. len(attrtype_nid_list]==no of attributes to attach
    # ssid_list=[[new ssid of all the attributes]].--->[[new_s1,new_s2, ...]]
    # rendernbhData_list = list of attribute values


    #-------------------------for relations-------------------single relation of a relationtype between multiple subjects
    #nodetype_list = [ndtype4ssid1of subj1,ndtype4ssid2of sub1,ndtype4ssid3 for subj1, only subj1's ...] 
    #old_subjectssid_list=list of old ssid of subject1
    #--------------------new_subjectssid_list=list of new ssid of subject1
    #type_nid_list= relntype_nid_list---single value list
    #ssid_list=new ssid of the relation--->[[new_s1_ofsubj1,new_s2_ofsubj1, ...],[new_s1_ofsubj2,new_s1_ofsubj2, ...], ...]
    #rendernbhData_list= {} + subject2_ssid_list + appended(leftrole/rightrole)
    # rendernbhData_list=[ inherit_rendernbh_dic ,new_s1_of_subj2ssid1,new_s2_ofsubj2ssid2,...,rightrole]--->for new snapshot of subj1_list
    # rendernbhData_list=[ inherit_rendernbh_dic ,new_s1_of_subj1ssid1,new_s2_ofsubj1ssid2,...,leftrole]--->for new snapshot of subj2_list
    #select the previous record of the subject_ssid to create new snapshot of it.
    if render_what == 'relations':
              inherit_rendernbh_dic = rendernbhData_list.pop(0)
              roleflag = rendernbhData_list.pop()

    combined_sql=""
    for n in range(len(nodetype_list)):

      columns_schema=get_schema(nodetype_list[n])
      #columns_schema=['col1name','col2name', ...]
      #columns_schema[0]=col1name
      values_sql="("
      schema_sql=get_schema_sql(nodetype_list[n])

      sql="SELECT %s from %s where ssid=%s;"%(schema_sql,nodetype_list[n],old_subjectssid_list[n])
      execute_query(sql,curs)
      old_snapshot_data=query_fetchall(curs)

      #old_snapshot_data=[(ssid,nid,uid,...)]
      #old_snapshot_data[0][1]=nid , ...1

      changedtype_value=""
      noofchanges_count=0
      
      colindex=0

      sql="UPDATE %s set "%(nodetype_list[n])
      #1)   rendered_nbh
      rendernbh={}                             

      if old_snapshot_data[0][colindex]==None or old_snapshot_data[0][colindex]=='':
         pass 
      else:  
         rendernbh=cPickle.loads(  b64decode( old_snapshot_data[0][colindex] ) ) #rendernbh={}
      #call to corresponding
      if render_what=="attributes":
               rendered_nbh=handle_renderednbh4_attr(rendernbh,type_nid_list,rendernbhData_list,listof_ssid_list[0],0)#this 0 is for 'structure'
               values =  b64encode( cPickle.dumps(rendered_nbh) )

      else: # render_what=="relations"
              new_rendered_nbh = handle_renderednbh4_reln(rendernbh,type_nid_list[0],rendernbhData_list,roleflag)
              if inherit_rendernbh_dic!={}:
                 handle_rendernbh_4_inherit(new_rendered_nbh, inherit_rendernbh_dic)
              values = b64encode( cPickle.dumps(new_rendered_nbh) )


      sql = sql + "rendered_nbh ='%s'"%(values) +","
      colindex = colindex + 1 

      #2 ) nbh

      nbh={}             
      nbh_list=[]
      if old_snapshot_data[0][colindex]==None or old_snapshot_data[0][colindex]=='':
               pass
      else:   
               nbh=cPickle.loads(  b64decode(old_snapshot_data[0][colindex] ) )#nbh={}
      if nbh.has_key(render_what):
               nbh_list=nbh[render_what]#nbh_list=[list of attr/reln ssid]


      nbh[render_what]=nbh_list+listof_ssid_list[n]        
      values= b64encode( cPickle.dumps(nbh) )
      sql = sql + "nbh ='%s'"%(values) +","
      colindex = colindex + 1 

      #3) ssid --remain same -- 
      colindex = colindex + 1 
      #4)nid -- remain same ---
      nid = old_snapshot_data[0][colindex]
      colindex = colindex + 1 
      #5) uid
      sql = sql + "uid =%s"%(uid) +","
      colindex = colindex + 1 

      #6) inid ---- remains same ---
      colindex = colindex + 1 
      #7) status --- remains same -----


      colindex = colindex + 1       

      #8) fieldschanged


      #fieldschanged calculation

      values = "{"

                 
      if render_what=="relations": 
               if roleflag=="leftroles":
                  inversename = get_inversename(type_nid_list[0],curs)
                  values = values+ str(inversename)
               else:
                     values = values + str(type_nid_list[0])
               changedtype_value= changedtype_value +"1,"
               noofchanges_count=1
               values = values + "}" 
      else:   #this is for attributes.
         for type_nids in type_nid_list: 
             values =values + type_nids + ","
             changedtype_value = changedtype_value + "1,"
             noofchanges_count = noofchanges_count + 1
             values = values.rstrip(',') + "}" 
      sql = sql + "fieldschanged ='%s'"%(values) +"," 
      colindex = colindex + 1       

      #9) noofchanges
      

      #'noofchanges' calculation
      sql = sql + "noofchanges =%s"%( noofchanges_count ) +"," 
      colindex = colindex + 1 

      #10) changetype


      #'changetype': calculaion

      changedtype_value = changedtype_value.rstrip(",")
      sql = sql + "changetype ='{%s}'"%( changedtype_value ) +"," 
      colindex = colindex + 1 

      #11)noofcommits


      #'noofcommits': calculation
      nc_sql="select max(noofcommits) from %s where nid='%s';"%(nodetype_list[n],nid)
      execute_query(nc_sql,curs)
      noofcommits =query_fetchall(curs)
      no_of_commits = noofcommits[0][0] + 1                                                                                                       
      sql = sql + "noofcommits = %s"%( no_of_commits ) +"," 
      colindex = colindex + 1 

      #12)noofchangesaftercommit -- remains same
      colindex = colindex + 1 

      
      #13)
      #'history': calcuation --remains same-----
      colindex = colindex + 1 

      #14)timestamp
      sql = sql + "gbtimestamp = now()"  
      colindex = colindex + 1 
      sql = sql +"where ssid = %s;"%(old_subjectssid_list[n])

      combined_sql=combined_sql+sql   

    execute_query(combined_sql,curs)





def R_newsnapshot(nodetype, uid, old_subjectssid, new_subject_ssid, relntype_nid_list, list_of_relnssid_list, subject1,curs):
    #this function is invoked when multiple relation between 2 subject is created.
    #ssid_list i.e,(new_reln_ssid for s1 with reln r1, new_reln_ssid for s1 with reln r2 , ...)
    #nodetype =  ndtype of each subject whose new snapshot is to be created.
    #old_subjectssid =old ssid of subject whose new snapshot is to be created.
    #new_subjectssid = new ssid of subject whose new snapshot is to be created.
    #relntype_nid_list= relntype_nid_list---multivalue list

    #select the previous record of the subject_ssid to create new snapshot of it.
    print "entered R_newsnapshot"
    print "old_subjectssid",old_subjectssid
    print "new_subject_ssid",new_subject_ssid
    print "relntype_nid_list",relntype_nid_list
    print "list_of_relnssid_list",list_of_relnssid_list
    print "subject1",subject1


    columns_schema=get_schema(nodetype)

    #columns_schema=['col1name','col2name', ...]
    #columns_schema[0]=col1name
    values_sql="("
    schema_sql=get_schema_sql(nodetype)
    sql="SELECT %s from %s where ssid=%s;"%(schema_sql,nodetype,old_subjectssid)
    #print sql
    execute_query(sql,curs)
    old_snapshot_data=query_fetchall(curs)

    #old_snapshot_data=[(ssid,nid,uid,...)]
    #old_snapshot_data[0][1]=nid , ...1
    
    changedtype_value=""
    noofchanges_count=0
    
    colindex=0
    
    #1)   rendered_nbh
    rendernbh={}                             

    if old_snapshot_data[0][colindex]==None or old_snapshot_data[0][colindex]=='':
         pass 
    else:  
         rendernbh=cPickle.loads(  b64decode( old_snapshot_data[0][colindex] ) ) #rendernbh={}

    for relnindex in range(len( relntype_nid_list)):     
          rendernbh = handle_renderednbh4_reln(rendernbh, relntype_nid_list[relnindex], [subject1], 'leftroles')
    values_sql=values_sql+"'"+ b64encode( cPickle.dumps(rendernbh) )+"',"


    #2 ) nbh
    colindex = colindex + 1 
    nbh={}             
    nbh_list=[]
    if old_snapshot_data[0][colindex]==None or old_snapshot_data[0][colindex]=='':
               pass
    else:   
               nbh=cPickle.loads(  b64decode(old_snapshot_data[0][colindex] ) )#nbh={}
    if nbh.has_key('relations'):
         nbh_list=nbh['relations']

    for relnssid_list in list_of_relnssid_list:
        nbh_list = nbh_list + relnssid_list
    nbh['relations'] = nbh_list    

    values_sql=values_sql+"'"+ b64encode( cPickle.dumps(nbh) )+"',"


    #3) ssid
    colindex = colindex + 1 

    # writing new ssid
    values_sql=values_sql+str(new_subject_ssid)+","


    #4)nid
    colindex = colindex + 1 

    nid= old_snapshot_data[0][colindex]
    values_sql=values_sql+"'"+str( old_snapshot_data[0][colindex])+"'," 


    #5) uid
    colindex = colindex + 1 

    values_sql=values_sql+str(uid)+"," 


    #6) inid
    colindex = colindex + 1 

    #inid calculation
    values_sql=values_sql+str(old_snapshot_data[0][colindex])+", " 

    
    #7) status
    colindex = colindex + 1 

    values_sql=values_sql+"'"+str(old_snapshot_data[0][colindex])+"', " 
      
    #8) fieldschanged
    colindex = colindex + 1 

    #fieldschanged calculation

    values_sql=values_sql+"'{"

    #if roleflag=="leftroles":
    for relntype_nid in relntype_nid_list:
        inversename=get_inversename( relntype_nid, curs)
        values_sql=values_sql + str(inversename) +","
        changedtype_value= changedtype_value +"1,"
        noofchanges_count =  noofchanges_count + 1
    values_sql=values_sql.rstrip(',') + "}', " 

    
    #9) noofchanges
    colindex = colindex + 1 

    #'noofchanges' calculation
    values_sql=values_sql+str( noofchanges_count )+", " 


    #10) changetype
    colindex = colindex + 1 

    #'changetype': calculaion

    values_sql=values_sql+"'{"
    values_sql=values_sql+changedtype_value
    values_sql=values_sql.rstrip(",")+"}',"                                                   


    #11)noofcommits
    colindex = colindex + 1 

    #'noofcommits': calculation
    sql="select max(noofcommits) from %s where nid='%s';"%(nodetype,nid)
    execute_query(sql,curs)
    noofcommits =query_fetchall(curs)
    noofcommits = noofcommits[0][0] + 1                                                                                                       
    values_sql=values_sql+str(noofcommits)+", " 

    
    #12)noofchangesaftercommit
    colindex = colindex + 1 
    values_sql=values_sql+str(old_snapshot_data[0][colindex])+", " 
    colindex = colindex + 1 

      
    #13)
    #'history': calcuation

    values_sql=values_sql+"'{"
    for noofelems in old_snapshot_data[0][colindex]:
                values_sql=values_sql+str(noofelems)+","
    values_sql=values_sql+ str( old_subjectssid) +"}', " 

    #14)timestamp
    colindex = colindex + 1 
    values_sql=values_sql+"now()"+","        
    colindex = colindex + 1 
    while (colindex < len(columns_schema) ):
            values_sql = values_sql+str(old_snapshot_data[0][colindex])+", " 
            colindex = colindex + 1 

    values_sql=values_sql.strip()
    values_sql=values_sql.rstrip(",")
    values_sql=values_sql + ")"                                      
    
    sql="INSERT INTO %s (%s) values %s;"%(nodetype, schema_sql,values_sql)

    execute_query(sql,curs)

