

-- This file is part of GNOWSYS: Gnowledge Networking and
-- Organizing System.

-- GNOWSYS is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as
-- published by the Free Software Foundation; either version 3 of
-- the License, or (at your option) any later version.

-- GNOWSYS is distributed in the hope that it will be useful, but
-- WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public
-- License along with GNOWSYS (COPYING); if not, write to the
-- Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
-- Boston, MA  02110-1301  USA59 Temple Place, Suite 330,


--CONTRIBUTORS : Abheeshek Jadhav, jamshed Irani, Roshan Dhupkhaiyaa, aditi meher



Create type gsearch AS ( value text,
                       ch character varying, -- attributetype nid                       
                       chr character varying, -- value of attribute  from
		       chr_ssid bigint, -- ssid of attribute
                       nodetype character varying,
			subject_inid Bigint,
			grank real);

create type inid_attributessid_attributetypessid AS ( subjectinid  bigint,
						   attributessid  bigint,
						   attributetypessid  bigint,
						    rnk real);

create type search_nid AS ( nbh text, ssid bigint);

create type nid_search AS (ndtype character varying, ssid bigint);



-------------------------
-------------------------

-- Function: plpgsql_call_handler()

-- DROP FUNCTION plpgsql_call_handler();

CREATE OR REPLACE FUNCTION plpgsql_call_handler()
  RETURNS opaque AS
'/usr/lib/postgresql/8.3/lib/plpgsql.so', 'plpgsql_call_handler'
  LANGUAGE 'c' VOLATILE
  COST 1;
ALTER FUNCTION plpgsql_call_handler() OWNER TO postgres;

create language 'plpgsql' HANDLER  plpgsql_call_handler LANCOMPILER 'PL/pgSQL';
------
------


create or replace function search_gnowsys_by_language(character varying, character varying)
returns setof gsearch
language plpgsql as'
Declare

      rec inid_attributessid_attributetypessid;
      item gsearch;
      
      id_atype bigint;
      id_a bigint;

Begin

        select  $1 AS txt Into item.value;
	For rec In select distinct subject_inid , attribute_ssid, attributetype_ssid , ts_rank(value_text_vec, to_tsquery($1)) From datatypes_varchar Where value_text_vec @@ to_tsquery($1)  OR value LIKE ''%''|| $1 ||''%'' AND language=$2  UNION ALL  select distinct subject_inid , attribute_ssid, attributetype_ssid, ts_rank(value_text_vec, to_tsquery($1)) From datatypes_text Where value_text_vec @@ to_tsquery($1)  OR value LIKE ''%''|| $1 ||''%'' AND language = $2	Loop

 		select distinct gb.nid into item.ch From gbattributetypes gb   Where gb.ssid = rec.attributetypessid;
 		 
		                           
         	select distinct gbnid.nodetype into item.nodetype From  gbnidssid gbnid 
							Where gbnid.inid = rec.subjectinid;

		select distinct dv.value into item.chr	From datatypes_varchar dv Where dv.attribute_ssid = rec.attributessid;
						
		
		select distinct ssid into item.chr_ssid From gbattributes gb where gb.ssid = rec.attributessid;
		
		select rec.subjectinid into item.subject_inid;
    
                select rec.rnk into item.grank;

		

		
	return next item;
      END LOOP;

return;
end';

------------
------------

create or replace function search_gnowsys(character varying)
returns setof gsearch
language plpgsql as'
Declare

      rec inid_attributessid_attributetypessid;
      item gsearch;
      
      id_atype bigint;
      id_a bigint;

Begin

        select  $1 AS txt Into item.value;
	For rec In select distinct subject_inid , attribute_ssid, attributetype_ssid , ts_rank(value_text_vec, to_tsquery($1)) From datatypes_varchar Where value_text_vec @@ to_tsquery($1)  OR value LIKE ''%''|| $1 ||''%''  UNION ALL  select distinct subject_inid , attribute_ssid, attributetype_ssid, ts_rank(value_text_vec, to_tsquery($1))  From datatypes_text Where value_text_vec @@ to_tsquery($1)  OR value LIKE ''%''|| $1 ||''%'' 	Loop

 		select distinct gb.nid into item.ch From gbattributetypes gb   Where gb.ssid = rec.attributetypessid;
 		 
		                           
         	select distinct gbnid.nodetype into item.nodetype From  gbnidssid gbnid 
							Where gbnid.inid = rec.subjectinid;

		select distinct dv.value into item.chr	From datatypes_varchar dv Where dv.attribute_ssid = rec.attributessid;
						
		
		select distinct ssid into item.chr_ssid From gbattributes gb where gb.ssid = rec.attributessid;
		
		select rec.subjectinid into item.subject_inid;

                select rec.rnk into item.grank;

		
	return next item;
      END LOOP;

return;
end';


----------------------
----------------------


CREATE OR REPLACE FUNCTION getlatest_ssid_from_listofnid(ary character varying[])
  RETURNS bigint[] AS
$BODY$

declare
-- to get list of latest ssid based on given list of nids.
	id bigint;
	i bigint;
	range bigint;
        value bigint[];

begin

	Select array_upper(ary,1) into range;

	For i IN 1..range Loop

			select ssid into id from gbnid_latestssid where nid = ary[i];
			select array_append(value,id) into value;
			
			
	End Loop;

return  value ;
End$BODY$
  LANGUAGE 'plpgsql' VOLATILE
  COST 100;
ALTER FUNCTION getlatest_ssid_from_listofnid(character varying[]) OWNER TO postgres;


------
------


-- Function: get_latest_ssid(bigint[])
-- returns two dimensional array with old ssid, new ssid for each inputed ssid in list

-- DROP FUNCTION get_latest_ssid(bigint[]);

CREATE OR REPLACE FUNCTION get_latest_ssid(ary bigint[])
  RETURNS SETOF bigint[] AS
$BODY$
Declare

	cnt bigint;
        sid bigint;
        range bigint;
        value bigint[][];

Begin 

	select array_upper(ary,1) into range;

	For cnt IN 1..range Loop
		select ARRAY[ary[cnt],gbl.ssid] into value from gbnidssid gb, gbnid_latestssid gbl where gb.nid = gbl.nid AND gb.ssid =  ary[cnt];
			return next value;
	END Loop;

return;
end$BODY$
  LANGUAGE 'plpgsql' VOLATILE
  COST 100
  ROWS 1000;
ALTER FUNCTION get_latest_ssid(bigint[]) OWNER TO postgres;

-----------
-----------



-- Function: searchby_nid(character varying)

-- DROP FUNCTION searchby_nid(character varying);

CREATE OR REPLACE FUNCTION searchby_nid(character varying)
  RETURNS SETOF search_nid AS
$BODY$

declare

	node  nid_search;
	txt text;
        search search_nid;-- used in order to store related nbh & its related ssid into it inorder to return

begin

	For node IN select nodetype  , ssid  from gbnidssid where nid_vec @@ to_tsquery(ch) Or nid LIKE '%'|| ch ||'%' Loop
			select node.ssid into search.ssid;
		IF node.ndtype = "gbobjects" THEN
			select gb.rendered_nbh  into search.nbh from gbobjects gb where gb.ssid = node.ssid;
			return next search;

			ELSIF node.ndtype = "gbobjecttypes"  THEN
				select gb.rendered_nbh into search.nbh from gbobjecttypes gb where gb.ssid = node.ssid;
				return next search;

			ELSIF node.ndtype = "gbrelations"  THEN
				select gb.rendered_nbh into search.nbh from gbrelations gb where gb.ssid = node.ssid;
				return next search;

			ELSIF node.ndtype = "gbrelationtypes"  THEN
				select gb.rendered_nbh into search.nbh  from gbrelationtypes gb where gb.ssid = node.ssid;
				return next search;
		
	
		END IF;
	END LOOP;
return;
end$BODY$
  LANGUAGE 'plpgsql' VOLATILE
  COST 100
  ROWS 1000;
ALTER FUNCTION searchby_nid(character varying) OWNER TO postgres;



------------
------------

create or replace function getnbh(ssid bigint, inid bigint)
returns text
language plpgsql as'

Declare
	ndtype character varying;
        nbh text;
Begin 

     select nodetype into ndtype from gbnidssid where inid = $2;
     
	IF ndtype = "gbobjects" THEN
			select gb.rendered_nbh  into nbh from gbobjects gb where gb.ssid = $1;
			

			ELSIF ndtype = "gbobjecttypes"  THEN
				select gb.rendered_nbh into nbh from gbobjecttypes gb where gb.ssid = $1;
				

			ELSIF ndtype = "gbrelations"  THEN
				select gb.rendered_nbh into nbh from gbrelations gb where gb.ssid = $1;

			ELSIF ndtype = "gbrelationtypes"  THEN
				select gb.rendered_nbh into nbh  from gbrelationtypes gb where gb.ssid = $1;

			ELSIF ndtype = "gbattributes" THEN
				select gb.rendered_nbh into nbh from gbattributes gb where gb.ssid = $1;

			ELSIF ndtype = "gbattributetypes" THEN
				select gb.rendered_nbh into nbh from gbattributetypes gb where gb.ssid = $1;
				
	END IF;
return nbh;
end';

create or replace function exact_match(text)
returns setof gsearch
language plpgsql as'

Declare
     rec inid_attributessid_attributetypessid;
      item gsearch;

Begin

	 select  $1 AS txt Into item.value;
	For rec In select distinct subject_inid , attribute_ssid, attributetype_ssid  From datatypes_varchar Where value LIKE ''''|| $1 ||''''  UNION ALL  select distinct subject_inid , attribute_ssid, attributetype_ssid From datatypes_text Where value LIKE ''''|| $1 ||'''' 	Loop
		
		select distinct gb.nid into item.ch From gbattributetypes gb  Where gb.ssid = rec.attributetypessid;
 		 
		                           
         	select distinct gbnid.nodetype into item.nodetype From  gbnidssid gbnid 
							Where gbnid.inid = rec.subjectinid;

		select distinct dv.value into item.chr	From datatypes_varchar dv Where dv.attribute_ssid = rec.attributessid;
						
		
		select distinct ssid into item.chr_ssid From gbattributes gb where gb.ssid = rec.attributessid;
		
		select rec.subjectinid into item.subject_inid;
    
                --select rec.rnk into item.grank;

		

		
	return next item;
      END LOOP;

return;
end';
