

-- This file is part of GNOWSYS: Gnowledge Networking and
-- Organizing System.

-- GNOWSYS is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as
-- published by the Free Software Foundation; either version 3 of
-- the License, or (at your option) any later version.

-- GNOWSYS is distributed in the hope that it will be useful, but
-- WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public
-- License along with GNOWSYS (COPYING); if not, write to the
-- Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
-- Boston, MA  02110-1301  USA59 Temple Place, Suite 330,


-- Author: Rajiv Nair <rajivnair@gnu.org>

--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- Name: auth_schema; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA auth_schema;


ALTER SCHEMA auth_schema OWNER TO postgres;

SET search_path = auth_schema, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: roles; Type: TABLE; Schema: auth_schema; Owner: postgres; Tablespace: 
--

CREATE TABLE roles (
    username character varying(20),
    rolename character varying(20)
);


ALTER TABLE auth_schema.roles OWNER TO postgres;

--
-- Name: users; Type: TABLE; Schema: auth_schema; Owner: postgres; Tablespace: 
--

CREATE TABLE users (
    username character varying(20) NOT NULL,
    password character varying(45),
    fullname character varying(30),
    email character varying(50),
    CONSTRAINT users_pkey PRIMARY KEY (username)
);


ALTER TABLE auth_schema.users OWNER TO postgres;

SET search_path = public, pg_catalog;




--
-- Name: gbobjects; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE gbobjects (
    ssid bigint primary key,
    nid varchar NOT NULL,
    inid bigint NOT NULL,
    uid bigint NOT NULL,
    status character varying,
    noofchanges integer NOT NULL,
    fieldschanged character varying[] NOT NULL,
    changetype bigint[] NOT NULL,
    noofcommits integer NOT NULL,
    noofchangesaftercommit integer NOT NULL,
    history bigint[] NOT NULL,
    gbtimestamp timestamp with time zone DEFAULT now(),
    rendered_nbh text,
    nbh text
);


ALTER TABLE public.gbobjects OWNER TO postgres;
create index nid_gbobjects_idx on gbobjects using GIN(to_tsvector('english',nid));



--
-- Name: gbregularexpressions; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE gbregularexpressions (
    regexid serial,
    expression character varying,
    description text,
    CONSTRAINT gbregularexpressions_regexid_key UNIQUE (regexid)
    
);

ALTER TABLE public.gbregularexpressions OWNER TO postgres;


--
-- Name: gbvaluerestrictions; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE gbvaluerestrictions (
    restrictionid serial,
    datatype character varying,
    description text,
    regexid bigint,
    length bigint,
    range character varying,
    "precision" integer,
    CONSTRAINT gbvaluerestrictions_restrictionid_key UNIQUE (restrictionid),
    CONSTRAINT gbvaluerestrictions_toregex_fkey FOREIGN KEY (regexid)
    REFERENCES gbregularexpressions (regexid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
    );


ALTER TABLE public.gbvaluerestrictions OWNER TO postgres;


--
-- Name: gbselectionlist; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE gbselectionlist (
    selid serial,
    selectiontype integer NOT NULL,
    datatype character varying NOT NULL,
    listid bigint NOT NULL,
    CONSTRAINT gbselectionlist_selid_key UNIQUE (selid),
    CONSTRAINT gbselectionlist_listid_fkey FOREIGN KEY (listid)
    REFERENCES gbobjects(ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);
ALTER TABLE public.gbselectionlist OWNER TO postgres;


--
-- Name: gbattributetypes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--


CREATE TABLE gbattributetypes (
    ssid bigint primary key,
    nid varchar NOT NULL,
    inid bigint NOT NULL,
    uid bigint NOT NULL,
    status character varying,
    noofchanges integer NOT NULL,
    fieldschanged character varying[] NOT NULL,
    changetype bigint[] NOT NULL,
    noofcommits integer NOT NULL,
    noofchangesaftercommit integer NOT NULL,
    history bigint[] NOT NULL,
    gbtimestamp timestamp with time zone DEFAULT now(),
    restrictiontype integer NOT NULL,
    restrictionref bigint NOT NULL,
    rendered_nbh text,
    nbh text
    
    );


ALTER TABLE public.gbattributetypes OWNER TO postgres;


--
-- Name: gbattributes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE gbattributes (
  ssid bigint primary key,
  nid varchar NOT NULL,
  inid bigint NOT NULL,
  uid bigint NOT NULL,
  status character varying,
  noofchanges integer NOT NULL,
  fieldschanged character varying[] NOT NULL,
  changetype bigint[] NOT NULL,
  noofcommits integer NOT NULL,
  noofchangesaftercommit integer NOT NULL,
  history bigint[] NOT NULL,
  gbtimestamp timestamp with time zone DEFAULT now(),
  attributetype bigint,
  subjectid bigint NOT NULL,
  datatype character varying,
  rendered_nbh text,
  nbh text
  );

ALTER TABLE public.gbattributes OWNER TO postgres;


--
-- Name: datatypes_abstime; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_abstime (
    subject_inid bigint,
    value abstime,
    attribute_inid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_abstime_fkey_a FOREIGN KEY (attribute_inid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_abstime_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
 );


ALTER TABLE public.datatypes_abstime OWNER TO postgres;


--
-- Name: datatypes_aclitem; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_aclitem (
    subject_inid bigint,
    value aclitem,
    attribute_inid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_acltime_fkey_a FOREIGN KEY (attribute_inid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_aclitem_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_aclitem OWNER TO postgres;


--
-- Name: datatypes_bit; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_bit (
    subject_inid bigint,
    value bit(1),
    attribute_inid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_bit_fkey_a FOREIGN KEY (attribute_inid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_bit_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_bit OWNER TO postgres;

--
-- Name: datatypes_boolean; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_boolean (
    subject_inid bigint,
    value boolean,
    attribute_inid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_boolean_fkey_a FOREIGN KEY (attribute_inid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_boolean_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_boolean OWNER TO postgres;

--
-- Name: datatypes_box; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_box (
    subject_inid bigint,
    value box,
    attribute_inid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_box_fkey_a FOREIGN KEY (attribute_inid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_box_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_box OWNER TO postgres;

--
-- Name: datatypes_bpchar; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_bpchar (
    subject_inid bigint,
    value bpchar,
    attribute_inid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_bpchar_fkey_a FOREIGN KEY (attribute_inid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_bpchar_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_bpchar OWNER TO postgres;

--
-- Name: datatypes_bytea; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_bytea (
    subject_inid bigint,
    value bytea,
    attribute_inid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_bytea_fkey_a FOREIGN KEY (attribute_inid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_bytea_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_bytea OWNER TO postgres;

--
-- Name: datatypes_char; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_char (
    subject_inid bigint,
    value character(1),
    attribute_inid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_char_fkey_a FOREIGN KEY (attribute_inid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_char_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_char OWNER TO postgres;

--
-- Name: datatypes_cid; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_cid (
    subject_inid bigint,
    value cid,
    attribute_inid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_cid_fkey_a FOREIGN KEY (attribute_inid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_cid_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_cid OWNER TO postgres;

--
-- Name: datatypes_cidr; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_cidr (
    subject_inid bigint,
    value cidr,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_cidr_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_cidr_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_cidr OWNER TO postgres;

--
-- Name: datatypes_circle; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_circle (
    subject_inid bigint,
    value circle,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_circle_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_circle_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_circle OWNER TO postgres;

--
-- Name: datatypes_date; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_date (
    subject_inid bigint,
    value date,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_date_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_date_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_date OWNER TO postgres;

--
-- Name: datatypes_float4; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_float4 (
    subject_inid bigint,
    value real,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_float4_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_float4_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_float4 OWNER TO postgres;

--
-- Name: datatypes_float8; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_float8 (
    subject_inid bigint,
    value double precision,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_float8_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_float8_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_float8 OWNER TO postgres;

--
-- Name: datatypes_inet; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_inet (
    subject_inid bigint,
    value inet,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_inet_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_inet_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_inet OWNER TO postgres;

--
-- Name: datatypes_int2; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_int2 (
    subject_inid bigint,
    value smallint,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_int2_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_int2_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_int2 OWNER TO postgres;

--
-- Name: datatypes_int2vector; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_int2vector (
    subject_inid bigint,
    value int2vector,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_int2vector_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_int2vector_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_int2vector OWNER TO postgres;

--
-- Name: datatypes_int4; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_int4 (
    subject_inid bigint,
    value integer,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_int4_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_int4_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_int4 OWNER TO postgres;

--
-- Name: datatypes_int8; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_int8 (
    subject_inid bigint,
    value bigint,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_int8_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_int8_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_int8 OWNER TO postgres;

--
-- Name: datatypes_interval; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_interval (
    subject_inid bigint,
    value interval,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_interval_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_interval_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_interval OWNER TO postgres;

--
-- Name: datatypes_line; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_line (
    subject_inid bigint,
    value line,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_line_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_line_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_line OWNER TO postgres;

--
-- Name: datatypes_lseg; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_lseg (
    subject_inid bigint,
    value lseg,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_lseg_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_lseg_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_lseg OWNER TO postgres;

--
-- Name: datatypes_macaddr; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_macaddr (
    subject_inid bigint,
    value macaddr,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_macaddr_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_macaddr_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_macaddr OWNER TO postgres;

--
-- Name: datatypes_money; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_money (
    subject_inid bigint,
    value money,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_money_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_money_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_money OWNER TO postgres;

--
-- Name: datatypes_name; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_name (
    subject_inid bigint,
    value name,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_name_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_name_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_name OWNER TO postgres;

--
-- Name: datatypes_numeric; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_numeric (
    subject_inid bigint,
    value numeric,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_numeric_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_numeric_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_numeric OWNER TO postgres;

--
-- Name: datatypes_oid; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_oid (
    subject_inid bigint,
    value oid,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_oid_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_oid_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_oid OWNER TO postgres;

--
-- Name: datatypes_oidvector; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_oidvector (
    subject_inid bigint,
    value oidvector,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_oidvector_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_oidvector_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_oidvector OWNER TO postgres;

--
-- Name: datatypes_path; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_path (
    subject_inid bigint,
    value path,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_path_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_path_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_path OWNER TO postgres;

--
-- Name: datatypes_point; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_point (
    subject_inid bigint,
    value point,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_point_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_point_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_point OWNER TO postgres;

--
-- Name: datatypes_polygon; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_polygon (
    subject_inid bigint,
    value polygon,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_polygon_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_polygon_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_polygon OWNER TO postgres;

--
-- Name: datatypes_refcursor; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_refcursor (
    subject_inid bigint,
    value refcursor,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_refcursor_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_refcursor_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_refcursor OWNER TO postgres;

--
-- Name: datatypes_regclass; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_regclass (
    subject_inid bigint,
    value regclass,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_regclass_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_regclass_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_regclass OWNER TO postgres;

--
-- Name: datatypes_regoper; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_regoper (
    subject_inid bigint,
    value regoper,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_regoper_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_regoper_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_regoper OWNER TO postgres;

--
-- Name: datatypes_regoperator; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_regoperator (
    subject_inid bigint,
    value regoperator,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_regoperator_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_regoperator_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_regoperator OWNER TO postgres;

--
-- Name: datatypes_regproc; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_regproc (
    subject_inid bigint,
    value regproc,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_regproc_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_regproc_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_regproc OWNER TO postgres;

--
-- Name: datatypes_regprocedure; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_regprocedure (
    subject_inid bigint,
    value regprocedure,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_regprocedure_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_regprocedure_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION

);


ALTER TABLE public.datatypes_regprocedure OWNER TO postgres;

--
-- Name: datatypes_regtype; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_regtype (
    subject_inid bigint,
    value regtype,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_regtype_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_regtype_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_regtype OWNER TO postgres;

--
-- Name: datatypes_reltime; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_reltime (
    subject_inid bigint,
    value reltime,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_reltime_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_reltime_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_reltime OWNER TO postgres;

--
-- Name: datatypes_serial; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_serial (
    subject_inid bigint,
    value integer NOT NULL,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_serial_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_serial_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_serial OWNER TO postgres;

--
-- Name: datatypes_serial8; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_serial8 (
    subject_inid bigint,
    value bigint NOT NULL,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_serial8_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_serial8_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_serial8 OWNER TO postgres;

--
-- Name: datatypes_smgr; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_smgr (
    subject_inid bigint,
    value smgr,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_smgr_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_smgr_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_smgr OWNER TO postgres;

--
-- Name: datatypes_text; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_text (
    subject_inid bigint,
    value text,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_text_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION, 
    value_text_vec tsvector,
    CONSTRAINT gbdatatypes_text_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_text OWNER TO postgres;


--
-- Name: datatypes_varchar; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_varchar (
    subject_inid bigint,
    value varchar,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_varchar_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION, 
    value_text_vec tsvector,
    CONSTRAINT gbdatatypes_varchar_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_varchar OWNER TO postgres;

--
-- Name: datatypes_tid; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_tid (
    subject_inid bigint,
    value tid,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_tid_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_tid_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_tid OWNER TO postgres;

--
-- Name: datatypes_time; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_time (
    subject_inid bigint,
    value time without time zone,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_time_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_time_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_time OWNER TO postgres;

--
-- Name: datatypes_timestamptz; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_timestamptz (
    subject_inid bigint,
    value timestamp with time zone,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_timestamptz_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_timestamptz_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_timestamptz OWNER TO postgres;

--
-- Name: datatypes_timetz; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_timetz (
    subject_inid bigint,
    value time with time zone,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_timetz_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_timetz_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_timetz OWNER TO postgres;

--
-- Name: datatypes_tinterval; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_tinterval (
    subject_inid bigint,
    value tinterval,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_tinterval_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_tinterval_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_tinterval OWNER TO postgres;

--
-- Name: datatypes_unknown; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_unknown (
    subject_inid bigint,
    value unknown,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_unknown_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_unknown_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_unknown OWNER TO postgres;

--
-- Name: datatypes_varbit; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_varbit (
    subject_inid bigint,
    value bit varying,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_varbit_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_varbit_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_varbit OWNER TO postgres;

--
-- Name: datatypes_xid; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE datatypes_xid (
    subject_inid bigint,
    value xid,
    attribute_ssid bigint,
    attributetype_inid bigint,
    language character varying,
    CONSTRAINT gbdatatypes_xid_fkey_a FOREIGN KEY (attribute_ssid)
    REFERENCES gbattributes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION,
    CONSTRAINT gbdatatypes_xid_fkey FOREIGN KEY (attributetype_inid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
);


ALTER TABLE public.datatypes_xid OWNER TO postgres;


CREATE TABLE gbmetatypes (
  ssid bigint NOT NULL,
  nid varchar NOT NULL,
  inid bigint NOT NULL,
  uid bigint NOT NULL,
  status character varying,
  noofchanges integer NOT NULL,
  fieldschanged character varying[] NOT NULL,
  changetype bigint[] NOT NULL,
  noofcommits integer NOT NULL,
  noofchangesaftercommit integer NOT NULL,
  history bigint[] NOT NULL,
  gbtimestamp timestamp with time zone DEFAULT now(),
  rendered_nbh text,
  nbh text,
  CONSTRAINT gbmetatypes_ssid_key UNIQUE (ssid)
);

ALTER TABLE public.gbmetatypes OWNER TO postgres;

--
-- Name: gbusertypes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--


CREATE TABLE gbusertypes (
    ssid bigint primary key,
    nid varchar NOT NULL,
    inid bigint NOT NULL,
    uid bigint NOT NULL,
    status character varying,
    noofchanges integer NOT NULL,
    fieldschanged character varying[] NOT NULL,
    changetype bigint[] NOT NULL,
    noofcommits integer NOT NULL,
    noofchangesaftercommit integer NOT NULL,
    history bigint[] NOT NULL,
    gbtimestamp timestamp with time zone DEFAULT now(),
    rendered_nbh text,
    nbh text

    );

ALTER TABLE public.gbusertypes OWNER TO postgres;



--
-- Name: gbuser; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--


CREATE TABLE gbusers (
    ssid bigint primary key,
    nid varchar NOT NULL,
    inid bigint NOT NULL,
    uid serial,
    status character varying,
    noofchanges integer NOT NULL,
    fieldschanged character varying[] NOT NULL,
    changetype bigint[] NOT NULL,
    noofcommits integer NOT NULL,
    noofchangesaftercommit integer NOT NULL,
    history bigint[] NOT NULL,
    gbtimestamp timestamp with time zone DEFAULT now(),
    rendered_nbh text,
    nbh text
 );


ALTER TABLE public.gbusers OWNER TO postgres;


 
--
-- Name: gbobjecttypes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--
CREATE TABLE gbobjecttypes (
    ssid bigint primary key,
    nid varchar NOT NULL,
    inid bigint NOT NULL,
    uid bigint NOT NULL,
    status character varying,
    noofchanges integer NOT NULL,
    fieldschanged character varying[] NOT NULL,
    changetype bigint[] NOT NULL,
    noofcommits integer NOT NULL,
    noofchangesaftercommit integer NOT NULL,
    history bigint[] NOT NULL,
    gbtimestamp timestamp with time zone DEFAULT now(),
    rendered_nbh text,
    nbh text
    );


ALTER TABLE public.gbobjecttypes OWNER TO postgres;
create index nid_gbobjecttypes_idx on gbobjecttypes using GIN(to_tsvector('english',nid));

--
-- Name: gbrelationtypes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--


CREATE TABLE gbrelationtypes (
    ssid bigint primary key,
    nid varchar NOT NULL,
    inid bigint NOT NULL,
    inversename varchar, 
    uid bigint NOT NULL,
    status character varying,
    noofchanges integer NOT NULL,
    fieldschanged character varying[] NOT NULL,
    changetype bigint[] NOT NULL,
    noofcommits integer NOT NULL,
    noofchangesaftercommit integer NOT NULL,
    history bigint[] NOT NULL,
    gbtimestamp timestamp with time zone DEFAULT now(),
    istransitive boolean,
    isreflexive boolean,
    issymmetrical boolean,
    rendered_nbh text,
    nbh text
   );


ALTER TABLE public.gbrelationtypes OWNER TO postgres;



--
-- Name: gbrelation; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--


CREATE TABLE gbrelations (
    ssid bigint primary key,
    nid varchar NOT NULL,
    inid bigint NOT NULL,
    uid bigint NOT NULL,
    status character varying,
    noofchanges integer NOT NULL,
    fieldschanged character varying[] NOT NULL,
    changetype bigint[] NOT NULL,
    noofcommits integer NOT NULL,
    noofchangesaftercommit integer NOT NULL,
    history bigint[] NOT NULL,
    gbtimestamp timestamp with time zone DEFAULT now(),
    relationtype bigint,
    subject1 bigint,
    subject2 bigint,
    rendered_nbh text,
    nbh text
   );


ALTER TABLE public.gbrelations OWNER TO postgres;


CREATE INDEX subject1_relations_idx on gbrelations (subject1);
CREATE INDEX subject2_relations_idx on gbrelations (subject2); 



--
-- Name: gbfunctions; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE gbfunctions (
    ssid bigint primary key,
    nid varchar NOT NULL,
    inid bigint NOT NULL,
    uid bigint NOT NULL,
    status character varying,
    noofchanges integer NOT NULL,
    fieldschanged character varying[] NOT NULL,
    changetype bigint[] NOT NULL,
    noofcommits integer NOT NULL,
    noofchangesaftercommit integer NOT NULL,
    history bigint[] NOT NULL,
    gbtimestamp timestamp with time zone DEFAULT now(),
    rendered_nbh text,
    nbh text
    );


ALTER TABLE public.gbfunctions OWNER TO postgres;

--
-- Name: gbprocesstypes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE gbprocesstypes (
    ssid bigint primary key,
    nid varchar NOT NULL,
    inid bigint NOT NULL,
    uid bigint NOT NULL,
    status character varying,
    noofchanges integer NOT NULL,
    fieldschanged character varying[] NOT NULL,
    changetype bigint[] NOT NULL,
    noofcommits integer NOT NULL,
    noofchangesaftercommit integer NOT NULL,
    history bigint[] NOT NULL,
    gbtimestamp timestamp with time zone DEFAULT now(),
    rendered_nbh text,
    nbh text
    );


ALTER TABLE public.gbprocesstypes OWNER TO postgres;


--
-- Name: gbprocess; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE gbprocess (
    ssid bigint primary key,
    nid varchar NOT NULL,
    inid bigint NOT NULL,
    uid bigint NOT NULL,
    status character varying,
    noofchanges integer NOT NULL,
    fieldschanged character varying[] NOT NULL,
    changetype bigint[] NOT NULL,
    noofcommits integer NOT NULL,
    noofchangesaftercommit integer NOT NULL,
    history bigint[] NOT NULL,
    gbtimestamp timestamp with time zone DEFAULT now(),
    rendered_nbh text,
    nbh text
    );


ALTER TABLE public.gbprocess OWNER TO postgres;


CREATE TABLE gbroletypes (
    rtid serial,
    subjecttype1 bigint NOT NULL,
    subjecttype2 bigint NOT NULL,
    cardinality1 integer NOT NULL,
    cardinality2 integer NOT NULL,
    applicablenodetypes1 character varying,
    applicablenodetypes2 character varying
   );
ALTER TABLE public.gbroletypes OWNER TO postgres;


CREATE TABLE gbcatalogrelationtypes (
    relationtypeid bigint NOT NULL,
    roletypeid bigint NOT NULL,
    CONSTRAINT gbcatalog_relationtypes_fkey FOREIGN KEY (relationtypeid)
    REFERENCES gbrelationtypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
    );
ALTER TABLE public.gbcatalogrelationtypes  OWNER TO postgres;


CREATE TABLE gbcatalogsubjecttypes (
    attributetypeid bigint NOT NULL,
    subjecttypeid bigint NOT NULL,
    applicablenodetypes character varying ,
    CONSTRAINT gbcatalog_subjecttypes_fkey FOREIGN KEY (attributetypeid)
    REFERENCES gbattributetypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
    );
ALTER TABLE public.gbcatalogsubjecttypes OWNER TO postgres;




CREATE TABLE gbcatalogpriorstatedef (
    ssid bigint NOT NULL,
    priorstatedef bigint NOT NULL,
    CONSTRAINT gbcatalog_priorstatedef_fkey FOREIGN KEY (ssid)
    REFERENCES gbprocesstypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
    );
ALTER TABLE public.gbcatalogpriorstatedef OWNER TO postgres;

CREATE TABLE gbcatalogpoststatedef (
    ssid bigint NOT NULL,
    poststatedef bigint NOT NULL,
    CONSTRAINT gbcatalog_poststatedef_fkey FOREIGN KEY (ssid)
    REFERENCES gbprocesstypes (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
    );
ALTER TABLE public.gbcatalogpoststatedef OWNER TO postgres;

CREATE TABLE gbcatalogpriorstate (
    ssid bigint NOT NULL,
    priorstate bigint NOT NULL,
    CONSTRAINT gbcatalog_priorstate_fkey FOREIGN KEY (ssid)
    REFERENCES gbprocess (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
    );
ALTER TABLE public.gbcatalogpriorstate OWNER TO postgres;

CREATE TABLE gbcatalogpoststate (
    ssid bigint NOT NULL,
    poststate bigint NOT NULL,
    CONSTRAINT gbcatalog_poststate_fkey FOREIGN KEY (ssid)
    REFERENCES gbprocess (ssid) MATCH SIMPLE
    ON UPDATE NO ACTION ON DELETE NO ACTION
    );
ALTER TABLE public.gbcatalogpoststate OWNER TO postgres;


CREATE TABLE gbnidssid
(
  ssid bigint NOT NULL,
  nid character varying NOT NULL,
  inid bigint NOT NULL,
  nodetype character varying NOT NULL,
  value_nid_vec tsvector
);
--for fast retreiving instead of searching all gbtables where the ssid belongs.
ALTER TABLE gbnidssid OWNER TO postgres;


CREATE INDEX ssid_gbnidssid_idx on gbnidssid (ssid);
CREATE INDEX nid_gbnidssid_idx on gbnidssid (nid); 


CREATE TABLE gbnid_latestssid
(
  ssid bigint primary key,
  nid character varying NOT NULL
);
--for fast retreiving instead of searching all gbtables where the ssid belongs.
ALTER TABLE gbnid_latestssid OWNER TO postgres;


CREATE TABLE md5sum
(
  attributessid bigint primary key,
  attrmd5sum text NOT NULL
);
--for fast retreiving instead of searching all gbtables where the ssid belongs.
ALTER TABLE md5sum OWNER TO postgres;



CREATE SEQUENCE ssid_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;



insert into gbusers(ssid,nid,inid,status,noofchanges,fieldschanged,changetype,noofcommits,noofchangesaftercommit,history,rendered_nbh,nbh) values (nextval('ssid_seq'),'admin',1,'Public',1,'{status}','{1}',0,0,'{0}','KGRwMQou','KGRwMQou');

insert into gbroletypes(subjecttype1,subjecttype2,cardinality1,cardinality2,applicablenodetypes1,applicablenodetypes2) values(0,0,0,0,'gbusers,gbprocess,gbobjects,gbrelations,gbattributes','gbusertypes,gbprocesstypes,gbobjecttypes,gbrelationtypes,gbattributetypes');
insert into gbroletypes(subjecttype1,subjecttype2,cardinality1,cardinality2,applicablenodetypes1,applicablenodetypes2) values(0,0,0,0,'gbusertypes,gbprocesstypes,gbobjecttypes,gbrelationtypes,gbattributetypes','gbmetatypes');
insert into gbroletypes(subjecttype1,subjecttype2,cardinality1,cardinality2,applicablenodetypes1,applicablenodetypes2) values(0,0,0,0,'gbusertypes,gbprocesstypes,gbobjecttypes,gbrelationtypes,gbattributetypes,gbmetatypes','gbusertypes,gbprocesstypes,gbobjecttypes,gbrelationtypes,gbattributetypes,gbmetatypes');


INSERT INTO gbrelationtypes (ssid, nid , inid ,inversename , uid, status, noofchanges, fieldschanged, changetype, noofcommits, noofchangesaftercommit, history,rendered_nbh,nbh) values(nextval('ssid_seq'),'instanceof',2,'instance',1,'Public',2,'{status,roletypes}','{1,1}',0,0,'{0}','KGRwMQou','KGRwMQou');
INSERT INTO gbrelationtypes (ssid, nid , inid ,inversename , uid, status, noofchanges, fieldschanged, changetype, noofcommits, noofchangesaftercommit, history,rendered_nbh,nbh) values(nextval('ssid_seq'),'subtypeof',3,'supertypeof',1,'Public',2,'{status,roletypes}','{1,1}',0,0,'{0}','KGRwMQou','KGRwMQou');


insert into gbcatalogrelationtypes values (2,1);
insert into gbcatalogrelationtypes values (2,2);
insert into gbcatalogrelationtypes values (3,3);

update gbrelationtypes set nbh = 'KGRwMQpTJ3JvbGV0eXBlcycKcDIKKGxwMwpTJzEnCmFTJzInCmFzLg==' where ssid = 2;
update gbrelationtypes set nbh = 'KGRwMQpTJ3JvbGV0eXBlcycKcDIKKGxwMwpTJzMnCmFzLg==' where ssid = 3;

INSERT INTO gbobjecttypes values(nextval('ssid_seq'),'gblist',4,1,'public',1,'{status}','{1}',0,0,'{0}',now(),'KGRwMQpTJ2F0dHJpYnV0ZXR5cGVzJwpwMgoobHAzClMnMTQnCnA0CmFzLg==','KGRwMQou');

INSERT INTO gbregularexpressions values(0,'NO REGULAR EXPRESSION','NO DESCRIPTION');

INSERT INTO gbvaluerestrictions(datatype,description,regexid) values('varchar','username of the user',0);
INSERT INTO gbvaluerestrictions(datatype,description,regexid) values('varchar','password of the user',0);
INSERT INTO gbvaluerestrictions(datatype,description,regexid) values('varchar','emailid of the user',0);
INSERT INTO gbvaluerestrictions(datatype,description,regexid) values('varchar','firstname of the user',0);
INSERT INTO gbvaluerestrictions(datatype,description,regexid) values('varchar','lastname of the user',0);
INSERT INTO gbvaluerestrictions(datatype,description,regexid) values('text','title of a node',0);
INSERT INTO gbvaluerestrictions(datatype,description,regexid) values('text','description of a node',0);
INSERT INTO gbvaluerestrictions(datatype,description,regexid) values('text','content of a node',0);
INSERT INTO gbvaluerestrictions(datatype,description,regexid) values('varchar','datatype of the selection list',0);
INSERT INTO gbvaluerestrictions(datatype,description,regexid) values('int8[]','datatype of the mandatory fields',0);


insert into gbusertypes(ssid,nid,inid,uid,status,noofchanges,fieldschanged,changetype,noofcommits,noofchangesaftercommit,history,rendered_nbh,nbh) values (nextval('ssid_seq'),'GnowsysUsers',5,1,'Public',2,'{status,attributetypes}','{1,1}',0,0,'{0}','KGRwMQou','KGRwMQou');


insert into gbattributetypes(ssid,nid,inid,uid,status,noofchanges,fieldschanged,changetype,noofcommits,noofchangesaftercommit,history,restrictiontype,restrictionref,rendered_nbh,nbh) values (nextval('ssid_seq'),'username',6,1,'Public',2,'{status,subjecttypes}','{1,1}',0,0,'{0}',1,1,'KGRwMQou','KGRwMQou');
insert into gbattributetypes(ssid,nid,inid,uid,status,noofchanges,fieldschanged,changetype,noofcommits,noofchangesaftercommit,history,restrictiontype,restrictionref,rendered_nbh,nbh) values (nextval('ssid_seq'),'password',7,1,'Public',2,'{status,subjecttypes}','{1,1}',0,0,'{0}',1,2,'KGRwMQou','KGRwMQou');
insert into gbattributetypes(ssid,nid,inid,uid,status,noofchanges,fieldschanged,changetype,noofcommits,noofchangesaftercommit,history,restrictiontype,restrictionref,rendered_nbh,nbh) values (nextval('ssid_seq'),'email',8,1,'Public',2,'{status,subjecttypes}','{1,1}',0,0,'{0}',1,3,'KGRwMQou','KGRwMQou');
insert into gbattributetypes(ssid,nid,inid,uid,status,noofchanges,fieldschanged,changetype,noofcommits,noofchangesaftercommit,history,restrictiontype,restrictionref,rendered_nbh,nbh) values (nextval('ssid_seq'),'firstname',9,1,'Public',2,'{status,subjecttypes}','{1,1}',0,0,'{0}',1,4,'KGRwMQou','KGRwMQou');
insert into gbattributetypes(ssid,nid,inid,uid,status,noofchanges,fieldschanged,changetype,noofcommits,noofchangesaftercommit,history,restrictiontype,restrictionref,rendered_nbh,nbh) values (nextval('ssid_seq'),'lastname',10,1,'Public',2,'{status,subjecttypes}','{1,1}',0,0,'{0}',1,5,'KGRwMQou','KGRwMQou');
insert into gbattributetypes(ssid,nid,inid,uid,status,noofchanges,fieldschanged,changetype,noofcommits,noofchangesaftercommit,history,restrictiontype,restrictionref,rendered_nbh,nbh) values (nextval('ssid_seq'),'title',11,1,'Public',1,'{status}','{1}',0,0,'{0}',1,6,'KGRwMQou','KGRwMQou');
insert into gbattributetypes(ssid,nid,inid,uid,status,noofchanges,fieldschanged,changetype,noofcommits,noofchangesaftercommit,history,restrictiontype,restrictionref,rendered_nbh,nbh) values (nextval('ssid_seq'),'description',12,1,'Public',1,'{status}','{1}',0,0,'{0}',1,7,'KGRwMQou','KGRwMQou');
insert into gbattributetypes(ssid,nid,inid,uid,status,noofchanges,fieldschanged,changetype,noofcommits,noofchangesaftercommit,history,restrictiontype,restrictionref,rendered_nbh,nbh) values (nextval('ssid_seq'),'content',13,1,'Public',1,'{status}','{1}',0,0,'{0}',1,8,'KGRwMQou','KGRwMQou');
insert into gbattributetypes(ssid,nid,inid,uid,status,noofchanges,fieldschanged,changetype,noofcommits,noofchangesaftercommit,history,restrictiontype,restrictionref,rendered_nbh,nbh) values (nextval('ssid_seq'),'listdatatype',14,1,'Public',1,'{status,subjecttypes}','{1}',0,0,'{0}',1,9,'KGRwMQou','KGRwMQou');
insert into gbattributetypes(ssid,nid,inid,uid,status,noofchanges,fieldschanged,changetype,noofcommits,noofchangesaftercommit,history,restrictiontype,restrictionref,rendered_nbh,nbh) values (nextval('ssid_seq'),'mandatoryflds',15,1,'Public',1,'{status}','{1}',0,0,'{0}',1,10,'KGRwMQou','KGRwMQou');



INSERT INTO gbcatalogsubjecttypes(attributetypeid,subjecttypeid) values (6,5);
INSERT INTO gbcatalogsubjecttypes(attributetypeid,subjecttypeid) values (7,5);
INSERT INTO gbcatalogsubjecttypes(attributetypeid,subjecttypeid) values (8,5);
INSERT INTO gbcatalogsubjecttypes(attributetypeid,subjecttypeid) values (9,5);
INSERT INTO gbcatalogsubjecttypes(attributetypeid,subjecttypeid) values (10,5);
INSERT INTO gbcatalogsubjecttypes(attributetypeid,subjecttypeid) values (11,0);
INSERT INTO gbcatalogsubjecttypes(attributetypeid,subjecttypeid) values (12,0);
INSERT INTO gbcatalogsubjecttypes(attributetypeid,subjecttypeid) values (13,0);
INSERT INTO gbcatalogsubjecttypes(attributetypeid,subjecttypeid) values (14,4);
INSERT INTO gbcatalogsubjecttypes(attributetypeid,subjecttypeid) values (15,0);



update gbusertypes set rendered_nbh = 'KGRwMQpTJ2F0dHJpYnV0ZXR5cGVzJwpwMgoobHAzClMnNicKYVMnNycKYVMnOCcKYVMnOScKYVMnMTAnCnA0CmFzLg==' where ssid = 5;

--INSERT INTO gbobjecttypes values(nextval('ssid_seq'),'courses',11,1,'public',1,'{status}','{1}',0,0,'{0}',now(),'','');
--INSERT INTO gbobjecttypes values(nextval('ssid_seq'),'content',12,1,'public',1,'{status}','{1}',0,0,'{0}',now(),'','');


insert into gbnidssid values(1,'admin',1,'gbusers',to_tsvector('admin'::text));
insert into gbnidssid values(2,'instanceof',2,'gbrelationtypes',to_tsvector('instanceof'::text));
insert into gbnidssid values(3,'subtypeof',3,'gbrelationtypes',to_tsvector('subtypeof'::text));
insert into gbnidssid values(4,'gblist',4,'gbobjecttypes',to_tsvector('gblist'::text));
insert into gbnidssid values(5,'GnowsysUsers',5,'gbusertypes',to_tsvector('GnowsysUsers'::text));
insert into gbnidssid values(6,'username',6,'gbattributetypes',to_tsvector('username'::text));
insert into gbnidssid values(7,'password',7,'gbattributetypes',to_tsvector('password'::text));
insert into gbnidssid values(8,'email',8,'gbattributetypes',to_tsvector('email'::text));
insert into gbnidssid values(9,'firstname',9,'gbattributetypes',to_tsvector('firstname'::text));
insert into gbnidssid values(10,'lastname',10,'gbattributetypes',to_tsvector('lastname'::text));
insert into gbnidssid values(11,'title',11,'gbattributetypes',to_tsvector('title'::text));
insert into gbnidssid values(12,'description',12,'gbattributetypes',to_tsvector('description'::text));
insert into gbnidssid values(13,'content',13,'gbattributetypes',to_tsvector('content'::text));
insert into gbnidssid values(14,'listdatatype',14,'gbattributetypes',to_tsvector('listdatatype'::text));
insert into gbnidssid values(15,'mandatoryflds',15,'gbattributetypes',to_tsvector('mandatoryflds'::text));
--insert into gbnidssid values(11,'courses',11,'gbobjecttypes',to_tsvector('admin'::text));
--insert into gbnidssid values(12,'content',12,'gbobjecttypes',to_tsvector('admin'::text));


insert into gbnid_latestssid values(1,'admin');
insert into gbnid_latestssid values(2,'instanceof');
insert into gbnid_latestssid values(3,'subtypeof');
insert into gbnid_latestssid values(4,'gblist');
insert into gbnid_latestssid values(5,'GnowsysUsers');
insert into gbnid_latestssid values(6,'username');
insert into gbnid_latestssid values(7,'password');
insert into gbnid_latestssid values(8,'email');
insert into gbnid_latestssid values(9,'firstname');
insert into gbnid_latestssid values(10,'lastname');
insert into gbnid_latestssid values(11,'title');
insert into gbnid_latestssid values(12,'description');
insert into gbnid_latestssid values(13,'content');
insert into gbnid_latestssid values(14,'listdatatype');
insert into gbnid_latestssid values(15,'mandatoryflds');
--insert into gbnid_latestssid values(11,'courses');
--insert into gbnid_latestssid values(12,'content');


