# -*- coding: utf-8 -*- 
#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################


__author__ = """Rajiv Nair <rajivnair@gnu.org>"""


import psycopg2
from GeneralMethods import *
from UpdateMethods import *
from GetMethods import GetMethods
import cPickle
import os,sys
from datetime import datetime
from base64 import b64encode,b64decode


class Inherit:
	def __init__(self , conString , uid):
		self.constring = conString
		self.conn = psycopg2.connect( conString )   
		self.curs = self.conn.cursor() 
		self.subtypes = []
		self.instances = []
		self.uid = uid
		

	def setRoles( self, subject1_ssid_list, subject1_inid_list, subject2inid, rts ):
		"""
		"""
		for rt in rts:
			get_rtids_query = "SELECT roletypeid from gbcatalogrelationtypes WHERE relationtypeid = '%s'" % ( rt )
			self.curs.execute( get_rtids_query )	
			rtids = self.curs.fetchall()

			roletypes = []
			for r in rtids :
				roletypes.append( r[0] )
		
			rtids_string = list2string( roletypes ) 

			get_rtidinfo_query = "SELECT * from gbroletypes where rtid in %s" %( rtids_string )
			self.curs.execute( get_rtidinfo_query )	
			rtid_info = self.curs.fetchall()

			rtid_list = []
			newroleidlist = [] 

					
			qstring1 = ''
			qstring2 = ''

			for roleinfotuple in rtid_info:
				for subject1_inid in subject1_inid_list:
					temp = list( roleinfotuple )
					
					insertflag = 0
					if str(temp[1]) == subject2inid:
						temp[1] = subject1_inid
						insertflag = 1
					if str(temp[2]) == subject2inid:
						temp[2] = subject1_inid
						insertflag = 1
                                
					if insertflag == 1:
						seq_rtid = get_next_sequence_value( 'gbroletypes_rtid_seq' , self.curs)
						newroleidlist.append( str(seq_rtid) )

						if  temp[5] <> None:	
							qstring1 = qstring1 + "(%s,%s,%s,%s,%s,'%s','%s')," %(seq_rtid, temp[1], temp[2], temp[3], temp[4], temp[5], temp[6])
						if  temp[5] == None:	
							qstring2 = qstring2 + "(%s,%s,%s,%s,%s)," %(seq_rtid, temp[1], temp[2], temp[3], temp[4])
				
					
			qstring1 =  qstring1[:-1]	
			qstring2 =  qstring2[:-1]	

			if qstring1 <> '':
				
				query = "insert into gbroletypes (rtid,subjecttype1,subjecttype2,cardinality1,cardinality2,applicablenodetypes1,applicablenodetypes2) values %s;"  %( qstring1 )
				
				execute_query( query , self.curs )            
			if qstring2 <> '':
				query = "insert into gbroletypes (rtid,subjecttype1,subjecttype2,cardinality1,cardinality2) values %s;"  %( qstring2 )
				execute_query( query , self.curs )            
					
				

			get_rt_query = "SELECT rendered_nbh from %s where ssid = %s" %('gbrelationtypes' , rt)
                        self.curs.execute( get_rt_query )
                        values  = self.curs.fetchall()[0]
                        rendered_nbh = cPickle.loads(  b64decode( values[0] ) )
			try:
				rendered_nbh['roletypes'] = rendered_nbh['roletypes'] + newroleidlist
			except:
				rendered_nbh['roletypes'] = newroleidlist
                        update_query = "UPDATE %s set rendered_nbh='%s' where ssid = %s;" %('gbrelationtypes' , b64encode( cPickle.dumps(rendered_nbh) )  , rt)
                        self.curs.execute( update_query )


		
	def setSubjecttypes ( self, subject1_ssid_list, subject1_inid_list, subject2inid, ats  ):
		"""
		"""
		
		
		qstring1 = ''
		qstring2 = ''

		self.curs.execute( "SELECT attributetypeid,subjecttypeid,applicablenodetypes from gbcatalogsubjecttypes WHERE attributetypeid in %s" % ( list2string( ats ) ) )	
		st_info_previous = self.curs.fetchall()
		
		st_info = []
		for val in st_info_previous:
			if val not in st_info:
				st_info.append( val )
		
		at_st_dict = {}
		   
		for stinfotuple in st_info:
			for subject1_inid in subject1_inid_list:
				temp = list( stinfotuple )
				if str(temp[1]) == subject2inid:
					temp[1] = long(subject1_inid)
				temp_tuple = tuple(temp)
				if temp_tuple not in st_info:
					if  temp[2] <> None:	
						qstring1 = qstring1 + "(%s,%s,'%s')," %( temp[0], temp[1], temp[2])
					if  temp[2] == None:		
						qstring2 = qstring2 + "(%s,%s)," %( temp[0], temp[1] )

				if str(temp[0]) not in at_st_dict.keys():
					   at_st_dict[ str(temp[0]) ] = [ temp[1] ]
				else:
					   at_st_dict[ str(temp[0]) ].append( temp[1] )
					
		qstring1 =  qstring1[:-1]	
		qstring2 =  qstring2[:-1]	
				   

		if qstring1 <> '':
				query = "insert into gbcatalogsubjecttypes (attributetypeid,subjecttypeid,applicablenodetypes) values %s"  %( qstring1 )
				execute_query( query , self.curs )            
	        if qstring2 <> '':
				query = "insert into gbcatalogsubjecttypes (attributetypeid,subjecttypeid) values %s"  %( qstring2 )
				execute_query( query , self.curs )            
		   
                
	        for key in at_st_dict:
			get_at_query = "SELECT rendered_nbh from %s where ssid = %s" %('gbattributetypes' , key)
                        self.curs.execute( get_at_query )
                        values  = self.curs.fetchall()[0]
                        rendered_nbh = cPickle.loads(  b64decode( values[0] ) )
			try:
				rendered_nbh['attributetypes'] = rendered_nbh['attributetypes'] + at_st_dict[key]
			except:
				rendered_nbh['attributetypes'] = at_st_dict[key]
                        update_query = "UPDATE %s set rendered_nbh='%s' where ssid = %s;" %('gbattributetypes' , b64encode( cPickle.dumps(rendered_nbh) )  , key)
                        self.curs.execute( update_query )
		   
		
		
	def inherit( self, subject1_ssid_list , subject1_inid_list, subject1_nodetype, subject2_ssid_list ):
		"""
		ABOUT THE ARGUMENTS:
		1) subject1 ssid
		2) subject2 ssid list


		ALGORITHM:
		1) get the inids of subject2_ssid_list
		2) check the neighbourhood of subject2_ssid_list and get relationtypes and attributetypes
		3) combine relationtypes and attributetypes and make a dictionary where there are 
		   two keys 'relationtypes' and 'attributetypes'. The values are put into the respective 
		   keys. This is appended to the neighbourhood of the new node created. Basically
		   these are the relationtypes and attributetypes of the new node.
		4) RELATIONTYPES:
                   For each id in subject2_ssid_list 
		   -- get roletypes and the corresponding info from the catalog tables 
		   -- replace the id in any of the subjecttypes field with the ssid of subject1.
		   -- generate roletype ids for every entry and add it to the relatiotypes.
		5) ATTRIBUTETYPES:
		   For each id in subject2_ssid_list 
		   -- get subjectypes and replace the subjecttype info with the subject1 ssid.
		   
		   
		"""

		obj = GetMethods( self.constring )

		inidsdict = obj.getinids( subject2_ssid_list, userid=self.uid )

		nbhdict = obj.getNeighbourhood( subject2_ssid_list, 'rendered_nbh')
		
   	        rt_at_dict = {'relationtypes':[],'attributetypes':[]}		   
		for ssid in nbhdict:
			subject2inid = inidsdict[ssid]
			if 'relationtypes' in nbhdict[ssid]:
				rts = nbhdict[ssid]['relationtypes']
				if rts <> []:
					#self.setRoles( subject1_ssid_list, subject1_inid_list, subject2inid, rts )
					rt_at_dict['relationtypes'] = rt_at_dict['relationtypes'] + rts    
			if 'attributetypes' in nbhdict[ssid]:	
				ats = nbhdict[ssid]['attributetypes']
				if ats <> []:
					#self.setSubjecttypes( subject1_ssid_list, subject1_inid_list, subject2inid, ats )
					rt_at_dict['attributetypes'] = rt_at_dict['attributetypes'] + ats       
		

		
		# get_nbh_query = "SELECT ssid,rendered_nbh from %s where ssid in %s" %( subject1_nodetype , list2string(subject1_ssid_list) )
		
		# self.curs.execute( get_nbh_query )
		# values  = self.curs.fetchall()

		# final_dict = {}
		# for ssid_nbh in values:
		# 	rendered_nbh = cPickle.loads(  b64decode( ssid_nbh[1] ) )

		# 	try:
		# 		rendered_nbh['attributetypes'] = rendered_nbh['attributetypes'] + rt_at_dict['attributetypes']
		# 	except:
		# 		rendered_nbh['attributetypes'] = rt_at_dict['attributetypes']
		# 	try:	
		# 		rendered_nbh['relationtypes'] = rendered_nbh['relationtypes'] + rt_at_dict['relationtypes']
		# 	except:
		# 		rendered_nbh['relationtypes'] = rt_at_dict['relationtypes']

			
		# 	update_query = "UPDATE %s set rendered_nbh='%s' where ssid = %s;" %( subject1_nodetype , b64encode( cPickle.dumps(rendered_nbh) )  , ssid_nbh[0])
		# 	self.curs.execute( update_query )
		
		#commitclose(self.curs,self.conn)		   
		
		return rt_at_dict			    
			
			
        

			
if __name__=="__main__":
      constring="dbname=<postgres_databasename> user=<postgres_username> password=<postgres_password> host=localhost"	

      obj=Inherit(constring,'1')
      print obj.inherit(['282'],['282'],'gbobjecttypes',['48'])
      #print obj.getContributors('149')
      #print obj.getModDate('149')
      ##print obj.getAllInstances( '152' )
      ##print obj.getSubtypes( '152' )
      ##print obj.getInstances( '152' )
      ##print obj.getAllSubtypes( ['152'] )
      ##print obj.getRelationids ([['17','15'],['17','16']])
      #Attrssidlist = ['130','131','123']
      ##print obj.getAttributeValues( Attrssidlist )
      ##print obj.getNodetype( '12345' )
      ##print obj.getRelationtypes(['11','38026'])
      ##print obj.getAttributetypes(['5','19'])
      ##print obj.getRoles('instanceof')
      ##print obj.getDatatype(['6','7','8','9'])
      ##print obj.getSelectionlist()
      ##print obj.isnidExists('colors')
      ##print obj.getRegex()
      ##print obj.getSubjecttypes('Languages')
      #ssid_list=['7']
      ##print obj.getinfoFromSSID(ssid_list)
      ##print obj.getlatestssids(['writer1','book2'],'nid')
      #obj.getlatestssids(['instanceof','subtypeof'],'nid')
      ##print obj.getUserIdfromUsername('')
      ##print obj.getRestrictions(['10','50','51'])
      #print obj.getNeighbourhood(['311'],'rendered_nbh')
      ##print obj.getAllSnapshots('nid',"Vesit's OWner")
      ##print obj.getlatestssidsFromNids(["Vesit's OWner"])
      ##print obj.getPublicIds(['3','4','11','12'],1)
      ##print obj.search( 'Writer' )
      #print obj.getnids(['113'],userid='1')
      ##print obj.getCount('gbusers')
      ##print obj.getSpecificnbh('142',['attributes','relations'])
      ##print obj.getSpecificnbh('142',{'attributes':['title'],'relations':['hasWritten']})
      ##print obj.getAuthor('88')
      ##print obj.updateStatus( '133' , 'deleted')
      ##print obj.updateStatus( '142' , 'deleted')
      ##print obj.getlatestssids(['writer4','book2'],'nid')
      ##print obj.getStructure('142')
      ##print obj.updatePasswd('gnowsysuser8','abc','1')
      #print obj.getPossibleRel( 'hasWritten' )
      #print obj.getPossibleAttr( '1429' )
      #print obj.getPriorstates(['123'])
      #print obj.getPoststates(['123'])      
      #print obj.getNodetypes(['6','40','331'])      
      #params = {'instanceof':['199']}
      #print obj.getFrame('gbobjects',params)
      #print obj.getRelFrame('gbobjects','reads','1035')
      #print obj.getFrame('gbobjects', {'instanceof': ['21']},'0')





