# -*- coding: utf-8 -*- 
#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################

__contributor__= """   Jay Mehta (jay87.mehta@gmail.com)  """
__docformat__ = 'plaintext'
  

from GeneralMethods import *
from Relation import *
from Attribute import *
import psycopg2

class metatypes:
  def __init__(self , constring , uid):
          self.constring = constring 
          self.conn = psycopg2.connect( constring )
          self.curs = self.conn.cursor()
          self.uid = uid

  def create_metatype(self,input):#4 gbmetatypes
      input['uid']=self.uid
      if input['nid'].isspace():
           return  "nid NOT given"
      else:
            if id_exists("nid",input['nid'],"gbnid_latestssid",self.curs)==1:
              return "nid cannot be null"

            uid=input['uid']
            nid=input['nid']
            if input['status'].isspace():
               status="public"
            else:
               if check_statusfield(input['status'])==0:
                  return "Invalid status"
               status=input['status']
               
            noofchanges=1
            fieldschanged="{status}"
            changetype="{1}"
            noofcommits=0
            noofchangesaftercommit=0
            history="{0}"
            rendered_nbh={}
            nbh={}
            new_subject1_ssid=get_next_sequence_value('ssid_seq',self.curs)#this is the new ssid of the metatype.
            #print"NEW SUBJECT SSID OF METATYPES",new_subject1_ssid
            new_subject1_ssid_list=[]
            new_subject1_ssid_list.append(new_subject1_ssid)

            #ouput_dic is returned on sucessful object creation.
            output_dic={}
            output_dic['new_subject_ssid'] = new_subject1_ssid

            supertypeof_inid_list = []
            classof_inid_list=[]#It is always a blank list.

            flag_inherit = 0

            if input.has_key('subtypeof'):
               subtypeof=input['subtypeof']#subtypeof=['23','43','63']
               if ssid_exists(subtypeof,"gbmetatypes" ,self.curs)==0:
                  return "invalid subtypeof ssids" 
               else:
                  ##print" all subtypeof ssids validated"                

                  subtypeof_relnobj=relations( self.constring , self.uid)

                  relninput={'uid':input['uid'],'status':input['status'],'relationtypes':'subtypeof','subject1':new_subject1_ssid_list,'subject2':input['subtypeof'],'nodetype1_list':['gbmetatypes']}  

                  #newssid_of_subtypeof_list=[]
                  #for s2 in range(len(relninput['subject2'])):
                  #    newssid_of_subtypeof_list.append(get_next_sequence_value('ssid_seq',self.curs))

                  #here supertypeof_inid_list = subject2_inid_list corresponds to ssids of subject2 which are input['subtypeof']    
                  supertypeof_inid_list = get_inid_from_ssid(relninput['subject2'],self.curs)                   

                  #if wish to create new snapshot ...
                  #dic_from_Reln=subtypeof_relnobj.startchecks_n_callwrite(relninput,"3",new_subject1_ssid_list,newssid_of_subtypeof_list,supertypeof_inid_list,1,0,0)

                  dic_from_Reln=subtypeof_relnobj.startchecks_n_callwrite(relninput,"3",new_subject1_ssid_list,relninput['subject2'],supertypeof_inid_list,0,0,0)
                  if dic_from_Reln==-1:
                     return -1

                  flag_inherit = 1
                  inherit_s2_list = inherit_s2_list + input['subtypeof']

                  subtypeof_relnssid_list=dic_from_Reln['subj1ssid_relnssidlist_dic'].values()[0]#all subtypeof relnssids.
                  if subtypeof_relnssid_list==-1:
                     return "Problem occured while creating subtypeof relations."
                  else:
                       noofchanges=noofchanges+1
                       fieldschanged=fieldschanged.rstrip("}")+",subtypeof}"
                       changetype=changetype.rstrip("}")+",1}"

                       nbh['relations']=subtypeof_relnssid_list
                       rendered_nbh['relations']={}
                       rendered_nbh['relations']['subtypeof']={}
                       #rendered_nbh['relations']['subtypeof']['rightroles']=newssid_of_subtypeof_list
                       rendered_nbh['relations']['subtypeof']['rightroles']=relninput['subject2']
            if input.has_key('relation'):                       
                #print "INPUT HAS KEY RELATION"
                unknownrelation_list=input['relation']#unknownrelation_list=[('reltypenid',['list of ssids']),()],
                relntype_ssid_list= check_relntypenid_listofsubjssid(self.curs,unknownrelation_list)
                if relntype_ssid_list==-1:
                    return "input['relations'] cant have instanceof or subtypeof as relationtypenid."

                unknownrelation_obj=relations( self.constring , self.uid)
                oldS2_newS2_dic = {}
                olds2ssid_inid_dic={}
                s2ssid_snapshotData_dic={}
                all_subject2_ssid_list=[]

                tupleno=0
                for tuple in unknownrelation_list:
                        unknownrelation_ssid=tuple[1]
                        unknown_relntype_nid=tuple[0]
                        relninput={'uid':input['uid'],'status':input['status'],'relationtypes':unknown_relntype_nid,'subject1':new_subject1_ssid_list,'subject2':unknownrelation_ssid,'nodetype1_list':['gbmetatypes']}
                        
                        newssid_of_unknownrelation_list=[]

                        for s2 in relninput['subject2'] :
                            if oldS2_newS2_dic.has_key(s2):
                               newssid_of_unknownrelation_list.append( oldS2_newS2_dic[s2] )
                            else:
                               newS2 = get_next_sequence_value('ssid_seq',self.curs) 
                               newssid_of_unknownrelation_list.append( newS2 )
                               #print "newssid_of_unknownrelations====", newssid_of_unknownrelation_list
                               oldS2_newS2_dic[s2] = newS2
                               all_subject2_ssid_list.append(s2)                        

                        #here s2_inid_list is list of subject2_inid, where subject2_ssid_list is unknownrelation_ssid.     
                        s2_inid_list = get_inid_from_ssid(relninput['subject2'],self.curs)                            

                        for s2indexno in range(len(s2_inid_list)):
                            olds2ssid_inid_dic[relninput['subject2'][s2indexno]] = s2_inid_list[s2indexno]

                        #here father1_inid_list is a list of inids of fathers of subject1

                        father1_inid_list = 0
                        if input.has_key('subtypeof'):
                              supertypeof_subj1_List = [ get_inid_from_ssid(input['subtypeof'],self.curs) ] 
                        else:
                             #print "cant create relation without giving subjects subtypeof or instanceof"
                             return -1


                        #print "relntype_ssid_list[tuple_no] ",relntype_ssid_list[tupleno]
                        dic_from_Reln=unknownrelation_obj.startchecks_n_callwrite(relninput,relntype_ssid_list[tupleno],new_subject1_ssid_list,newssid_of_unknownrelation_list,s2_inid_list,0,father1_inid_list,supertypeof_subj1_List)
                        if dic_from_Reln == -1:
                           #print "Problem occured while creating unknown relations for this object."
                           return -1
                        unknownrelation_ssid_list=dic_from_Reln['subj1ssid_relnssidlist_dic'].values()[0]# =all new  unknonwn reln ssids

                        subj2_snapshot_dic_fromReln = dic_from_Reln['subj2_snapshot_dic']

                        noofchanges=noofchanges+1
                        fieldschanged=fieldschanged.rstrip("}")+","+unknown_relntype_nid+"}"
                        changetype=changetype.rstrip("}")+",1}"
                        rendered_nbh['relations'][unknown_relntype_nid]={}
                        rendered_nbh['relations'][unknown_relntype_nid]['rightroles']= newssid_of_unknownrelation_list
                        nbh['relations']= nbh['relations'] + unknownrelation_ssid_list

                        #collect data for writing new snapshot of subject2       
                        for s2index in range(len(newssid_of_unknownrelation_list)):
                            s2ssid = newssid_of_unknownrelation_list[s2index]
                            if s2ssid_snapshotData_dic.has_key(s2ssid): 
                               snapshotDataDic = s2ssid_snapshotData_dic[s2ssid]
                               snapshotDataDic['relntype_nid_list'].append( relninput['relationtypes'] )
                               snapshotDataDic['relnssid'].append( subj2_snapshot_dic_fromReln['newRelnssidList_4_subj2List'][s2index] )
                               s2ssid_snapshotData_dic[s2ssid] = snapshotDataDic
                            else:
                               snapshotDataDic={}
                               snapshotDataDic['relntype_nid_list'] = [relninput['relationtypes']]
                               snapshotDataDic['nodetype'] = subj2_snapshot_dic_fromReln['nodetype2_list'][s2index]
                               snapshotDataDic['relnssid'] = [subj2_snapshot_dic_fromReln['newRelnssidList_4_subj2List'][s2index]]
                               s2ssid_snapshotData_dic[s2ssid] = snapshotDataDic
                        #end of colecting data
                        
                        tupleno=tupleno+1           
                #start creating new snapshot for each subject2-------
                #print "oldS2_newS2_dic   ",oldS2_newS2_dic   
                for oldS2ssid in oldS2_newS2_dic :
                    s2ssid = oldS2_newS2_dic [oldS2ssid]
                    snapshotDataDic = s2ssid_snapshotData_dic[s2ssid]
                    #print "key--",s2ssid
                    #print snapshotDataDic
                    R_newsnapshot(snapshotDataDic['nodetype'], input['uid'], oldS2ssid, s2ssid,snapshotDataDic['relntype_nid_list'],snapshotDataDic['relnssid'],new_subject1_ssid,self.curs)
                #end--------

                #start writing new subject2 ssid in gbnidssid and gbnidlatestssid.    
                #print "all_subject2_ssid_list",all_subject2_ssid_list
                subject2_nid_list = get_nid_from_ssid(all_subject2_ssid_list, self.curs)
                #print "subject2_nid_list",subject2_nid_list
                #print "olds2ssid_inid_dic",olds2ssid_inid_dic

                for ssid_no in range(len(subject2_nid_list)):
                    o_s2_ssid = all_subject2_ssid_list[ ssid_no ]
                    n_s2_ssid = oldS2_newS2_dic [o_s2_ssid]
                    #print "updating ",o_s2_ssid," to ",n_s2_ssid
                    nodetype = s2ssid_snapshotData_dic[n_s2_ssid]['nodetype']               
                    s2inid = olds2ssid_inid_dic[o_s2_ssid]
                    reset_ssid_2_latestssid(n_s2_ssid, subject2_nid_list[ssid_no],self.curs)
                    bind_nidssid(n_s2_ssid, subject2_nid_list[ssid_no], s2inid, nodetype, self.curs)
                # end -------    

                output_dic['oldS2_newS2_dic'] =  oldS2_newS2_dic                                   
            if input.has_key('attributes'):
                #creating the attribute. writing in both gbattributes table and datatypes_* table
                gbattr_input={'nid':input['nid'],'uid':uid,'status':status,'instanceof':input['attributes'],'subject':new_subject1_ssid_list[0],'subject_inid':new_subject1_ssid_list[0],'language':input['language'],'nodetype':'gbmetatypes'}

                attrobj=attribute( self.constring , self.uid)

                new_attr_ssid_list=[]
                for no_of_attrs in range(len(input['attributes'])):
                    new_attr_ssid_list.append(get_next_sequence_value('ssid_seq',attrobj.curs))

                gbattr_input['new_attr_ssid_list'] = new_attr_ssid_list    
                    
                attrtype_nid_attrvalue_list = attrobj.create_newattr(gbattr_input,new_subject1_ssid_list[0],classof_inid_list,supertypeof_inid_list,1,0)

                if attrtype_nid_attrvalue_list==-1:
                   return "Problem occured while creating attribute."
                else:
                   attrtype_nid_list =attrtype_nid_attrvalue_list [0]
                   attrvalue_list=attrtype_nid_attrvalue_list[1]
                   fieldschanged=fieldschanged.rstrip("}")
                   changetype=changetype.rstrip("}")
                   for attrtypenids in attrtype_nid_list:
                       noofchanges=noofchanges+1
                       fieldschanged=fieldschanged+","+attrtypenids
                       changetype=changetype+ ",1"
                   fieldschanged=fieldschanged+"}"                           
                   changetype=changetype+ "}"
                   nbh['attribute']=new_attr_ssid_list
                   rendered_nbh['attributes']={}
                   for no_of_attr in range(len(attrtype_nid_list)):
                       rendered_nbh['attributes'] [attrtype_nid_list[no_of_attr]] = (new_attr_ssid_list[no_of_attr],attrvalue_list[no_of_attr]) 
            #  inheritance logic ---start                                                                                                                 
            if flag_inherit == 1:
               from Inherit import *
               inherit_obj = Inherit(self.constring,self.uid)
               inherit_rendernbh_dic = inherit_obj.inherit( new_subject1_ssid_list ,new_subject1_ssid_list,'gbmetatypes', inherit_s2_list)
               rendered_nbh['attributetypes'] = inherit_rendernbh_dic['attributetypes']
               rendered_nbh['relationtypes'] = inherit_rendernbh_dic['relationtypes']
            #end----


            #write in gbmetatypes
            sql="INSERT INTO gbmetatypes values(%s,'%s',%s,'%s','%s',%s,'%s','%s',%s,%s,'%s',now(),'%s','%s');"%(new_subject1_ssid_list[0],nid,new_subject1_ssid_list[0],uid,status,noofchanges,fieldschanged,changetype,noofcommits,noofchangesaftercommit,history,b64encode( cPickle.dumps(rendered_nbh) ), b64encode( cPickle.dumps(nbh) ))
            #print sql
            execute_query(sql,self.curs)
            bind_nidssid(new_subject1_ssid,input['nid'],new_subject1_ssid,"gbmetatypes",self.curs)
            bind_nidlatestssid(new_subject1_ssid,input['nid'],self.curs)
            commitclose(self.curs,self.conn)   
            try:
              commitclose(unknownrelation_obj.curs,unknownrelation_obj.conn)
            except:
              #print "no relations given as input for objecttype"
              pass
            try:
              commitclose(subtypeof_relnobj.curs,subtypeof_relnobj.conn)
            except:
              #print "no subtypeof for gbmetatypes"
              pass
            try:
              commitclose(attrobj.curs,attrobj.conn)   
            except:
              #print "no attributes for gbmetatypes"
              pass
            try:
              commitclose( inherit_obj.curs, inherit_obj.conn)   
            except:
              #print "no inherit for objecttype"
              pass

            return output_dic

    
