
#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################


# This file contains methods for import and export of RDF triplets

__contributer__ = """shaswat<shaswat@hbcse.tifr.res.in>"""
__docformat__ = 'plaintext'


import xmlrpclib
from GetMethods import *
from SetMethods import *
import os
import sys

"""                                                                                                                                             
This function converts  the neighbourhood of a gnowsys type or token  into an  N3 file                        
Thus rdf triples can be generated and then  a gnowsys server can be update with these new relations                                                        
The validating file for the gnowsys schema can be found at <http://www.gnowledge.org/gnowsys-schema#>                                                    
"""
 
def n3_nbhexport(ssid,conString,path,system):

    path = path+'/n3/' + ssid  + '.txt'
    os.system("touch " + path)
    con = GetMethods(conString)
    nid = con.getnids([ssid])[ssid]
    #path = '/usr/local/Plone/zeocluster/parts/client1/var/GB/gnowsys/Data/n3'
    file=open(path,'w')
    file.write("@prefix dc:<http://purl.org/dc/elements/1.1/>.  \n@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .  \n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>.    \n@prefix owl:  <http://www.w3.org/2002/07/owl#>.      \n@prefix : <#> .   \n@prefix  gnowsys:<http://gnowledge.org/gnowsys-schema#> .  \n@prefix " +system+":<http://gnowledge.org/" +  system  + "-schema#> .  \n \n")
    if nid.find(".") > 0 :
        extension = nid.split(".")[1]
        nid  =     nid.split(".")[0] + "(d)"     +   extension
    if nid.find(":") > 0 :
            extension = nid.split(":")[1]
            nid  =     nid.split(":")[0] + "(c)"     +   extension
    if nid.find("/") > 0 :
            parts = nid.split("/")
            nid = " "
            for part in parts :
                nid  =    nid +  part  + "(s)"

    file.write(":document  dc:title    \" This is the description of the node " + nid  +  " \" . ")
    file.write("\n:document rdf:About \" This contains the semantic relations . ")
    file.write("\n:"+ nid +  " gnowsys:hasssid :" + ssid)
    ot =  con.getAll("gbobjecttypes").keys()
    rt =  con.getAll("gbrelationtypes").keys()
    at = con.getAll("gbattributetypes").keys()
    f = con.getAll("gbfunctions").keys()

    """
###################################################################### setting the types ############################################################
    for rel_type in rt :
        file.write("\nharvest:" +   rel_type    + "  rdf:is   gnowsys:relationtype." )
        list = con.getRoles(rel_type)
        for dic in list :
            l1  =  dic['subjecttype1']
            l2  =  dic['subjecttype2']
            if   l1 == '0'  or l2 ==  '0'  :
                pass
            else :
                subject1 =  con.getnids([l1])[l1]
                subject2 =  con.getnids([l2])[l2]
                file.write("\nharvest:" + rel_type + " gnowsys:hasrole :" +  str(subject1) + ",:" +     str(subject2) )
 
    for   at_type in at :
        file.write("\nharvest:" +    at_type    + "  rdf:is   gnowsys:attributetype ." )
        list =       con.getSubjecttypes(at_type)
        for dic in list :
            l3  = dic['stid']
            if l3 !=  '0' :
                  subject =              con.getnids([l3])[l3]
            file.write("\nharvest:" + at_type + "gnowsys:hassubject :" + subject )
    for obj_type in                      ot :
        file.write("\n:" +  obj_type  + "  rdf:is gnowsys:objecttype." )

    for   function  in  f :
        file.write("\nharvest:" +  function  +  "  rdf:is gnowsys:function ." )


        """
################################################################# adding the tokens and relations   ######################################################
    
    
    #l= con.getlatestssids([nid],'nid')[nid]
    l = ssid
    dic1 =  con.getNeighbourhood([l],'rendered_nbh')[l] 
    string = " " 
    rdflist = [":document  rdf:About    \" This contains the semantic relations found on    www.gnowledge.org/depmap \" ."]
    try :
            attributes = dic1['attributes'].keys()
            for attribute_type in attributes :
                tuple = dic1['attributes'][attribute_type]
                string =    string +   "\n:"   + nid  +   " gnowsys:attributes" + " " + system + ":" +  attribute_type  + "\""   +  str(tuple[1]) +  "\"" 
                
    except :
            pass
    try :
            dic =   dic1["relations"]
    except :
            return "no relations "

    
    for keys in dic.keys():
      try :
        l = dic[keys]["rightroles"]
        values = con.getnids(l).values()
        string = string +    "\n:"  +  nid + " " + system + ":" + keys 
        tab = 0
        for value in values :
            temp = value
            #if value.find("/") > 0 :
                #value = value.split("/")[1]
            if value.find(".") > 0 :
                extension = value.split(".")[1]
                value = value.split(".")[0] + "(d)"  +   extension
            if value.find(":") > 0 :
                extension = value.split(":")[1]
                value  =        value.split(":")[0] + "(c)"     +   extension
            if value.find("/") > 0 :
                parts = value.split("/")
                value = " "
                for part in parts :
                    value  =    value +  part  + "(s)"
            #ssid =   con.getlatestssids([temp],'nid')[temp]
            #if con.getNodetype(ssid)   ==     "gbobjecttypes"    :
                    #value =  " harvest:" + value
            #else :
            if tab == 0 :
                value = ":" + value
                string1 =  " "        +       value 
                tab = 1 
            else :
                value = ":" + value
                string1 =   ","  +  value 
            string = string + string1
            rdflist.append( ":"   + nid +   system + ":" + keys + string1 + ";")
        string = string + ";"
      except :
          pass
      
      try :
            l = dic[keys]["leftroles"]
            values = con.getnids(l).values()
            string = string +   "\n:"   + nid +    " " +  system  + ":" + con.getInverseName(keys)
            tab = 0
            for value in values :
                temp = value
                #if value.find("/") > 0 :
                    #value = value.split("/")[1]
                if value.find(".") > 0 :
                        extension = value.split(".")[1]
                        value = value.split(".")[0] + "(d)"  +  extension
                if value.find(":") > 0 :
                    extension = value.split(":")[1]
                    value  =     value.split(":")[0] + "(c)"  +  extension
                if value.find("/") > 0 :
                    parts = value.split("/")
                    value  = " "
                    for part in parts :
                        value  =    value +  part  + "(s)"
                #ssid =   con.getlatestssids([temp],'nid')[temp]
                #if con.getNodetype(ssid)   ==     "gbobjecttypes"    :
                    #value =  " harvest:" + value
                #else :
                value = ":" + value
                if tab == 0 :
                    string1 = " " + value
                    tab = 1
                else :
                    string1 =   ","  +  value
                string = string + string1
                rdflist.append( ":"   + nid +  " " + system   +  ":" + con.getInverseName(keys) + string1 + ";")
            string = string + ";"
      except :
            pass

    
    file.write(string)
    file.close()
    filept = open( path ,'r')
    filecont = filept.read()
    filept.close()
    return filecont
    





"""
This function converts an entire gnowsys database , and consequently  , and entire ontology into an  N3 file
Thus all types , tokens and relations between them are converted into a file of rdf triples
The validating file for the gnowsys schema can be found at <http://www.gnowledge.org/gnowsys-schema#>
""" 

def n3_export(conString, path,system):
    ontology = system
    path1 = path +'/n3/' +  ontology + '.txt'
    con = GetMethods(conString)
    #path = '/usr/local/Plone/zeocluster/parts/client1/var/GB/gnowsys/Data/n3'
    file=open(path1,'w')
    file.write("@prefix dc:<http://purl.org/dc/elements/1.1/> .   \n@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>  . \n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>.    \n@prefix owl:  <http://www.w3.org/2002/07/owl#>.      \n@prefix : <#> .   \n@prefix  gnowsys:<http:www.//gnowledge.org/gnowsys-schema#> .  \n@prefix  " + system + ":<http://gnowledge.org/" + ontology  + "-schema#> .  \n \n")
    #n3_schema(conString, path , system)
    file.write(":document  dc:title    \" This is the description of the " + ontology + "   Ontology \" . ")
    file.write("\n:document gnowsys:extends :false")    # this is pretty important
    ot =  con.getAll("gbobjecttypes")
    rt =  con.getAll("gbrelationtypes")
    at = con.getAll("gbattributetypes")
    f  = con.getAll("gbfunctions")
    print ot
    print rt 
    print at
    print "setting the types"
    # get ot ,rt ,at and f from structure of  system 
################################################################## setting the types ######################################################################
    for rel_type in rt :
        file.write("\n" + ontology + ":" +   rel_type  + "  rdf:is gnowsys:relationtype." )
        list = con.getRoles(rel_type)
        
        for dic in list :
            l1 = str(dic['subjecttype1'])
            l2 = str(dic['subjecttype2'])
            if   l1 == '0'  or l2 ==  '0'  :
                pass
            else :
                subject1 =  con.getnids([l1])[l1]
                subject2 =  con.getnids([l2])[l2]
                file.write("\n" + ontology + ":" + rel_type + " gnowsys:hasrole :" + str(subject1) + "," +        str(subject2) )
         
    for  at_type in at :
          file.write("\n" +  ontology  +  ":" +  at_type  + " rdf:is gnowsys:attributetype ." )
          list=  con.getSubjecttypes(at_type)
          for dic in list:
              l3 = dic['stid']
              if l3 !=  '0' :   
                  subject =              con.getnids([l3])[l3]
                  file.write("\n" + ontology + ":" + at_type + " gnowsys:hassubject :" + subject    )

    for obj_type in  ot :
        file.write("\n"      +   ontology + ":"  +  obj_type  + " rdf:is gnowsys:objecttype." )

    for   function  in     f :
        nid = function
        if nid.find(".") > 0 :
            extension = nid.split(".")[1]
            nid  =     nid.split(".")[0] + "(d)"     +   extension
        if nid.find(":") > 0 :
            extension = nid.split(":")[1]
            nid  =     nid.split(":")[0] + "(c)"     +   extension
        
        function = nid
        file.write("\n" +  ontology +    ":" +  function  + " rdf:is gnowsys:function ." )




###################################################################### adding tokens and relations #####################################################
    file.write("\n :document  rdf:About    \" This contains the semantic relations  ")
    type_list = ["gbobjecttypes","gbrelationtypes","gbattributetypes","gbobjects","gbfunctions"]
    string = " "
    for type in type_list:
     list =    con.getAll(type).keys()
     for nid in list :
         #print nid
        #nid =   nid.lstrip(" ")
        l= con.getlatestssids([nid],'nid')[nid]
        dic1 = con.getNeighbourhood([l],'rendered_nbh')[l]

        if nid.find(".") > 0 :
            extension = nid.split(".")[1]
            nid  =     nid.split(".")[0] + "(d)"     +   extension
        if nid.find(":") > 0 :
            extension = nid.split(":")[1]
            nid  =     nid.split(":")[0] + "(c)"     +   extension
        

        try:   
            attributes = dic1['attributes'].keys()        
            for attribute_type in attributes :
                tuple = dic1['attributes'][attribute_type]
                attribute = str(tuple[1])
                nid =  attribute
                if nid.find(".") > 0 :
                    extension = nid.split(".")[1]
                    nid  =     nid.split(".")[0] + "(d)"     +   extension
                if nid.find(":") > 0 :
                    extension = nid.split(":")[1]
                    nid  =     nid.split(":")[0] + "(c)"     +   extension
                if nid.find(",") > 0 :
                    parts =    nid.split(",")
                    nid =  ""
                    for part in  parts :
                        nid = nid + part + "(p)"     
                attribute = nid 
                string =  string +  "\n:"  + nid  +   " gnowsys:attributes" + " " + ontology  + ":" +  attribute_type  + "\"" + attribute + "\""
            
        except :
            pass
        try :
            dic =   dic1["relations"]
        except :
            continue
                
        
        for keys in dic.keys():
            try :
                l = dic[keys]["rightroles"]
            except :
                   continue
            values = con.getnids(l).values()
            string = string +   "\n:"  + nid   +     " " + ontology + ":" + keys
            tab = 0
            for value in values :
                temp = value
                #if value.find("/") > 0 :
                #    value = value.split("/")[1]
                #ssid =   con.getlatestssids([temp],'nid')[temp]
                #if con.getNodetype(ssid) == "gbobjecttypes"    :
                       # value =  " harvest:" + value
                #else :
                value = ":" + value
                if tab == 0 :
                        string = string      +    " "     +     value
                        tab = 1
                else :
                        string = string  +  ","   +  value
            string = string + ";"

    file.write(string)
    file.close()


###########################################################################################################################################################
def n3_schema(conString,path,system):
    ontology = system
    path = path +'/n3/' +  system +         '-schema.txt'
    #conString = conString                                                             
    con = GetMethods(conString)
    #path = '/usr/local/Plone/zeocluster/parts/client1/var/GB/gnowsys/Data/n3'                                                          
    file=open(path,'w')
    file.write("@prefix dc:<http://purl.org/dc/elements/1.1/>  \n@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>.    \n@prefix owl:  <http://www.w3.org/2002/07/owl#>.      \n@prefix : <#> .   \n@prefix  gnowsys:<http:www.//gnowledge.org/gnowsys-schema#> .  \n@prefix  " + system + ":<http://gnowledge.org/" + ontology  + "-schema#> .  \n \n")
    file.write(":document  dc:title    \" This is the description of the system of " + ontology + " \" . ")
    file.write("\n:document gnowsys:extends :true")    # this is pretty important 
    ot =  con.getAll("gbobjecttypes").keys()
    rt =  con.getAll("gbrelationtypes").keys()
    at = con.getAll("gbattributetypes").keys()
    f = con.getAll("gbfunctions").keys()
    # get ot ,rt ,at and f from structure of  system  

    for rel_type in rt :
        file.write("\n" + ontology + ":" +   rel_type  + "  rdf:is gnowsys:relationtype." )
        list = con.getRoles(rel_type)
        for dic in list :
            l1 = str(dic['subjecttype1'])
            l2 = str(dic['subjecttype2'])
            if   l1 == '0'  or l2 ==  '0'  :
                pass
            else :
                subject1 =  con.getnids([l1])[l1]
                subject2 =  con.getnids([l2])[l2]
                file.write("\n" + ontology + ":" + rel_type + " gnowsys:hasrole :" + str(subject1) + "," +        str(subject2) )

    for  at_type in at :
          file.write("\n" +  ontology  +  ":" +  at_type  + " rdf:is gnowsys:attributetype ." )
          list=  con.getSubjecttypes(at_type)
          for dic in list:
              l3 = dic['stid']
              if l3 !=  '0' :
                  subject =              con.getnids([l3])[l3]
                  file.write("\n" + ontology + ":" + at_type + " gnowsys:hassubject :" + subject    )

    for obj_type in  ot :
        file.write("\n"      +   ontology + ":"  +  obj_type  + " rdf:is gnowsys:objecttype." )

    for   function  in  f :
        nid = function
        if nid.find(".") > 0 :
            extension = nid.split(".")[1]
            nid  =     nid.split(".")[0] + "(d)"     +   extension
        if nid.find(":") > 0 :
            extension = nid.split(":")[1]
            nid  =     nid.split(":")[0] + "(c)"     +   extension
        function = nid
        file.write("\n" +  ontology +    ":" +  function  + " rdf:is gnowsys:function ." )





##########################################################################################################################################################

def rdf_import(url,path,schema,option,type):
    if type=="owl" :
        print "importing owl  vocabulary "
        if option=="file":
            print "importing   file "
            owl_import(url,path)
            return
        elif option=="schema":
             print " importing schema " 
             owl_import(url,schema)
             print " importing    file "
             owl_import(url,path)
             return
    startcode = "rdf:About"
    extends = " "
    system =  " "
    #con = GetMethods(conString)
    #setcon = SetMethods(conString,'1')
    file=open(path ,'r')
    line = file.readline().strip()
    object_dic = {}
    otlist =  []
    rtlist = {}
    atlist =  {}
    flist =  []
    #url="http://admin:admin@localhost:8080/rdf-site/gnowql"
    setcon=xmlrpclib.Server(url)
    if option=="schema" :
        pass
    if option=="file" :
        # takes all its info from  current file  itself , assuming schema to be already made in given url 
         pass
    
    # adding the schema 
    while (1):
        if option=="file":
            break
        else :
             file1 = open(schema, "r" )
        line = file1.readline().rstrip("\n")
        if line.find(startcode) > 0 :
            break
        if line.find("gnowsys:ontology")  >= 0  :
            system = line.split("gnowsys:ontology")[1]
            system = system.split(":")[1]
        if line.find("gnowsys:objecttype") > 0 :            
            otlist.append(line.split(" ")[0].split(":")[1])
        if line.find("gnowsys:relationtype")   >   0          :
            relation =    line.split(" ")[0].split(":")[1]
            if rtlist.has_key(relation):
                pass
            else :
                rtlist[relation] = []
        if line.find("gnowsys:attributetype")   >   0      :
            attribute  =       line.split(" ")[0].split(":")[1]
            if atlist.has_key(attribute):
                pass
            else :
                atlist[attribute] = []
        if line.find("gnowsys:function")   >   0      :
            function  =           (line.split(":")[1]).split(" rdf")[0]
            nid =  function
            if nid.find("(d)") > 0 :
                extension = nid.split("(d)")[1]
                nid  =     nid.split("(d)")[0] + "."     +   extension
            if nid.find("(c)") > 0 :
                extension = nid.split("(c)")[1]
                nid  =     nid.split("(c)")[0] +  ":"     +   extension
            if nid.find("(p)") > 0 :
                    parts = nid.split("(p)")
                    nid = " "
                    for part in parts :
                        nid  =    nid +  part  + ","
            function =    nid
            flist.append(function)


        if line.find("gnowsys:hasrole")             >    0             :
            relation =  line.split(" ")[0].split(":")[1]
            subjects = line.split(" ")[2]
            subject1 = subjects.split(",")[0]
            subject2 = subjects.split(",")[1]
            tuple = (subject1,subject2)
            rtlist[relation].append(tuple)
        if line.find("gnowsys:hassubject") > 0 :
            attribute = line.split(" ")[0].split(":")[1]
            subject =   line.split(" ")[2]
            atlist[attribute].append(subject)
    tag = 0
    #print otlist
    #print rtlist
    #print atlist
    #print flist



    while (1):
        
        line = file.readline().rstrip("\n")
        if line.find(startcode) > 0 :
            break
        if line.find("gnowsys:objecttype") > 0 :
            otlist.append(line.split(" ")[0].split(":")[1])
        if line.find("gnowsys:relationtype")   >   0                         :
                relation =    line.split(" ")[0].split(":")[1]
                if rtlist.has_key(relation):
                    pass
                else :
                    rtlist[relation] = []
        if line.find("gnowsys:attributetype")   >   0      :
            attribute  =       line.split(" ")[0].split(":")[1]
            if atlist.has_key(attribute):
                pass
            else :
                atlist[attribute] = []
        if line.find("gnowsys:function")   >   0      :
            function  =           (line.split(":")[1]).split(" rdf")[0]
            nid =  function
            if nid.find("(d)") > 0 :
                extension = nid.split("(d)")[1]
                nid  =     nid.split("(d)")[0] + "."     +   extension
            if nid.find("(c)") > 0 :
                extension = nid.split("(c)")[1]
                nid  =     nid.split("(c)")[0] +  ":"     +   extension
            if nid.find("(p)") > 0 :
                    parts = nid.split("(p)")
                    nid = " "
                    for part in parts :
                        nid  =    nid +  part  + "/"
            function =    nid
            if  function in flist :
                pass
            else :
                flist.append(function)
        if line.find("gnowsys:hasrole")             >    0             :
            relation =  line.split(" ")[0].split(":")[1]
            subjects = line.split(" ")[2]
            subject1 = subjects.split(",")[0]
            subject2 = subjects.split(",")[1]
            tuple = (subject1,subject2)
            rtlist[relation].append(tuple)
        if line.find("gnowsys:hassubject") > 0 :
            attribute = line.split(" ")[0].split(":")[1]
            subject =   line.split(" ")[2]
            atlist[attribute].append(subject)



    
    print "otlist:" , otlist
    print "flist:" , flist
    print "atlist:" , atlist
    print "rtlist:" , rtlist

    while(line):
        line = file.readline().strip(" ")
        line = line.rstrip(";\n")
        if len(line)==0:
            continue

        subject1 = line.split(":")[1]
        if subject1.find("gnowsys") > 0 :
             subject = subject1.split(" gnowsys")[0]
        else :
            subject = subject1.split(" " + system)[0]
        nid = subject 
        if nid.find("(d)") > 0 :
            extension = nid.split("(d)")[1]
            nid  =     nid.split("(d)")[0] + "."     +   extension
        if nid.find("(c)") > 0 :
            extension = nid.split("(c)")[1]
            nid  =     nid.split("(c)")[0] +  ":"     +   extension              
        subject = nid
        if object_dic.has_key(subject)  :
            pass
        else :
            object_dic[subject]={}
        
        predicate = (line.split(subject1)[1]).split(" ")[0]
        predicate = predicate.split(":")[1]
        nid = predicate
        if nid.find("(d)") > 0 :
            extension = nid.split("(d)")[1]
            nid  =     nid.split("(d)")[0] + "."     +   extension
        if nid.find("(c)") > 0 :
            extension = nid.split("(c)")[1]
            nid  =     nid.split("(c)")[0] +  ":"     +   extension
        predicate = nid
        if object_dic[subject].has_key(predicate):
            pass
        else :
            object_dic[subject][predicate]=[]


        object = line.split(predicate  + " ")[1]        
        if object.find(",") > 0 :
            object_list =         object.split(",")
        else :
            object_list = [object]
        object_dic[subject][predicate] =      []
        for object in object_list :
            object = object.strip(":")
            nid = object
            if nid.find("(d)") > 0 :
                extension = nid.split("(d)")[1]
                nid  =     nid.split("(d)")[0] + "."     +   extension
            if nid.find("(c)") > 0 :
                extension = nid.split("(c)")[1]
                nid  =     nid.split("(c)")[0] +  ":"     +   extension
            if nid.find("(p)") > 0 :
                parts = nid.split("(p)")
                nid = " "
                for part in parts :
                    nid  =    nid +  part  + ","

            object_dic[subject][predicate].append(nid)
        # object_dic = {"perl.h" :    {"subtypeof " : ["header"] } , {"dependson" :"stdio.h"} }
#######################################################################################################################################################
      
    for key in object_dic :
      
            print key
            print object_dic[key]
    

    """
    tab = 0
    for ot in otlist :
        if ot in ['gblist']:
            pass
        else :
            input =    { 'nodetype':'objecttype','nid':ot ,  'status':'public' }
            #if object_dic.has_key(ot):
                #if object_dic[ot].has_key("subtypeof") :
                    #input['subtypeof'] = object_dic[ot]["subtypeof"]
            
            if object_dic.has_key(ot): 
                if object_dic[ot].has_key('attributes') :
                    input['language']='en'
                    tab = 0
                    for tuple in  object_dic[ot]['attributes']:
                        attype = (tuple.split('"')[0]).split(':')[1]
                        attribute = tuple.split('"')[1]
                        tuple =        (attype,attribute)
                        if tab ==  0 :
                           input['attributes'] =     [tuple]
                           tab = 1
                        else :
                           input['attributes'].append(tuple)
            print input
            print setcon.setnode(input)
    tab = 0
    for  ft  in    flist       :
            input =    { 'nodetype':'function','nid':ft ,   'status':'public' }
            # if object_dic.has_key(ft):                                                                                               
                    #if object_dic[ft].has_key("subtypeof") :                                                                                   
                  #input['subtypeof'] = object_dic[ft]["subtypeof"]                                                                          
            if   object_dic.has_key(ft)   :
                if object_dic[ft].has_key('attributes') :
                    input['language']='en'
                    tab = 0
                    for tuple in  object_dic[ft]['attributes']:
                        attype = (tuple.split('"')[0]).split(':')[1]
                        attribute = tuple.split('"')[1]
                        tuple =        (attype,attribute)

                        if tab ==  0 :
                           input['attributes'] =     [tuple]
                           tab = 1
                        else :
                           input['attributes'].append(tuple)
            print input
            print setcon.setnode(input)

   
    tab = 0        
    for rt in rtlist.keys() :
            if rt == "subtypeof" or rt == "instanceof":
                pass
            else : 
                tuplelist = rtlist[rt]
                for tuple in tuplelist:
                    s1 = tuple[0]
                    s1 = s1.strip(":")
                    s2 = tuple[1]
                    input = {'nodetype':'relationtype','nid': rt,'status':'Public','inversename':'','subjecttype1':[s1],'subjecttype2':[s2], 'applicablenodetypes':'types' }
                   # if object_dic.has_key(rt):
                       # if object_dic[rt].has_key("subtypeof") :                                                                                      
                           # input['subtypeof'] = object_dic[rt]["subtypeof"]
                    if object_dic.has_key(rt) :
                        if object_dic[rt].has_key('attributes') :
                            input['language']='en'
                            tab = 0
                            for tuple in  object_dic[rt]['attributes']:
                                attype = (tuple.split('"')[0]).split(':')[1]
                                attribute = tuple.split('"')[1]
                                tuple =        (attype,attribute)
                                if tab ==  0 :
                                    input['attributes'] =     [tuple]
                                    tab = 1
                                else :
                                    input['attributes'].append(tuple)

                    print input
                    print setcon.setnode(input)
    tab = 0
    for at in  atlist.keys()   :
        if at in ['firstname','lastname','username','username','password','email','mandatoryflds','content','listdatatype','title','description']:
            pass
        else :
            subjectlist       = atlist[at]
            slist = []
            for s in subjectlist :
                s = s.strip(":")
                slist.append(s)
            input = {'nodetype':'attributetype','nid': at ,'status':'Public','inversename':'','subjecttypes':[slist],'applicablenodetypes':'types'  }
            #if object_dic.has_key(rt):
                   #if object_dic[at].has_key("subtypeof") :                                                                                        
                    #    input['subtypeof'] = object_dic[at]["subtypeof"]
            if object_dic.has_key(at) : 
                if object_dic[at].has_key('attributes') :
                    input['language']='en'
                    tab = 0
                    for tuple in  object_dic[at]['attributes']:
                        attype = (tuple.split('"')[0]).split(':')[1]
                        attribute = tuple.split('"')[1]
                        tuple =        (attype,attribute)
                        if tab ==  0 :
                           input['attributes'] =     [tuple]
                           tab = 1
                        else :
                           input['attributes'].append(tuple)

            print input
            print setcon.setnode(input)

######################################################################################################################################################
    for nid in object_dic.keys()  :   
        tab = 0 
        input={  'nid':nid , 'status':'public', 'language':'english'}
        if nid in otlist or nid in  rtlist.keys() or nid in  atlist.keys() or nid in  flist :
            pass
        else :
                input={ 'nodetype' : 'object'  ,'nid': nid ,  'status':'public', 'language':'english'}
                print nid
                superlist = object_dic[nid]['instanceof']
                for st in superlist :
                    supertype = setcon.getlatestssids([st],'nid')[st]
                    input['instanceof'] =  [supertype]
                if object_dic[nid].has_key('attributes') :
                    tab = 0
                    for tuple in  object_dic[nid]['attributes']:
                        attype = (tuple.split('"')[0]).split(':')[1]
                        attribute = tuple.split('"')[1]
                        tuple =        (attype,attribute)
                        if tab ==  0 :
                           input['attributes'] =      [tuple]
                           tab = 1 
                        else :
                           input['attributes'].append(tuple)
                print input
                print setcon.setnode(input)
    

    
    for    nid in  object_dic.keys():
        rt_dic =  object_dic[nid]
        for key in rt_dic.keys() :
                if key=="instanceof" or   key=="attributes" :
                    continue
                else :
                    input = {'status':'public','relationtypes':key,'nodetype1_list':['gbobjects'],'set_relation':"1",'nodetype':'relation'}
                    if setcon.nidExists(nid) == 1 :
                        value = setcon.getlatestssids([nid],'nid')[nid]
                        input['subject1'] = [value]
                        s2_list = rt_dic[key]
                        for s2 in s2_list:
                            if setcon.nidExists(s2) == 1  :
                                temp  =    setcon.getlatestssids([s2],'nid')[s2]
                                input['subject2'] =    [temp]
                                print   input
                                #try :
                                print setcon.set_relation(input)
                                #except :
                                 #   continue
                            else :
                                print   s2 + "doesnt exist in database"
                                continue
                   
                    else :
                        print    nid + "doesnt exist"

"""
    
########################################################################################################################################################
"""
owl_import is used to import generic owl defined ontologies , objects and relations  into gnowsys
"""
def owl_import(url,path):
    file=open(path ,'r')
    while(1) :
          line = file.readline().rstrip("\n")
          if line.find("xml:base=") >=    0 :
              base=line.split("xml:base=\"")[1]
              base=base.split("\"")[0]
          if line.find("<owl:Ontology") >= 0 : 
              namespace=line.split("rdf:about=\"")[1]
              namespace=namespace.split("\"")[0]
          if line.find("</owl:Ontology>")    >=   0 :
              break
    if len(namespace) == 0 :
        namespace = base
    print namespace
    object_dic = {}
    otlist =      []
    otlist.append("owl#Thing")
    rtlist = {}
    atlist =  {}
    setcon=xmlrpclib.Server(url)
    #namespace="http://dbpedia.org/ontology/"
    string = "rdf:about=\"" 
    string1 = "rdf:resource=\""

    while (1):
        line = file.readline().rstrip("\n")
        if line.find("</rdf:RDF>") >=  0 :
            break
        #  owl Class is gnowsys object-type. The subClassof property is mapped to the subtypeof relation
        if line.find("owl:Class") >= 0 :
            if line.find("rdf:about=\"") < 0 :
                continue
            ot = line.split(string)[1]
            ot = ot.lstrip(namespace)
            ot = ot.rstrip("\">")
            #print "objecttype:",ot
            #print " ********* "
            object_dic[ot]  = {}
            otlist.append(ot)
            while(1):
                line = file.readline().rstrip("\n")
                if line.find("<rdfs:subClassOf")          > 0 :
                  superclass =  line.split(string1)[1]
                  superclass =  superclass.strip(namespace)
                  superclass = superclass.rstrip("\"/>")
                  if superclass.find("owl#Thing") >= 0     : 
                      superclass = "owl#Thing"
                  #print "subclassof",superclass
                  if object_dic[ot].has_key("subtypeof")    :   
                      object_dic[ot]["subtypeof"].append(superclass)
                  else :
                      object_dic[ot]["subtypeof"] = [superclass]
                if line.find("</owl:Class>")   >= 0:
                    break
            #print " ************ "
        #  owl ObjectProperty is gnowsys relation-type . The domain and range map to the applicable subject-types
        if line.find("<owl:ObjectProperty") >= 0 :
            relation = line.split(string)[1]
            relation = relation.split(namespace)[1]
            relation = relation.rstrip("\">")
            #print "relationtype:",relation
            if rtlist.has_key(relation):
                    pass
            else :
                    rtlist[relation] =  {}
                    subject1_list = []
                    subject2_list = []
                    superclass_list = []                    
                    object_dic[relation] =    {}
            while(1):
                    line = file.readline().rstrip("\n")
                    if line.find("rdfs:subPropertyOf")     >= 0 :
                        superclass = line.split(string1)[1]
                        superclass =  superclass.strip(namespace)
                        superclass = superclass.rstrip("\"/>")
                        #print "subclassof",superclass
                        if object_dic[relation].has_key("subtypeof")    : 
                            object_dic[relation]["subtypeof"].append(superclass)
                        else :
                            object_dic[relation]["subtypeof"] = [superclass]
                    if line.find("<rdfs:domain")    >=  0 :
                         if line.find("rdf:resource=") < 0 :
                              line = file.readline().rstrip("\n")
                              line = file.readline().rstrip("\n")
                              while(1) :
                                   line = file.readline().rstrip("\n")
                                   if line.find("</owl:unionOf>") >= 0    :   
                                       line = file.readline().rstrip("\n")
                                       break
                                   else :
                                       subject1 =  line.split(string)[1]
                                       subject1 =  subject1.lstrip(namespace)
                                       subject1 = subject1.rstrip("\"/>")
                                       if subject1.find("owl#Thing") >= 0     :
                                             subject1  = "owl#Thing"
                                       subject1_list.append(subject1)
                         else :
                             subject1 =  line.split(string1)[1]                                                                          
                             subject1 =  subject1.lstrip(namespace)
                             subject1 = subject1.rstrip("\"/>")
                             if subject1.find("owl#Thing") >= 0     :
                                 subject1  = "owl#Thing"
                             subject1_list.append(subject1)
                    if line.find("<rdfs:range")     >=    0     : 
                        if line.find("rdf:resource=") < 0 :
                              line = file.readline().rstrip("\n")
                              line = file.readline().rstrip("\n")
                              while(1) :
                                   line = file.readline().rstrip("\n")
                                   if line.find("</owl:unionOf>")   >= 0 :
                                       line = file.readline().rstrip("\n")
                                       break
                                   else :
                                       subject2  =  line.split(string)[1]
                                       subject2 =  subject2.lstrip(namespace)
                                       subject2 = subject2.rstrip("\"/>")
                                       if subject2.find("owl#Thing") >= 0     :
                                           subject2  = "owl#Thing"
                                       subject2_list.append(subject2)
                        else : 
                            subject2 =  line.split(string1)[1]
                            subject2 =  subject2.lstrip(namespace)
                            subject2 = subject2.rstrip("\"/>")
                            if  subject2.find("owl#Thing") >= 0     :
                                        subject2      = "owl#Thing"
                            subject2_list.append(subject2)
                    if line.find("</owl:ObjectProperty>") >=  0:
                        break        
            rtlist[relation]['subject1'] = subject1_list
            rtlist[relation]['subject2'] = subject2_list
            if len(superclass_list) > 0    :   
                rtlist[relation]['subtypeof'] = superclass_list
            #print "************** "
            #print "subject1:" , subject1_list
            #print "subject2:" , subject2_list
            #print "*************** "
        # owl DatatypeProperty is gnowsys attribute-type . The domain is the applicable subjects and the range is the datatype
        if line.find("<owl:DatatypeProperty")   >=   0   :
            attribute = line.split(string)[1]
            attribute = attribute.split(namespace)[1]
            attribute = attribute.rstrip("\">")
            #print "attributetype:" , attribute
            if atlist.has_key(attribute):
                pass
            else :
                atlist[attribute] =  {}
                subject_list = []
                datatype = ''
                superclass_list = []
                object_dic[attribute] = {}
            while(1):
                line =  file.readline().rstrip("\n")
                if line.find("rdfs:subPropertyOf")     >= 0 :
                        superclass = line.split(string1)[1]
                        superclass =  superclass.strip(namespace)
                        superclass = superclass.rstrip("\"/>")
                        #print "subclassof",superclass
                        if object_dic[at].has_key("subtypeof")    : 
                            object_dic[at]["subtypeof"].append(superclass)
                        else :
                            object_dic[at]["subtypeof"] = [superclass]
                if line.find("<rdfs:domain") >= 0 :
                    if line.find("rdf:resource=") < 0 :
                        line = file.readline().rstrip("\n")
                        line = file.readline().rstrip("\n")
                        while(1) :
                            line = file.readline().rstrip("\n")
                            if line.find("</owl:unionOf>")  >= 0     :
                                line = file.readline().rstrip("\n")
                                break
                            else :
                                subject =  line.split(string)[1]
                                subject =   subject.lstrip(namespace)
                                subject = subject.rstrip("\"/>")
                                if subject.find("owl#Thing") >= 0     :
                                     subject  = "owl#Thing"
                                subject_list.append(subject)
                    else :
                        subject =  line.split(string1)[1]
                        subject =  subject.lstrip(namespace)
                        subject = subject.rstrip("\"/>")
                        subject_list.append(subject)
                if line.find("<rdfs:range")  >=  0 :
                      if line.find("rdf:resource=") < 0 :
                        pass
                      else : 
                          datatype  =  line.split(string1)[1]
                          datatype =  datatype.lstrip("http://www.w3.org/2001/XMLSchema#")
                          datatype =  datatype.rstrip("\"/>")
                if line.find("</owl:DatatypeProperty>")  >= 0 :
                    break
            atlist[attribute]['subject'] =  subject_list
            atlist[attribute]['datatype'] =  datatype
            if len(superclass_list) > 0 :
                atlist[attribute]['subtypeof'] = superclass_list
            #print "subject:"  , subject_list
            #print "datatype:" , datatype
    
        #print "otlist:" , otlist , "\n"
        #print "atlist:" , atlist , "\n"
        #print "rtlist:" , rtlist , "\n"
        #print "object_dic:",object_dic
        
        else :
            if line.find("<")    >=    0 :
                if line.endswith('/>'):
                    parts =  line.split("rdf:ID=\"")
                    subject       =  parts[1].split("\"")[0]
                    ot = parts[0].rstrip(" ")
                    ot = ot.split("<")[1]
                    object_dic[subject] = {}
                    object_dic[subject]['instanceof'] =     ot
                    #print "subject:" , subject , "class:"    ,   ot
                elif line.find("rdf:ID=\"") >= 0 :
                    parts =   line.split("rdf:ID=\"")
                    subject       =  parts[1].split("\"")[0]
                    ot = parts[0].rstrip(" ")
                    ot = ot.split("<")[1]
                    object_dic[subject] = {}
                    object_dic[subject]['instanceof'] =     ot   
                    #print "subject:" , subject , "class:"    ,   ot
                    while(1):
                         line =  file.readline().rstrip("\n")
                         if line.find("</" + ot) >= 0   :
                             #print " end  of assertions " 
                             break
                         if line.find("rdf:resource") >= 0:
                             line = line.split("<")[1]
                             parts = line.split(string1)
                             object = parts[1].strip("\"")
                             object = object.split("\"")[0]
                             predicate = parts[0].rstrip(" ")
                             #print "predicate:" , predicate , "object:" , object
                             if object_dic[subject].has_key(predicate):
                                 object_dic[subject][predicate].append(object)
                             else :
                                 object_dic[subject][predicate] = [object] 
   
                         if line.find("rdf:datatype") >= 0 :
                             value    = line.split(">")[1]
                             value =  value.split("<")[0]
                             at = (line.split("rdf:datatype")[0]).rstrip(" ")
                             at = at.split("<")[1]
                             att  =  at+"\""+value+"\""
                             #print "attribute:" ,  att
                             if object_dic[subject].has_key("attributes"):
                                 object_dic[subject]["attributes"].append(att)
                             else :
                                 object_dic[subject]["attributes"]=[att]
                         
        # object_dic = {"perl.h" :    {"subtypeof " : ["header"] } , {"dependson" :"stdio.h"} }
#######################################################################################################################################################
      
    #for key in object_dic :  
            #print key
            #print object_dic[key]    
                                 
    
    
    print " adding the types "

    tab = 0
    for ot in otlist :
        if ot in ['gblist']:
            pass
        else :
            input =    { 'nodetype':'objecttype','nid':ot ,  'status':'public' }
            #print input
            print setcon.setnode(input)
        
    tab = 0        
    for rt in rtlist.keys() :
            if rt == "subtypeof" or rt == "instanceof":
                pass
            else : 
                subjectlist1 = rtlist[rt]['subject1']
                subjectlist2 = rtlist[rt]['subject2']
                input = {'nodetype':'relationtype','nid': rt,'status':'Public','inversename':'','subjecttype1':subjectlist1,'subjecttype2':subjectlist2, 'applicablenodetypes':'types'  }                                                                                    
             
       
                #if rtlist[rt].has_key("subtypeof"):
                #        input['subtypeof'] =    rtlist[rt]["subtypeof"]
                #print input
                print setcon.setnode(input)
    tab = 0
    for at in  atlist.keys()   :
        if at in ['firstname','lastname','username','username','password','email','mandatoryflds','content','listdatatype','title','description']:
            pass
        else :
            subjectlist =  atlist[at]['subject']
            datatype = atlist[at]['datatype']
            print datatype
            if datatype == "integer" :
                   datatype   = "int"
            elif datatype == "float"  :
                datatype =  "float"
            else :
                datatype = "text[]"
            input = {'nodetype':'attributetype','nid': at ,'status':'Public','inversename':'','subjecttypes':subjectlist,'applicablenodetypes':'types','datatype':datatype, 'restrictiontype':1,  }
            #if atlist[at].has_key("subtypeof") :                                                                                        
             #       input['subtypeof'] = atlist[at]["subtypeof"]
            
            #print input
            print setcon.setnode(input)

######################################################################################################################################################




    print "   adding objects "

    for nid in object_dic.keys()  :   
        tab = 0 
        input={  'nid':nid , 'status':'public', 'language':'english'}
        if nid in otlist or nid in  rtlist.keys() or nid in  atlist.keys()   :
            pass
        else :
                input={ 'nodetype' : 'object'  ,'nid': nid ,  'status':'public', 'language':'english'}
                ot  = object_dic[nid]['instanceof']
                s  = setcon.getlatestssids([ot],'nid')[ot]
                input['instanceof'] =     [s]
                try  :   
                 if object_dic[nid].has_key('attributes') :
                    tab = 0
                    for tuple in  object_dic[nid]['attributes']:
                        attype = (tuple.split('"')[0])
                        attribute = tuple.split('"')[1]
                        #print  atlist[attype]
                        print   attype
                        value = setcon.getlatestssids([attype],'nid')[attype]
                        datatype =       (setcon.getDatatype([value]).values())[0]
                        print datatype
                        if datatype=='int' :
                            attribute = int(attribute)
                        if datatype=='float' :
                            
                            attribute = float(attribute)
                        tuple =         (attype,attribute)
                        if tab ==  0 :
                           input['attributes'] =      [tuple]
                           tab = 1 
                        else :
                           input['attributes'].append(tuple)
                except  :
                      print sys.exc_info()[0]

                print input
                print setcon.setnode(input)
    
    

    
    print     " adding the relations "
    for    nid in  object_dic.keys() :
        rt_dic =  object_dic[nid]
        #print nid ,     rt_dic
        for key in rt_dic.keys() :
                if key=="instanceof" or   key=="attributes" :
                    continue
                else :
                    input = {'status':'public','relationtypes':key,'nodetype1_list':['gbobjects'],'set_relation':"1",'nodetype':'relation'}
                    if  setcon.nidExists(nid) == 1  :  
                        value = setcon.getlatestssids([nid],'nid')[nid]
                        input['subject1'] = [value]
                        nodettype  = setcon.getNodetype(value)
                        input['nodetype1_list'] = [nodettype]
                        s2_list = rt_dic[key]
                        try :
                            temp  =    setcon.getlatestssids(s2_list,'nid').values()
                            #print  nid    , " " , s2_list
                            input['subject2'] =        temp
                            print   input
                            try :
                                       print setcon.set_relation(input)
                            except :
                                    print "error in setting relation "
                                
                        except :
                             print "one of the subject2 nids doesnt exist "

                    else :
                        print    nid + "doesnt exist"
                        


                    
    print    " there are a total of : " + str(setcon.triplesKB()) + "triples"
       




#constring="dbname=dbpedia2  user=shaswat password=shaswat host=localhost"
#n3_import('http://admin:admin@localhost:8080/rdf-site/gnowql',"/usr/local/Plone/zeocluster/parts/client1/var/GB/gnowsys/Data/n3/","atlas","file","generic")
#n3_export(constring,"/usr/local/Plone/zeocluster/parts/client1/var/GB/gnowsys/Data/","dbpedia")
#n3_nbh("perl.h","harvest.rdf")
#owl_import('http://admin:shaswat@localhost:8080/rdf-site/gnowql','/home/shaswat/Desktop/dbpedia-ontology.owl')
#owl_import('http://admin:shaswat@localhost:8080/rdf-site/gnowql','/home/shaswat/Desktop/db_triples.rdf')
#rdf_import('http://admin:admin@158.144.42.67:8080/dbpedia/gnowql',"/home/shaswat/Desktop/db_triples.rdf","","file","owl")    
#rdf_import('http://admin:shaswat@localhost:8080/rdf-site/gnowql',"/usr/local/Plone/zeocluster/parts/client1/var/GB/gnowsys/Data/n3/dbpedia.txt","","file","gnowsys")









############################################################################################################################################################
