# -*- coding: utf-8 -*- 
#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################


__author__ = """Rajiv Nair <rajivnair@gnu.org>"""
__author__ = """Jay Mehta <jay87.mehta@gmail.com>"""
__docformat__ = 'plaintext'


from GeneralMethods import *
from Object import *
import psycopg2
import cPickle
from base64 import b64encode, b64decode


def decide( self, nodetype1, nodetype2, applicablenodetypes1, applicablenodetypes2):
      """
      """

      l = []
      nodetypes = ['gbobjecttypes','gbrelationtypes','gbattributetypes','gbfunctions','gbprocesstypes']

      if nodetype1 == 'gbmetatypes' and nodetype2 in nodetypes:
            if applicablenodetypes1=='tokens' and applicablenodetypes2=='types':
                  l.append('metatypes')
                  l.append('types')
      if nodetype1 in nodetypes and nodetype2 == 'gbmetatypes':
            if applicablenodetypes1=='types' and applicablenodetypes2=='tokens':
                  l.append('types')
                  l.append('metatypes')
      if nodetype1 == 'gbmetatypes' and nodetype2 == 'gbmetatypes':
                  l.append('metatypes')
                  l.append('metatypes')
      if nodetype1 in nodetypes and nodetype2 in nodetypes:
                  l.append(applicablenodetypes1)
                  l.append(applicablenodetypes2)
      
      return l      
            

def setRelationType(self , dictionary ,uid):


                  """
                  The following combination of applicablenodetypes is possible
                  1) types-types(T-T)
                  2) tokens-tokens(t-t)
                  3) metatypes-metatypes(M-M)
                  4) types-tokens(T-t)
                  5) metatypes-types(M-T)
                  6) tokens-types(t-T)
                  7) types-metatypes(T-M)

                  T-T: indicates relation is possible between types(subtypes) only.(subtypes,subtypes)
                  t-t: indicates relation is possible between tokens only. (instances,instances)
                  M-M: indicates relation is possible between types(instances). (instances,instances)
                  t-T: indicates relation is possible between a token(instances) and a type(subtypes). (instances,subtypes)(subtypes,instances)
                  T-M: indicates relation is possible between a type(subtypes) and a metatype(instances) (subtypes,instances)(instances,subtypes)

                  EXAMPLE OF THE DICTIONARY PASSED :
                  
                  dictionary = 
                  {
                  'nodetype':'relationtype'
                  'nid':'haspart', [mandatory field]
                  'uid':'1', [mandatory field]
                  'status':'Public',
                  'inversename':'ispartof', [mandatory field]
                  'subjecttype1':[nidsofrole1],  (list of ssids of types) [mandatory field]
                  'subjecttype2':[nidsofrole2],  (list of ssids of types) [mandatory field]
                  'mandatoryprops':['subject1','subject2','relationtypes'],
                  'applicablenodtypes1':'types',
                  'applicablenodtypes2':'types',
                  }
                  
                  

                  CHECKS :

                  1) Checking the mandatory fields : nodetype,nid,uid,inversename,subjecttype1,subjecttype2.
                  2) Check if nid,uid,subjecttype1 and subjecttype2 exist in the gnowledge base.
                  3) Check if subjecttype1 and subjecttype2 are types since a relationtype cannot be made between two tokens,
                  Following are the types : 
                  -gbmetatypes
                  -gbproccesstypes
                  -gbusertypes
                  -gbobjecttypes
                  -gbattributetypes
                  -gbrelationtypes.


                  STEPS : 

                  1)

                  1.1. Creating a dictionary with inid as the key and their corresponding nodetypes as the values.
                  1.2. The inids are the subjecttypes passed by the user
                  1.3. For example : Converting the list of tuples [(11L,'gbobjecttypes'),(12L,'gbobjecttypes')]  to a dictionary {'11': 'gbobjecttypes', '12': 'gbobjecttypes'}
                  1.4. The dictionary is stored in the variable inid_nodetype_dict.

                  
                  2)

                  2.1. Creating a unique combination of values from the subjecttype1 list and subjecttype2 list passed by the user
                  2.2. For example : 
                       subjecttype1 : ['11','12']
                       subjecttype2 : ['11','12']
                       The unique combination would be [['11','11'],['12','12'],['11','12']]
                  
                  3)
                  3.1. Inserting the values in gbroletypes table depending on the applicable nodetypes passed by the user
                  3.2. If the applicablenodetypes is not provided the applicablenodetypes1 and the applicablenodetypes2 field is 
                       kept None

                       
                  4)
                  4.1. Generating an ssid for the relationtype and inserting it in the gbrelationtypes table.
                  4.2. Insert the nid, ssid, inid and nodetype in the gbnidssid table.
                  4.3. Update the table gbnid_latestssid with the ssid of the relationtype generated and its nid.


                  5)
                  5.1. Calculate the roletypes field using the gbroletypes table.
                  5.2. update the nbh field of the relationtype by adding a key roletypes to its dictionary and uodate its value.

                  
                  """

                  # IMPLEMENTING CHECK 1

                  mandatory_fields = ['nid','inversename','subjecttype1','subjecttype2']
                  supplied_fields = dictionary.keys()
                  
                  for field in mandatory_fields:
                        if (field not in supplied_fields) :
                              message = field + ' IS MANDATORY [MANDATORYFIELDS : nid,inversename,subjecttype1,subjecttype2] '
                              return message 

                  subjecttype1 = dictionary['subjecttype1']
                  subjecttype2 = dictionary['subjecttype2']


                  nid = dictionary['nid']
                  nidexists = 0        


                  try:
                        decision = dictionary['decision']
                  except:
                        decision = 0

                  
                  if (id_exists('nid',nid,'gbnidssid',self.curs) == 1) :
                        if  (decision == 1):
                              nidexists = 1
                        elif (decision == 0):
                              return 'A relationtype with the same nid already exists. Please give a different nid'
                  else:      
                        nidexists = 0
                  

                  if subjecttype1 <> []:
                        subjecttype1 = get_inid_from_nid( subjecttype1 ,self.curs)
                  else:
                        return 'SUBJECTTYPE1 LIST IS BLANK'

                  if subjecttype2 <> []:
                        subjecttype2 = get_inid_from_nid( subjecttype2 ,self.curs)
                  else:
                        return 'SUBJECTTYPE2 LIST IS BLANK'

                  dictionary.update({'subjecttype1':subjecttype1})
                  dictionary.update({'subjecttype2':subjecttype2})
                  

                  
                  if 'status' not in supplied_fields:
                        status = 'Public'
                  else: 
                        status = dictionary['status']

                  
                  noofchanges=3
                  fieldschanged="{status,roletypes,inversename}"
                  changetype="{1,1,1}"
                  noofcommits=0
                  noofchangesaftercommit=0
                  history="{0}"
                  rendered_nbh={}
                  nbh={}

                  new_subject1_ssid = 0

                  flag_inherit = 0
                  inherit_s2_list=[]

                  if nidexists == 0:
                        new_subject1_ssid = get_next_sequence_value('ssid_seq',self.curs)#new ssid of the relationtype 
                        new_subject1_ssid_list = [ new_subject1_ssid ]
                  else:
                        query = "SELECT inid from gbrelationtypes where nid = '%s';" %(nid)
                        execute_query( query , self.curs )
                        new_subject1_ssid = str(query_fetchall( self.curs )[0][0])
                        new_subject1_ssid_list = [ new_subject1_ssid ]

                  supertypeof_inid_list = []
                  classof_inid_list = []
                
                  subjecttype1_list = dictionary['subjecttype1']
                  subjecttype2_list = dictionary['subjecttype2']

                  set_subjecttype1 = set( subjecttype1_list )
                  set_subjecttype2 = set( subjecttype2_list )
                  combined_subjecttypes = list( set_subjecttype1.union( set_subjecttype2 ) )
                  
                  combined_subjecttypes_string = list2string( combined_subjecttypes )
                  
                  
                  # IMPLEMENTING CHECK 2

                  sqlquery = "select ssid,nodetype from %s where ssid in %s;" %( 'gbnidssid' , combined_subjecttypes_string )
                  execute_query( sqlquery , self.curs )
                  fetched_value = query_fetchall( self.curs )
                  #return [fetched_value,combined_subjecttypes]
                  if fetched_value != None :
                        if len( fetched_value ) != len( combined_subjecttypes ):
                              return ' PLEASE ENTER VALID SUBJECTTYPES , SOME OF THE SUBJECTTYPES YOU PROVIDED DONT SEEM TO EXIST IN THE GNOWLEDGE BASE'
                  else:
                        return ' PLEASE ENTER VALID SUBJECTTYPES , THE SUBJECTTYPES YOU PROVIDED DONT SEEM TO EXIST IN THE GNOWLEDGE BASE '
                  

                  # IMPLEMENTING CHECK 3
                  
                  for inid_nodetype in fetched_value : 
                        #if not inid_nodetype[1].endswith( 'types' ) : 
                        if not istype(inid_nodetype[1]): 
                              return ' IT IS MANDATORY FOR THE SUBJECTTYPES PROVIDED TO BE TYPES AND NOT TOKENS '
                           

                  # IMPLEMENTING STEP 1                  

                  inid_nodetype_dict = {}
                  for inid_nodetype in fetched_value : 
                        inid_nodetype_dict[ str(inid_nodetype[0]) ] =  inid_nodetype[1]


                  # IMPLEMENTING STEP 2                  
                  
                  unique_combination = []
                  for subjecttype1 in subjecttype1_list : 
                        for subjecttype2 in subjecttype2_list : 
                              combination = [ str(subjecttype1) , str(subjecttype2) ]
                              inversecombination = [ str(subjecttype2) , str(subjecttype1) ]
                              """
                              if ( combination not in unique_combination  ) and ( inversecombination not in unique_combination ) : 
                                    unique_combination.append( combination )
                              """      
                              if ( combination not in unique_combination  ): 
                                    unique_combination.append( combination )

                  
                  sql_nextsequencertid = 'select max(rtid) from gbroletypes;'
                  execute_query( sql_nextsequencertid , self.curs )            
                  next_sequence_rtid = query_fetchall( self.curs )[0][0] + 1
                  
                  
                  
                  # IMPLEMENTING STEP 3                  
                  applicablenodetypes1 = 'tokens'
                  applicablenodetypes2 = 'tokens'

                  if dictionary.has_key('applicablenodetypes1') and dictionary.has_key('applicablenodetypes2'):
                        applicablenodetypes1 = dictionary['applicablenodetypes1']
                        applicablenodetypes2 = dictionary['applicablenodetypes2']
                  elif dictionary.has_key('applicablenodetypes'):
                        applicablenodetypes1 = dictionary['applicablenodetypes']
                        applicablenodetypes2 = dictionary['applicablenodetypes']
                        
                  

                        
                  finalquerystring = ''
                  
                  sql_query_insert_roletypes = "insert into gbroletypes (rtid,subjecttype1,subjecttype2,cardinality1,cardinality2,applicablenodetypes1,applicablenodetypes2) values "
                  for combination in unique_combination : 
                        subjecttype1 = str( inid_nodetype_dict[combination[0]] )
                        subjecttype2 = str( inid_nodetype_dict[combination[1]] )
                        applicableto = decide( self, subjecttype1,subjecttype2 , applicablenodetypes1, applicablenodetypes2 )
                        try:
                              querystring = "("+ str(next_sequence_rtid + unique_combination.index(combination))+","+combination[0]+","+combination[1]+","+"1"+","+"1"+",'"+applicableto[0]+"','"+applicableto[1]+"')"
                        except:
                              applicableto = ['types','metatypes']
                              querystring = "("+ str(next_sequence_rtid + unique_combination.index(combination))+","+combination[0]+","+combination[1]+","+"1"+","+"1"+",'"+applicableto[0]+"','"+applicableto[1]+"')"
                              
                        if unique_combination.index(combination) != len(unique_combination) - 1:
                              finalquerystring = finalquerystring + querystring + ',' 
                        else:
                              finalquerystring = finalquerystring + querystring
                        totalstring =  sql_query_insert_roletypes + finalquerystring      
                  
                  execute_query( totalstring , self.curs )            
                        
                  
                  input = dictionary
                  if input.has_key('subtypeof'):
                        subtypeof=input['subtypeof']#subtypeof=['23','43','63']
                        if ssid_exists(subtypeof,"gbrelationtypes" ,self.curs)==0:
                              return "invalid subtypeof ssids"
                        else:
                              subtypeof_relnobj=relations( self.constring , uid )
                        relninput={'uid':uid,'status':input['status'],'relationtypes':'subtypeof','subject1':new_subject1_ssid_list,'subject2':input['subtypeof'],'nodetype1_list':['gbrelationtypes']}  
                        supertypeof_inid_list = get_inid_from_ssid(relninput['subject2'],self.curs)                   
                        dic_from_Reln=subtypeof_relnobj.startchecks_n_callwrite(relninput,"3",new_subject1_ssid_list,relninput['subject2'],supertypeof_inid_list,0,0,0)
                        if dic_from_Reln==-1:
                              return -1

                        flag_inherit = 1
                        inherit_s2_list = inherit_s2_list + input['subtypeof']
                        
                        subtypeof_relnssid_list=dic_from_Reln['subj1ssid_relnssidlist_dic'].values()[0]#all subtypeof relnssids.
                        if subtypeof_relnssid_list==-1:
                              return  "Problem occured while creating subtypeof relations."
                        else:
                              noofchanges=noofchanges+1
                              fieldschanged=fieldschanged.rstrip("}")+",subtypeof}"
                              changetype=changetype.rstrip("}")+",1}"
                              nbh['relations']=subtypeof_relnssid_list
                              rendered_nbh['relations']={}
                              rendered_nbh['relations']['subtypeof']={}
                              rendered_nbh['relations']['subtypeof']['rightroles']=relninput['subject2']

                              
                  if input.has_key('instanceof'):
                        instanceof=input['instanceof']#      'instanceof':['245','45','26'],
                        if ssid_exists(instanceof,"gbmetatypes" ,self.curs)==0:
                              print "invalid instanceof ssids"
                              return -1
                        else:
                              instanceof_relnobj=relations( self.constring , uid)
                              relninput={'uid':uid,'status':input['status'],'relationtypes':'instanceof','subject1':new_subject1_ssid_list,'subject2':input['instanceof'],'nodetype1_list':['gbrelationtypes']}
                              classof_inid_list = get_inid_from_ssid(relninput['subject2'],self.curs)                       
                              dic_from_Reln=instanceof_relnobj.startchecks_n_callwrite(relninput,"2",new_subject1_ssid_list,relninput['subject2'],classof_inid_list,0,0)
                              if dic_from_Reln==-1:
                                    return -1

                              flag_inherit = 1
                              inherit_s2_list = inherit_s2_list + input['instanceof']
                              
                              instanceof_relnssid_list=dic_from_Reln['subj1ssid_relnssidlist_dic'].values()[0]# =all instanceof reln ssids
                              if instanceof_relnssid_list==-1:
                                    return  "Problem occured while creating instanceof relations." 
                              else:
                                    noofchanges=noofchanges+1
                                    fieldschanged=fieldschanged.rstrip("}")+",instanceof}"
                                    changetype=changetype.rstrip("}")+",1}"
                                    if rendered_nbh.has_key('relations'):
                                          pass
                                    else:
                                          nbh['relations']=[]
                                          rendered_nbh['relations']={}
                                    rendered_nbh['relations']['instanceof']={}
                                    rendered_nbh['relations']['instanceof']['rightroles']=relninput['subject2']
                                    for reln_ssid in instanceof_relnssid_list:
                                          nbh['relations'].append(reln_ssid)
                                          
                  
                  

                  if input.has_key('attributes'):
                        gbattr_input={'nid':input['nid'],'uid':uid,'status':status,'instanceof':input['attributes'],'subject':new_subject1_ssid,'subject_inid':new_subject1_ssid,'language':input['language'],'nodetype':'gbrelationtypes'}

                        attrobj=attribute( self.constring , uid)

                        new_attr_ssid_list=[]
                        for no_of_attrs in range(len(input['attributes'])):
                              new_attr_ssid_list.append(get_next_sequence_value('ssid_seq',attrobj.curs))

                        attrtype_nid_attrvalue_list = attrobj.create_newattr(gbattr_input,new_subject1_ssid_list[0],classof_inid_list,supertypeof_inid_list,1,0)
                        if attrtype_nid_attrvalue_list==-1:
                              return " Problem occured while creating attribute for this object."
                        else:
                              attrtype_nid_list =attrtype_nid_attrvalue_list [0]
                              attrvalue_list=attrtype_nid_attrvalue_list[1]
                              fieldschanged=fieldschanged.rstrip("}")
                              changetype=changetype.rstrip("}")
                              for attrtypenids in attrtype_nid_list:
                                    noofchanges=noofchanges+1
                                    fieldschanged=fieldschanged+","+attrtypenids
                                    changetype=changetype+ ",1"
                              fieldschanged=fieldschanged+"}"                           
                              changetype=changetype+ "}"
                              nbh['attribute']=new_attr_ssid_list
                              rendered_nbh['attributes']={}
                              for no_of_attr in range(len(attrtype_nid_list)):
                                  rendered_nbh['attributes'] [attrtype_nid_list[no_of_attr]] = (new_attr_ssid_list[no_of_attr],attrvalue_list[no_of_attr]) 

                  # IMPLEMENTING STEP 4                        


                  inversename = dictionary['inversename']
                  generatedroletypes_id_list = []
                  for i in range(len( unique_combination )):
                              generatedroletypes_id_list.append( str(next_sequence_rtid + i) )

                  if nidexists == 0:
                        rendered_nbh['roletypes'] =  generatedroletypes_id_list
                        rendered_nbh['inversename'] =  inversename
                  else:
                        getall_query = "SELECT rendered_nbh from %s where ssid = %s" %('gbrelationtypes' , new_subject1_ssid)
                        self.curs.execute( getall_query )
                        values  = self.curs.fetchall()[0]
                        rendered_nbh = cPickle.loads(  b64decode( values[0] ) )
                        rendered_nbh['roletypes'] = rendered_nbh['roletypes'] + generatedroletypes_id_list
                        update_query = "UPDATE %s set rendered_nbh='%s' where ssid = %s;" %('gbrelationtypes' , b64encode( cPickle.dumps(rendered_nbh) )  , new_subject1_ssid )
                        self.curs.execute( update_query )

                  finalquerystring = ''
                  current_seq_relationtypes = ''


                  if nidexists == 0:
                        #  inheritance logic ---start
                        if flag_inherit == 1:
                              from Inherit import *
                              inherit_obj = Inherit(self.constring,self.uid)
                              inherit_rendernbh_dic = inherit_obj.inherit( new_subject1_ssid_list ,new_subject1_ssid_list,'gbobjecttypes', inherit_s2_list)
                              rendered_nbh['attributetypes'] = inherit_rendernbh_dic['attributetypes']
                              rendered_nbh['relationtypes'] = inherit_rendernbh_dic['relationtypes']
                        #end----

                        insert_relationtype_query = "insert into gbrelationtypes values (%s,'%s',%s,'%s',%s,'%s',%s,'%s','%s','%s','%s','%s',now(),%s,%s,%s,'%s','%s') " %( str(new_subject1_ssid ),nid,str( new_subject1_ssid ),inversename,uid,status,noofchanges,fieldschanged,changetype,noofcommits,noofchangesaftercommit,history,'FALSE','FALSE','FALSE',b64encode( cPickle.dumps(rendered_nbh) ),b64encode( cPickle.dumps(nbh) ) )

                        current_seq_relationtypes = new_subject1_ssid


                        value_nid_vec="to_tsvector('"+str(nid)+"'::text)"
                        insert_gbnidssid_query = "insert into gbnidssid values ("+str(get_current_sequence_value('ssid_seq',self.curs))+",'"+str(nid)+"',"+str(get_current_sequence_value('ssid_seq',self.curs))+","+"'gbrelationtypes',"+value_nid_vec+");"




                        insert_gbnidlatestssid = "insert into gbnid_latestssid values ("+str(get_current_sequence_value('ssid_seq',self.curs))+",'"+nid+"');"



                  
                        execute_query( insert_relationtype_query , self.curs )            
                        execute_query( insert_gbnidssid_query , self.curs )            
                        execute_query( insert_gbnidlatestssid , self.curs )            
                  else:
                        query = "UPDATE gbrelationtypes set nbh='%s' where ssid=%s"%(b64encode( cPickle.dumps(rendered_nbh) ),new_subject1_ssid)
                        execute_query( query , self.curs )            
                        

                  currentvalue_relationtype = new_subject1_ssid
                  
      
                  query_populate_gbrelationtypes = 'insert into gbcatalogrelationtypes values '
                  for roletypeid in generatedroletypes_id_list : 
                        if generatedroletypes_id_list.index( roletypeid ) != len( generatedroletypes_id_list ) - 1:
                              finalquerystring = finalquerystring  + '('+str(currentvalue_relationtype)+','+str(roletypeid)+')' + ','
                        else:
                              finalquerystring = finalquerystring  + '('+str(currentvalue_relationtype)+','+str(roletypeid)+');'
                                    
                        
                  query_populate_gbrelationtypes = query_populate_gbrelationtypes + finalquerystring
                  execute_query( query_populate_gbrelationtypes , self.curs )            

                  
                  updateSubjectTypes ( self, inid_nodetype_dict , ['relationtypes'] , new_subject1_ssid  , uid , self.curs)

                  # IMPLEMENTING STEP 6
                  

                  commitclose( self.curs , self.conn )
                  
                  try:
                    commitclose(subtypeof_relnobj.curs,subtypeof_relnobj.conn)
                  except:
                    #print "no subtypeof given as input for objecttype"
                    pass    
                  try:
                    commitclose(instanceof_relnobj.curs,instanceof_relnobj.conn)
                  except:
                    #print "no instanceof given as input for objecttype"
                    pass  

                  return new_subject1_ssid



def updateSubjectTypes ( self , args , fieldschanged , relationtypeid , uid , curs):
      """
      The arguments are of the form:
      {'11':'gbobjecttypes','12':'gbobjecttypes}
      """

      for stid in args.keys():
           schema = get_schema( args[stid] )
           #newssid = get_next_sequence_value('ssid_seq',curs)
           snapshots_dict = {}
           getall_query = "SELECT rendered_nbh from %s where ssid = %s" %( args[stid] , stid)
           curs.execute( getall_query )
           values  = curs.fetchall()[0]
           rendered_nbh = values[0]
           
           rendernbh = {}
           if rendered_nbh != None:
               rendernbh = cPickle.loads(  b64decode( rendered_nbh ) )
               if rendernbh.has_key( fieldschanged[0] ):
                     if str(relationtypeid) not in rendernbh[fieldschanged[0]]:
                           rendernbh[fieldschanged[0]].append( str(relationtypeid) )
               else:
                  rendernbh[fieldschanged[0]] = [str(relationtypeid)]
           else:
               rendernbh[fieldschanged[0]] = [str(relationtypeid)]

           
           snapshots_dict['rendered_nbh'] =  b64encode( cPickle.dumps(rendernbh) )
           
           
           update_query = "UPDATE %s set rendered_nbh='%s' where ssid = %s;" %( args[stid] , snapshots_dict['rendered_nbh']  ,stid )
           curs.execute( update_query )



# def updateSubjectTypes ( self , args , fieldschanged , relationtypeid , uid , curs):
#       """
#       The arguments are of the form:
#       {'11':'gbobjecttypes','12':'gbobjecttypes}
#       """

#       for stid in args.keys():
#            schema = get_schema( args[stid] )
#            #newssid = get_next_sequence_value('ssid_seq',curs)
#            newssid = stid
#            snapshots_dict = {}
#            getall_query = "SELECT * from %s where ssid = %s" %( args[stid] , stid)
#            curs.execute( getall_query )
#            values  = curs.fetchall()[0]
#            snapshots_dict['nid'] = values[1]
#            snapshots_dict['inid'] = values[2]
#            snapshots_dict['uid'] = uid
#            snapshots_dict['status'] = 'public'
#            snapshots_dict['noofchanges'] = len( fieldschanged )

#            fields = values[6] + fieldschanged
#            a = "{"
#            for elem in fields:
#                  a = a + elem + ","
#            a=a.rstrip(",")+"}" 
#            snapshots_dict['fieldschanged'] = a

#            changetype = values[7] + [1L]
#            a = "{"
#            for elem in changetype:
#                  a = a + str(elem) + ","
#            a=a.rstrip(",")+"}" 
           
#            snapshots_dict['changetype'] = a

#            snapshots_dict['noofcommits'] =  values[8] + 1
#            snapshots_dict['noofchangesaftercommit'] =  values[9]

#            history = values[10] + [ long( newssid ) ]
#            a = "{"
#            for elem in history:
#                  a = a + str(elem) + ","
#            a=a.rstrip(",")+"}" 
           
#            snapshots_dict['history'] = a

#            rendernbh = cPickle.loads(  b64decode( values[schema.index('rendered_nbh')] ) )
#            if rendernbh.has_key( fieldschanged[0] ):
#                  rendernbh[fieldschanged[0]].append( str(relationtypeid) )
#            else:
#                  rendernbh[fieldschanged[0]] = [str(relationtypeid)]
                 
#            snapshots_dict['rendered_nbh'] =  b64encode( cPickle.dumps(rendernbh) )
           
#            snapshots_dict['nbh'] = values[schema.index('nbh')]

#            insert_query = "INSERT INTO %s (ssid,nid,inid,uid,status,noofchanges,fieldschanged,changetype,noofcommits,noofchangesaftercommit,history,gbtimestamp) values(%s,'%s',%s,'%s','%s',%s,'%s','%s',%s,%s,'%s',now());"%(args[stid], newssid , snapshots_dict['nid'],snapshots_dict['inid'] ,snapshots_dict['uid'],snapshots_dict['status'],snapshots_dict['noofchanges'],snapshots_dict['fieldschanged'],snapshots_dict['changetype'],snapshots_dict['noofcommits'],snapshots_dict['noofchangesaftercommit'],snapshots_dict['history'])
           
#            update_query1 = "UPDATE %s set rendered_nbh='%s' where ssid = %s;" %( args[stid] , snapshots_dict['rendered_nbh']  ,newssid )
#            curs.execute( insert_query + update_query1 )

#            try:
#                  update_query2 = "UPDATE %s set nbh='%s'  where ssid = %s;" %( args[stid] , snapshots_dict['nbh'] , newssid )
#                  curs.execute( update_query2  )
#            except:
#                  pass
           
#            bind_nidssid(newssid,snapshots_dict['nid'],snapshots_dict['inid'],args[stid],curs)
#            reset_ssid_2_latestssid(newssid,snapshots_dict['nid'],curs)
           

      
           
