# -*- coding: utf-8 -*- 
#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################

__author__ = """Jay Mehta <jay87.mehta@gmail.com>"""
__docformat__ = 'plaintext'
  

from GeneralMethods import *
from GetMethods import *
from Attribute import *
from Relation import *
import cPickle
import psycopg2
from base64 import b64encode, b64decode

class Update:

  def __init__(self , constring ,uid ):
          self.constring=constring
          self.conn = psycopg2.connect( constring )   
          self.curs = self.conn.cursor() 
          self.uid = uid

  def startchecks(self,subject_ssid):
    
      nodetype_list=get_nodetype_from_gbnidssid([subject_ssid],"ssid",self.curs)
      if nodetype_list==[]:
        #print "subject_ssid not found"
        return -1
      else:
        ##print "ssid exists"
        return nodetype_list 


  def UpdateAttribute(self,input,new_subject_ssid,old_rendernbh,obj):

      #given a subject ssid add new attributetype with its( attribute)value and update attributevalue if exists.
     
      if old_rendernbh == None:
         old_rendernbh={}
      if old_rendernbh.has_key('attributes'):
            exists_nid_value_dic = old_rendernbh['attributes']#{'attrtypenid':(attrssid,attrtypevalue) , ...}
            
            # get all attrtypenid in a list.create Attr_to_attach_list for attr to be attached and 
            # attr_to_attach_list=[(attrtypenid,attrvalue), ...]#call create_newattr() of Attribute.py
            # attr_to_update_list=[(attrtypenid,attrvalue), ...]#call create_newattr() of Attribute.py but doesnt need check--> can_subj_have_attr(). 
            # then modify the subject. i.e, create new snapshot of the subject and modify fieldschanged,nbh,rendered_nbh
      
            attr_to_update_list=[] #[(attrtypenid,attrvalue),(,)]
            attr_to_attach_list=[] #[(attrtypenid,attrvalue),(,)]

            instanceof_list = input['instanceof'] #[(attrtypenid,attrvalue),(attrtypenid,attrvalue)]
            for index in range( len( instanceof_list ) ):
                if exists_nid_value_dic.has_key( instanceof_list[index][0] ): #attrtype from input already attached to subject
                   if exists_nid_value_dic[ instanceof_list[index][0] ][1] == instanceof_list[index][1]:#the attrvale is also same.
                      ##print " skipping this input as attrtype has same attrvalue that is already attached."
                      pass
                   else:
                     ##print" diff attrvalue--------------"
                     attr_to_update_list.append( instanceof_list[index] )#different attrvalue
                else:
                   attr_to_attach_list.append( instanceof_list[index] ) #this attrtype not attached to subject         
      else:
            attr_to_update_list = [] #[(attrtypenid,attrvalue),(,)]
            attr_to_attach_list = input['instanceof']

      final_dic={}#dic to return values to Update()
      if attr_to_update_list != []:

               #Attribute update is to be done
               U_new_attr_ssid_list = []
               for no_of_attrs in range(len(attr_to_update_list)):
                   U_new_attr_ssid_list.append(get_next_sequence_value('ssid_seq',obj.curs))

               input['instanceof'] = attr_to_update_list
               input['new_attr_ssid_list'] = U_new_attr_ssid_list
               U_attrtype_nid_attrvalue_list = obj.create_newattr(input,new_subject_ssid,0,0,0,1)
            
               if U_attrtype_nid_attrvalue_list!=-1:
                  if attr_to_attach_list!=[]:  #attach and update
                     A_new_attr_ssid_list = []
                     for no_of_attrs in range(len(attr_to_attach_list)):
                         A_new_attr_ssid_list.append(get_next_sequence_value('ssid_seq',obj.curs))

                     input['instanceof'] = attr_to_attach_list 
                     input['new_attr_ssid_list'] = A_new_attr_ssid_list
                     A_attrtype_nid_attrvalue_list = obj.create_newattr(input,new_subject_ssid,0,0,1,1)
                     
                     if A_attrtype_nid_attrvalue_list!=-1:
                       
                        final_dic['A_attrtype_nid_list'] =A_attrtype_nid_attrvalue_list[0]
                        final_dic['U_attrtype_nid_list'] =U_attrtype_nid_attrvalue_list[0]
                        final_dic['attrvalue_list'] = A_attrtype_nid_attrvalue_list[1] + U_attrtype_nid_attrvalue_list[1]
                        final_dic['new_attr_ssid_list'] = U_new_attr_ssid_list + A_new_attr_ssid_list
                        return final_dic

                     else:
                        #print "Atleast One of the attribute cannot be attached. Not attaching any of the inputted attribute."
                        return -1
                     
                  else:      # only attr_to_update
                     final_dic['A_attrtype_nid_list'] = []
                     final_dic['U_attrtype_nid_list'] = U_attrtype_nid_attrvalue_list[0]
                     final_dic['attrvalue_list'] =  U_attrtype_nid_attrvalue_list[1]
                     final_dic['new_attr_ssid_list'] = U_new_attr_ssid_list
                     return final_dic
               else:
                    #print "Atleast One of the attribute cannot be Updated."
                    return -1
      elif  attr_to_attach_list !=[]:#only to attach
               A_new_attr_ssid_list = []
               for no_of_attrs in range(len(attr_to_attach_list)):
                   A_new_attr_ssid_list.append(get_next_sequence_value('ssid_seq',obj.curs))

               input['instanceof'] = attr_to_attach_list 
               input['new_attr_ssid_list'] = A_new_attr_ssid_list
               ##print "this is only to attach",input
               A_attrtype_nid_attrvalue_list = obj.create_newattr(input,new_subject_ssid,0,0,1,1)
               ##print A_attrtype_nid_attrvalue_list
               if A_attrtype_nid_attrvalue_list !=-1:   
                  final_dic['U_attrtype_nid_list'] = []
                  final_dic['A_attrtype_nid_list'] =A_attrtype_nid_attrvalue_list[0]
                  final_dic['attrvalue_list'] = A_attrtype_nid_attrvalue_list[1] 
                  final_dic['new_attr_ssid_list'] = A_new_attr_ssid_list
                  return final_dic

               else:
                 return -1
      else:
              #print "NO new Attributes value given. subject had same value as in previous snapshot "
              return 1


  def UpdateRelation(self,input,new_subject_ssid,old_rendernbh,relnobj):
      new_unknownrelation_list=[]
      final_dic={}
      final_dic['listof_relntype_nid']=[]

      #derive all relntype inid from its nid --- start
      rtypenid_string="('"
      for t in input['relation']:
          rtypenid_string = rtypenid_string+t[0]+"','"
      #rtypenid_string = rtypenid_string.rstrip(",")+")
      rtypenid_string = rtypenid_string[:-2]+")"
      sql="SELECT nid,inid FROM gbrelationtypes WHERE nid in %s;"%(rtypenid_string)
      execute_query(sql,self.curs)    
      rtype_nid_inid_list=query_fetchall(self.curs)#[(nid,inid), (), ...]
      rtype_nid_inid_dic={}
      for t in rtype_nid_inid_list:
          rtype_nid_inid_dic[ str( t[0] ) ] = str( t[1] )
      #end ---

      #checking if input['relation'] has value that are already attached -- start
      for tuple in input['relation']:
          s2inid_list=get_inid_from_ssid(tuple[1],self.curs)
          sql="select subject2 from gbrelations where subject1=%s and relationtype=%s;"                                                                                    %(input['subject_inid'],rtype_nid_inid_dic[tuple[0]])

          execute_query(sql,self.curs)
          s2_list=query_fetchall(self.curs)
          temp_s2_list=[]
          for s2tuple in s2_list:
              temp_s2_list.append(str(s2tuple[0]))

          s2inid_list_to_attach = list( set(s2inid_list) -  set(temp_s2_list) )
          if s2inid_list_to_attach != []:
             new_unknownrelation_list.append((tuple[0],s2inid_list_to_attach) )
             final_dic['listof_relntype_nid'].append(tuple[0])
      # ----- end      
      if new_unknownrelation_list==[]:           
         return 1

      listof_news2list=[]
      listof_new_relnssid_list=[]
      
      unknownrelation_list = new_unknownrelation_list # =[('reltypenid',['list of inids']),()],
      oldS2_newS2_dic = {}
      olds2ssid_inid_dic={}
      s2ssid_snapshotData_dic={}
      all_subject2_ssid_list=[]

      flag_inherit = 0
      inherit_s2_list=[]

      tupleno=0
      for tuple in unknownrelation_list:
          unknownrelation_ssid=tuple[1]
          unknown_relntype_nid=tuple[0]
          
          relninput={'uid':input['uid'],'status':input['status'],'relationtypes':unknown_relntype_nid,'subject1':[input['subject_inid']],'subject2':unknownrelation_ssid,'nodetype1_list':[input['nodetype']]}
          ##print relninput

          #generating new ssid of subject2 for each relationtypenid
          newssid_of_unknownrelation_list = []
          for s2 in relninput['subject2'] :
                            if oldS2_newS2_dic.has_key(s2):
                               newssid_of_unknownrelation_list.append( oldS2_newS2_dic[s2] )
                            else:
                               newS2 = get_next_sequence_value('ssid_seq',self.curs) 
                               newssid_of_unknownrelation_list.append( newS2 )
                               ##print "newssid createdDD====", newssid_of_unknownrelation_list
                               oldS2_newS2_dic[s2] = newS2
                               all_subject2_ssid_list.append(s2)                        
                        
          listof_news2list.append(newssid_of_unknownrelation_list )
          #print oldS2_newS2_dic   
          #here s2_inid_list is list of subject2_inid, where subject2_ssid_list is unknownrelation_ssid.     
          s2_inid_list = get_inid_from_ssid(relninput['subject2'],relnobj.curs)
          for s2indexno in range(len(s2_inid_list)):
              olds2ssid_inid_dic[relninput['subject2'][s2indexno]] = s2_inid_list[s2indexno]

          #print"(((((((INPUT=",relninput
          relntype_inid = rtype_nid_inid_dic [tuple[0]]
          dic_from_Reln = relnobj.startchecks_n_callwrite(relninput,relntype_inid,[new_subject_ssid],newssid_of_unknownrelation_list,s2_inid_list,0,0,0)

          if dic_from_Reln==-1:
               return"Cant create RELATION. CONDITIONS NOT SATISFIED."

          if dic_from_Reln['flag_inherit'] == 1:
                  flag_inherit = 1
                  inherit_s2_list = inherit_s2_list + newssid_of_unknownrelation_list

          unknownrelation_ssid_list = dic_from_Reln['subj1ssid_relnssidlist_dic'].values()[0]# =all new  unknonwn reln ssids
          subj2_snapshot_dic_fromReln = dic_from_Reln['subj2_snapshot_dic']
          if unknownrelation_ssid_list==-1:
               #print " Problem occured while creating (other /unknown) relations."
               return -1

          listof_new_relnssid_list.append( unknownrelation_ssid_list )                          
          #collect data for writing new snapshot of subject2       
          for s2index in range(len(newssid_of_unknownrelation_list)):
            s2ssid = newssid_of_unknownrelation_list[s2index]
            if s2ssid_snapshotData_dic.has_key(s2ssid): 
               snapshotDataDic = s2ssid_snapshotData_dic[s2ssid]
               snapshotDataDic['relntype_nid_list'].append( relninput['relationtypes'] )
               snapshotDataDic['relnssid'].append( subj2_snapshot_dic_fromReln['newRelnssidList_4_subj2List'][s2index] )
               s2ssid_snapshotData_dic[s2ssid] = snapshotDataDic
            else:
               snapshotDataDic={}
               snapshotDataDic['relntype_nid_list'] = [relninput['relationtypes']]
               snapshotDataDic['nodetype'] = subj2_snapshot_dic_fromReln['nodetype2_list'][s2index]
               snapshotDataDic['relnssid'] = [subj2_snapshot_dic_fromReln['newRelnssidList_4_subj2List'][s2index]]
               s2ssid_snapshotData_dic[s2ssid] = snapshotDataDic
          #end of colecting data
          tupleno=tupleno+1

      #start creating new snapshot for each subject2-------
      #print "oldS2_newS2_dic   ",oldS2_newS2_dic   
      for oldS2ssid in oldS2_newS2_dic :
          s2ssid = oldS2_newS2_dic [oldS2ssid]
          snapshotDataDic = s2ssid_snapshotData_dic[s2ssid]
          #print "key--",s2ssid
          #print snapshotDataDic
          #R_newsnapshot(snapshotDataDic['nodetype'], input['uid'], oldS2ssid, s2ssid,snapshotDataDic['relntype_nid_list'],snapshotDataDic['relnssid'],input['subject'],self.curs)
          # Modified R_newsnapshot call, passing the new ssid os subject1 instead of the one passed by the user
          R_newsnapshot(snapshotDataDic['nodetype'], input['uid'], oldS2ssid, s2ssid,snapshotDataDic['relntype_nid_list'],snapshotDataDic['relnssid'],new_subject_ssid,self.curs)
      #end--------
          
      #start writing new subject2 ssid in gbnidssid and gbnidlatestssid.    
      #print "all_subject2_ssid_list",all_subject2_ssid_list
      subject2_nid_list = get_nid_from_ssid(all_subject2_ssid_list, self.curs)
      #print "subject2_nid_list",subject2_nid_list
      #print "olds2ssid_inid_dic",olds2ssid_inid_dic

      for ssid_no in range(len(subject2_nid_list)):
                    o_s2_ssid = all_subject2_ssid_list[ ssid_no ]
                    n_s2_ssid = oldS2_newS2_dic [o_s2_ssid]
                    #print "updating ",o_s2_ssid," to ",n_s2_ssid
                    nodetype = s2ssid_snapshotData_dic[n_s2_ssid]['nodetype']               
                    s2inid = olds2ssid_inid_dic[o_s2_ssid]
                    reset_ssid_2_latestssid(n_s2_ssid, subject2_nid_list[ssid_no],self.curs)
                    bind_nidssid(n_s2_ssid, subject2_nid_list[ssid_no], s2inid, nodetype, self.curs)
      # end -------    

      #  inheritance logic ---start                                                                                                                 
      if flag_inherit == 1:
               from Inherit import *
               inherit_obj = Inherit(self.constring,self.uid)
               inherit_rendernbh_dic = inherit_obj.inherit( [new_subject_ssid] , [input['subject_inid']] , input['nodetype'], inherit_s2_list)
               listof_news2list.insert(0, inherit_rendernbh_dic)
      #end----
      else:
               listof_news2list.insert(0, {})

      final_dic['listof_news2list']= listof_news2list
      final_dic['listof_new_relnssid_list']= listof_new_relnssid_list
      final_dic['oldS2_newS2_dic'] = oldS2_newS2_dic
      print "==================final_dic===================",final_dic
      return final_dic

  def Update(self,input):
      input['uid'] = self.uid
      #print input       
      nodetype_list = self.startchecks(input['subject'])

      if nodetype_list!=-1:
         nid_inid_list= get_nidinid_from_ssid(input['subject'],self.curs)
         subject_nid= nid_inid_list[0][0]
         subject_inid= str(nid_inid_list[0][1])
         input['subject_inid']=subject_inid  
         input['nodetype']=nodetype_list[0]
        
         new_subject_ssid=get_next_sequence_value('ssid_seq',self.curs)
         final_dic2return={}
         final_dic2return['new_subject_ssid'] = new_subject_ssid
         
         from GetMethods import *
         GetMethodsObj = GetMethods (self.constring)
         output_dic = GetMethodsObj.getNeighbourhood([input['subject']],'rendered_nbh')
         commitclose(GetMethodsObj.curs,GetMethodsObj.conn)
         #print output_dic
         old_renderednbh = output_dic[input['subject']]
      
         if input.has_key('instanceof'):#there are attributes to update/add/both.
            from Attribute import *
            Aobj=attribute(self.constring,self.uid)     

            #handling unicode for each attributes and nid.
            input = modify_inputdic( input )

            AttrDic = self.UpdateAttribute(input,new_subject_ssid,old_renderednbh,Aobj)
            #print "OUTPUT FROM ATTR ",AttrDic
            if AttrDic==-1:
               #print " one of the attributes could not be attached"
               return -1
         else:
            AttrDic=1

         if input.has_key('relation'):
            #print "IN RELATIONS PART INPUT DICTIONARY=========",input
            relnobj=relations(self.constring,self.uid)
            Rdic = self.UpdateRelation(input,new_subject_ssid,old_renderednbh,relnobj)
            
            if Rdic==-1:
               return -1
            elif Rdic!=1:
              final_dic2return['oldS2_newS2_dic'] =  Rdic['oldS2_newS2_dic']
         else:
            Rdic=1

         flag_PT=0   
         if input['nodetype']=='gbprocesstypes':
            if input.has_key('priorstatedef'):
               flag_PT=1

         flag_P=0
         if input['nodetype'] == 'gbprocess':
            if input.has_key('priorstate'):
              flag_P=1

         if Rdic == 1 and AttrDic == 1 and flag_P != 1 and flag_PT != 1:
            #there are no attributes/relations to update or add. Also no priorstate/def n poststate/def to add.      
            if input.has_key('structure'):
               if old_renderednbh.has_key('structure'):
                  if input['structure'] == old_renderednbh['structure']:#new structure is same as previous.
                       #print"new structure is same as previous."
                       return "new structure is same as previous."
                  else:#new structure is different from the previous.
                       pass
                  
               updatestructure(input['nodetype'],input['uid'],input['subject'],new_subject_ssid,input['structure'],input['commit'],self.curs)
               reset_ssid_2_latestssid(new_subject_ssid,subject_nid,self.curs)#update subject's ssid
               bind_nidssid(new_subject_ssid,subject_nid,subject_inid,nodetype_list[0],self.curs)#for new snapshot of subject   
               commitclose(self.curs,self.conn)
               try:
                 commitclose(Aobj.curs,Aobj.conn)
               except:
                 pass
               try:
                 commitclose(relnobj.curs,relnobj.conn)
               except:
                 pass
               return new_subject_ssid
            else:
              return "no structure to update/add. No new Attributes/Relations values given "

         elif Rdic==1:# no relations
              A_attr_nid_list = AttrDic['A_attrtype_nid_list'] 
              U_attr_nid_list = AttrDic['U_attrtype_nid_list'] 
              attrvalue_list = AttrDic['attrvalue_list'] 
              new_attrssid_list = AttrDic['new_attr_ssid_list']

              listof_news2list = [] 
              listof_new_relnssid_list = []
              listof_relntype_nid = []
         elif AttrDic==1: # no Attributes
              A_attr_nid_list =[]
              U_attr_nid_list = []
              attrvalue_list = []
              new_attrssid_list =[]
              
              listof_news2list = Rdic['listof_news2list']
              listof_new_relnssid_list = Rdic['listof_new_relnssid_list']
              listof_relntype_nid = Rdic['listof_relntype_nid']
         else: # reln and attributes both 
              A_attr_nid_list = AttrDic['A_attrtype_nid_list'] 
              U_attr_nid_list = AttrDic['U_attrtype_nid_list'] 
              attrvalue_list = AttrDic['attrvalue_list'] 
              new_attrssid_list = AttrDic['new_attr_ssid_list']

              #print '-----------------AttrDic-----------',AttrDic

	      #print '-----------Rdic--------------',Rdic
	
              listof_news2list = Rdic['listof_news2list']
              listof_new_relnssid_list = Rdic['listof_new_relnssid_list']
              listof_relntype_nid = Rdic['listof_relntype_nid']

              

         if input.has_key('structure'):
              if old_renderednbh.has_key('structure'):
                     if input['structure'] == old_renderednbh['structure']:#new structure is same as previous.
                        input['structure']=0
                     else:
                        pass
         else:
               input['structure']=0

         #update2newsnapshot(input['nodetype'], input['uid'],input['subject'],new_subject_ssid,input['commit'],self.curs, new_attrssid_list, attrvalue_list, A_attr_nid_list, U_attr_nid_list, listof_new_relnssid_list, listof_news2list, listof_relntype_nid, input['structure'])
         update2newsnapshot(input,new_subject_ssid,input['commit'],self.curs, new_attrssid_list, attrvalue_list, A_attr_nid_list, U_attr_nid_list, listof_new_relnssid_list, listof_news2list, listof_relntype_nid)

         if flag_P == 1:
            handle_process(input,new_subject_ssid,self.curs)
         
         if flag_PT == 1:
            handle_processtypes(input,new_subject_ssid, self.curs)
          
         #print"updating old_ssid_of_subject=",input['subject']," to new_subject_ssid=",new_subject_ssid
         reset_ssid_2_latestssid(new_subject_ssid,subject_nid,self.curs)#update subject's ssid
         bind_nidssid(new_subject_ssid,subject_nid,subject_inid,nodetype_list[0],self.curs)#for new snapshot of subject   
         commitclose(self.curs,self.conn)
         try:
             commitclose(Aobj.curs,Aobj.conn)
         except:
             pass
         try:
             commitclose(relnobj.curs,relnobj.conn)
         except:
             pass
         try:
             commitclose(inherit_obj.curs, inherit_obj.conn)
         except:
             pass
         
         return  final_dic2return
         

if __name__=="__main__":
  constring="dbname=<postgres_databasename> user=<postgres_username> password=<postgres_password> host=localhost"

  uid = 1
  obj=Update(constring,uid)

  """
  input = {
            'status':'Public',  
            'attribute':[('11','VESITOWNER'),('12','BORN:1955')],
            'subject':'40',
            'language':'en',
            'commit':'1',
            'structure':['only OWNER'],
            'relation':[('FOUNDER',['46'])]
           }
           
           

  input = {
            'status':'public',  
            'attribute':[('11','OBJECTTYPE1'),('12','first gnowsys objecttype')],
            'mandatoryfields':['17'],
            'subject':'18',
            'language':'en',
            'commit':'1'
           }
  input = {
            'status':'public',  
            'attributes':[('11',"VESIT TRUSTY"),('12','the only trusty of VESIT college'),('13','college location:chembur, Mumbai.')],
            'subject':'68',
            'language':'en',
            'commit':'1',
            'relation':[('FOUNDER',['76'])]

           }


 
  input = {
            'status':'public',  
            'subject':'45',
            'commit':'1',
            'structure':['11','12'],
            'attributes':[('11','no title')],
            'language':'en'
           }
  input = {
            'status':'public',  
            'subject':'84',
            'commit':'1',
             'attributes':[('11','there is still no title')],
            'language':'en',
            'relation':[('FOUNDER',['46'])]
           }


  input = {
            'status':'public',
            'attribute':[('11','O1'),('12','this is O1')],
            'subject':'25',
            'language':'en',
            'commit':'1',
            'relation':[('dependson',['29'])],
            'attributes':[('title','Object1'),('description','this is first object')]
            }

  input = {
            'status':'public',
            'subject':'133',
            'language':'en',
            'commit':'1',
            'relation':[('hasWritten',['109'])],
            'attributes':[('title','writer3 instance updated'),('description','writer3 instance description updated')]
            }


  input = {
            'nodetype':'gbobjects',
            'status':'public',
            'subject':'295',
            'language':'en',
            'commit':'1',
            'relation':[('hasWritten',['313','322']),('knowslang',['420'])],
            'attributes':[('title','writer2 relations and attributes updated'),('description','writer1 description updated')]
            }


  input = {'instanceof': ['130'], 
           'status': 'public', 
           'language': 'en', 
           'relation': [['loves', ['38']]], 
           'commit': '1', 
           'attributes': [['content', ' Instance of Writer,second instance'], ['description', ' Instance of Book,second test instance'], ['title', ' new second object testbook']], 
           'subject': '200'
          } 	


  input = {'status': 'public', 
           'language': 'en', 
           'subtypeof': ['28', '21'], 
           'relation': [['partof', ['31']]], 
           'commit': '1', 
           'attributes': [['stage_status', 'testing']], 
           'subject': '628'}
  """
  """
  input = {
           'status': 'public', 
           'language': 'en', 
           'relation': [['partof', ['44']], ['Depends-ON', ['44']], ['instanceof', ['130']], ['loves', ['200']]], 
           'commit': 1, 
           'attributes': [['content', 'Instance of Writer,second instance'], ['description', 'Instance of Book,second test instance'], ['title', 'second object testbook']], 
           'subject': '1128'
          }
  """        
  """
  input = {
           'status': 'public', 
           'language': 'en', 
           'commit': 1, 
           'attributes': [['legislature', 'Parliament'], ['description', 'Singapore is a microstate and the smallest nation in Southeast Asia. This is orders of magnitude larger than Monaco and Vatican City, the only other surviving sovereign city-states.'], ['title', 'Singapore is a microstate and the smallest nation in Southeas'],['area','710.2 km2'],['population','4,839,400']], 
           'subject': '171'
          }
  """        
  input = {                                                                                                                                                            'status':'public',                                                                                                                               
           'subject':'325',                                                                                                                                 
           'language':'en',                                                                                                                                 
           'commit':'1',                                                                                                                                    
           'relation':[('dependson2',['322'])]                                       
           } 

  input = {'status': 'public', 'commit': '1', 'relation': [('instanceof', ['2111'])], 'subject': '2110'}
  input = {'status': 'public', 'commit': '1', 'attributes': [('grade', '50')], 'subject': '2429','language':'english'}

  #input = {'status': 'public', 'attributes': [['content', 'content'], ['description', 'test'], ['title', 'new']], 'subject': '122', 'language': 'en', 'commit': '1'}

  input = {
            'status':'public',
            'subject':'18270',
            'commit':'1',
            'relation':[('dependson',['18271','18272'])]
            }


  if input.has_key('mandatoryfields'):
     if input.has_key('attributes'):   
        input['attributes'].append(('mandatoryflds',input['mandatoryfields']))   
     else:
        input['attributes']=[('mandatoryflds',input['mandatoryfields'])]
     input.pop('mandatoryfields')

  if input.has_key('attributes'):
     input['instanceof']=input['attributes']
     input.pop('attributes')

  #print input
  print  obj.Update(input)
  #commitclose(obj.curs,obj.conn)
  #,('11',''),('12','blank description')],
  #things that we derive: subject nid,inid,nodetype
  #things to pass: subject ssid,status

"""
  'relation':[('CREATOR',['241'])]

"""


