# -*- coding: utf-8 -*- 
 
#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################

__author__ = """Rajiv Nair <rajivnair@gnu.org>"""

from SetMethods import *
from GetMethods import *
import os
from time import sleep
import xmlrpclib
import time
import cPickle
import datetime
import time



file = open('/tmp/mainfile.txt')
dict = {}
nidlist = []

for line in file.readlines():
    value = ''
    array = line.split(':')
    if array[0] == 'Package':
        key = array[1]
        key = key.replace('\n','')
        key = key.replace(' ','')
        nidlist.append(key)
    if array[0] == 'Depends':
        len_depends = len('Depends') + 1
        value = line[len_depends:]
        valuelst = value.split(',')
        finallist = []
        for elem in valuelst:
            finallist.append(elem.split('|')[0].split('(')[0].replace('\n','').replace(' ',''))
        dict.update({key:finallist})
        #print dict


constring="dbname=test25 user=rajiv password=rajiv host=localhost"
gnowql = SetMethods( constring )
getobj = GetMethods( constring )

input = {
      'nodetype':'objecttype',
      'nid':'Packages',
      'uid':'1',
      'status':'public'
      }
print gnowql.setnode( input )


l = getobj.getlatestssids(['Packages'],'nid')
package_ssid = str(l['Packages'])


input = {                                                                                                                       
    'nodetype':'relationtype',                                                                                             
    'nid':'dependson',                                                                                
    'uid':'1',                                                                                          
    'status':'Public',                                                                                                      
    'inversename':'isrequiredfor',                                                                          
    'subjecttype1':[package_ssid],                                                      
    'subjecttype2':[package_ssid]                                                       
    }
gnowql.setnode(input)


file1 = open('/var/25objectstats','a')
cnt = 1
for nid in nidlist:
    input = {
      'nodetype':'object',
      'nid':nid,
      'uid':'1',
      'status':'public',
      'instanceof':[package_ssid]
       }
    gnowql.setnode( input )
    file1.write(str(cnt)+',')
    file1.write(str(datetime.datetime.fromtimestamp(time.time())))
    file1.write('\n')            
    cnt = cnt + 1
file1.close()



cnt = 1
file2 = open('/var/25relationstats','a')
for key in dict:
    file2.write(str(cnt)+',')
    file2.write(str(key)+',')
    latestssidskeys = getobj.getlatestssids([key],'nid')
    keys = latestssidskeys.values()
    latestssidsvalues = getobj.getlatestssids(dict[key],'nid')
    values = latestssidsvalues.values()
    try:
        input = {
         'nodetype':'relation',
         'uid':'1',
         'status':'Public',
         'subject1':keys,
         'subject2':values,
         'relationtypes':'dependson'
         }
        gnowql.setnode(input)
    except:
        pass
    file2.write(str(datetime.datetime.fromtimestamp(time.time())) + '   ')
    file2.write('\n')
    cnt = cnt + 1
file2.close()


    



    
