# -*- coding: utf-8 -*- 
 
#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################

import psycopg2
from GetMethods import *

class dicMapper: 
    def __init__(self,constring,userid):
        self.constring = constring
        self.conn = psycopg2.connect( constring )   
        self.curs = self.conn.cursor() 
        self.uid = userid

    def dicmapper4attr(self,list_of_dic):
        input={}
        input['nodetype'] = 'attribute'
        input['language']='english'
        dic = list_of_dic[0]
        input['uid'] = dic['uid']
        input['status'] = dic['status'].lower()
        input['subject'] = dic['subject'][0]
        input['instanceof'] =[]
        ssidlist = []        
        ssid_value_dic={}
        getObj = GetMethods(self.constring)
        for dic in list_of_dic:
            print "dic==",dic
            ssidlist.append( dic['instanceof'][0] )
            ssid_value_dic[ dic['instanceof'] [0] ] = dic['value']
 
        attrtype_ssid_nid_dic = getObj.getnids( ssidlist )
        print "attrtype_ssid_nid_dic",attrtype_ssid_nid_dic
        
        for ssid in attrtype_ssid_nid_dic: 
            input['instanceof'].append( (attrtype_ssid_nid_dic[ssid], ssid_value_dic[ssid] ) )
            
        from SetMethods import SetMethods
        obj = SetMethods( self.constring , self.uid )
        print input    
        return obj.setnode( input )                         
        
    def dicmapper(self,dic,nodetype):
        input={}
        input['nodetype'] = nodetype
       
        input['uid'] = dic['uid']
        input['status'] = dic['status'].lower()
        if dic.has_key('nid'):
            input['nid'] = dic['nid']

        if dic.has_key('title'):
            input['attributes']=[('title',dic['title'][0])]  
            
        if dic.has_key('description'):
            if input.has_key('attributes') :
                input['attributes'].append( ('description',dic['description']) )
            else:
                input['attributes']=[ ('description',dic['description']) ]

        if dic.has_key('content'):
            if input.has_key('attributes') :
                input['attributes'].append( ('content',dic['content']) )
            else:
                input['attributes'] = [ ('content',dic['content']) ]
        
        if input.has_key('attributes'):       
            input['language']='english' 

        if dic.has_key('instanceof') :
            getObj = GetMethods(self.constring)
            latestssid_nid_dic = getObj.getlatestssidsFromNids(dic['instanceof'])
            latestssid=[]
            for key in dic['instanceof']:
                latestssid.append(latestssid_nid_dic[key])
            input['instanceof'] = latestssid

        if dic.has_key('subtypeof') :
            getObj = GetMethods(self.constring)
            latestssid_nid_dic = getObj.getlatestssidsFromNids(dic['subtypeof'])
            latestssid=[]
            for key in dic['subtypeof']:
                latestssid.append(latestssid_nid_dic[key])
            input['subtypeof'] = latestssid

        if nodetype=='relationtype' :
            input['subjecttype1'] = dic['role1']
            input['subjecttype2'] = dic['role2']
            input['inversename'] = dic ['inversename'][0]
            input['applicablenodetypes'] = 'types'

        elif nodetype=='relation' :   
            input['subject1'] = [dic['subject1'] ]
            input['subject2'] = [dic['subject2'] ]
            input['relationtypes'] = dic['relationtypes']

        elif nodetype == 'attributetype' :
             input['subjecttypes'] = dic['subjecttypes']
             input['regex'] = ''
             input['applicablenodetypes'] = 'types'
             input['restrictiontype'] = 1
             input['datatype'] = 'varchar'

        elif nodetype == 'user':     
             if dic.has_key('username'):
                input['nid'] = dic['username'] 
                if input.has_key('attributes'): 
                   input['attributes'].append( ('username',dic['username']) )
                else:    
                   input['attributes'] =[ ('username',dic['username']) ]

             if dic.has_key('fullname'):
                if input.has_key('attributes'): 
                   input['attributes'].append(  ('firstname',dic['fullname']) )
                else:    
                   input['attributes'] =[ ('firstname',dic['fullname']) ]

             if dic.has_key('email'):
                if input.has_key('attributes'): 
                   input['attributes'].append(  ('email',dic['email']) )
                else:    
                   input['attributes'] =[ ('email',dic['email']) ]
                
             if dic.has_key('password'):
                if input.has_key('attributes'): 
                   input['attributes'].append(  ('password',dic['password']) )
                else:    
                   input['attributes'] =[ ('password',dic['password']) ]
             
        from SetMethods import SetMethods
        obj = SetMethods( self.constring , self.uid )
        if 'nid' in input.keys(): 
            input['nid'] = input['nid'].replace("'","''")
        print "-------==========",input    
        return obj.setnode( input )                         

    
             


if __name__=='__main__':
  constring='dbname=gnowsys user=jay password=jay host=localhost'  
  o = dicMapper(constring,1)    
  input = {
      'uid':'1',
      'status':'public',
      'username':'selfUser1',
      'fullname':'SU1',
      'password':'su1su1',
      'email':'su1@gmail.com',
      'content':"this user is instanceof selfusers",
      'title':['selfuserr1'],
      'description':'SELF-USER',
      'instanceof':['selfusers']
      }
  o.dicmapper(input,'user')
  """
  dict = {
            'uid':1,
            'status':'public',
            'instanceof':['249'],  # is the ssid  of the attributeType i.e 'Copyright'
            'value':'GPLv0.4',
            'subject':['84']      # is the ssid of the object i.e image1
            }
  list_of_dic=[]
  list_of_dic.append(dict)
  dict= {
            'uid':1,
            'status':'public',
            'instanceof':['11'], 
            'value':'attaching title: O1',
            'subject':['84']      
            }

  list_of_dic.append(dict)
  o.dicmapper4attr(list_of_dic)

  input={
      'nid':'haspart',
      'uid':'1',
      'status':'public',
      'content':"the 'haspart' relntype created.",
      'title':['haspart'],
      'inversename':['ispartof'],
      'description':'adding relation type haspart',
      'role1':['Courses'],
      'role2':['Content']
      }
  o.dicmapper(input,'relationtype')
  """
  
