# -*- coding: utf-8 -*-

#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################

__author__ = """Nagarjuna G. <nagarjun@gnu.org>"""
__docformat__ = 'plaintext'


from Products.CMFPlone import PloneMessageFactory as _
from ZODB.POSException import ConflictError
from AccessControl import ClassSecurityInfo
from Products.Archetypes.atapi import *
from zope.interface import implements
import interfaces
from Products.CMFDynamicViewFTI.browserdefault import BrowserDefaultMixin
from Products.gnowsysApp_rc1.config import *
import psycopg2
import psycopg2.extensions
import psycopg2.extras
import md5

##code-section module-header #fill in your manual code here
##/code-section module-header

schema = Schema((


),
)

##code-section after-local-schema #fill in your manual code here
##/code-section after-local-schema

gnowql_schema = BaseSchema.copy() + \
    schema.copy()

##code-section after-schema #fill in your manual code here
##/code-section after-schema

class gnowql(BaseContent, BrowserDefaultMixin):
    """
    """
    security = ClassSecurityInfo()

    implements(interfaces.Ignowql)

    meta_type = 'gnowql'
    _at_rename_after_creation = True

    schema = gnowql_schema

    ##code-section class-header #fill in your manual code here
    ##/code-section class-header

    # Methods

    security.declarePublic('userExists')
    security.declarePublic('genNBHImage')
    security.declarePublic('genimage')
    security.declarePublic('genDepImage')
    security.declarePublic('gendep')
    security.declarePublic('setuser')
    security.declarePublic('n3_nbhexport')
    security.declarePublic('genN3')


    def getAuthUserid( self ):
        """
        """
        userid = self.portal_membership.getAuthenticatedMember().getId()
        if userid != None:
            connection_string = self.dbadapter.connection_string
            conn = psycopg2.connect( connection_string )   
            curs = conn.cursor() 
            curs.execute("select distinct(inid) from gbusers where nid = '%s';" %(userid) )
            uid = curs.fetchall()
            if uid == []:
                return 'user not in database'
            else:
                uid = str(uid[0][0])
                return uid
        else:
            return '0'


    def manageAddAttributeType(self, dict):
        """
        """
        connection_string = self.dbadapter.connection_string
        from dictionaryMapper import *
        dicobj = dicMapper(connection_string, dict['uid'])
        return dicobj.dicmapper(dict, 'attributetype' )

    def manageAddAttribute(self, list_of_dict):
        """
        """
        connection_string = self.dbadapter.connection_string
        from dictionaryMapper import *
        dicobj = dicMapper(connection_string, list_of_dict[0]['uid'])
        return dicobj.dicmapper4attr( list_of_dict )
        

    def manageAddObject(self, dict):
        """
        """
        connection_string = self.dbadapter.connection_string
        from dictionaryMapper import *
        dicobj = dicMapper(connection_string, dict['uid'])
        return dicobj.dicmapper(dict, 'object' )

    def manageAddObjectType(self, dict):
        """
        """
        connection_string = self.dbadapter.connection_string
        from dictionaryMapper import *
        dicobj = dicMapper(connection_string, dict['uid'])
        return dicobj.dicmapper(dict, 'objecttype' )

    def manageAddRelationType(self, dict):
        """
        """
        connection_string = self.dbadapter.connection_string
        from dictionaryMapper import *
        dicobj = dicMapper(connection_string, dict['uid'])
        return dicobj.dicmapper(dict, 'relationtype' )
    
    def manageAddRelation(self, dict):
        """
        """
        connection_string = self.dbadapter.connection_string
        from dictionaryMapper import *
        dicobj = dicMapper(connection_string, dict['uid'])
        return dicobj.dicmapper(dict, 'relation' )
    
    def manageAddUser(self, dict):
        """
        """
        connection_string = self.dbadapter.connection_string
        from dictionaryMapper import *
        dicobj = dicMapper(connection_string, dict['uid'])
        return dicobj.dicmapper(dict, 'user' )

    def manageAddUserType(self, dict):
        """
        """
        connection_string = self.dbadapter.connection_string
        from dictionaryMapper import *
        dicobj = dicMapper(connection_string, dict['uid'])
        return dicobj.dicmapper(dict, 'usertype' )


    def set_relation(self , dictionary):
        """
        this is same as setnode(input) where nodetype='relation',except new snapshot of subject1 and subject2 are not cretated. 
        """
       
        userid = self.portal_membership.getAuthenticatedMember().getId()
        if userid != None:
            connection_string = self.dbadapter.connection_string
            conn = psycopg2.connect( connection_string )   
            curs = conn.cursor() 
            curs.execute("select distinct(inid) from gbusers where nid = '%s';" %(userid) )
            uid = curs.fetchall()
            if uid == []:
                return 'user not in database'
            else:
                uid = str(uid[0][0])
                from SetMethods import SetMethods
                obj = SetMethods( connection_string , uid )
                return obj.set_relation( dictionary )                         
                
        else:
            return 'You are not an authenticated user'



    def setuser(self , dictionary):
        """
        """
        uid = '1'
        connection_string = self.dbadapter.connection_string
        from SetMethods import SetMethods
        obj = SetMethods( connection_string , uid )
        return obj.setnode( dictionary )                         
                
        

    def setnode(self , dictionary):
        """
        """

        userid = self.portal_membership.getAuthenticatedMember().getId()
        if userid != None:
            connection_string = self.dbadapter.connection_string
            conn = psycopg2.connect( connection_string )   
            curs = conn.cursor() 
            curs.execute("select distinct(inid) from gbusers where nid = '%s';" %(userid) )
            uid = curs.fetchall()
            if uid == []:
                return 'user not in database'
            else:
                uid = str(uid[0][0])
                from SetMethods import SetMethods
                obj = SetMethods( connection_string , uid )
                return obj.setnode( dictionary )                         
                
        else:
            return 'You are not an authenticated user'
                         
    def updateStructure( self , ssid , nodetype , structure_to_append ):
        """
        appends the structure only without creating its new snapshot for given a ssid
        """
        from GetMethods import GetMethods
        #from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.updateStructure( ssid , nodetype, structure_to_append )

    def replaceStructure(self, ssid ,nodetype , structure, old_rnbh=0):
        """
        replace the old structure only without creating its new snapshot for given a ssid
        """
        from GetMethods import GetMethods
        #from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.replaceStructure( ssid , nodetype, structure, old_rnbh=0 )

    def getlatestVersion(self, nid):
        """
        """
        from GetMethods import GetMethods
        #from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getlatestVersion( nid )

    def getUsernamefromUserId(self,uid):
        """
        accepts uid and return nid which is username
        """
        from GetMethods import GetMethods
        #from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getUsernamefromUserId(uid)

    def get_inid_from_nid(self,nid_list):
        from GetMethods import GetMethods
        #rom GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.get_inid_from_nid( nid_list )

    def Update(self, dictionary):
        """this function adds/updates attribute ,relation,structure of given subject ssid
        """

        userid = self.portal_membership.getAuthenticatedMember().getId()
        if userid != None:
            connection_string = self.dbadapter.connection_string
            conn = psycopg2.connect( connection_string )   
            curs = conn.cursor() 
            curs.execute("select distinct(inid) from gbusers where nid = '%s';" %(userid) )
            uid = curs.fetchall()
            if uid == []:
                return 'user not in database'
            else:
                uid = str(uid[0][0])

                from UpdateMethods import Update
                constring = self.dbadapter.connection_string
                obj = Update( constring , uid )

                if dictionary.has_key('mandatoryfields'):
                    if dictionary.has_key('attributes'):   
                       dictionary ['attributes'].append(('mandatoryflds',dictionary['mandatoryfields']))   
                    else:
                       dictionary['attributes']=[('mandatoryflds',dictionary['mandatoryfields'])]
                    dictionary.pop('mandatoryfields')
                    
                if dictionary.has_key('attributes'):
                   dictionary ['instanceof']=dictionary['attributes']
                   dictionary.pop('attributes')
                return obj.Update(dictionary)
                
        else:
            return 'You are not an authenticated user'
        
    def Delete(self, dictionary):
        """this function deletes attributes ,relations of given subject ssid. also possible delete that node
        """
        userid = self.portal_membership.getAuthenticatedMember().getId()
        if userid != None:
            connection_string = self.dbadapter.connection_string
            conn = psycopg2.connect( connection_string )   
            curs = conn.cursor() 
            curs.execute("select distinct(inid) from gbusers where nid = '%s';" %(userid) )
            uid = curs.fetchall()
            if uid == []:
                return 'user not in database'
            else:
                uid = str(uid[0][0])

                from DeleteMethods import Delete
                constring = self.dbadapter.connection_string
                obj=Delete(constring,uid)
                return obj.delete( dictionary )
                
        else:
            return 'You are not an authenticated user'
        
        
    
    
    def setlist( self , dictionary ):
        """
        """
        userid = self.portal_membership.getAuthenticatedMember().getId()
        if userid != None:
            connection_string = self.dbadapter.connection_string
            conn = psycopg2.connect( connection_string )   
            curs = conn.cursor() 
            curs.execute("select distinct(inid) from gbusers where nid = '%s';" %(userid) )
            uid = curs.fetchall()
            if uid == []:
                return 'user not in database'
            else:
                uid = str(uid[0][0])
                from AttributeType import setlist
                constring = self.dbadapter.connection_string
                set_Sellist = setlist( dictionary , constring , uid)
                return set_Sellist
        else:
            return 'You are not an authenticated user'
        

    def setregex( self , dictionary ):
        """
        """
        from AttributeType import setregex
        constring = self.dbadapter.connection_string
        set_regex = setregex( dictionary , constring )
        return set_regex
        

    def addUser( self , username , password ):
        """
        """
        roles = ('Contributor',)
        self.portal_registration.addMember( username , password , roles)


    
    def addUserSQL( self , username , password ,fullname , email):
        """
        """
        connection_string = self.dbadapter.connection_string
        roles = 'Member'
        conn = psycopg2.connect( connection_string )   
        curs = conn.cursor() 

        import md5
        m=md5.new()
        m.update(password)
        passwd = m.hexdigest()

        insert_query_users = "INSERT INTO auth_schema.users (username,password,fullname,email) values ('%s','%s','%s','%s');" %(username, passwd, fullname , email)
        curs.execute( insert_query_users )
        insert_query_roles = "INSERT INTO auth_schema.roles (username,rolename) values ('%s','%s');"  % (username,roles)
        curs.execute( insert_query_roles )
        conn.commit()
        curs.close()
        conn.close()
        

    def getUserId( self ):
        """
        """
        return self.portal_membership.getAuthenticatedMember().getId()
        """
        portal = self.portal_url.getPortalObject()
        mu = self.portal_membership
        for member in mu.listMembers():
            u = member.getUser()
            return u
        """

    def userExists( self , username, password):
        """
        """
        
#         uid = self.portal_membership.getAuthenticatedMember().getId()
#         user = self.REQUEST['AUTHENTICATED_USER']

#         if uid == None:
#             return 0
#         else:
#             return 1
        

        connection_string = self.dbadapter.connection_string
        conn = psycopg2.connect( connection_string )   
        curs = conn.cursor() 

        m=md5.new()
        m.update( password )
        passwd = m.hexdigest()
        
        query = "select username from auth_schema.users where username = '%s' and password = '%s';" %( username, passwd )
        curs.execute( query )
        uname = curs.fetchall()
        
        if uname <> []:
            return 1
        else:
            return 0
        
        
    def nidExists( self , nid ):
        """
        Checks if the nid exists
        """
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.nidExists( nid )


    def getAll(self,nodetype):
        """
        Accepts nodetype i.e, tablename and returns a dictionary with key as nid and value latestssid 
        """
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        uid = self.getAuthUserid()
        return obj.getAll( nodetype , userid = uid)

    def get_uid(self,nodetype,ssid_list):
        """
        accepts list of ssids of a nodetype and return the uid field of each ssid.                                                                                  """
        from GetMethods import GetMethods                                                                                                                   
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.get_uid(nodetype,ssid_list)


    def getUsernamefromUserId_list(self,uid_list,flag_dic=0):
        """
        accepts multiple uid  and return nid which is username                                                                                                      """
        from GetMethods import GetMethods                                                                                                                   
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getUsernamefromUserId_list(uid_list,flag_dic)



    def  getUserIdfromUsername(self,username):
         """
         accepts username and returns its id i.e, userid
         """
         from GetMethods import GetMethods
         connection_string = self.dbadapter.connection_string
         obj = GetMethods( connection_string )
         return obj.getUserIdfromUsername(username)
    


    def getlatestssids( self , idlist , idtype, nodetypes = []):
        """
        idtype : idtype could be any one of nid, ssid, inid
        idlist : idlist could be a list of nids or list of ssids or list of inids.
        example : getlatestssids( ['11','12','13'] , idtype):
        """
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        uid = self.getAuthUserid()
        return obj.getlatestssids( idlist , idtype, nodetypes, userid = uid )

    def get_renderednbh(self, subject_ssid_list,nodetype_list):
        """
        accepts list of ssid whose renderednbh is to be obtained. All ssids should be of same type/token                                                            """
        from GeneralMethods import *
        conn = psycopg2.connect(self.dbadapter.connection_string)
        curs = conn.cursor()
        final_list = get_renderednbh(subject_ssid_list,nodetype_list,curs)
        new_list=[]
        import cPickle
        from base64 import b64decode
        for unpickled_value in final_list:
            new_list.append( cPickle.loads(b64decode( unpickled_value )) )
        commitclose(curs,conn)
        return new_list


    def get_nbh_renderednbh(self, subject_ssid_list,nodetype_list):
        """
        accepts ssid whose nbh and renderednbh is to be obtained. All ssids should be of same type/token                                                            """
        from GeneralMethods import *
        conn = psycopg2.connect(self.dbadapter.connection_string)
        curs = conn.cursor()
        final_dic = get_nbh_renderednbh(subject_ssid_list,nodetype_list,curs)
        commitclose(curs,conn)
        return final_dic


    def getNeighbourhood(self, ssid_list , getwhat, nodetypes = [] ):
        """
        getwhat can take values rendered_nbh or nbh
        """
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getNeighbourhood( ssid_list , getwhat, nodetypes )


    def getsnapshots_history_n_version(self,nodetype,ssid):
        """
        returns origin of all history fields of given ssid.                                                                                                 
        """
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getsnapshots_history_n_version(nodetype,ssid)



    def getAllSnapshots(self, idtype , id ):
        """
        Gets all the snapshots(ssids) of the given node corresponding to input nid/ssid/inid.
        """
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        uid = self.getAuthUserid()
        return obj.getAllSnapshots(idtype , id , userid = uid)



    def getDatatype(self, attrtype_ssid_list):
        """
        Given a list of attributessids return its datatypes
        """
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getDatatype( attrtype_ssid_list )


    def getAllnbh(self,ssid_list):
        """
        given a list of ssid returns entire rows/tuples.
        """

        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getAllnbh( ssid_list )


    def getRoles( self , RTnid ):
        """
        Given a relationtype nid this method returns the roles participating in the relationtype 

        FOR EXAMPLE : getRoles('instanceof')

        OUTPUT : 

        [ {'cardinality1': 0, 'cardinality2': 0, 'rtid': 1, 'applicablenodetypes2': 'gbusertypes,gbprocesstypes,gbobjecttypes,gbrelationtypes,gbattributetypes', 'applicablenodetypes1': 'gbusers,gbprocess,gbobjects,gbrelations,gbattributes', 'subjecttype1': 0L, 'subjecttype2': 0L}, 
        {'cardinality1': 0, 'cardinality2': 0, 'rtid': 2, 'applicablenodetypes2': 'gbmetatypes', 'applicablenodetypes1': 'gbusertypes,gbprocesstypes,gbobjecttypes,gbrelationtypes,gbattributetypes', 'subjecttype1': 0L, 'subjecttype2': 0L} ]
        
        """

        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getRoles( RTnid )


    def getSubjecttypes( self , ATnid):
        """
        Given a attributetype nid this method returns the subjecttypes participating in the attributetype 

        FOR EXAMPLE : getSubjecttypes('Languages')
        
        OUTPUT : 
        [{'stid': '19', 'applicablenodetypes': None}]

        So the subjecttype is 19 and the applicablenodetypes is None which means that the attribute would be attached
        to the instances of subjecttype with inid 19
        """

        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getSubjecttypes( ATnid )


    def getSelectionlist( self ):
        """
        This method returns all the selectionlists  in the gnowledge base . Used while attaching attributetypes.

        FOR EXAMPLE : getSelectionlist()

        OUTPUT : 
        
        [{'listid': '49', 'value': ['english', 'hindi', 'marathi'], 'nid': 'Languages'}, 
        {'listid': '74913', 'value': ['earth', 'jupiter', 'mars'], 'nid': 'Planets'}]

        """

        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getSelectionlist(  )


    def getRegex( self ):
        """
        This method returns all the regular expressions  in the gnowledge base . Used while attaching attributetypes.

        FOR EXAMPLE : getRegex( )

        OUTPUT : 
        [{'id': '0', 'exp': 'NO REGULAR EXPRESSION'}, 
        {'id': '1', 'exp': '\x08(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?).(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)'}, 
        {'id': '2', 'exp': '\x08(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?).(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)'}]

        """

        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getRegex( )


    def getRestrictions( self , ATlist ) :
        """
        
        Given list of attributetype ssids the method returns all the restrictions that the attributetypes have.

        FOR EXAMPLE : getRestrictions( ['10','50','51'] )

        OUTPUT : 
        
        {{'10': {'datatype': 'varchar', 'range': None, 'precision': None, 'regexid': '0', 'length': None, 'type': '1'}, '51': {'datatype': 'float8[]', 'range': '0-5', 'precision': 2, 'regexid': '1', 'length': 5L, 'type': '1'}, '50': {'datatype': 'varchar[]', 'listid': 49L, 'type': '0', 'selectiontype': '0'}}

        """
        
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getRestrictions( ATlist )



    def getAttributetypes( self , subjecttypelist ) :
        """
        
        Given list of subjecttype inids the method returns all the attributetypes attached.

        FOR EXAMPLE :  getAttributetypes(['5']) 

        OUTPUT : 
        {'5': ['6', '7', '8', '9', '10']}

        """
        
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getAttributetypes( subjecttypelist )



    def getRelationtypes( self , subjecttypelist ) :
        """
        
        Given list of subjecttype inids the method returns all the relationtypes attached.

        FOR EXAMPLE :  getRelationtypes(['11','38026']) 

        OUTPUT : 
        {'11': ['12'], '38026': ['38028']}

        """
        
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getRelationtypes( subjecttypelist )


    def getAttributeValues( self , Attrssidlist ) :
        """

        Given a list of attributessids returns their values.

        example : getAttributeValues(['173','174','176']) 
        output :
        {'173':'Richard Dawkins','174':'The God Delusion','176':['121','122','123']}

        """

        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getAttributeValues( Attrssidlist ) 


    def getNodetype( self , ssid ) :
        """
        Returns nodetype given node ssid

        example : getNodetype('253')
        output : gbattributes


        """

        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getNodetype( ssid ) 


    def getNodetypes( self , idlist ) :
        """
        Returns nodetype given  ssid list

        example : getNodetypes(['331','40','6'])
        output : {'331': 'gbobjects', '40': 'gbrelations', '6': 'gbattributetypes'}


        """

        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getNodetypes( idlist ) 


    def getSubtypes( self , nodeid ) :
        """
        Returns only the 'subtypes' of the node specified

        For example : 
        If nodeid is 15 then the method returns only the subtypes of the 
        node provided

        """

        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getSubtypes( nodeid ) 


    
    def getSubtypesCnt( self , ssid ) :
        """
        Returns only the count 'subtypes' of the node specified

        For example : 
        If nodeid is 15 then the method returns only the count subtypes of the 
        node provided

        """

        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getSubtypesCnt( ssid ) 


    def getInstances( self , nodeid , type) :
        """
        Returns only the 'subtypes' of the node specified

        For example : 
        If nodeid is 15 then the method returns only the instances of the 
        node provided

        """

        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        uid = self.getAuthUserid()
        return obj.getInstances( nodeid , type , userid = uid) 


    
    def getInstancesCnt( self , ssid) :
        """
        Returns only the count of 'instances' of the node specified

        For example : 
        If nodeid is 15 then the method returns only the count instances of the 
        node provided

        """

        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        uid = self.getAuthUserid()
        return obj.getInstancesCnt( ssid ) 


    
    def getOntologies( self ) :
        """
        
        """

        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getOntologies() 




    def getAllSubtypes( self , nodeid ) :
        """

        Returns all the 'subtypes' of the node specified

        For example : 
        If nodeid is 15 then the method returns all the subtypes of the 
        node provided
        ie If '15' has subtype '20' and and '20' has subtype '40' and '40' has subtype '60'.
        then getAllSubtypes( '15' ) would return ['20','40','60']
 
        """

        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getAllSubtypes( nodeid ) 


    def getAllInstances( self , nodeid ) :
        """

        Returns all the 'subtypes' of the node specified

        For example : 
        If nodeid is 15 then the method returns all the instances of the 
        node provided
        The code has been divided into two parts :
        1) It gets all the subtypes first
            -- If '15' has subtype '20' and and '20' has subtype '40' and '40' has subtype '60'.
               then getAllSubtypes( '15' ) would return ['20','40','60']

        2) Then from the list of subtypes it gets all the instances.
           -- i.e instances of 20,40 and 60
 
        """

        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getAllInstances( nodeid ) 



    def getRelationids( self , ids ):
        """
        The ids are of the form:
        [['17','16'],['17','15']]
        
        output = {'19': [17L, 16L], '18': [17L, 15L]}
        """
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getRelationids( ids ) 


    def updateStatus( self , ssid , status ):
        """
        Updates the status, given a ssid
        """
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.updateStatus( ssid , status ) 


    def gettimestamp(self,nodetype,ssid_list):
        """
        Gets the gbtimestamp
        """
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.gettimestamp( nodetype , ssid_list ) 

        
    def getPublicIds(self,lstids):
        """
        return ids created by the user or ids with status is public
        """
        if lstids == []:
            return lstids

        userid = self.portal_membership.getAuthenticatedMember().getId()
        if userid != None:
            connection_string = self.dbadapter.connection_string
            conn = psycopg2.connect( connection_string )  
            curs = conn.cursor()
            curs.execute("select distinct(inid) from gbusers where nid = '%s';" %(userid) )
            uid = curs.fetchall()
            if uid == []:
                return 'user not in database'
            else:
                uid = str(uid[0][0])
                from GetMethods import GetMethods
                connection_string = self.dbadapter.connection_string
                obj = GetMethods( connection_string )
                return obj.getPublicIds( lstids , uid) 
            


    def updatecommit( self,input):
        """
        """
        userid = self.portal_membership.getAuthenticatedMember().getId()
        if userid != None:
            connection_string = self.dbadapter.connection_string
            conn = psycopg2.connect( connection_string )  
            curs = conn.cursor()
            curs.execute("select distinct(inid) from gbusers where nid = '%s';" %(userid) )
            uid = curs.fetchall()
            if uid == []:
                return 'user not in database'
            else:
                uid = str(uid[0][0])
              
        nodetype="gb"+input['nodetype']
       
        #handling 'noofcommits':
        sql="select max(noofcommits) from %s where nid='%s';"%(nodetype,input['nid'])
        #print sql
        execute_query(sql,curs)
        noofcommits =query_fetchall(curs)[0][0]
        #print "max(noofcommits)==",noofcommits
        #print "commit===========",commit
        noofcommits = noofcommits + 1
        query="update %s set noofcommits=%s,noofchangesaftercommit=0 where ssid=%s;"%(nodetype,noofcommits,input['subject'])
        execute_query(query,curs)
        conn.commit()
        curs.close()
        conn.close()




    def searchNodes(self, searchstr, tblname , searchtype='0' ):
        """
        Performs search in gnowledge base
        Simple search :  takes in nid as input
        input:searchNodes('Historic','gbobjecttypes')
        output:
        [(24L, 'HistoricPlace'), (181L, 'HistoricBuilding')]

        """
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        uid = self.getAuthUserid()
        return obj.searchNodes( searchstr , tblname, userid = uid , searchtype = '0') 



    
    def search(self, querystr ,tblnames = ['gbobjecttypes','gbobjects']):
        """
        Performs search in gnowledge base
        Simple search :  takes in nid as input
        input:search('Writer')
        output:
        [{'nodetype': 'gbobjecttypes', 'ssid': '16', 'nid': 'Writer','type':'nid'}, {'nodetype': 'gbobjecttypes', 'ssid': '26', 'nid': 'newWriter','type':'nid'}]
        """
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        uid = self.getAuthUserid()
        return obj.search( querystr , tblnames , uid ) 


    # def search(self, querystr):
    #     """
    #     Performs search in gnowledge base
    #     Simple search :  takes in nid as input
    #     input:search('Writer')
    #     output:
    #     [{'nodetype': 'gbobjecttypes', 'ssid': '16', 'nid': 'Writer','type':'nid'}, {'nodetype': 'gbobjecttypes', 'ssid': '26', 'nid': 'newWriter','type':'nid'}]
    #     """
    #     from GetMethods import GetMethods
    #     connection_string = self.dbadapter.connection_string
    #     obj = GetMethods( connection_string )
    #     uid = self.getAuthUserid()
    #     return obj.search( querystr , userid = uid ) 


    def getnids( self, lstssids, nodetypes = []):
        """
        Returns a list of nids given list of ssids
        input :  getnids( ['13','14','15'] )
        output : 
        {'13': 'content', '15': 'mandatoryflds', '14': 'listdatatype'}

        """
        
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        uid = self.getAuthUserid()
        return obj.getnids( lstssids , nodetypes, userid = uid) 

    def getinids( self, lstssids, nodetypes = []):
        """
        Returns a list of inids given list of ssids
        input :  getnids( ['13','14','15'] )
        output : 
        {'13': '4', '15': '15', '14': '12'}

        """
        
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        uid = self.getAuthUserid()
        return obj.getinids( lstssids , userid = uid) 


    def genTriples( self , ssid ):
        """
        Generates rdf triples given subjectid
        """
        
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.genTriples( ssid ) 


    def getCount( self , nodetype ):
        """
        Gets the count of number of objects in a table given a nodetype 
        """
        
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getCount(  nodetype  ) 


    def getSpecificnbh( self ,ssid , nbhprops):
        """
        Gets Specific neighbourhood of a node

        nbhprops = ['attributes','relations']
		
        output:
        {'attributes': ['description', 'title'], 'relations': ['instanceof', 'hasWritten']}

	( or )


        nbhprops = {'attributes':['title'],'relations':['hasWritten']}
		
        output:
        {'attributes': {'title': ('143', 'writer3 instance updated')}, 'relations': {'hasWritten': {'rightroles': ['147']}}}

	"""
        
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getSpecificnbh( ssid , nbhprops)


    def getAuthor( self , ssid ):
        """
        Generates rdf triples given subjectid
        """
        
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getAuthor( ssid ) 




    def updatePasswd( self , username , password):
        """
        Update Password updates the password given username
        """
        
        userid = self.portal_membership.getAuthenticatedMember().getId()

        if userid != None:
            connection_string = self.dbadapter.connection_string
            conn = psycopg2.connect( connection_string )  
            curs = conn.cursor()
            curs.execute("select distinct(inid) from gbusers where nid = '%s';" %( userid ) )
            uid = curs.fetchall()
            if uid == []:
                return 'user not in database'
            else:
                uid = str( uid[0][0] )
                from GetMethods import GetMethods
                connection_string = self.dbadapter.connection_string
                obj = GetMethods( connection_string )
                obj.updatePasswd( username , password , uid) 
    


    def getStructure( self , ssid ):
        """
        Get the structure of given the ssid of a node
        """
        
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getStructure( ssid ) 


    def getPortalUrl( self ):
        """
        Gets the portal url
        """
        return self.portal_url()


    def genNBHImage( self , ssid, redirect_cond = 0):
        """
        Generates the image of a node showing it's neighbourhood
        """
        
        #portal_url = self.portal_url()
        from GenGraph import GenGraph
        connection_string = self.dbadapter.connection_string
        datapath = self.Data.basepath
        

        obj = GenGraph( connection_string , datapath , self.portal_url())

        return obj.genGraph( [ssid] , redirect_cond )



    def genDepImage( self , ssid, rt):
        """
        Generates the image of a node showing it's neighbourhood
        """
        
        #portal_url = self.portal_url()
        from GenGraph import GenGraph
        connection_string = self.dbadapter.connection_string
        datapath = self.Data.basepath
        

        obj = GenGraph( connection_string , datapath , self.portal_url())

        return obj.SpecificGraph( ssid, rt )
    


    def gendep( self , id):
        """
        Calls the genDepImage and redirects to the page where the image is
        """
        
        
        self.gnowql.genDepImage( id )
        self.REQUEST.RESPONSE.redirect( self.portal_url()+"/Data/nbhimages/"+id+"_depmap.svg" )


    def genimage( self , id):
        """
        Calls the genNBHImage and redirects to the page where the image is
        """
        
        
        self.gnowql.genNBHImage( id )
        self.REQUEST.RESPONSE.redirect( self.portal_url()+"/Data/nbhimages/"+id+".svg" )

        


    def getDatatypes( self , type):
        """                                                                                                                              
        Generates the image of a node showing it's neighbourhood                                                                         
        """


        from datatypes import datatypes
        obj = datatypes( type )
        return obj



    def getPossibleRel( self , relationtype):
        """
        Gets possible relations possible with a given node
        """
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getPossibleRel( relationtype  ) 



    def searchPossibleRel( self , searchstr, RTnid, role ):
        """
        searches for possible relations possible with a given node
        """
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.searchPossibleRel( searchstr, RTnid, role ) 


    def searchPossibleAttr( self , searchstr, ATnid ):
        """
        searches for possible attributes possible with a given node
        """
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.searchPossibleAttr( searchstr, ATnid ) 


    def getPossibleAttr( self , objid):
        """
        Gets possible attributes possible with a given node
        """
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getPossibleAttr( objid  ) 


    def getPriorstates( self , objidlist):
        """
        Gets possible priorstates
        """
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getPriorstates( objidlist  )


    def getPoststates( self , objidlist):
        """
        Gets possible poststates
        """
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getPoststates( objidlist  )


    def getFrame( self , nodetype, param = {} , type = '0'):
        """
        gets Frame given nodetype and param
        """
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getFrame( nodetype, param ,type)
    


    def getRelFrame( self ,nodetype, relationtype,ssid='0'):
        """
        """
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getRelFrame( nodetype,relationtype,ssid ) 


    def getInverseName(self , nid):
        """                                                                                                                                                  
        Get the inversename of the given relation type name                                                                                                  
        """
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getInverseName( str(nid) )



    def getInverseNames(self , nids):
        """                                                                                                                                                  
        Get the inversenames of the given relationtypes name                                                                                                  
        """
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getInverseNames( nids )


    def n3_nbhexport(self,ssid,system):
        """
        Gets the neighbourhood as an N3 file of RDF triplets 
        """
        from RDFMethods import *
        connection_string = self.dbadapter.connection_string
        datapath = self.Data.basepath
        #obj = GenGraph( connection_string , datapath )
        return n3_nbhexport(ssid, connection_string,  datapath , system )



    def genN3( self , ssid  , system ):
        """
        Calls the genNBHImage and redirects to the page where the image is
        """
        
        
        self.gnowql.n3_nbhexport( ssid , system )
        self.REQUEST.RESPONSE.redirect( self.portal_url()+"/Data/n3/"+ssid+".txt" )


    def n3_export(self,system):
        """                                                                                                                          
        Exports an entire database into RDF triplets and stores in N3 file in given path.                                             
        If the parameter system corresponds to an ontology present in the database , only the ontology is imported .                           
        """
        from RDFMethods import  *
        connection_string = self.dbadapter.connection_string
        datapath = self.Data.basepath
        return n3_export(connection_string, datapath ,system )



    def searchfs(self,string):
        """                                                                                                             """
        datapath = self.Data.basepath
        uid = '0'

        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )        
        return obj.searchfs( string , uid, datapath)

    
    def n3_schema(self,system):
        """                                                                                                                             
        Exports the schema of given ontology in a database into RDF triplets and stores in N3 file in given path .                      
        """
        from RDFMethods import  *
        connection_string = self.dbadapter.connection_string
        datapath = self.Data.basepath
        return n3_schema(connection_string, datapath ,system )


    def rdf_import(self,url,datapath,file,option,type):
        """                                                                                                                                                 
        Imports N3 file to gnowsys database specified in url                                                                          
        Please ensure that the server specified in the url is on the localhost and the database is empty                             
        System is name of the file , option should be set to 'file', type should be set to 'owl' or  'gnowsys'                                                            
        """
        from RDFMethods import  *
        return rdf_import(url,datapath,file,option,type)

    def getContributors(self , ssid):
        """                                                                                                                            
        Gets contributors for a ssid
        input: ssid
        output: 
        {'146': 'user1', '81': 'admin', '116': 'admin', '58': 'admin', '149': 'user2'}
        """
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getContributors( ssid )


    
    def getModDate(self , ssid):
        """                                                                                                                                   
        Gets modification or creation date for a ssid
        input:ssid
        output:11 August 2009 05:15:15 PM +05:30
        """
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.getModDate( ssid )


        
    def triplesKB(self):
        """
        Gets triples of the entire kb
        """
        from GetMethods import GetMethods
        connection_string = self.dbadapter.connection_string
        obj = GetMethods( connection_string )
        return obj.triplesKB( )


    def getusers(self):
        """                                                                                                                                                         """

        connection_string = self.dbadapter.connection_string
        conn = psycopg2.connect( connection_string )
        curs = conn.cursor()

        query = "select * from auth_schema.users;"
        curs.execute( query )
        usernames = curs.fetchall()
        return usernames


    def getroles(self):
        """                                                                                                                                                         """

        connection_string = self.dbadapter.connection_string
        conn = psycopg2.connect( connection_string )
        curs = conn.cursor()

        query = "select * from auth_schema.roles;"
        curs.execute( query )
        roles = curs.fetchall()
        return roles


registerType(gnowql, PROJECTNAME)
# end of class gnowql

##code-section module-footer #fill in your manual code here
##/code-section module-footer



