
-- This file is part of GNOWSYS: Gnowledge Networking and
-- Organizing System.

-- GNOWSYS is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as
-- published by the Free Software Foundation; either version 3 of
-- the License, or (at your option) any later version.

-- GNOWSYS is distributed in the hope that it will be useful, but
-- WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public
-- License along with GNOWSYS (COPYING); if not, write to the
-- Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
-- Boston, MA  02110-1301  USA59 Temple Place, Suite 330,

--CONTRIBUTORS : Abheeshek Jadhav, jamshed Irani, Roshan Dhupkhaiyaa, aditi meher


--drop type gsearch;
--drop type inid_attributessid_attributetypessid;
--drop type search_nid;
--drop type nid_search;


Create type gsearch AS ( value text, -- this now holds nid of the subject to which there is a in match with the request and not the search itself.
                       ch character varying, -- attributetype nid                       
                       chr character varying, -- value of attribute  from
		       chr_ssid bigint, -- ssid of attribute
                       nodetype character varying,
			subject_inid bigint,
			rnk real);

create type inid_attributessid_attributetypessid AS ( subject_inid  bigint,
						   attributessid  bigint,
						   attributetypessid  bigint,
						    rnk real);

create type search_nid AS ( nid  character varying , nodetype character varying  , ssid bigint , r_nbh Text , nbh Text);

create type nid_search AS (ndtype character varying, ssid bigint);

-----------------------------------------------------------------------------------------------------------------------------


-- Function: plpgsql_call_handler()

-- DROP FUNCTION plpgsql_call_handler();

CREATE OR REPLACE FUNCTION plpgsql_call_handler()
  RETURNS opaque AS
'/usr/lib/postgresql/8.3/lib/plpgsql.so', 'plpgsql_call_handler'
  LANGUAGE 'c' VOLATILE
  COST 1;
ALTER FUNCTION plpgsql_call_handler() OWNER TO postgres;

create language 'plpgsql' HANDLER  plpgsql_call_handler LANCOMPILER 'PL/pgSQL';
------
------

-- install plpython deb packages from the net
-- create language

create language 'plpythonu' HANDLER  plpython_call_handler;







-- Function: search_gnowsys(character varying)

-- DROP FUNCTION search_gnowsys(character varying);

CREATE OR REPLACE FUNCTION search_gnowsys(character varying)
  RETURNS SETOF gsearch AS
$BODY$
Declare

      rec inid_attributessid_attributetypessid;
      item gsearch;
      
      id_atype bigint;
      id_a bigint;

Begin

        select  $1 AS txt Into item.value;
	For rec In select distinct subject_inid , attribute_ssid, attributetype_inid ,ts_rank(value_text_vec, to_tsquery($1)) as Rank  From datatypes_varchar Where  attributetype_inid <> 7  AND (value_text_vec @@ to_tsquery($1)  OR  value LIKE '%'|| $1 ||'%'  OR value LIKE '%'|| lower($1) ||'%')  UNION ALL  select distinct subject_inid , attribute_ssid, attributetype_inid, ts_rank(value_text_vec, to_tsquery($1)) as Rank  From datatypes_text Where  attributetype_inid <> 7     AND (value_text_vec @@ to_tsquery($1)  OR value LIKE '%'|| $1 ||'%'  OR value LIKE '%'|| lower($1) ||'%') Loop

 		select distinct gb.nid into item.ch From gbattributetypes gb   Where gb.ssid = rec.attributetypessid;
 		 
		                           
         	select distinct gbnid.nodetype into item.nodetype From  gbnidssid gbnid 
							Where gbnid.inid = rec.subject_inid;

		select distinct gbnid.nid into item.value From gbnidssid gbnid Where gbnid.inid = rec.subject_inid;

		select distinct dv.value into item.chr	From datatypes_varchar dv Where dv.attribute_ssid = rec.attributessid;
						
		
		select distinct ssid into item.chr_ssid From gbattributes gb where gb.ssid = rec.attributessid;
		
		select rec.subject_inid into item.subject_inid;

                select rec.rnk into item.rnk;

		
	return next item;
      END LOOP;

return;
end$BODY$
  LANGUAGE 'plpgsql' VOLATILE
  COST 100
  ROWS 1000;
ALTER FUNCTION search_gnowsys(character varying) OWNER TO postgres;

----------------------------------------------------------------------------------------------------------------------------

-- Function: search_gnowsys_by_language(character varying, character varying)

-- DROP FUNCTION search_gnowsys_by_language(character varying, character varying);

CREATE OR REPLACE FUNCTION search_gnowsys_by_language(character varying, character varying)
  RETURNS SETOF gsearch AS
$BODY$
Declare

      rec inid_attributessid_attributetypessid;
      item gsearch;
      
      id_atype bigint;
      id_a bigint;

Begin

        select  $1 AS txt Into item.value;
        For rec In select distinct subject_inid , attribute_ssid, attributetype_inid ,ts_rank(value_text_vec, to_tsquery($1)) as Rank  From datatypes_varchar Where  attributetype_inid <> 7  AND (value_text_vec @@ to_tsquery($1)  OR  value LIKE '%'|| $1 ||'%') AND ( language = $2 ) UNION ALL  select distinct subject_inid , attribute_ssid, attributetype_inid, ts_rank(value_text_vec, to_tsquery($1)) as Rank  From datatypes_text Where  attributetype_inid <> 7     AND (value_text_vec @@ to_tsquery($1)  OR  value LIKE '%'|| $1 ||'%')  AND ( language = $2 ) Loop

 		select distinct gb.nid into item.ch From gbattributetypes gb   Where gb.ssid = rec.attributetypessid;
 		 
		                           
         	select distinct gbnid.nodetype into item.nodetype From  gbnidssid gbnid 
							Where gbnid.inid = rec.subject_inid;

		select distinct dv.value into item.chr	From datatypes_varchar dv Where dv.attribute_ssid = rec.attributessid;
						
		
		select distinct ssid into item.chr_ssid From gbattributes gb where gb.ssid = rec.attributessid;
		
		select rec.subject_inid into item.subject_inid;

                select rec.rnk into item.rnk;

		
	return next item;
      END LOOP;

return;
end$BODY$
  LANGUAGE 'plpgsql' VOLATILE
  COST 100
  ROWS 1000;
ALTER FUNCTION search_gnowsys_by_language(character varying, character varying) OWNER TO postgres;

-----------------------------------------------------------------------------------------------------------------------------

-- Function: exact_match(text)

-- DROP FUNCTION exact_match(text);

CREATE OR REPLACE FUNCTION exact_match(text)
  RETURNS SETOF gsearch AS
$BODY$

Declare
     rec inid_attributessid_attributetypessid;
      item gsearch;

Begin

	 select  $1 AS txt Into item.value;
	For rec In select distinct subject_inid , attribute_ssid, attributetype_inid  From datatypes_varchar Where value LIKE '%'|| $1 ||'%'  UNION ALL  select distinct subject_inid , attribute_ssid, attributetype_inid From datatypes_text Where value LIKE '%'|| $1 ||'%' 	Loop
		
		select distinct gb.nid into item.ch From gbattributetypes gb  Where gb.ssid = rec.attributetypessid;
 		 
		                           
         	select distinct gbnid.nodetype into item.nodetype From  gbnidssid gbnid 
							Where gbnid.inid = rec.subject_inid;

		select distinct dv.value into item.chr	From datatypes_varchar dv Where dv.attribute_ssid = rec.attributessid;
						
		
		select distinct ssid into item.chr_ssid From gbattributes gb where gb.ssid = rec.attributessid;
		
		select rec.subject_inid into item.subject_inid;
    
                --select rec.rnk into item.rnk;

		

		
	return next item;
      END LOOP;

return;
end$BODY$
  LANGUAGE 'plpgsql' VOLATILE
  COST 100
  ROWS 1000;
ALTER FUNCTION exact_match(text) OWNER TO postgres;

-----------------------------------------------------------------------------------------------------------------------------

-- Function: searchby_nid(character varying)

-- DROP FUNCTION searchby_nid(character varying);

CREATE OR REPLACE FUNCTION searchby_nid(ch character varying)
  RETURNS SETOF search_nid AS
$BODY$


declare

	
        search search_nid;-- used in order to store related nbh & its related ssid into it inorder to return

begin

	For search IN select nid, nodetype  , max(inid)  from gbnidssid where  value_nid_vec @@ to_tsquery(ch) OR nid LIKE '%'|| ch ||'%' OR nid LIKE '%'|| lower(ch) ||'%' group by nid,nodetype Loop


		IF search.nodetype = 'gbobjects' THEN
			select  gb.rendered_nbh ,gb.nbh into search.r_nbh ,search.nbh from gbobjects gb where gb.ssid = search.ssid;
			return next search;

			ELSIF search.nodetype = 'gbobjecttypes'  THEN
				select  gb.rendered_nbh ,gb.nbh into search.r_nbh ,search.nbh from gbobjecttypes gb where gb.ssid = search.ssid;
				return next search;

			ELSIF search.nodetype = 'gbrelations'  THEN
				select  gb.rendered_nbh ,gb.nbh into search.r_nbh ,search.nbh from gbrelations gb where gb.ssid = search.ssid;
				return next search;

			ELSIF search.nodetype = 'gbrelationtypes'  THEN
				select gb.rendered_nbh ,gb.nbh into search.r_nbh ,search.nbh from gbrelationtypes gb where gb.ssid = search.ssid;
				return next search;

			ELSIF search.nodetype = 'gbusers'  THEN
				select  gb.rendered_nbh ,gb.nbh into search.r_nbh ,search.nbh  from gbusers gb where gb.ssid = search.ssid;
				return next search;

			ELSIF search.nodetype = 'gbprocess'  THEN
				select  gb.rendered_nbh ,gb.nbh into search.r_nbh ,search.nbh  from gbprocess gb where gb.ssid = search.ssid;
				return next search;
	
		END IF;
	END LOOP;
return;
end$BODY$
  LANGUAGE 'plpgsql' VOLATILE
  COST 100
  ROWS 1000;
ALTER FUNCTION searchby_nid(character varying) OWNER TO postgres;

-----------------------------------------------------------------------------------------------------------------------------

-- Function: get_latest_ssid(bigint[])

-- DROP FUNCTION get_latest_ssid(bigint[]);

CREATE OR REPLACE FUNCTION get_latest_ssid(ary bigint[])
  RETURNS SETOF bigint[] AS
$BODY$
Declare

	cnt bigint;
        sid bigint;
        range bigint;
        value bigint[][];

Begin 

	select array_upper(ary,1) into range;

	For cnt IN 1..range Loop
		select ARRAY[ary[cnt],max(gbl.ssid)] into value from gbnidssid gb, gbnid_latestssid gbl where gb.nid = gbl.nid AND gb.ssid =  ary[cnt] group by gbl.nid;
			return next value;
	END Loop;

return;
end$BODY$
  LANGUAGE 'plpgsql' VOLATILE
  COST 100
  ROWS 1000;
ALTER FUNCTION get_latest_ssid(bigint[]) OWNER TO postgres;

-----------------------------------------------------------------------------------------------------------------------------

-- Function: getlatest_ssid_from_listofnid(character varying[])

-- DROP FUNCTION getlatest_ssid_from_listofnid(character varying[]);

CREATE OR REPLACE FUNCTION getlatest_ssid_from_listofnid(ary character varying[])
  RETURNS bigint[] AS
$BODY$

declare
-- to get list of latest ssid based on given list of nids.
	id bigint;
	i bigint;
	range bigint;
        value bigint[];

begin

	Select array_upper(ary,1) into range;

	For i IN 1..range Loop

			select ssid into id from gbnid_latestssid where nid = ary[i];
			select array_append(value,id) into value;
			
			
	End Loop;

return  value ;
End$BODY$
  LANGUAGE 'plpgsql' VOLATILE
  COST 100;
ALTER FUNCTION getlatest_ssid_from_listofnid(character varying[]) OWNER TO postgres;

-----------------------------------------------------------------------------------------------------------------------------

-- Function: getnbh(bigint, bigint)

-- DROP FUNCTION getnbh(bigint, bigint);

CREATE OR REPLACE FUNCTION getnbh(snap_shot_id bigint, nodetyp_id bigint)
  RETURNS text AS
$BODY$

Declare
	ndtype character varying;
        rnbh text;
Begin 

     select nodetype into ndtype from gbnidssid where inid = nodetyp_id AND ssid = snap_shot_id ;
     
	IF ndtype = 'gbobjects' THEN
			select gb.rendered_nbh  into rnbh from gbobjects gb where gb.ssid = snap_shot_id;
		

			ELSIF ndtype = 'gbobjecttypes'  THEN
				select gb.rendered_nbh into rnbh from gbobjecttypes gb where gb.ssid = snap_shot_id;
				

			ELSIF ndtype = 'gbrelations'  THEN
				select gb.rendered_nbh into rnbh from gbrelations gb where gb.ssid = snap_shot_id;

			ELSIF ndtype = 'gbrelationtypes'  THEN
				select gb.rendered_nbh into rnbh  from gbrelationtypes gb where gb.ssid = snap_shot_id;

			ELSIF ndtype = 'gbattributes' THEN
				select gb.rendered_nbh into rnbh from gbattributes gb where gb.ssid = snap_shot_id;

			ELSIF ndtype = 'gbattributetypes' THEN
				select gb.rendered_nbh into rnbh from gbattributetypes gb where gb.ssid = snap_shot_id;
		
			ELSIF ndtype = 'gbusers' THEN
				select gb.rendered_nbh into rnbh from gbusers gb where gb.ssid = snap_shot_id;

			ELSIF ndtype = 'gbprocess' THEN
				select gb.rendered_nbh into rnbh from gbprocess gb where gb.ssid = snap_shot_id;
				
	END IF;
return rnbh;
end$BODY$
  LANGUAGE 'plpgsql' VOLATILE
  COST 100;
ALTER FUNCTION getnbh(bigint, bigint) OWNER TO postgres;

-----------------------------------------------------------------------------------------------------------------------------

-- Function: python_searchby_nid(text, text)

-- DROP FUNCTION python_searchby_nid(text, text);

CREATE OR REPLACE FUNCTION python_searchby_nid(text, text)
  RETURNS text AS
$BODY$
import cPickle
from base64 import b64encode,b64decode

item = args[0]
ans = args[1]



if ans == "neigh":
	p_stmt = plpy.prepare("select nid , nodetype , ssid , nbh from searchby_nid($1)",["text"])
	e_stmt = plpy.execute(p_stmt,[item])
	n_bh = cPickle.loads(b64decode(e_stmt[0]["nbh"]))
	return n_bh;
	
if ans == "ren":
	p_stmt = plpy.prepare("select nid , nodetype , ssid , r_nbh  from searchby_nid($1)",["text"])
	e_stmt = plpy.execute(p_stmt,[item])
	re_nbh = cPickle.loads(b64decode(e_stmt[0]["r_nbh"]))
	return re_nbh;
	 
if ans == "both":
	p_stmt = plpy.prepare("select nid , nodetype , ssid , r_nbh , nbh from searchby_nid($1)",["text"])
	e_stmt = plpy.execute(p_stmt,[item])
	re_nbh = cPickle.loads(b64decode(e_stmt[0]["r_nbh"]))
	n_bh = cPickle.loads(b64decode(e_stmt[0]["nbh"]))
	return (re_nbh,n_bh);

end $BODY$
  LANGUAGE 'plpythonu' VOLATILE
  COST 100;
ALTER FUNCTION python_searchby_nid(text, text) OWNER TO postgres;





