# -*- coding: utf-8 -*- 
#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################


__contributor__= """   Jay Mehta (jay87.mehta@gmail.com)  """
__docformat__ = 'plaintext'





#!/usr/bin/env python

import os.path
import sys
import psycopg2
import psycopg2.extensions
import psycopg2.extras

dbname = raw_input("DATABASE NAME: ")
username = raw_input("USERNAME: ")
password = raw_input("PASSWORD: ")
host = raw_input("HOST: ")
"""
dbname = <postgres_databasename>
username = <postgres_username>
password = <postgres_password>
host = 'localhost'
"""
connection_string1 = "user="+username+"  "+"password="+password+"  "+"dbname=postgres  "+"host="+host
conn = psycopg2.connect( connection_string1 )
curs = conn.cursor()
create_database_query = "CREATE DATABASE "+ dbname +" ENCODING = 'UTF8' TABLESPACE= pg_default TEMPLATE = template0;"
print create_database_query
conn.set_isolation_level(0)
curs.execute(create_database_query)
conn.commit()
curs.close()
conn.close()

con_string = "user="+username+"  "+"password="+password+"  "+"dbname="+dbname+"  "+"host="+host

conn1 = psycopg2.connect(con_string)
curs1 = conn1.cursor()
fread = open('GnowsysSchema.sql','r')
data = fread.read()
#print data
curs1.execute(data)
fread.close()
conn1.commit()
sql="select count(*) from pg_tables;"
curs1.execute(sql)
rows = curs1.fetchall()
try:
      if rows[0][0]==126:
            print"successful test database schema generation"
      else:
            print"Some problem encountered while creating test database . please rerun"
except:
            print"Some problem encountered while creating test database . please rerun"

fread = open('pythonu_methods.sql','r')
data = fread.read()
curs1.execute(data)
conn1.commit()
fread.close()


curs1.close()
conn1.close()

from SetMethods import SetMethods
from DeleteMethods import Delete
import unittest

MT1_ssid =""
OT1_ssid=""
OT1_ssid_withRel=""
OT2_ssid=""
RT1_ssid=""
AT1_ssid=""
sub_OT1_ssid=""
sub_OT12_ssid=""
O1_ssid =""      
O12_ssid = ""
O1_subO1_ssid = ""
#F1_ssid=""
UT1_ssid = ""
UT2_ssid = ""

RT2_ssid = ""
PT1_ssid=""
Username_AT_ssid=""
Password_AT_ssid=""
Email_AT_ssid=""

class gnowsysTest(unittest.TestCase):
         
      def setUp(self):
          #print "Setup invoked"  
          #import xmlrpclib
          #self.con = xmlrpclib.Server("http://admin:admin@localhost:8080/gnow/gnowql")
          pass  
   
      #def test_metatype(self):
      def test1(self):
          print"testing METATYPE"  
          input = {
                'nid':'Metatype 1',
                'status':'public',
                'nodetype':'metatype',
                'attributes':[('title','Metatype1'),('description','the first Meta type')],
                'language':'en'
                }
          #print input
          #check 1 

          global con_string
          SM_obj = SetMethods(con_string,1)
          Mt1_ssid = SM_obj.setnode(input)['new_subject_ssid']
          print "MT1_ssid-",Mt1_ssid
          self.assertTrue( Mt1_ssid.isdigit() ,Mt1_ssid)
          global MT1_ssid 
          MT1_ssid = Mt1_ssid

      #def test_setOT(self):    
      def test2(self):    
          print"testing OBJECTTYPE"  
          global con_string
          SM_obj = SetMethods(con_string,1)
          global MT1_ssid 
          input={}
          input = {
                'nid':'OT1',
                'status':'public',
                'nodetype':'objecttype',
                'instanceof':[ MT1_ssid],
                'attributes':[('title','first OT1'),('description','the first OT1 an instanceof MT1')] ,
                'language':'english'
                }
          #check 1 
          #print input
          Ot1_ssid = SM_obj.setnode(input)['new_subject_ssid']
          self.assertTrue( Ot1_ssid.isdigit() ,Ot1_ssid)
          global OT1_ssid
          OT1_ssid = Ot1_ssid
          print "OT1_ssid",OT1_ssid
          #check 2
          #print input
          SM_obj = SetMethods(con_string,1)
          status_msg = SM_obj.setnode(input)
          self.assertTrue( status_msg =='nid exists. cant create again with the same nid.','nid exists. cant create again with the same nid.')

          input={}
          input = {
                'nid':'OT2',
                'status':'public',
                'nodetype':'objecttype',
                'instanceof':[ MT1_ssid]
                }
          # check 3
          #print input
          SM_obj = SetMethods(con_string,1)
          Ot2_ssid = SM_obj.setnode(input)['new_subject_ssid']
          self.assertTrue( Ot2_ssid.isdigit() , Ot2_ssid)
          global OT2_ssid 
          OT2_ssid = Ot2_ssid
          print" OT2_ssid" ,OT2_ssid

          input={}
          input = {
                'nid':'subtypeof-OT1',
                'status':'public',
                'nodetype':'objecttype',
                'subtypeof':[OT1_ssid],
                'attributes':[('title','subtypeof-OT1'),('description','the first subtypeof OT1')],
                'language':'english'
                
                }
          #check 4
          #print input
          SM_obj = SetMethods(con_string,1)
          sub_Ot1_ssid = SM_obj.setnode(input)['new_subject_ssid']
          self.assertTrue( sub_Ot1_ssid.isdigit() ,sub_Ot1_ssid)
          global sub_OT1_ssid 
          sub_OT1_ssid = sub_Ot1_ssid
          print " sub_OT1_ssid", sub_OT1_ssid

          input={}
          input = {
                'nid':'subtypeof-OT12',
                'status':'public',
                'nodetype':'objecttype',
                'subtypeof':[OT1_ssid,OT2_ssid],
                }
          #check 5
          #print input
          SM_obj = SetMethods(con_string,1)
          sub_Ot12_ssid = SM_obj.setnode(input)['new_subject_ssid']
          self.assertTrue( sub_Ot12_ssid.isdigit() ,sub_Ot12_ssid)
          global sub_OT12_ssid 
          sub_OT12_ssid = sub_Ot12_ssid
          print "sub_OT12_ssid",sub_OT12_ssid 
          
      #def test_setRT(self):    
      def test3(self):    
          print"testing RELATIONTYPE"  
          global con_string
          SM_obj = SetMethods(con_string,1)
          
          input = {
                'nodetype':'relationtype',
                'nid':'Depends-ON',
                'status':'Public',
                'inversename':'Required for',
                'subjecttype1':['OT2'],
                'subjecttype2':['OT1'],
                'applicablenodetypes':'types'
                }
          #check 1
          #print input
          Rt1_ssid = SM_obj.setnode(input)
          self.assertTrue( Rt1_ssid.isdigit() ,Rt1_ssid)
          print Rt1_ssid

          SM_obj = SetMethods(con_string,1)
          input = {
                'nodetype':'relationtype',
                'nid':'Depends-ON',
                'status':'Public',
                'inversename':'Required for',
                'subjecttype1':['subtypeof-OT1','subtypeof-OT12'],
                'subjecttype2':['OT1'],
                'applicablenodetypes':'types'
                }
          #check 2
          #print input
          Rt1_ssid = SM_obj.setnode(input)
          self.assertTrue( Rt1_ssid.isdigit() ,Rt1_ssid)
          global RT1_ssid  
          RT1_ssid = Rt1_ssid
          print Rt1_ssid
          
      #def test_setAT(self):  
      def test4(self):  
          print"testing ATTRIBUTETYPE"  
          global con_string
          SM_obj = SetMethods(con_string,1)
            
          input =  {
                'nid':'stage_status',# [mandatory field]                                                                                                    
                'status':'public',
                'subjecttypes':['OT1','OT2'], #  (list of ssids of types)    [mandatory field]       
                'restrictiontype':1, #    (1 indicates valuerestriction) [mandatory field]                                                                  
                'datatype':'text[]' , #   (selected from a list of datatypes) [mandatory field]                                                             
                'nodetype':'attributetype',
                'regex':'',
                'applicablenodetypes':'types'
                 }
          #check 1
          #print input
          At1_ssid = SM_obj.setnode(input)
          self.assertTrue( At1_ssid.isdigit() , At1_ssid)
          global AT1_ssid
          AT1_ssid = At1_ssid
          print AT1_ssid
      
      #def test_setO(self):    
      def test5(self):    
          print"testing OBJECT"              
          global con_string
          SM_obj = SetMethods(con_string,1)
          
          global OT1_ssid
          global OT2_ssid
          global sub_OT1_ssid
          input = {
                'nodetype':'object',
                'nid':'O1',
                'status':'public',
                'instanceof':[OT1_ssid]
                }
          #check 1
          #print input
          
          o1_ssid = SM_obj.setnode(input)['new_subject_ssid']
          self.assertTrue( o1_ssid.isdigit() , o1_ssid)
          global O1_ssid
          O1_ssid = o1_ssid
          print "O1_ssid",O1_ssid

          SM_obj = SetMethods(con_string,1)
          input={}
          input = {
                'nodetype':'object',
                'nid':'O12',
                'status':'public',
                'instanceof':[OT1_ssid,OT2_ssid]
                }
          #check 2
          #print input
          o12_ssid = SM_obj.setnode(input)['new_subject_ssid']
          self.assertTrue( o12_ssid.isdigit() , o12_ssid)
          global O12_ssid
          O12_ssid = o12_ssid
          print "O12_ssid",O12_ssid

          SM_obj = SetMethods(con_string,1)
          input={}
          input = {
                'nodetype':'object',
                'nid':'O1_subO1',
                'status':'public',
                'instanceof':[OT1_ssid, sub_OT1_ssid],
                'attributes':[('title','O1_subO1'),('description','this is object instanceof O1 and subtypeof-O1'),('stage_status',["week1 start: pre-planning Stage"])],
                'language':'english'
                }
          #check 3
          #print input
          o1_subO1_ssid = SM_obj.setnode(input)['new_subject_ssid']
          self.assertTrue( o1_subO1_ssid.isdigit() , o1_subO1_ssid)
          global O1_subO1_ssid
          O1_subO1_ssid = o1_subO1_ssid
          print "O1_subO1_ssid",O1_subO1_ssid

      #def test_A(self):        
      def test6(self):    
          print"testing ATTRIBUTE"  
          global con_string
          SM_obj = SetMethods(con_string,1)

          global OT1_ssid  
          input = {
                'nodetype':'attribute',
                'status':'Public',
                'instanceof':[('stage_status',["week1 end: pre-planning Stage","week2 start: breifing stage"])],
                'subject':OT1_ssid,
                'language':'english'
                }
          #check 1
          #print input
          ssid_list = SM_obj.setnode(input)
          print ssid_list
          self.assertTrue( isinstance(ssid_list,list) ,ssid_list)  
          OT1_ssid = str( ssid_list[0][0] )
          print" OT1_ssid", OT1_ssid

      
      #def test_R(self):    
      def test7(self):    
          print "=======================Relations======================="  
          global con_string
          SM_obj = SetMethods(con_string,1)
          #check 1. relation between types
          global sub_OT1_ssid,sub_OT12_ssid, OT2_ssid, OT1_ssid
          global OT1_ssid_withRel
          input = {
          'nodetype':'relation',
          'status':'Public',
          'subject1':[sub_OT1_ssid, sub_OT12_ssid, OT2_ssid],
          'subject2':[OT1_ssid],
          'relationtypes':'Depends-ON'
          }
          #print input
          ssid_list =  SM_obj.setnode(input)
          self.assertTrue( isinstance(ssid_list,list) ,ssid_list)
          print "WATCH ==",ssid_list
          sub_OT1_ssid = ssid_list[0][0]
          sub_OT12_ssid = ssid_list[0][1]
          OT2_ssid = ssid_list[0][2]
          OT1_ssid_withRel = ssid_list[1][0]

          #check 2. relation between tokens
          SM_obj = SetMethods(con_string,1)
          global O1_ssid, O12_ssid, O1_subO1_ssid
          input={}
          input = {
          'nodetype':'relation',
          'status':'Public',
          'subject1':[O12_ssid],
          'subject2':[O1_ssid],
          'relationtypes':'Depends-ON'
          }

          #print input
          ssid_list = SM_obj.setnode(input)
          self.assertTrue( isinstance(ssid_list,list) ,ssid_list)
          #print ssid_list

          SM_obj = SetMethods(con_string,1)
          input={}
          input = {
          'nodetype':'relation',
          'status':'Public',
          'subject1':[O1_subO1_ssid],
          'subject2':[O1_ssid],
          'relationtypes':'Depends-ON'
          }

          #print input
          ssid_list = SM_obj.setnode(input)
          self.assertTrue( isinstance(ssid_list,list) ,ssid_list)
          #print ssid_list

          SM_obj = SetMethods(con_string,1)
          input={}
          input = {
          'nodetype':'relation',
          'status':'Public',
          'subject1':[O12_ssid,O1_subO1_ssid],
          'subject2':[O1_ssid],
          'relationtypes':'Depends-ON'
          }

          #print input
          ssid_list = SM_obj.setnode(input)
          #print ssid_list
          self.assertTrue( isinstance(ssid_list,list) ,ssid_list)

      #def test_set_relation(self):    
      def test8(self): 
          print "testing RELATIONS"  
          global con_string
          SM_obj = SetMethods(con_string,1)

          input = {
          'nodetype':'relation',
          'status':'Public',
          'subject1':[O12_ssid,O1_subO1_ssid],
          'subject2':[O1_ssid],
          'relationtypes':'Depends-ON',
          'nodetype1_list':['gbobjects'],
          'set_relation':'1'
          }

          #print input
          one= SM_obj.set_relation(input)
          #print one
          self.assertEqual(one,1 ,one)
      
      #def test_setfunc(self):    
      def test9(self):
          global con_string
          SM_obj = SetMethods(con_string,1)


          print"-----------------functions-----------------------------"  
          global MT1_ssid  
          #check1
          input = {
                 'nid':'F1',
                 'status':'public',
                 'nodetype':'function',
                 'instanceof':[MT1_ssid],
                 'language':'en',
                 'attributes':[('title','F1 '),('description','first Function.')]
                 }
          #print input
          f1_ssid = SM_obj.setnode(input)['new_subject_ssid']
          self.assertTrue( f1_ssid.isdigit() , f1_ssid)
          print f1_ssid
          #global F1_ssid
          F1_ssid = f1_ssid
          
          #check 2
          SM_obj = SetMethods(con_string,1)
          input = {
                'nodetype':'relationtype',
                'nid':'Depends-ON',
                'status':'Public',
                'inversename':'Required for',
                'subjecttype1':['F1'],
                'subjecttype2':['F1'],
                'applicablenodetypes':'types'
                }
          #print input
          Rt1_ssid = SM_obj.setnode(input)
          self.assertTrue( Rt1_ssid.isdigit() ,Rt1_ssid)
          #print Rt1_ssid

          #check 3 
          SM_obj = SetMethods(con_string,1)
          input = {
                 'nid':'sub-F1',
                 'status':'public',
                 'nodetype':'function',
                 'instanceof':[MT1_ssid],
                 'subtypeof':[F1_ssid],
                 'language':'en',
                 'attributes':[('title','sub-F1 '),('description','first Function which is subtypeof another function and instanceof metatype.')],
                 'relation':[('Depends-ON',[F1_ssid])]
                 }
          #print input
          minus_one = SM_obj.setnode(input)
          #print minus_one
          self.assertEqual(minus_one,-1 ,minus_one)
          
          #check 4
          SM_obj = SetMethods(con_string,1)
          input = {
                 'nid':'sub-F2',
                 'status':'public',
                 'nodetype':'function',
                 'instanceof':[MT1_ssid],
                 'subtypeof':[F1_ssid],
                 'language':'en',
                 'attributes':[('title','sub-F2 '),('description','second Function which is subtypeof another function')]
                 }
          #print input
          sub_f2_ssid = SM_obj.setnode(input)['new_subject_ssid']
          #print sub_f2_ssid
          self.assertTrue( sub_f2_ssid.isdigit() , sub_f2_ssid)


          #check 5
          SM_obj = SetMethods(con_string,1)
          input = {
                 'nid':'sub-F1',
                 'status':'public',
                 'nodetype':'function',
                 'instanceof':[MT1_ssid],
                 'subtypeof':[F1_ssid],
                 'language':'en',
                 'attributes':[('title','sub-F1 '),('description','first Function which is subtypeof another function and is dependent on a function')],
                 'relation':[('Depends-ON',[sub_f2_ssid])]
                 }
          #print input
          sub_f1_ssid = SM_obj.setnode(input)['new_subject_ssid']
          #print sub_f1_ssid
          self.assertTrue( sub_f1_ssid.isdigit() , sub_f1_ssid)

      #def test10(self): 
      def testPT(self):    
          print"=============================================Processtype================================================================="
          global con_string
          #check 1
          global PT1_ssid
          #print con_string
          SM_obj = SetMethods(con_string,1)
          global MT1_ssid
          global OT1_ssid
          global O1_ssid

          input = {
                'nid':'ProcessType1',
                'status':'public',
                'instanceof':[MT1_ssid],
                'priorstatedef':[OT1_ssid],
                'poststatedef':[OT2_ssid],
                'nodetype':'processtype',
                'attributes':[('title','ProcessType1'),('description','the first process type .')],
                'language':'en'
                }
      
          #print input
          pt1_ssid = SM_obj.setnode(input)['new_subject_ssid']
          print pt1_ssid
          self.assertTrue( pt1_ssid.isdigit() , pt1_ssid)
          PT1_ssid = pt1_ssid

      def test_delete(self):
          print"-----------------Delete-----------------------------"  
          global con_string  
          global OT2_ssid  
          #check1
          global OT1_ssid  
          D_obj = Delete(con_string,1)
          input=   {
                'subject':OT1_ssid,
                'status':'public',
                'commit':'1',
                'relation':[('Depends-ON','leftroles', [OT2_ssid] )],
                'attributes': ['title','stage_status']
                }
          #print input
          msg = D_obj.delete(input)
          #print msg
          self.assertEqual( msg,'invalid input. subject doesnot have this relationtypenid.' , msg)          
          #check 2
          global OT1_ssid_withRel  
          D_obj = Delete(con_string,1)
          input=   {
                'subject':OT1_ssid_withRel,
                'status':'public',
                'commit':'1',
                'relation':[('Depends-ON','leftroles', [OT2_ssid] )],
                'attributes': ['title','stage_status']
                }
          #print input
          ssid= D_obj.delete(input)
          #print ssid
          self.assertTrue( ssid.isdigit() , ssid)          
          OT1_ssid = ssid


      #def test11(self): 
      def test_process(self):    
          global con_string
          print"============================================Process=================================================================="
          #check 1
          global PT1_ssid
          SM_obj = SetMethods(con_string,1)
          global O12_ssid
          global O1_ssid

          input = {
                'nid':'Process1',
                'status':'public',
                'instanceof':[PT1_ssid],
                'priorstate':[O1_ssid],
                'poststate':[O12_ssid],
                'nodetype':'process',
                'attributes':[('title','Process1'),('description','the first process .')],
                'language':'en'
                }
      
          #print input
          p1_ssid = SM_obj.setnode(input)['new_subject_ssid']
          print p1_ssid
          self.assertTrue( p1_ssid.isdigit() , p1_ssid)
          P1_ssid = p1_ssid
     
      def test_setUType(self): 
          print"-----------------Usertype-----------------------------"            
          #def test12(self):    
          global con_string
          #check 1
          SM_obj = SetMethods(con_string,1)
          input = {
                'nid':'gnowsys_tester_forum',
                'status':'public',
                'attributes':[('title','gnowsys_tester_forum'),('description','All gnowsys tester are members.')],
                'language':'en',
                'nodetype':'usertype'
                }
          #print input
          ut1_ssid = SM_obj.setnode(input)['new_subject_ssid']
          print ut1_ssid
          self.assertTrue( ut1_ssid.isdigit() , ut1_ssid)
          global UT1_ssid
          UT1_ssid = ut1_ssid

          #check2
          SM_obj = SetMethods(con_string,1)
          input = {
                'nid':'gnowsys_document_forum',
                'status':'public',
                'subtypeof':['5'],
                'attributes':[('title','gnowsys_document_forum'),('description','All gnowsys document writers are members.')],
                'language':'en',
                'nodetype':'usertype'
                }
          #print input
          ut2_ssid = SM_obj.setnode(input)['new_subject_ssid']
          print ut2_ssid
          self.assertTrue( ut2_ssid.isdigit() , ut2_ssid)
          global UT2_ssid
          UT2_ssid = ut2_ssid
          
          #check 3

          SM_obj = SetMethods(con_string,1)

          input = {
                'nodetype':'relation',
                'status':'Public',
                'subject1':[UT1_ssid],
                'subject2':['5'],
                'relationtypes':'subtypeof',
                'nodetype1_list':['gbusertypes'],
                'set_relation':'1'
                }

          #print input
          one= SM_obj.set_relation(input)
          #print one
          self.assertEqual(one,1 ,one)

          #check 4
          SM_obj = SetMethods(con_string,1)
          input = {
                'nodetype':'relationtype',
                'nid':'grouped',
                'status':'Public',
                'inversename':'form group',
                'subjecttype2':['gnowsys_tester_forum'],
                'subjecttype1':['gnowsys_document_forum'],
                'applicablenodetypes':'types'
                }
          #print input
          Rt2_ssid = SM_obj.setnode(input)
          self.assertTrue( Rt2_ssid.isdigit() ,Rt2_ssid)
          global RT2_ssid
          RT2_ssid = Rt2_ssid
          print Rt2_ssid

          #check 5
          SM_obj = SetMethods(con_string,1)
          input =  {
                'nid':'username',# [mandatory field]                                                                                                    
                'status':'public',
                'subjecttypes':['gnowsys_document_forum','gnowsys_tester_forum'], #  (list of ssids of types)    [mandatory field]       
                'restrictiontype':1, #    (1 indicates valuerestriction) [mandatory field]                                                                  
                'datatype':'text[]' , #   (selected from a list of datatypes) [mandatory field]                                                             
                'nodetype':'attributetype',
                'regex':'',
                'applicablenodetypes':'types'
                 }
          #print input
          username_At_ssid = SM_obj.setnode(input)
          self.assertTrue( username_At_ssid.isdigit() , username_At_ssid)
          global Username_AT_ssid
          Username_AT_ssid = username_At_ssid
          #print Username_AT_ssid

          #check 6
          SM_obj = SetMethods(con_string,1)
          input =  {
                'nid':'email',# [mandatory field]                                                                                                    
                'status':'public',
                'subjecttypes':['gnowsys_document_forum','gnowsys_tester_forum'], #  (list of ssids of types)    [mandatory field]       
                'restrictiontype':1, #    (1 indicates valuerestriction) [mandatory field]                                                                  
                'datatype':'text[]' , #   (selected from a list of datatypes) [mandatory field]                                                             
                'nodetype':'attributetype',
                'regex':'',
                'applicablenodetypes':'types'
                 }
          #print input
          email_At_ssid = SM_obj.setnode(input)
          self.assertTrue( email_At_ssid.isdigit() , email_At_ssid)
          global Email_AT_ssid
          Email_AT_ssid = email_At_ssid
          #print Email_AT_ssid

          #check 7
          SM_obj = SetMethods(con_string,1)
          input =  {
                'nid':'password',# [mandatory field]                                                                                                    
                'status':'public',
                'subjecttypes':['gnowsys_document_forum','gnowsys_tester_forum'], #  (list of  of types)    [mandatory field]       
                'restrictiontype':1, #    (1 indicates valuerestriction) [mandatory field]                                                                  
                'datatype':'text[]' , #   (selected from a list of datatypes) [mandatory field]                                                             
                'nodetype':'attributetype',
                'regex':'',
                'applicablenodetypes':'types'
                 }
          #print input
          password_At_ssid = SM_obj.setnode(input)
          self.assertTrue( password_At_ssid.isdigit() , password_At_ssid)
          global Password_AT_ssid
          Password_AT_ssid = password_At_ssid
          #print password_At_ssid

      def test_setUser(self): 
          #def test13(self):    
          global con_string
          print"-----------------USer-----------------------------"  
          #check 1
          global UT1_ssid
          SM_obj = SetMethods(con_string,1)
          input = {
                'nodetype':'user',
                'status':'public',
                'instanceof':['5',UT1_ssid],
                'attributes':[('username','g-tester1'),('password','g-tester1'),('email','gtester1@gmail.com')],
                'language':'en',
                'nid':'gtester-1'
                }

          #print input
          u1_ssid = SM_obj.setnode(input)['new_subject_ssid']
          print u1_ssid
          self.assertTrue( u1_ssid.isdigit() , u1_ssid)
          #check2
          global UT2_ssid
          SM_obj = SetMethods(con_string,1)
          input = {
                'nodetype':'user',
                'status':'public',
                'instanceof':[UT2_ssid],
                'attributes':[('username','g-documenter1'),('password','g-documenter1'),('email','gdocumenter1@gmail.com')],
                'language':'en',
                'nid':'gtester-2',
                'relation':[('grouped',[u1_ssid])]
                }
          #print input
          u2_ssid = SM_obj.setnode(input)['new_subject_ssid']
          print "u2ssid",u2_ssid
          self.assertTrue( u2_ssid.isdigit() , u2_ssid)


      def test_up(self):
          from UpdateMethods import Update  
          global con_string
          print"-----------------Update-----------------------------"  
          global OT1_ssid
          input = {
                'nodetype':'relationtype',
                'nid':'partof',
                'status':'Public',
                'inversename':'consists',
                'subjecttype1':['OT2'],
                'subjecttype2':['OT1'],
                'applicablenodetypes':'types'
                }
          #check 1
          #print input
          SM_obj = SetMethods(con_string,1)          
          Rt_ssid = SM_obj.setnode(input)
          self.assertTrue( Rt_ssid.isdigit() ,Rt_ssid)
          #print Rt_ssid

          input = {
                'nodetype':'object',
                'nid':'O3',
                'status':'public',
                'instanceof':[OT2_ssid],
                'language':'en',
                'attributes':[('title','Object3'),('description','this is created to test update')]
                }
          #print input
          SM_obj = SetMethods(con_string,1)          
          o3_ssid = SM_obj.setnode(input)['new_subject_ssid']
          self.assertTrue( o3_ssid.isdigit() , o3_ssid)
          global O3_ssid
          O3_ssid = o3_ssid
          #print "O3_ssid",O3_ssid
          
          UP_obj = Update(con_string,1)
          global O1_ssid
          print "--------------start updating=============================="
          input = {
            'status':'public',
            'subject':O3_ssid,
            'language':'en',
            'commit':'1',
            'relation':[('Depends-ON',[O1_ssid]),('partof',[O1_ssid])],
            'attributes':[('title','object3'),('description','this is created to test update with dual reln on same subject')]
            }
          #print input
          if input.has_key('mandatoryfields'):
                if input.has_key('attributes'):   
                      input['attributes'].append(('mandatoryflds',input['mandatoryfields']))   
                else:
                      input['attributes']=[('mandatoryflds',input['mandatoryfields'])]
                input.pop('mandatoryfields')
                
          if input.has_key('attributes'):
                input['instanceof']=input['attributes']
                input.pop('attributes')
                
          newo3_ssid = UP_obj.Update(input)['new_subject_ssid']
          self.assertTrue( newo3_ssid.isdigit() , newo3_ssid)
   

            
      def tearDown(self):
          #print "tear down invoked"  
          pass  

if __name__ == '__main__':
    unittest.main()
    #or
    #suite = unittest.TestLoader().loadTestsFromTestCase(DefaultWidgetSizeTestCase)
    #unittest.TextTestRunner(verbosity=2).run(suite)
