# -*- coding: utf-8 -*-

#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################



__author__ = """Nagarjuna G. <nagarjun@gnu.org>"""
__author__ = """Rajiv Nair <rajivnair@gnu.org>"""
__docformat__ = 'plaintext'


import logging
logger = logging.getLogger('gnowsysApp_rc1: setuphandlers')
from Products.gnowsysApp_rc1.config import PROJECTNAME
from Products.gnowsysApp_rc1.config import DEPENDENCIES
from Products.CMFCore.utils import getToolByName
import transaction
import os
import random
import md5
##code-section HEAD
##/code-section HEAD

def isNotgnowsysApp_rc1Profile(context):
    return context.readDataFile("gnowsysApp_rc1_marker.txt") is None


def updateRoleMappings(context):
    """after workflow changed update the roles mapping. this is like pressing
    the button 'Update Security Setting' and portal_workflow"""
    
    if isNotgnowsysApp_rc1Profile(context): return 
    wft = getToolByName(context.getSite(), 'portal_workflow')
    wft.updateRoleMappings()


def postInstall(context):
    """Called as at the end of the setup process. """


    site = context.getSite()
    site.invokeFactory('gnowql', 'gnowql')

    
    inspath = site.portal_url()
    splitpath = inspath.split('/')
    insname = str(splitpath[-1])

    data_path = CLIENT_HOME + "/GB/" + insname  + "/"
    data_subdirs = ["nbhimages","n3"]
    for eachdir in data_subdirs:
        if not(os.path.exists(data_path + eachdir)):
            os.makedirs(data_path + eachdir)


    site.manage_addProduct['LocalFS'].manage_addLocalFS('Data', '', data_path)
    site.manage_addProduct['ZPsycopgDA'].manage_addZPsycopgConnection('dbadapter', 'Connection to PG', '', zdatetime=None, tilevel=2, check=None, REQUEST=None)


    file = open('/tmp/DBconnectionstring.txt','r')
    constring = file.read()
    file.close()
    site.dbadapter.connection_string = constring
    site.dbadapter.encoding = 'UTF-8'
    site.dbadapter.manage_open_connection()
    

    values = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890"
    min = 7
    max = 7
    passwdlist = random.sample(values,random.randint(min,max))
    password = ''

    for value in passwdlist:
        password = password + value
      
    input = {
      'nodetype':'user',
      'status':'public',
      'instanceof':['5'],
      'attributes':[('username','gnowsys'),('password',password),('email','gnowsys@gmail.com')]
       }
    site.gnowql.setnode( input )  

    input = {
      'nid':'ONTOLOGY',
      'status':'public',
      'nodetype':'metatype',
      'uid':'1'
      }
    site.gnowql.setnode( input )

    file = open(INSTANCE_HOME+'/Products/gnowsysApp_rc1/inituser.txt','w')
    file.write('username: gnowsys')
    file.write('\n')
    file.write('password: '+password)
    file.close
    
    
    if isNotgnowsysApp_rc1Profile(context): return 
    site = context.getSite()


##code-section FOOT
##/code-section FOOT
