/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.Vector;
import net.percederberg.grammatica.parser.ProductionPatternRule;

public class ProductionPattern {
    private int id;
    private String name;
    private boolean syntetic;
    private Vector rules;

    public ProductionPattern(int id, String name) {
        this.id = id;
        this.name = name;
        this.syntetic = false;
        this.rules = new Vector();
    }

    public boolean isSyntetic() {
        return this.syntetic;
    }

    public boolean isLeftRecursive() {
        int i = 0;
        while (i < this.rules.size()) {
            ProductionPatternRule rule = (ProductionPatternRule)this.rules.get(i);
            if (rule.isLeftRecursive()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isRightRecursive() {
        int i = 0;
        while (i < this.rules.size()) {
            ProductionPatternRule rule = (ProductionPatternRule)this.rules.get(i);
            if (rule.isRightRecursive()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isMatchingEmpty() {
        int i = 0;
        while (i < this.rules.size()) {
            ProductionPatternRule rule = (ProductionPatternRule)this.rules.get(i);
            if (rule.isMatchingEmpty()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setSyntetic(boolean syntetic) {
        this.syntetic = syntetic;
    }

    public int getRuleCount() {
        return this.rules.size();
    }

    public ProductionPatternRule getRule(int pos) {
        return (ProductionPatternRule)this.rules.get(pos);
    }

    public void addRule(ProductionPatternRule rule) {
        rule.setPattern(this);
        this.rules.add(rule);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        StringBuffer indent = new StringBuffer();
        buffer.append(this.name);
        buffer.append("(");
        buffer.append(this.id);
        buffer.append(") ");
        int i = 0;
        while (i < buffer.length()) {
            indent.append(" ");
            ++i;
        }
        i = 0;
        while (i < this.rules.size()) {
            if (i == 0) {
                buffer.append("= ");
            } else {
                buffer.append("\n");
                buffer.append(indent);
                buffer.append("| ");
            }
            buffer.append(this.rules.get(i));
            ++i;
        }
        return buffer.toString();
    }
}

