/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.percederberg.grammatica.parser.Analyzer;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.Parser;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.Production;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.ProductionPatternElement;
import net.percederberg.grammatica.parser.ProductionPatternRule;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.grammatica.parser.Tokenizer;

public class RecursiveDescentParser
extends Parser {
    private boolean initialized = false;
    private HashMap lookAheads = new HashMap();

    public RecursiveDescentParser(Tokenizer tokenizer) {
        super(tokenizer);
    }

    public RecursiveDescentParser(Tokenizer tokenizer, Analyzer analyzer) {
        super(tokenizer, analyzer);
    }

    public void addPattern(ProductionPattern pattern) throws ParserCreationException {
        if (pattern.isMatchingEmpty()) {
            throw new ParserCreationException("couldn't add production pattern " + pattern.getName() + " , as it can match zero elements (minimum is one)");
        }
        if (pattern.isLeftRecursive()) {
            throw new ParserCreationException("couldn't add production pattern " + pattern.getName() + " , as it is left recursive");
        }
        super.addPattern(pattern);
        this.lookAheads.put(pattern, new PatternLookAhead(pattern));
        this.initialized = false;
    }

    public void prepare() throws ParserCreationException {
        super.prepare();
        Iterator iter = this.getPatterns().iterator();
        while (iter.hasNext()) {
            this.calculateLookAhead((ProductionPattern)iter.next());
        }
        this.initialized = true;
    }

    public Node parse() throws ParserCreationException, ParseException {
        if (!this.initialized) {
            this.prepare();
        }
        Node node = this.parsePattern(this.getStartPattern());
        Token token = this.peekToken(0);
        if (token != null) {
            throw new ParseException(4, token.getImage(), token.getStartLine(), token.getStartColumn());
        }
        return node;
    }

    private Node parsePattern(ProductionPattern pattern) throws ParseException {
        Token token = this.peekToken(0);
        PatternLookAhead look = (PatternLookAhead)this.lookAheads.get(pattern);
        int i = 0;
        while (i < pattern.getRuleCount()) {
            ProductionPatternRule rule = pattern.getRule(i);
            if (look.getFallback() != rule && look.isNext(rule)) {
                return this.parseRule(rule);
            }
            ++i;
        }
        if (look.getFallback() != null) {
            return this.parseRule(look.getFallback());
        }
        throw new ParseException(4, token.getImage(), token.getStartLine(), token.getStartColumn());
    }

    private Node parseRule(ProductionPatternRule rule) throws ParseException {
        Production node = new Production(rule.getPattern());
        this.enterNode(node);
        int i = 0;
        while (i < rule.getElementCount()) {
            this.parseElement(node, rule.getElement(i));
            ++i;
        }
        return this.exitNode(node);
    }

    private void parseElement(Production node, ProductionPatternElement elem) throws ParseException {
        if (elem.isToken()) {
            int i = 0;
            while (i < elem.getMaxCount()) {
                Token token = this.peekToken(0);
                if (i < elem.getMinCount() || elem.isMatch(token)) {
                    token = this.nextToken(elem.getId());
                    this.enterNode(token);
                    this.addNode(node, this.exitNode(token));
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            ProductionPattern pattern = this.getPattern(elem.getId());
            PatternLookAhead look = (PatternLookAhead)this.lookAheads.get(pattern);
            int i = 0;
            while (i < elem.getMaxCount()) {
                if (i < elem.getMinCount() || look.isNext()) {
                    this.addNode(node, this.parsePattern(pattern));
                    ++i;
                    continue;
                }
                break;
            }
        }
    }

    private void calculateLookAhead(ProductionPattern pattern) throws ParserCreationException {
        int length = 1;
        PatternLookAhead look = (PatternLookAhead)this.lookAheads.get(pattern);
        LookAhead result = new LookAhead(1);
        LookAhead[] ruleResults = new LookAhead[pattern.getRuleCount()];
        int i = 0;
        while (i < pattern.getRuleCount()) {
            ruleResults[i] = this.findLookAhead(pattern.getRule(i), 1);
            result.addAll(ruleResults[i]);
            ++i;
        }
        if (look.getLookAhead() == null) {
            look.setLookAhead(result);
        }
        LookAhead conflicts = this.findConflicts(1, ruleResults);
        while (conflicts.size() > 0) {
            ++length;
            i = 0;
            while (i < pattern.getRuleCount()) {
                ProductionPatternRule rule = pattern.getRule(i);
                if (ruleResults[i].intersects(conflicts)) {
                    ruleResults[i] = this.findLookAhead(rule, length);
                    look.setRuleLookAhead(rule, ruleResults[i]);
                }
                if (ruleResults[i].intersects(conflicts)) {
                    if (look.getFallback() == null) {
                        look.setFallback(rule);
                    } else if (look.getFallback() != rule) {
                        throw new ParserCreationException("inherent ambiguity in " + pattern.getName());
                    }
                }
                ++i;
            }
            conflicts = this.findConflicts(length, ruleResults);
        }
        i = 0;
        while (i < pattern.getRuleCount()) {
            this.calculateLookAhead(pattern.getRule(i), 0);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void calculateLookAhead(ProductionPatternRule rule, int pos) throws ParserCreationException {
        length = 1;
        if (pos >= rule.getElementCount()) {
            return;
        }
        pattern = rule.getPattern();
        elem = rule.getElement(pos);
        if (elem.getMinCount() == elem.getMaxCount()) {
            this.calculateLookAhead(rule, pos + 1);
            return;
        }
        if (elem.isToken()) {
            first = new LookAhead(1);
            first.add(elem.getId());
        } else {
            first = this.findLookAhead(this.getPattern(elem.getId()), 1);
        }
        follow = this.findLookAhead(rule, 1, pos + 1);
        conflicts = first.createIntersection(follow);
        if (conflicts.size() <= 0 || !elem.isToken()) ** GOTO lbl23
        throw new ParserCreationException("inherent ambiguity in " + pattern.getName() + " in element " + (pos + 1));
lbl-1000:
        // 1 sources

        {
            first = this.findLookAhead(this.getPattern(elem.getId()), ++length);
            follow = this.findLookAhead(rule, length, pos + 1);
            if (first.intersects(conflicts)) {
                throw new ParserCreationException("inherent ambiguity in " + pattern.getName() + " in element " + (pos + 1));
            }
            conflicts = first.createIntersection(follow);
lbl23:
            // 2 sources

            ** while (conflicts.size() > 0)
        }
lbl24:
        // 1 sources

        if (length > 1) {
            pattern = this.getPattern(elem.getId());
            look = (PatternLookAhead)this.lookAheads.get(pattern);
            look.setLookAhead(first);
        }
        this.calculateLookAhead(rule, pos + 1);
    }

    private LookAhead findLookAhead(ProductionPattern pattern, int length) {
        PatternLookAhead look = (PatternLookAhead)this.lookAheads.get(pattern);
        LookAhead result = look.getLookAhead();
        if (result != null) {
            if (length == result.getMaxLength()) {
                return result;
            }
            if (length < result.getMaxLength()) {
                return new LookAhead(length, result);
            }
        }
        result = new LookAhead(length);
        int i = 0;
        while (i < pattern.getRuleCount()) {
            result.addAll(this.findLookAhead(pattern.getRule(i), length));
            ++i;
        }
        if (look.getLookAhead() == null) {
            look.setLookAhead(result);
        }
        return result;
    }

    private LookAhead findLookAhead(ProductionPatternRule rule, int length) {
        PatternLookAhead look = (PatternLookAhead)this.lookAheads.get(rule.getPattern());
        LookAhead result = look.getRuleLookAhead(rule);
        if (result != null) {
            if (length == result.getMaxLength()) {
                return result;
            }
            if (length < result.getMaxLength()) {
                return new LookAhead(length, result);
            }
        }
        result = this.findLookAhead(rule, length, 0);
        if (look.getRuleLookAhead(rule) == null) {
            look.setRuleLookAhead(rule, result);
        }
        return result;
    }

    private LookAhead findLookAhead(ProductionPatternRule rule, int length, int pos) {
        LookAhead next;
        if (length <= 0 || pos >= rule.getElementCount()) {
            return new LookAhead(0);
        }
        ProductionPatternElement elem = rule.getElement(pos);
        if (elem.isToken()) {
            next = new LookAhead(length);
            next.add(elem.getId());
        } else {
            next = this.findLookAhead(this.getPattern(elem.getId()), length);
        }
        LookAhead result = new LookAhead(length);
        result.addAll(next);
        if (elem.getMinCount() == 0) {
            result.addEmpty();
        }
        int max = Math.min(length, elem.getMaxCount());
        int i = 1;
        while (i < max) {
            next = next.createCombination(next);
            result.addAll(next);
            ++i;
        }
        max = length - result.getMinLength();
        if (max <= 0) {
            return result;
        }
        next = this.findLookAhead(rule, max, pos + 1);
        return result.createCombination(next);
    }

    private LookAhead findConflicts(int maxLength, LookAhead[] sets) {
        LookAhead result = new LookAhead(maxLength);
        int i = 0;
        while (i < sets.length) {
            int j = 0;
            while (j < i) {
                result.addAll(sets[i].createIntersection(sets[j]));
                ++j;
            }
            ++i;
        }
        return result;
    }

    private class LookAhead {
        private ArrayList elements = new ArrayList();
        private int maxLength;

        public LookAhead(int maxLength) {
            this.maxLength = maxLength;
        }

        public LookAhead(int maxLength, LookAhead src) {
            this(maxLength);
            int i = 0;
            while (i < src.elements.size()) {
                this.add((ArrayList)src.elements.get(i));
                ++i;
            }
        }

        public int size() {
            return this.elements.size();
        }

        public int getMinLength() {
            int min = -1;
            int i = 0;
            while (i < this.elements.size()) {
                ArrayList list = (ArrayList)this.elements.get(i);
                if (min < 0 || list.size() < min) {
                    min = list.size();
                }
                ++i;
            }
            return min < 0 ? 0 : min;
        }

        public int getMaxLength() {
            int max = 0;
            int i = 0;
            while (i < this.elements.size()) {
                ArrayList list = (ArrayList)this.elements.get(i);
                if (list.size() > max) {
                    max = list.size();
                }
                ++i;
            }
            return max;
        }

        public boolean isNext() throws ParseException {
            int i = 0;
            while (i < this.elements.size()) {
                if (this.isNext((ArrayList)this.elements.get(i))) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean isNext(ArrayList list) throws ParseException {
            int i = 0;
            while (i < list.size()) {
                Token token = RecursiveDescentParser.this.peekToken(i);
                Integer id = (Integer)list.get(i);
                if (token == null || token.getId() != id.intValue()) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private boolean contains(ArrayList elem) {
            int i = 0;
            while (i < this.elements.size()) {
                if (this.elements.get(i).equals(elem)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean intersects(LookAhead set) {
            int i = 0;
            while (i < set.elements.size()) {
                if (this.contains((ArrayList)set.elements.get(i))) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private void add(ArrayList list) {
            if (list.size() > this.maxLength) {
                list = (ArrayList)list.clone();
                while (list.size() > this.maxLength) {
                    list.remove(list.size() - 1);
                }
            }
            if (!this.contains(list)) {
                this.elements.add(list);
            }
        }

        public void add(int token) {
            ArrayList<Integer> list = new ArrayList<Integer>(1);
            list.add(new Integer(token));
            this.add(list);
        }

        public void addEmpty() {
            this.add(new ArrayList(0));
        }

        public void addAll(LookAhead set) {
            int i = 0;
            while (i < set.elements.size()) {
                this.add((ArrayList)set.elements.get(i));
                ++i;
            }
        }

        public LookAhead createIntersection(LookAhead set) {
            LookAhead result = new LookAhead(this.maxLength);
            int i = 0;
            while (i < this.elements.size()) {
                ArrayList list = (ArrayList)this.elements.get(i);
                if (set.contains(list)) {
                    result.add(list);
                }
                ++i;
            }
            return result;
        }

        public LookAhead createCombination(LookAhead set) {
            LookAhead result = new LookAhead(this.maxLength);
            if (this.size() <= 0) {
                return set;
            }
            if (set.size() <= 0) {
                return this;
            }
            int i = 0;
            while (i < this.elements.size()) {
                ArrayList first = (ArrayList)this.elements.get(i);
                if (first.size() >= this.maxLength) {
                    result.add(first);
                } else if (first.size() <= 0) {
                    result.addAll(set);
                } else {
                    int j = 0;
                    while (j < set.elements.size()) {
                        ArrayList second = (ArrayList)set.elements.get(j);
                        ArrayList temp = new ArrayList(first.size() + second.size());
                        temp.addAll(first);
                        temp.addAll(second);
                        result.add(temp);
                        ++j;
                    }
                }
                ++i;
            }
            return result;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("{");
            int i = 0;
            while (i < this.elements.size()) {
                buffer.append("\n  ");
                buffer.append(this.elements.get(i));
                ++i;
            }
            buffer.append("\n}");
            return buffer.toString();
        }
    }

    private class PatternLookAhead {
        private ProductionPattern pattern;
        private ProductionPatternRule fallback = null;
        private LookAhead lookAhead = null;
        private HashMap ruleLookAheads = new HashMap();

        public PatternLookAhead(ProductionPattern pattern) {
            this.pattern = pattern;
        }

        public boolean isNext() throws ParseException {
            if (this.lookAhead == null) {
                return false;
            }
            return this.lookAhead.isNext();
        }

        public boolean isNext(ProductionPatternRule rule) throws ParseException {
            LookAhead set = this.getRuleLookAhead(rule);
            if (set == null) {
                return false;
            }
            return set.isNext();
        }

        public ProductionPatternRule getFallback() {
            return this.fallback;
        }

        public void setFallback(ProductionPatternRule rule) {
            this.fallback = rule;
        }

        public LookAhead getLookAhead() {
            return this.lookAhead;
        }

        public void setLookAhead(LookAhead set) {
            this.lookAhead = set;
        }

        public LookAhead getRuleLookAhead(ProductionPatternRule rule) {
            return (LookAhead)this.ruleLookAheads.get(rule);
        }

        public void setRuleLookAhead(ProductionPatternRule rule, LookAhead set) {
            this.ruleLookAheads.put(rule, set);
        }
    }
}

