/*
 * Decompiled with CFR 0.152.
 */
package junit.runner;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class TestCaseClassLoader
extends ClassLoader {
    private Vector fPathItems;
    private String[] defaultExclusions = new String[]{"junit.framework.", "junit.extensions.", "junit.runner."};
    static final String EXCLUDED_FILE = "excluded.properties";
    private Vector fExcluded;

    public TestCaseClassLoader() {
        this(System.getProperty("java.class.path"));
    }

    public TestCaseClassLoader(String classPath) {
        this.scanPath(classPath);
        this.readExcludedPackages();
    }

    private void scanPath(String classPath) {
        String separator = System.getProperty("path.separator");
        this.fPathItems = new Vector(10);
        StringTokenizer st = new StringTokenizer(classPath, separator);
        while (st.hasMoreTokens()) {
            this.fPathItems.addElement(st.nextToken());
        }
    }

    public URL getResource(String name) {
        return ClassLoader.getSystemResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return ClassLoader.getSystemResourceAsStream(name);
    }

    public boolean isExcluded(String name) {
        int i = 0;
        while (i < this.fExcluded.size()) {
            if (name.startsWith((String)this.fExcluded.elementAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        if (this.isExcluded(name)) {
            try {
                c = this.findSystemClass(name);
                return c;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (c == null) {
            byte[] data = this.lookupClassData(name);
            if (data == null) {
                throw new ClassNotFoundException();
            }
            c = this.defineClass(name, data, 0, data.length);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private byte[] lookupClassData(String className) throws ClassNotFoundException {
        byte[] data = null;
        int i = 0;
        while (i < this.fPathItems.size()) {
            String path = (String)this.fPathItems.elementAt(i);
            String fileName = className.replace('.', '/') + ".class";
            data = this.isJar(path) ? this.loadJarData(path, fileName) : this.loadFileData(path, fileName);
            if (data != null) {
                return data;
            }
            ++i;
        }
        throw new ClassNotFoundException(className);
    }

    boolean isJar(String pathEntry) {
        return pathEntry.endsWith(".jar") || pathEntry.endsWith(".zip");
    }

    private byte[] loadFileData(String path, String fileName) {
        File file = new File(path, fileName);
        if (file.exists()) {
            return this.getClassData(file);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] getClassData(File f) {
        try {
            int n;
            FileInputStream stream = new FileInputStream(f);
            ByteArrayOutputStream out = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = stream.read(b)) != -1) {
                void var5_6;
                out.write(b, 0, (int)var5_6);
            }
            stream.close();
            out.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private byte[] loadJarData(String path, String fileName) {
        ZipFile zipFile = null;
        InputStream stream = null;
        File archive = new File(path);
        if (!archive.exists()) {
            return null;
        }
        try {
            zipFile = new ZipFile(archive);
        }
        catch (IOException io) {
            return null;
        }
        ZipEntry entry = zipFile.getEntry(fileName);
        if (entry == null) {
            return null;
        }
        int size = (int)entry.getSize();
        stream = zipFile.getInputStream(entry);
        byte[] data = new byte[size];
        int pos = 0;
        while (pos < size) {
            int n = stream.read(data, pos, data.length - pos);
            pos += n;
        }
        zipFile.close();
        byte[] byArray = data;
        Object var12_14 = null;
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e2) {
            // empty catch block
        }
        return byArray;
        catch (IOException e) {
            try {
                Object var12_15 = null;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e2) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void readExcludedPackages() {
        Properties p;
        block13: {
            this.fExcluded = new Vector(10);
            int i = 0;
            while (i < this.defaultExclusions.length) {
                this.fExcluded.addElement(this.defaultExclusions[i]);
                ++i;
            }
            InputStream is = this.getClass().getResourceAsStream(EXCLUDED_FILE);
            if (is == null) {
                return;
            }
            p = new Properties();
            p.load(is);
            Object var6_4 = null;
            try {
                is.close();
            }
            catch (IOException e2) {}
            break block13;
            {
                catch (IOException e) {
                    Object var6_5 = null;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    is.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("excluded.")) continue;
            String path = p.getProperty(key);
            if ((path = path.trim()).endsWith("*")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.length() <= 0) continue;
            this.fExcluded.addElement(path);
        }
    }
}

