/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import net.percederberg.grammatica.code.csharp.CSharpClass;
import net.percederberg.grammatica.code.csharp.CSharpComment;
import net.percederberg.grammatica.code.csharp.CSharpConstructor;
import net.percederberg.grammatica.code.csharp.CSharpFile;
import net.percederberg.grammatica.code.csharp.CSharpMethod;
import net.percederberg.grammatica.code.csharp.CSharpNamespace;
import net.percederberg.grammatica.code.csharp.CSharpUsing;
import net.percederberg.grammatica.output.CSharpConstantsFile;
import net.percederberg.grammatica.output.CSharpParserGenerator;
import net.percederberg.grammatica.parser.TokenPattern;

public class CSharpTokenizerFile {
    private static final String TYPE_COMMENT = "<remarks>A character stream tokenizer.</remarks>";
    private static final String CONSTRUCTOR_COMMENT = "<summary>Creates a new tokenizer for the specified input\nstream.</summary>\n\n<param name='input'>the input stream to read</param>\n\n<exception cref='ParserCreationException'>if the tokenizer\ncouldn't be initialized correctly</exception>";
    private static final String INIT_METHOD_COMMENT = "<summary>Initializes the tokenizer by creating all the token\npatterns.</summary>\n\n<exception cref='ParserCreationException'>if the tokenizer\ncouldn't be initialized correctly</exception>";
    private CSharpParserGenerator gen;
    private CSharpFile file;
    private CSharpClass cls;
    private CSharpMethod initMethod;

    public CSharpTokenizerFile(CSharpParserGenerator gen) {
        String name = gen.getBaseName() + "Tokenizer";
        this.gen = gen;
        this.file = new CSharpFile(gen.getBaseDir(), name);
        int modifiers = gen.getPublicAccess() ? 1 : 4;
        this.cls = new CSharpClass(modifiers, name, "Tokenizer");
        this.initMethod = new CSharpMethod(5, "CreatePatterns", "", "void");
        this.initializeCode();
    }

    private void initializeCode() {
        this.file.addUsing(new CSharpUsing("System.IO"));
        this.file.addUsing(new CSharpUsing("PerCederberg.Grammatica.Parser"));
        if (this.gen.getNamespace() == null) {
            this.file.addClass(this.cls);
        } else {
            CSharpNamespace n = new CSharpNamespace(this.gen.getNamespace());
            n.addClass(this.cls);
            this.file.addNamespace(n);
        }
        String str = this.file.toString() + "\n\n" + this.gen.getFileComment();
        this.file.addComment(new CSharpComment(2, str));
        this.cls.addComment(new CSharpComment(TYPE_COMMENT));
        CSharpConstructor constr = new CSharpConstructor("TextReader input");
        this.cls.addConstructor(constr);
        constr.addComment(new CSharpComment(CONSTRUCTOR_COMMENT));
        constr.addInitializer("base(input)");
        constr.addCode("CreatePatterns();");
        this.cls.addMethod(this.initMethod);
        this.initMethod.addComment(new CSharpComment(INIT_METHOD_COMMENT));
        this.initMethod.addCode("TokenPattern  pattern;");
    }

    public void addToken(TokenPattern pattern, CSharpConstantsFile constants) {
        StringBuffer code = new StringBuffer();
        code.append("pattern = new TokenPattern((int) ");
        code.append(constants.getConstant(pattern.getId()));
        code.append(",\n");
        code.append("                           \"");
        code.append(pattern.getName());
        code.append("\",\n");
        code.append("                           TokenPattern.PatternType.");
        switch (pattern.getType()) {
            case 1: {
                code.append("STRING");
                break;
            }
            case 2: {
                code.append("REGEXP");
            }
        }
        code.append(",\n");
        code.append("                           ");
        String str = pattern.getPattern();
        code.append(this.gen.getCodeStyle().getStringConstant(str));
        code.append(");\n");
        if (pattern.isError()) {
            code.append("pattern.SetError(");
            if (pattern.getErrorMessage() != null) {
                str = pattern.getErrorMessage();
                code.append(this.gen.getCodeStyle().getStringConstant(str));
            }
            code.append(");\n");
        }
        if (pattern.isIgnore()) {
            code.append("pattern.SetIgnore(");
            if (pattern.getIgnoreMessage() != null) {
                str = pattern.getIgnoreMessage();
                code.append(this.gen.getCodeStyle().getStringConstant(str));
            }
            code.append(");\n");
        }
        code.append("AddPattern(pattern);");
        this.initMethod.addCode("");
        this.initMethod.addCode(code.toString());
    }

    protected String getConstructorCall(String param) {
        return "new " + this.gen.getBaseName() + "Tokenizer(" + param + ")";
    }

    public void writeCode() throws IOException {
        this.file.writeCode(this.gen.getCodeStyle());
    }
}

