/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.ArrayList;
import net.percederberg.grammatica.parser.LookAheadSet;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.ProductionPatternAlternative;

public class ProductionPattern {
    private int id;
    private String name;
    private boolean syntetic;
    private ArrayList alternatives;
    private int defaultAlt;
    private LookAheadSet lookAhead;

    public ProductionPattern(int id, String name) {
        this.id = id;
        this.name = name;
        this.syntetic = false;
        this.alternatives = new ArrayList();
        this.defaultAlt = -1;
        this.lookAhead = null;
    }

    public boolean isSyntetic() {
        return this.syntetic;
    }

    public boolean isLeftRecursive() {
        int i = 0;
        while (i < this.alternatives.size()) {
            ProductionPatternAlternative alt = (ProductionPatternAlternative)this.alternatives.get(i);
            if (alt.isLeftRecursive()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isRightRecursive() {
        int i = 0;
        while (i < this.alternatives.size()) {
            ProductionPatternAlternative alt = (ProductionPatternAlternative)this.alternatives.get(i);
            if (alt.isRightRecursive()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isMatchingEmpty() {
        int i = 0;
        while (i < this.alternatives.size()) {
            ProductionPatternAlternative alt = (ProductionPatternAlternative)this.alternatives.get(i);
            if (alt.isMatchingEmpty()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setSyntetic(boolean syntetic) {
        this.syntetic = syntetic;
    }

    public int getAlternativeCount() {
        return this.alternatives.size();
    }

    public ProductionPatternAlternative getAlternative(int pos) {
        return (ProductionPatternAlternative)this.alternatives.get(pos);
    }

    public void addAlternative(ProductionPatternAlternative alt) throws ParserCreationException {
        if (this.alternatives.contains(alt)) {
            throw new ParserCreationException("couldn't add duplicate alternative to '" + this.name + "'");
        }
        alt.setPattern(this);
        this.alternatives.add(alt);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        StringBuffer indent = new StringBuffer();
        buffer.append(this.name);
        buffer.append("(");
        buffer.append(this.id);
        buffer.append(") ");
        int i = 0;
        while (i < buffer.length()) {
            indent.append(" ");
            ++i;
        }
        i = 0;
        while (i < this.alternatives.size()) {
            if (i == 0) {
                buffer.append("= ");
            } else {
                buffer.append("\n");
                buffer.append(indent);
                buffer.append("| ");
            }
            buffer.append(this.alternatives.get(i));
            ++i;
        }
        return buffer.toString();
    }

    LookAheadSet getLookAhead() {
        return this.lookAhead;
    }

    void setLookAhead(LookAheadSet lookAhead) {
        this.lookAhead = lookAhead;
    }

    ProductionPatternAlternative getDefaultAlternative() {
        if (this.defaultAlt >= 0) {
            Object obj = this.alternatives.get(this.defaultAlt);
            return (ProductionPatternAlternative)obj;
        }
        return null;
    }

    void setDefaultAlternative(int pos) {
        if (pos >= 0 && pos < this.alternatives.size()) {
            this.defaultAlt = pos;
        }
    }
}

