/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import net.percederberg.grammatica.Grammar;
import net.percederberg.grammatica.GrammarException;
import net.percederberg.grammatica.output.CSharpParserGenerator;
import net.percederberg.grammatica.output.JavaParserGenerator;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.Parser;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.grammatica.parser.Tokenizer;

public class Grammatica {
    private static final String COMMAND_HELP = "Syntax: Grammatica <grammarfile> <action> [<options>]\n\nActions:\n  --tokenize <file>\n      Debugs the grammar by using it to tokenize the specified\n      file. No code has to be generated for this.\n  --parse <file>\n      Debugs the grammar by using it to parse the specified\n      file. No code has to be generated for this.\n  --csoutput <dir>\n      Creates a C# parser for the grammar (in source code).\n      The specified directory with be used when generating\n      source code files.\n  --javaoutput <dir>\n      Creates a Java parser for the grammar (in source code).\n      The specified directory with be used as base directory\n      when generating source code files.\n\nC# Output Options:\n  --csnamespace <package>\n      Sets the C# namespace to use in generated source code files.\n  --csclassname <name>\n      Sets the C# class name prefix to use in generated source\n      code files.\n  --cspublic\n      Sets public access for all C# types generated.\n\nJava Output Options:\n  --javapackage <package>\n      Sets the Java package to use in generated source code files.\n  --javaclassname <name>\n      Sets the Java class name prefix to use in generated source\n      code files.\n  --javapublic\n      Sets public access for all Java types.";
    private static final String INTERNAL_ERROR = "INTERNAL ERROR: An internal error in Grammatica has been found.\n    Please report this error to the maintainers (see the web\n    site for instructions). Be sure to include the Grammatica\n    version number, as well as the information below:\n";

    public static void main(String[] args) {
        Grammar grammar = null;
        if (args.length == 1 && args[0].equals("--help")) {
            Grammatica.printHelp(null);
            System.exit(1);
        }
        if (args.length < 3 || args.length > 7) {
            Grammatica.printHelp("Wrong number of arguments");
            System.exit(1);
        }
        try {
            grammar = new Grammar(new File(args[0]));
        }
        catch (FileNotFoundException e) {
            Grammatica.printError(args[0], e);
            System.exit(1);
        }
        catch (ParseException e) {
            Grammatica.printError(args[0], e);
            System.exit(1);
        }
        catch (GrammarException e) {
            Grammatica.printError(e);
            System.exit(1);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (RuntimeException e) {
            Grammatica.printInternalError(e);
            System.exit(2);
        }
        try {
            if (args[1].equals("--tokenize")) {
                Grammatica.tokenize(grammar, new File(args[2]));
            } else if (args[1].equals("--parse")) {
                Grammatica.parse(grammar, new File(args[2]));
            } else if (args[1].equals("--javaoutput")) {
                Grammatica.writeJavaCode(args, grammar);
            } else if (args[1].equals("--csoutput")) {
                Grammatica.writeCSharpCode(args, grammar);
            } else {
                Grammatica.printHelp("unrecognized option: " + args[1]);
                System.exit(1);
            }
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (RuntimeException e) {
            Grammatica.printInternalError(e);
            System.exit(2);
        }
    }

    private static void printHelp(String error) {
        System.err.println(COMMAND_HELP);
        System.err.println();
        if (error != null) {
            System.err.print("Error: ");
            System.err.println(error);
            System.err.println();
        }
    }

    private static void printError(Exception e) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Error: ");
        buffer.append(e.getMessage());
        System.err.println(buffer.toString());
    }

    private static void printError(String file, FileNotFoundException e) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Error: couldn't open file:");
        buffer.append("\n    ");
        buffer.append(file);
        System.err.println(buffer.toString());
    }

    private static void printError(String file, ParseException e) {
        StringBuffer buffer = new StringBuffer();
        if (e.getErrorType() == 0) {
            Grammatica.printInternalError(e);
            return;
        }
        buffer.append("Error: in ");
        buffer.append(file);
        if (e.getLine() > 0) {
            buffer.append(": line ");
            buffer.append(e.getLine());
        }
        buffer.append(":\n");
        buffer.append(Grammatica.linebreakString(e.getErrorMessage(), "    ", 70));
        String line = Grammatica.readLines(file, e.getLine(), e.getLine());
        if (line != null) {
            buffer.append("\n\n");
            buffer.append(line);
            int i = 1;
            while (i < e.getColumn()) {
                if (line.charAt(i - 1) == '\t') {
                    buffer.append("\t");
                } else {
                    buffer.append(" ");
                }
                ++i;
            }
            buffer.append("^");
        }
        System.err.println(buffer.toString());
    }

    private static void printError(GrammarException e) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Error: in ");
        buffer.append(e.getFile());
        if (e.getStartLine() > 0) {
            if (e.getStartLine() == e.getEndLine()) {
                buffer.append(": line ");
                buffer.append(e.getStartLine());
            } else {
                buffer.append(": lines ");
                buffer.append(e.getStartLine());
                buffer.append("-");
                buffer.append(e.getEndLine());
            }
        }
        buffer.append(":\n");
        buffer.append(Grammatica.linebreakString(e.getErrorMessage(), "    ", 70));
        String lines = Grammatica.readLines(e.getFile(), e.getStartLine(), e.getEndLine());
        if (lines != null) {
            buffer.append("\n\n");
            buffer.append(lines);
        }
        System.err.println(buffer.toString());
    }

    private static void printInternalError(Exception e) {
        System.err.println(INTERNAL_ERROR);
        e.printStackTrace();
    }

    private static String linebreakString(String str, String prefix, int length) {
        StringBuffer buffer = new StringBuffer();
        while (str.length() + prefix.length() > length) {
            int pos = str.lastIndexOf(32, length - prefix.length());
            if (pos < 0 && (pos = str.indexOf(32)) < 0) break;
            buffer.append(prefix);
            buffer.append(str.substring(0, pos));
            str = str.substring(pos + 1);
            buffer.append("\n");
        }
        buffer.append(prefix);
        buffer.append(str);
        return buffer.toString();
    }

    private static String readLines(String file, int start, int end) {
        StringBuffer buffer = new StringBuffer();
        if (start < 1 || end < start) {
            return null;
        }
        try {
            BufferedReader input = new BufferedReader(new FileReader(file));
            int i = 0;
            while (i < end) {
                if (i + 1 < start) {
                    input.readLine();
                } else {
                    buffer.append(input.readLine());
                    buffer.append("\n");
                }
                ++i;
            }
            input.close();
        }
        catch (IOException e) {
            return null;
        }
        return buffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static void tokenize(Grammar grammar, File file) {
        try {
            Token token;
            Tokenizer tokenizer = grammar.createTokenizer(new FileReader(file));
            System.out.println("Tokens from " + file + ":");
            while ((token = tokenizer.next()) != null) {
                void var3_3;
                System.out.println(var3_3);
            }
        }
        catch (FileNotFoundException e) {
            Grammatica.printError(file.toString(), e);
            System.exit(1);
        }
        catch (GrammarException e) {
            Grammatica.printInternalError(e);
            System.exit(2);
        }
        catch (ParseException e) {
            Grammatica.printError(file.toString(), e);
            System.exit(1);
        }
    }

    private static void parse(Grammar grammar, File file) {
        try {
            Tokenizer tokenizer = grammar.createTokenizer(new FileReader(file));
            Parser parser = grammar.createParser(tokenizer);
            System.out.println("Parse tree from " + file + ":");
            parser.parse().printTo(System.out);
        }
        catch (FileNotFoundException e) {
            Grammatica.printError(file.toString(), e);
            System.exit(1);
        }
        catch (GrammarException e) {
            Grammatica.printInternalError(e);
            System.exit(2);
        }
        catch (ParserCreationException e) {
            Grammatica.printInternalError(e);
            System.exit(2);
        }
        catch (ParseException e) {
            Grammatica.printError(file.toString(), e);
            System.exit(1);
        }
    }

    private static void writeJavaCode(String[] args, Grammar grammar) {
        JavaParserGenerator gen = new JavaParserGenerator(grammar);
        int i = 1;
        while (i < args.length) {
            if (args[i].equals("--javaoutput")) {
                gen.setBaseDir(new File(args[++i]));
            } else if (args[i].equals("--javapackage")) {
                gen.setBasePackage(args[++i]);
            } else if (args[i].equals("--javaclassname")) {
                gen.setBaseName(args[++i]);
            } else if (args[i].equals("--javapublic")) {
                gen.setPublicAccess(true);
            } else {
                Grammatica.printHelp("unrecognized option: " + args[i]);
                System.exit(1);
            }
            ++i;
        }
        try {
            System.out.println("Writing Java parser source code...");
            gen.write();
            System.out.println("Done.");
        }
        catch (IOException e) {
            Grammatica.printError(e);
            System.exit(1);
        }
    }

    private static void writeCSharpCode(String[] args, Grammar grammar) {
        CSharpParserGenerator gen = new CSharpParserGenerator(grammar);
        int i = 1;
        while (i < args.length) {
            if (args[i].equals("--csoutput")) {
                gen.setBaseDir(new File(args[++i]));
            } else if (args[i].equals("--csnamespace")) {
                gen.setNamespace(args[++i]);
            } else if (args[i].equals("--csclassname")) {
                gen.setBaseName(args[++i]);
            } else if (args[i].equals("--cspublic")) {
                gen.setPublicAccess(true);
            } else {
                Grammatica.printHelp("unrecognized option: " + args[i]);
                System.exit(1);
            }
            ++i;
        }
        try {
            System.out.println("Writing C# parser source code...");
            gen.write();
            System.out.println("Done.");
        }
        catch (IOException e) {
            Grammatica.printError(e);
            System.exit(1);
        }
    }
}

