/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.grammatica.parser.TokenPattern;
import net.percederberg.grammatica.parser.re.CharBuffer;
import net.percederberg.grammatica.parser.re.Matcher;
import net.percederberg.grammatica.parser.re.RegExp;
import net.percederberg.grammatica.parser.re.RegExpException;

public class Tokenizer {
    private ArrayList matchers = new ArrayList();
    private Reader input = null;
    private CharBuffer buffer = new CharBuffer();
    private int position = 0;
    private int line = 1;
    private int column = 1;
    private boolean endOfBuffer = false;

    public Tokenizer(Reader input) {
        this.input = input;
    }

    public String getPatternDescription(int id) {
        int i = 0;
        while (i < this.matchers.size()) {
            TokenMatcher m = (TokenMatcher)this.matchers.get(i);
            if (m.getPattern().getId() == id) {
                return m.getPattern().toShortString();
            }
            ++i;
        }
        return null;
    }

    public int getCurrentLine() {
        return this.line;
    }

    public int getCurrentColumn() {
        return this.column;
    }

    public void addPattern(TokenPattern pattern) throws ParserCreationException {
        switch (pattern.getType()) {
            case 1: {
                this.matchers.add(new StringTokenMatcher(pattern));
                break;
            }
            case 2: {
                try {
                    this.matchers.add(new RegExpTokenMatcher(pattern));
                    break;
                }
                catch (RegExpException e) {
                    throw new ParserCreationException(2, pattern.getName(), "regular expression contains error(s): " + e.getMessage());
                }
            }
            default: {
                throw new ParserCreationException(2, pattern.getName(), "pattern type " + pattern.getType() + " is undefined");
            }
        }
    }

    public Token next() throws ParseException {
        Token token = null;
        do {
            if ((token = this.nextToken()) == null) {
                return null;
            }
            if (token.getPattern().isError()) {
                throw new ParseException(5, token.getPattern().getErrorMessage(), token.getStartLine(), token.getStartColumn());
            }
            if (!token.getPattern().isIgnore()) continue;
            token = null;
        } while (token == null);
        return token;
    }

    private Token nextToken() throws ParseException {
        TokenMatcher m;
        do {
            if (this.endOfBuffer) {
                this.readInput();
                this.endOfBuffer = false;
            }
            m = this.findMatch();
        } while (this.endOfBuffer && this.input != null);
        if (m != null) {
            String str = this.buffer.substring(this.position, this.position + m.length());
            Token token = new Token(m.getPattern(), str, this.line, this.column);
            this.position += m.length();
            this.line = token.getEndLine();
            this.column = token.getEndColumn() + 1;
            return token;
        }
        if (this.position >= this.buffer.length()) {
            return null;
        }
        ParseException e = new ParseException(3, String.valueOf(this.buffer.charAt(this.position)), this.line, this.column);
        if (this.buffer.charAt(this.position) == '\n') {
            ++this.line;
            this.column = 1;
        } else {
            ++this.column;
        }
        ++this.position;
        throw e;
    }

    private void readInput() throws ParseException {
        int length;
        char[] chars = new char[4096];
        if (this.input == null) {
            return;
        }
        if (this.position > 1024) {
            this.buffer.delete(0, this.position);
            this.position = 0;
        }
        try {
            length = this.input.read(chars);
        }
        catch (IOException e) {
            this.input = null;
            throw new ParseException(1, e.getMessage(), -1, -1);
        }
        if (length > 0) {
            this.buffer.append(chars, 0, length);
        }
        if (length < chars.length) {
            try {
                this.input.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.input = null;
        }
    }

    private TokenMatcher findMatch() {
        TokenMatcher bestMatch = null;
        int i = 0;
        while (i < this.matchers.size()) {
            TokenMatcher m = (TokenMatcher)this.matchers.get(i);
            if (m.matchFrom(this.position) && (bestMatch == null || m.length() > bestMatch.length())) {
                bestMatch = m;
            }
            if (m.hasReadEndOfString()) {
                this.endOfBuffer = true;
            }
            ++i;
        }
        return bestMatch;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.matchers.size()) {
            TokenMatcher m = (TokenMatcher)this.matchers.get(i);
            buffer.append(m);
            buffer.append('\n');
            ++i;
        }
        return buffer.toString();
    }

    private class RegExpTokenMatcher
    extends TokenMatcher {
        private RegExp regExp;
        private Matcher matcher;

        public RegExpTokenMatcher(TokenPattern pattern) throws RegExpException {
            super(pattern);
            this.regExp = new RegExp(pattern.getPattern());
            this.matcher = this.regExp.matcher(Tokenizer.this.buffer);
        }

        public int start() {
            if (this.matcher.length() <= 0) {
                return 0;
            }
            return this.matcher.start();
        }

        public int length() {
            return this.matcher.length();
        }

        public boolean hasReadEndOfString() {
            return this.matcher.hasReadEndOfString();
        }

        public boolean matchFrom(int pos) {
            return this.matcher.matchFrom(pos);
        }

        public String toString() {
            return super.toString() + this.regExp.toString();
        }
    }

    private class StringTokenMatcher
    extends TokenMatcher {
        private String image;
        private int start;
        private boolean endOfString;

        public StringTokenMatcher(TokenPattern pattern) {
            super(pattern);
            this.image = pattern.getPattern();
            this.reset();
        }

        public void reset() {
            this.start = -1;
            this.endOfString = false;
        }

        public int start() {
            return this.start < 0 ? 0 : this.start;
        }

        public int length() {
            return this.start < 0 ? 0 : this.image.length();
        }

        public boolean hasReadEndOfString() {
            return this.endOfString;
        }

        public boolean matchFrom(int pos) {
            this.reset();
            if (pos + this.image.length() > Tokenizer.this.buffer.length()) {
                this.endOfString = true;
                return false;
            }
            int i = 0;
            while (i < this.image.length()) {
                if (this.image.charAt(i) != Tokenizer.this.buffer.charAt(pos + i)) {
                    return false;
                }
                ++i;
            }
            this.start = pos;
            return true;
        }
    }

    private abstract class TokenMatcher {
        private TokenPattern pattern;

        public TokenMatcher(TokenPattern pattern) {
            this.pattern = pattern;
        }

        public TokenPattern getPattern() {
            return this.pattern;
        }

        public abstract int start();

        public abstract int length();

        public abstract boolean hasReadEndOfString();

        public abstract boolean matchFrom(int var1);

        public String toString() {
            return this.pattern.toString() + "\n";
        }
    }
}

