/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica;

import net.percederberg.grammatica.Grammar;
import net.percederberg.grammatica.GrammarAnalyzer;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.Production;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.ProductionPatternAlternative;
import net.percederberg.grammatica.parser.ProductionPatternElement;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.grammatica.parser.TokenPattern;

class SecondPassAnalyzer
extends GrammarAnalyzer {
    private Grammar grammar;
    private ProductionPattern currentProduction = null;
    private int nextSynteticId = 3001;

    public SecondPassAnalyzer(Grammar grammar) {
        this.grammar = grammar;
    }

    protected Node exitIdentifier(Token node) throws ParseException {
        String name = node.getImage();
        TokenPattern token = this.grammar.getTokenPatternByName(name);
        ProductionPattern prod = this.grammar.getProductionPatternByName(name);
        if (token != null) {
            node.addValue(token);
        } else if (prod != null) {
            node.addValue(prod);
        } else {
            throw new ParseException(6, "unrecognized identifier '" + name + "'", node.getStartLine(), node.getStartColumn());
        }
        return node;
    }

    protected Node exitQuotedString(Token node) throws ParseException {
        String str = node.getImage();
        TokenPattern token = this.grammar.getTokenPatternByImage(str = str.substring(1, str.length() - 1));
        if (token == null) {
            throw new ParseException(6, "unrecognized token \"" + str + "\"", node.getStartLine(), node.getStartColumn());
        }
        node.addValue(token);
        return node;
    }

    protected Node exitGrammar(Production node) {
        return null;
    }

    protected Node exitProductionPart(Production node) {
        return null;
    }

    protected void childProductionDeclaration(Production node, Node child) throws ParseException {
        super.childProductionDeclaration(node, child);
        if (child.getId() == 1019) {
            this.currentProduction = (ProductionPattern)child.getValue(0);
        }
    }

    protected Node exitProductionDeclaration(Production node) throws ParseException {
        ProductionPattern pattern = (ProductionPattern)this.getValue(this.getChildAt(node, 0), 0);
        Node child = this.getChildAt(node, 2);
        int i = 0;
        while (i < child.getValueCount()) {
            ProductionPatternAlternative alt = (ProductionPatternAlternative)this.getValue(child, i);
            try {
                pattern.addAlternative(alt);
            }
            catch (ParserCreationException e) {
                throw new ParseException(6, e.getMessage(), node.getStartLine(), node.getStartColumn());
            }
            ++i;
        }
        return null;
    }

    protected Node exitProduction(Production node) throws ParseException {
        ProductionPatternAlternative alt = new ProductionPatternAlternative();
        node.addValue(alt);
        int i = 0;
        while (i < node.getChildCount()) {
            Node child = this.getChildAt(node, i);
            if (child.getId() == 2011) {
                int j = 0;
                while (j < child.getValueCount()) {
                    ProductionPatternElement elem = (ProductionPatternElement)this.getValue(child, j);
                    alt.addElement(elem);
                    ++j;
                }
            } else if (child.getId() == 2010) {
                node.addValues(child.getAllValues());
            }
            ++i;
        }
        return node;
    }

    protected Node exitProductionAtom(Production node) throws ParseException {
        boolean token = false;
        int id = 0;
        int min = 1;
        int max = 1;
        Node child = this.getChildAt(node, 0);
        switch (child.getId()) {
            case 1019: {
                Object obj = this.getValue(child, 0);
                if (obj instanceof TokenPattern) {
                    token = true;
                    id = ((TokenPattern)obj).getId();
                    break;
                }
                token = false;
                id = ((ProductionPattern)obj).getId();
                break;
            }
            case 1020: {
                token = true;
                id = ((TokenPattern)this.getValue(child, 0)).getId();
                break;
            }
            case 1008: 
            case 1010: 
            case 1012: {
                if (child.getId() == 1010) {
                    min = 0;
                    max = -1;
                } else if (child.getId() == 1012) {
                    min = 0;
                    max = 1;
                }
                ProductionPatternElement elem = this.getProductionElement(this.getChildAt(node, 1));
                token = elem.isToken();
                id = elem.getId();
            }
        }
        child = this.getChildAt(node, node.getChildCount() - 1);
        if (child.getId() == 1014) {
            min = 0;
            max = 1;
        } else if (child.getId() == 1016) {
            min = 0;
            max = -1;
        } else if (child.getId() == 1015) {
            min = 1;
            max = -1;
        }
        node.addValue(new ProductionPatternElement(token, id, min, max));
        return node;
    }

    private ProductionPatternElement getProductionElement(Node node) throws ParseException {
        ProductionPatternAlternative alt = (ProductionPatternAlternative)this.getValue(node, 0);
        if (node.getValueCount() == 1 && this.isSimple(alt)) {
            return alt.getElement(0);
        }
        String str = this.currentProduction.getName() + "(" + (this.nextSynteticId - 3000) + ")";
        ProductionPattern prod = new ProductionPattern(this.nextSynteticId, str);
        prod.setSyntetic(true);
        int i = 0;
        while (i < node.getValueCount()) {
            alt = (ProductionPatternAlternative)this.getValue(node, i);
            try {
                prod.addAlternative(alt);
            }
            catch (ParserCreationException e) {
                throw new ParseException(6, e.getMessage(), node.getStartLine(), node.getStartColumn());
            }
            ++i;
        }
        this.grammar.addProduction(prod, node.getStartLine(), node.getEndLine());
        return new ProductionPatternElement(false, this.nextSynteticId++, 1, 1);
    }

    private boolean isSimple(ProductionPatternAlternative alt) {
        return alt.getElementCount() == 1 && alt.getMinElementCount() == 1 && alt.getMaxElementCount() == 1;
    }
}

