/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.percederberg.grammatica.parser.Analyzer;
import net.percederberg.grammatica.parser.LookAheadSet;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.Parser;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.Production;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.ProductionPatternAlternative;
import net.percederberg.grammatica.parser.ProductionPatternElement;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.grammatica.parser.Tokenizer;

public class RecursiveDescentParser
extends Parser {
    private HashMap lookAheads = new HashMap();

    public RecursiveDescentParser(Tokenizer tokenizer) {
        super(tokenizer);
    }

    public RecursiveDescentParser(Tokenizer tokenizer, Analyzer analyzer) {
        super(tokenizer, analyzer);
    }

    public void addPattern(ProductionPattern pattern) throws ParserCreationException {
        if (pattern.isMatchingEmpty()) {
            throw new ParserCreationException(3, pattern.getName(), "zero elements can be matched (minimum is one)");
        }
        if (pattern.isLeftRecursive()) {
            throw new ParserCreationException(3, pattern.getName(), "left recursive patterns are not allowed");
        }
        super.addPattern(pattern);
    }

    public void prepare() throws ParserCreationException {
        super.prepare();
        this.setInitialized(false);
        Iterator iter = this.getPatterns().iterator();
        while (iter.hasNext()) {
            this.calculateLookAhead((ProductionPattern)iter.next());
        }
        this.setInitialized(true);
    }

    protected Node parseStart() throws ParseException {
        Node node = this.parsePattern(this.getStartPattern());
        Token token = this.peekToken(0);
        if (token != null) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add("<EOF>");
            throw new ParseException(4, token.toShortString(), list, token.getStartLine(), token.getStartColumn());
        }
        return node;
    }

    private Node parsePattern(ProductionPattern pattern) throws ParseException {
        ProductionPatternAlternative defaultAlt = pattern.getDefaultAlternative();
        for (int i = 0; i < pattern.getAlternativeCount(); ++i) {
            ProductionPatternAlternative alt = pattern.getAlternative(i);
            if (defaultAlt == alt || !this.isNext(alt)) continue;
            return this.parseAlternative(alt);
        }
        if (defaultAlt == null || !this.isNext(defaultAlt)) {
            this.throwParseException(this.findUnion(pattern));
        }
        return this.parseAlternative(defaultAlt);
    }

    private Node parseAlternative(ProductionPatternAlternative alt) throws ParseException {
        Production node = new Production(alt.getPattern());
        this.enterNode(node);
        for (int i = 0; i < alt.getElementCount(); ++i) {
            try {
                this.parseElement(node, alt.getElement(i));
                continue;
            }
            catch (ParseException e) {
                this.addError(e, true);
                this.nextToken();
                --i;
            }
        }
        return this.exitNode(node);
    }

    private void parseElement(Production node, ProductionPatternElement elem) throws ParseException {
        for (int i = 0; i < elem.getMaxCount() && (i < elem.getMinCount() || this.isNext(elem)); ++i) {
            Node child;
            if (elem.isToken()) {
                child = this.nextToken(elem.getId());
                this.enterNode(child);
                this.addNode(node, this.exitNode(child));
                continue;
            }
            child = this.parsePattern(this.getPattern(elem.getId()));
            this.addNode(node, child);
        }
    }

    private boolean isNext(ProductionPattern pattern) {
        LookAheadSet set = pattern.getLookAhead();
        if (set == null) {
            return false;
        }
        return set.isNext(this);
    }

    private boolean isNext(ProductionPatternAlternative alt) {
        LookAheadSet set = alt.getLookAhead();
        if (set == null) {
            return false;
        }
        return set.isNext(this);
    }

    private boolean isNext(ProductionPatternElement elem) {
        LookAheadSet set = elem.getLookAhead();
        if (set != null) {
            return set.isNext(this);
        }
        if (elem.isToken()) {
            return elem.isMatch(this.peekToken(0));
        }
        return this.isNext(this.getPattern(elem.getId()));
    }

    private void calculateLookAhead(ProductionPattern pattern) throws ParserCreationException {
        ProductionPatternAlternative alt;
        int i;
        LookAheadSet previous = new LookAheadSet(0);
        int length = 1;
        CallStack stack = new CallStack();
        stack.push(pattern.getName(), 1);
        LookAheadSet result = new LookAheadSet(1);
        LookAheadSet[] alternatives = new LookAheadSet[pattern.getAlternativeCount()];
        for (i = 0; i < pattern.getAlternativeCount(); ++i) {
            alt = pattern.getAlternative(i);
            alternatives[i] = this.findLookAhead(alt, 1, 0, stack, null);
            alt.setLookAhead(alternatives[i]);
            result.addAll(alternatives[i]);
        }
        if (pattern.getLookAhead() == null) {
            pattern.setLookAhead(result);
        }
        LookAheadSet conflicts = this.findConflicts(pattern, 1);
        while (conflicts.size() > 0) {
            stack.clear();
            stack.push(pattern.getName(), ++length);
            conflicts.addAll(previous);
            for (i = 0; i < pattern.getAlternativeCount(); ++i) {
                alt = pattern.getAlternative(i);
                if (alternatives[i].intersects(conflicts)) {
                    alternatives[i] = this.findLookAhead(alt, length, 0, stack, conflicts);
                    alt.setLookAhead(alternatives[i]);
                }
                if (!alternatives[i].intersects(conflicts)) continue;
                if (pattern.getDefaultAlternative() == null) {
                    pattern.setDefaultAlternative(i);
                    continue;
                }
                if (pattern.getDefaultAlternative() == alt) continue;
                result = alternatives[i].createIntersection(conflicts);
                this.throwAmbiguityException(pattern.getName(), null, result);
            }
            previous = conflicts;
            conflicts = this.findConflicts(pattern, length);
        }
        for (i = 0; i < pattern.getAlternativeCount(); ++i) {
            this.calculateLookAhead(pattern.getAlternative(i), 0);
        }
    }

    private void calculateLookAhead(ProductionPatternAlternative alt, int pos) throws ParserCreationException {
        LookAheadSet previous = new LookAheadSet(0);
        int length = 1;
        if (pos >= alt.getElementCount()) {
            return;
        }
        ProductionPattern pattern = alt.getPattern();
        ProductionPatternElement elem = alt.getElement(pos);
        if (elem.getMinCount() == elem.getMaxCount()) {
            this.calculateLookAhead(alt, pos + 1);
            return;
        }
        LookAheadSet first = this.findLookAhead(elem, 1, new CallStack(), null);
        LookAheadSet follow = this.findLookAhead(alt, 1, pos + 1, new CallStack(), null);
        String location = "at position " + (pos + 1);
        LookAheadSet conflicts = this.findConflicts(pattern.getName(), location, first, follow);
        while (conflicts.size() > 0) {
            conflicts.addAll(previous);
            first = this.findLookAhead(elem, ++length, new CallStack(), conflicts);
            follow = this.findLookAhead(alt, length, pos + 1, new CallStack(), conflicts);
            first = first.createCombination(follow);
            elem.setLookAhead(first);
            if (first.intersects(conflicts)) {
                first = first.createIntersection(conflicts);
                this.throwAmbiguityException(pattern.getName(), location, first);
            }
            previous = conflicts;
            conflicts = this.findConflicts(pattern.getName(), location, first, follow);
        }
        this.calculateLookAhead(alt, pos + 1);
    }

    private LookAheadSet findLookAhead(ProductionPattern pattern, int length, CallStack stack, LookAheadSet filter) throws ParserCreationException {
        if (stack.contains(pattern.getName(), length)) {
            throw new ParserCreationException(4, pattern.getName(), null);
        }
        stack.push(pattern.getName(), length);
        LookAheadSet result = new LookAheadSet(length);
        for (int i = 0; i < pattern.getAlternativeCount(); ++i) {
            LookAheadSet temp = this.findLookAhead(pattern.getAlternative(i), length, 0, stack, filter);
            result.addAll(temp);
        }
        stack.pop();
        return result;
    }

    private LookAheadSet findLookAhead(ProductionPatternAlternative alt, int length, int pos, CallStack stack, LookAheadSet filter) throws ParserCreationException {
        if (length <= 0 || pos >= alt.getElementCount()) {
            return new LookAheadSet(0);
        }
        LookAheadSet first = this.findLookAhead(alt.getElement(pos), length, stack, filter);
        if (alt.getElement(pos).getMinCount() == 0) {
            first.addEmpty();
        }
        if (filter == null) {
            if ((length -= first.getMinLength()) > 0) {
                LookAheadSet follow = this.findLookAhead(alt, length, pos + 1, stack, null);
                first = first.createCombination(follow);
            }
        } else if (filter.isOverlap(first)) {
            LookAheadSet overlaps = first.createOverlaps(filter);
            filter = filter.createFilter(overlaps);
            LookAheadSet follow = this.findLookAhead(alt, length -= overlaps.getMinLength(), pos + 1, stack, filter);
            first.removeAll(overlaps);
            first.addAll(overlaps.createCombination(follow));
        }
        return first;
    }

    private LookAheadSet findLookAhead(ProductionPatternElement elem, int length, CallStack stack, LookAheadSet filter) throws ParserCreationException {
        LookAheadSet first = this.findLookAhead(elem, length, 0, stack, filter);
        LookAheadSet result = new LookAheadSet(length);
        result.addAll(first);
        if (filter == null || !filter.isOverlap(result)) {
            return result;
        }
        if (elem.getMaxCount() == Integer.MAX_VALUE) {
            first = first.createRepetitive();
        }
        int max = Math.min(length, elem.getMaxCount());
        for (int i = 1; i < max && (first = first.createOverlaps(filter)).size() > 0 && first.getMinLength() < length; ++i) {
            LookAheadSet follow = this.findLookAhead(elem, length, 0, stack, filter.createFilter(first));
            first = first.createCombination(follow);
            result.addAll(first);
        }
        return result;
    }

    private LookAheadSet findLookAhead(ProductionPatternElement elem, int length, int dummy, CallStack stack, LookAheadSet filter) throws ParserCreationException {
        LookAheadSet result;
        if (elem.isToken()) {
            result = new LookAheadSet(length);
            result.add(elem.getId());
        } else {
            ProductionPattern pattern = this.getPattern(elem.getId());
            result = this.findLookAhead(pattern, length, stack, filter);
            if (stack.contains(pattern.getName())) {
                result = result.createRepetitive();
            }
        }
        return result;
    }

    private LookAheadSet findConflicts(ProductionPattern pattern, int maxLength) throws ParserCreationException {
        LookAheadSet result = new LookAheadSet(maxLength);
        for (int i = 0; i < pattern.getAlternativeCount(); ++i) {
            LookAheadSet set1 = pattern.getAlternative(i).getLookAhead();
            for (int j = 0; j < i; ++j) {
                LookAheadSet set2 = pattern.getAlternative(j).getLookAhead();
                result.addAll(set1.createIntersection(set2));
            }
        }
        if (result.isRepetitive()) {
            this.throwAmbiguityException(pattern.getName(), null, result);
        }
        return result;
    }

    private LookAheadSet findConflicts(String pattern, String location, LookAheadSet set1, LookAheadSet set2) throws ParserCreationException {
        LookAheadSet result = set1.createIntersection(set2);
        if (result.isRepetitive()) {
            this.throwAmbiguityException(pattern, location, result);
        }
        return result;
    }

    private LookAheadSet findUnion(ProductionPattern pattern) {
        LookAheadSet result;
        int i;
        int length = 0;
        for (i = 0; i < pattern.getAlternativeCount(); ++i) {
            result = pattern.getAlternative(i).getLookAhead();
            if (result.getMaxLength() <= length) continue;
            length = result.getMaxLength();
        }
        result = new LookAheadSet(length);
        for (i = 0; i < pattern.getAlternativeCount(); ++i) {
            result.addAll(pattern.getAlternative(i).getLookAhead());
        }
        return result;
    }

    private void throwParseException(LookAheadSet set) throws ParseException {
        ArrayList<String> list = new ArrayList<String>();
        while (set.isNext(this, 1)) {
            set = set.createNextSet(this.nextToken().getId());
        }
        int[] initials = set.getInitialTokens();
        for (int i = 0; i < initials.length; ++i) {
            list.add(this.getTokenDescription(initials[i]));
        }
        Token token = this.nextToken();
        throw new ParseException(4, token.toShortString(), list, token.getStartLine(), token.getStartColumn());
    }

    private void throwAmbiguityException(String pattern, String location, LookAheadSet set) throws ParserCreationException {
        ArrayList<String> list = new ArrayList<String>();
        int[] initials = set.getInitialTokens();
        for (int i = 0; i < initials.length; ++i) {
            list.add(this.getTokenDescription(initials[i]));
        }
        throw new ParserCreationException(5, pattern, location, list);
    }

    private class CallStack {
        private ArrayList nameStack = new ArrayList();
        private ArrayList valueStack = new ArrayList();

        private CallStack() {
        }

        public boolean contains(String name) {
            return this.nameStack.contains(name);
        }

        public boolean contains(String name, int value) {
            Integer obj = new Integer(value);
            for (int i = 0; i < this.nameStack.size(); ++i) {
                if (!this.nameStack.get(i).equals(name) || !this.valueStack.get(i).equals(obj)) continue;
                return true;
            }
            return false;
        }

        public void clear() {
            this.nameStack.clear();
            this.valueStack.clear();
        }

        public void push(String name, int value) {
            this.nameStack.add(name);
            this.valueStack.add(new Integer(value));
        }

        public void pop() {
            if (this.nameStack.size() > 0) {
                this.nameStack.remove(this.nameStack.size() - 1);
                this.valueStack.remove(this.valueStack.size() - 1);
            }
        }
    }
}

