/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser.re;

import java.io.PrintWriter;
import java.util.BitSet;
import net.percederberg.grammatica.parser.re.CharBuffer;
import net.percederberg.grammatica.parser.re.Element;
import net.percederberg.grammatica.parser.re.Matcher;

class RepeatElement
extends Element {
    public static final int GREEDY = 1;
    public static final int RELUCTANT = 2;
    public static final int POSSESSIVE = 3;
    private Element elem;
    private int min;
    private int max;
    private int type;
    private int matchStart;
    private BitSet matches;

    public RepeatElement(Element elem, int min, int max, int type) {
        this.elem = elem;
        this.min = min;
        this.max = max <= 0 ? Integer.MAX_VALUE : max;
        this.type = type;
        this.matchStart = -1;
        this.matches = null;
    }

    public Object clone() {
        return new RepeatElement((Element)this.elem.clone(), this.min, this.max, this.type);
    }

    public int match(Matcher m, CharBuffer str, int start, int skip) {
        if (skip == 0) {
            this.matchStart = -1;
            this.matches = null;
        }
        switch (this.type) {
            case 1: {
                return this.matchGreedy(m, str, start, skip);
            }
            case 2: {
                return this.matchReluctant(m, str, start, skip);
            }
            case 3: {
                if (skip != 0) break;
                return this.matchPossessive(m, str, start, 0);
            }
        }
        return -1;
    }

    private int matchGreedy(Matcher m, CharBuffer str, int start, int skip) {
        if (skip == 0) {
            return this.matchPossessive(m, str, start, 0);
        }
        if (this.matchStart != start) {
            this.matchStart = start;
            this.matches = new BitSet();
            this.findMatches(m, str, start, 0, 0, 0);
        }
        for (int i = this.matches.size(); i >= 0; --i) {
            if (!this.matches.get(i)) continue;
            if (skip == 0) {
                return i;
            }
            --skip;
        }
        return -1;
    }

    private int matchReluctant(Matcher m, CharBuffer str, int start, int skip) {
        if (this.matchStart != start) {
            this.matchStart = start;
            this.matches = new BitSet();
            this.findMatches(m, str, start, 0, 0, 0);
        }
        for (int i = 0; i <= this.matches.size(); ++i) {
            if (!this.matches.get(i)) continue;
            if (skip == 0) {
                return i;
            }
            --skip;
        }
        return -1;
    }

    private int matchPossessive(Matcher m, CharBuffer str, int start, int count) {
        int length = 0;
        int subLength = 1;
        while (subLength > 0 && count < this.max) {
            subLength = this.elem.match(m, str, start + length, 0);
            if (subLength < 0) continue;
            ++count;
            length += subLength;
        }
        if (this.min <= count && count <= this.max) {
            return length;
        }
        return -1;
    }

    private void findMatches(Matcher m, CharBuffer str, int start, int length, int count, int attempt) {
        int subLength;
        if (count > this.max) {
            return;
        }
        if (this.min <= count && attempt == 0) {
            this.matches.set(length);
        }
        if ((subLength = this.elem.match(m, str, start, attempt)) < 0) {
            return;
        }
        if (subLength == 0) {
            if (this.min == count + 1) {
                this.matches.set(length);
            }
            return;
        }
        this.findMatches(m, str, start, length, count, attempt + 1);
        this.findMatches(m, str, start + subLength, length + subLength, count + 1, 0);
    }

    public void printTo(PrintWriter output, String indent) {
        output.print(indent + "Repeat (" + this.min + "," + this.max + ")");
        if (this.type == 2) {
            output.print("?");
        } else if (this.type == 3) {
            output.print("+");
        }
        output.println();
        this.elem.printTo(output, indent + "  ");
    }
}

