#
# $Id$
#
# This file is part of GraphTool.
#
# GraphTool is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# GraphTool is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GraphTool; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

from vcedge import *
import interactive as inter

class Arc (VcEdge, inter.Interactive):
    def __init__(self, graph):
        VcEdge.__init__(self, graph)
        inter.Interactive.__init__ (self)
        # partir de l nous sommes connects au CANVAS
        self._graph = graph
#        self.valued = False
#        self.value = 0

#     def init_shapes (self):
#         #init de value
#         VcEdge.init_shapes (self)
#         #ajout de la valeur
#         self._shapes.append (dia.shape.Text ())
# 	font = pango.FontDescription('sans 14')
# 	self._shapes[1].set_font_description(font)
# 	self._shapes[1].set_text_width(20)
#         self._shapes[1].set_max_height(20)
#         self._shapes[1].set_pos ((self.width, self.height))
#         self._shapes[1].set_text ('0')

    def __del__(self):
         VcEdge.__del__(self)

    def delete (self):
        print "effacage d'arc"
        try:
            #couper les refs  nous-mme dans nos noeuds
            self._first_node.remove_out_edge (self)
            self._second_node.remove_in_edge (self)
        except:
            print "Nous n'tions pas attachs ?"
        #perdre les refs  nos noeuds
        self._first_node = None
        self._second_node = None
        #couper la ref  nous-mme dans le graph
        self._graph.remove_arc (self)
        self.parent.remove(self)

    def attach (self, first, second):
        print first.get_successors ()
        if second in first.get_successors ():
            raise EdgeError ("nodes already connected")
        #se connecter au canvas/graphe
        self._graph.add_arc (self)
        #Connexion des handles (l'anctre s'en occupe)
        VcEdge.attach (self, first, second)
        #s'attacher  nos noeuds
        self._first_node = first
        self._second_node = second
        #attacher les noeuds  nous-mme
        self._first_node.add_out_edge (self)
        self._second_node.add_in_edge (self)

    def get_nodes (self):
        return (self._first_node, self._second_node)

    def get_first_node (self):
        return self._first_node

    def get_second_node (self):
        return self._second_node


class EdgeError(Exception):
    def __init__(self, msg):
        self.msg = msg

    def get_msg (self):
        return self.msg
