#
# $Id$
#
# This file is part of GraphTool.
#
# GraphTool is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# GraphTool is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GraphTool; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
import diacanvas
import gobject
import gtk
import propeditor

class EditionTool (diacanvas.Tool):
    __gsignals__ = {
    	'button_press_event': 'override',
        'key_press_event': 'override'
    }
    def __init__ (self):
        self.__gobject_init__()

    # Affichage du menu contextuel
    def do_button_press_event (self, view, event):
        if event.button is not 3:
            return 0

        menu = gtk.Menu()

        # si rien n'est selectionn, on montre le menu du graphe
        if not view.selected_items:
            tab = view.canvas.get_user_methods()
            for method in tab:
                # method: [label, callback, tips]
                item = gtk.MenuItem(method[0])
                item.connect('activate', self.launch, method[1])
                item.show()
                menu.append(item)
            menu.append(gtk.SeparatorMenuItem())
            item = gtk.MenuItem('Graph Properties')
            item.connect('activate',
                         self.show_graph_properties_dialog,
                         view.canvas)
            item.show()
            menu.append(item)
            menu.popup(None, None, None, event.button, event.time)
            return 1

        # si des objets sont slectionns, on montre les actions collectives
        # (supprimer), les actions personnelles (mthodes) et les proprits
        item = gtk.MenuItem('Delete Selection')
        item.connect('activate', view.delete_selection)
        item.show()
        menu.append(item)
        menu.append(gtk.SeparatorMenuItem())

        # les proprits seulement si un objet a le focus
        if view.focus_item:
            tab = view.focus_item.item.get_user_methods()
            for method in tab:
                item = gtk.MenuItem(method[0])
                item.connect('activate', self.launch, method[1])
                item.show()
                menu.append(item)
            menu.append(gtk.SeparatorMenuItem())
            item = gtk.MenuItem('Object Properties')
            item.connect('activate',
                         self.show_object_properties_dialog,
                         view.focus_item.item)
            item.show()
            menu.append(item)
        
        menu.popup(None, None, None, event.button, event.time)
        return 1

    def do_key_press_event (self, view, event):
        # Touche Delete
        if event.keyval == 65535:
            view.delete_selection()
        return 1

    def show_graph_properties_dialog (self, junk, graph):
        propeditor.create_prop_editor(graph)

    def show_object_properties_dialog (self, junk, obj):
        propeditor.create_prop_editor(obj)

    def launch (self, menuitem, callback):
        callback()
        
gobject.type_register(EditionTool)
