#
# $Id$
#
# This file is part of GraphTool.
#
# GraphTool is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# GraphTool is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GraphTool; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
"""
Le PlacementTool s'occupe de placer les objets sur le canvas, il rcupre aussi les
vnements souris et clavier quand il est activ (son activation se fait dans l'objet
'view' selon les ordres du GUI).

Paramtres:
 o le CanvasView: on en a besoin pour demander de repasser en mode normal
 o le type: 0 pour les noeuds et 1 pour les aretes
 o constructor_from_graph: le constructeur, donn au GUI par l'objet Graph, il permet
   d'instancier un objet du type voulu avant de le placer. pour les edges, il faudra
   fournir les 2 noeuds extrmits au constructeur
 o properties: utilis par DiaCanvas je crois ...

Fonctionnement:
 o pour les noeuds, l'utilisateur doit cliquer sur le canvas avec le bouton gauche.
www   on cre alors un noeud et on le place.
 o pour les aretes, l'utilisateur doit cliquer sur deux noeuds avec le clic gauche,
   on pourra alors crer l'arete correspondante.
 o clic-droit: annulation d'une insertion (passage en mode normal: destruction du
   placementtool) pour afficher le menu contextuel, ce n'est pas ici.

PS: le code est largement inspir de la dmo de l'auteur.

"""

import diacanvas as dia
import gobject
import traceback
import vcnode

class PlacementTool(dia.Tool):
    __gsignals__ = {
        'button_press_event': 'override',
    	'button_release_event': 'override',
        'key_press_event': 'override'
    }
    def __init__(self, view, constructor_from_graph, **properties):
	self.__gobject_init__()
	self.constructor = constructor_from_graph
	self.properties = properties
        self.view = view
        #print constructor_from_graph

    def do_key_press_event(self, view, event, data=None):
        # touche delete, on efface la selection
        return 1

    def do_button_press_event(self, view, event):
        # tester le bouton, si bouton droit, alors sortir du mode insertion
        if event.button == 3:
            # on sort du mode insertion
            view.gui.tb_normal_mode()
            return 1

	try:
            new_object = self._create_item (view, event)
	except Exception, e:
	    #print 'diacanvas.PlacementTool: Error while creating new item:', e
	    traceback.print_exc()
	    new_object = None
	    return 0
        
	try:
	    self._move_item (view, event, new_object)
	except Exception, e:
	    #print 'diacanvas.PlacementTool: Error while moving new item:', e
	    traceback.print_exc()
	    new_object.parent.remove(new_object)
	    new_object = None
            return 0

        #if not (event.state & 4):
        #    view.gui.tb_normal_mode()

	return 0

    def do_button_release_event(self, view, event):

        return 0

    def _create_item(self, view, event):
	"""
	Create a new object to be added to the canvas.
	Return: new canvas item.
	"""

        print "cration node"
        item = self.constructor()

	if not item:
            print "Something awful happened. Go hang yourself."
            return None
        
# 	if self.properties and len(self.properties) > 0:
# 	    try:
# 		for (k,v) in self.properties.items():
# 		    item.set_property(k, v)
# 	    except TypeError, e:
# 	        #print 'PlacementTool:', e
# 		traceback.print_exc()
	return item
	
    def _move_item(self, view, event, item):
	"""
	Move the newly created item to the desired position.
	"""
	wx, wy = view.window_to_world(event.x, event.y)
	ix, iy = item.affine_point_w2i(wx, wy)
	item.move(ix, iy)
	
gobject.type_register(PlacementTool)
