#
# $Id$
#
# This file is part of GraphTool.
#
# GraphTool is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# GraphTool is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GraphTool; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
"""
Le PlacementTool s'occupe de placer les objets sur le canvas, il rcupre aussi les
vnements souris et clavier quand il est activ (son activation se fait dans l'objet
'view' selon les ordres du GUI).

Paramtres:
 o le CanvasView: on en a besoin pour demander de repasser en mode normal
 o le type: 0 pour les noeuds et 1 pour les aretes
 o constructor_from_graph: le constructeur, donn au GUI par l'objet Graph, il permet
   d'instancier un objet du type voulu avant de le placer. pour les edges, il faudra
   fournir les 2 noeuds extrmits au constructeur
 o properties: utilis par DiaCanvas je crois ...

Fonctionnement:
 o pour les noeuds, l'utilisateur doit cliquer sur le canvas avec le bouton gauche.
www   on cre alors un noeud et on le place.
 o pour les aretes, l'utilisateur doit cliquer sur deux noeuds avec le clic gauche,
   on pourra alors crer l'arete correspondante.
 o clic-droit: annulation d'une insertion (passage en mode normal: destruction du
   placementtool) pour afficher le menu contextuel, ce n'est pas ici.

PS: le code est largement inspir de la dmo de l'auteur.

"""

import diacanvas as dia
import gobject
import traceback
import vcnode

class PlacementTool(dia.Tool):
    __gsignals__ = {
        'button_press_event': 'override',
    	'button_release_event': 'override',
        'key_press_event': 'override'
    }
    def __init__(self, view, type, constructor_from_graph, **properties):
	self.__gobject_init__()
#        dia.PlacementTool.__init__(self, type, **properties)
#        self.connect('key_press_event', self.do_key_press_event)
	self.constructor = constructor_from_graph
	self.properties = properties
        self.view = view
        self.type = type
        self.first = None
        print constructor_from_graph
##         if type:
##             print ' EDGE MODE INSTALLED'
##         else:
##             print ' NODE MODE INSTALLED'

    def do_key_press_event(self, view, event, data=None):
        # touche delete, on efface la selection
        return 1


    def do_button_press_event(self, view, event):
        ##print 'PlacementTool: clic', event.button, 'pressed'
        # tester le bouton, si bouton droit, alors sortir du mode insertion
        if event.button == 3:
            # on sort du mode insertion
            view.gui.tb_normal_mode()
            return 1
        if self.type:
            return 0

        # mode insertion d'arete
##         if self.type:
##             # si la sauvegarde du premier clic est vide, on la remplit 
##             if not self.first:
##                 #print 'premier clic: '
##                 if view.focus_item:
##                     #print '  ', view.focus_item
##                     self.first = view.focus_item
##                 else:
##                     #print ".. t'as loup le noeud..."
##                 return
##             else:
##                 #print 'second clic: '
##                 if view.focus_item:
##                     #print '  ', view.focus_item
##                 else:
##                     #print '.. loup'

	try:
            new_object = self._create_item(view, event)
	except Exception, e:
	    #print 'diacanvas.PlacementTool: Error while creating new item:', e
	    traceback.print_exc()
	    new_object = None
	    return 0
        
	if not new_object:
	    return 0

	if not new_object.parent:
            print "HELLLLLL"
	    new_object.set_property('parent', view.canvas.root)

	try:
	    self._move_item(view, event, new_object)
	except Exception, e:
	    #print 'diacanvas.PlacementTool: Error while moving new item:', e
	    traceback.print_exc()
	    new_object.parent.remove(new_object)
	    new_object = None
            return 0

##         if self.type:
##             hop = self.first.affine
##             new_object.set_property("tail_pos", (hop[4],hop[5]))
##             self.first = None

#	try:
#	    self._grab_handle(view, event, self.new_object)
#	except Exception, e:
#	    #print 'diacanvas.PlacementTool: Error while grabbing new item:', e
#	    traceback.#print_exc()
#	    self.new_object.parent.remove(self.new_object)
#	    self.new_object = None
#	    return 1

	#view.canvas.set_property ('allow_undo', old_allow_undo)
        if not (event.state & 4):
            view.gui.tb_normal_mode()

	return 0

    def do_button_release_event(self, view, event):
        #print 'PlacementTool: clic', event.button, 'released'

        if not self.type:
            return 0

        # si la sauvegarde du premier clic est vide, on la remplit
        #print view.focus_item
        #print view.focus_item.item
        if not self.first:
            #print 'premier clic'
            if view.focus_item and isinstance(view.focus_item.item, vcnode.VcNode):
                self.first = view.focus_item.item
                #print '  selecting', self.first
                view.unselect_all()
                view.gui.write_msg('Click on the TO node (the destination node)')
            return 0
        else:
            #print 'second clic'
            if not (view.focus_item and
                    isinstance(view.focus_item.item,
                               vcnode.VcNode)):
                return 0

        try:
            new_object = self._create_item(view, event)
	except Exception, e:
	    #print 'diacanvas.PlacementTool: Error while creating new item:', e
            self.first = None
	    traceback.print_exc()
	    new_object = None
	    return 0

	try:
	    self._move_item(view, event, new_object)
	except Exception, e:
	    #print 'diacanvas.PlacementTool: Error while moving new item:', e
	    traceback.print_exc()
	    #new_object.parent.remove(new_object)
	    new_object = None
            return 0

##         if self.type:
##             hop = self.first.affine
##             new_object.set_property("tail_pos", (hop[4],hop[5]))
##             self.first = None

##         try:
## 	    self._grab_handle(view, event, new_object)
## 	except Exception, e:
## 	    #print 'diacanvas.PlacementTool: Error while grabbing new item:', e
## 	    traceback.#print_exc()
## 	    new_object.parent.remove(new_object)
## 	    new_object = None
## 	    return 1
##          self.first = None
## 	if not new_object:
## 	    return 1

	if not new_object.parent:
            print "HELLLLLLL n2"
            new_object.set_property('parent', view.canvas.root)
            try:
                new_object.attach (self.first, view.focus_item.item)
            except Exception, e:
                view.gui.write_msg (e.get_msg ()+' ('+str(type(self.first))+')')
                new_object.set (parent=None)
                               

        #view.gui.tb_normal_mode()
#	del self.new_object
	return 0

# Avant l'insertion des aretes en clic release

##     def do_button_press_event(self, view, event):
##         #print 'PlacementTool: clic', event.button, 'pressed'
##         # tester le bouton, si bouton droit, alors sortir du mode insertion
##         if event.button == 3:
##             # on sort du mode insertion
##             self.view.gui.tb_normal_mode()
##             return

##         # mode insertion d'arete
##         if self.type:
##             # si la sauvegarde du premier clic est vide, on la remplit 
##             if not self.first:
##                 #print 'premier clic: '
##                 if view.focus_item:
##                     #print '  ', view.focus_item
##                     self.first = view.focus_item
##                 else:
##                     #print ".. t'as loup le noeud..."
##                 return
##             else:
##                 #print 'second clic: '
##                 if view.focus_item:
##                     #print '  ', view.focus_item
##                 else:
##                     #print '.. loup'

## 	try:
##             new_object = self._create_item(view, event)
## 	except Exception, e:
## 	    #print 'diacanvas.PlacementTool: Error while creating new item:', e
## 	    traceback.#print_exc()
## 	    new_object = None
## 	    return 1

## 	if not new_object:
## 	    return 1

## 	if not new_object.parent:
## 	    new_object.set_property('parent', view.canvas.root)

## 	try:
## 	    self._move_item(view, event, new_object)
## 	except Exception, e:
## 	    #print 'diacanvas.PlacementTool: Error while moving new item:', e
## 	    traceback.#print_exc()
## 	    new_object.parent.remove(new_object)
## 	    new_object = None
##             return 1

##         if self.type:
##             hop = self.first.affine
##             new_object.set_property("tail_pos", (hop[4],hop[5]))
##             self.first = None

## #	try:
## #	    self._grab_handle(view, event, self.new_object)
## #	except Exception, e:
## #	    #print 'diacanvas.PlacementTool: Error while grabbing new item:', e
## #	    traceback.#print_exc()
## #	    self.new_object.parent.remove(self.new_object)
## #	    self.new_object = None
## #	    return 1

## 	#view.canvas.set_property ('allow_undo', old_allow_undo)
## 	return 1

##     def do_button_release_event(self, view, event):
##         #print 'PlacementTool: clic', event.button, 'released'
## #	del self.new_object
## 	return 0

    def _create_item(self, view, event):
	"""
	Create a new object to be added to the canvas.
	Return: new canvas item.
	"""

        # pour les aretes
        if self.type:
            print "PT cration arrte"
            item = self.constructor ()
        # pour les noeuds
        else:
            print "NODE cr"
            item = self.constructor()

	if not item:
            #print 'Graph specifications denied the specified construction'
            return
        
	if self.properties and len(self.properties) > 0:
	    try:
		for (k,v) in self.properties.items():
		    item.set_property(k, v)
	    except TypeError, e:
	        #print 'PlacementTool:', e
		traceback.print_exc()
	return item
	
    def _move_item(self, view, event, item):
	"""
	Move the newly created item to the desired position.
	"""
	wx, wy = view.window_to_world(event.x, event.y)
	ix, iy = item.affine_point_w2i(wx, wy)
	item.move(ix, iy)
	
##     def _grab_handle(self, view, event, item):
## 	"""
## 	Grab a handle of the newly created canvas item. This will allow
## 	the user to instanty resize the newly created canvas item.
## 	"""
## 	if isinstance(item, dia.CanvasLine) and len(item.handles) > 0:
## 	    ##print 'PlacementTool: setting handle of Line'
## 	    first = item.handles[0]
## 	    last = item.handles[-1]
## 	    wx, wy = view.window_to_world(event.x, event.y)
## 	    dist, glue, glue_to = view.canvas.glue_handle (first, wx, wy)
## 	    if glue_to and (dist <= view.handle_layer.glue_distance):
## 		glue_to.connect_handle(first)
## 	    view.handle_layer.grab_handle(last)
## 	elif isinstance(item, dia.CanvasElement):
## 	    ##print 'PlacementTool: setting handle of Element'
## 	    handle = item.handles[dia.HANDLE_SE]
## 	    view.handle_layer.grab_handle(handle)
## 	else:
## 	    #print 'diacanvas.PlacementTool: no handle handling for element', item

gobject.type_register(PlacementTool)
