#
# $Id$
#
# This file is part of GraphTool.
#
# GraphTool is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# GraphTool is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GraphTool; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
import gobject
import gtk
import pango
import diacanvas as dia
from placementtool import *

class VcNode (dia.CanvasNode, dia.CanvasAbstractGroup):
    def __init__(self):
	self.__gobject_init__()
        self.handles[0].set_property('movable',False)
        self.init_shapes ()

    def init_shapes (self):
        self.set (height = 30, width = 30)
        self._shapes = []
      	self._shapes.append (dia.shape.Ellipse())
	self._shapes[0].ellipse (center=(self.width/2, self.height/2),
                                width=self.width,
                                height=self.height)
        self._shapes[0].set_fill (1)
        self._shapes[0].set_fill_color (dia.color (250,250,250))        
	self._shapes[0].set_line_width (1)
    
    def __del__(self):
        print "VcNode.__del__"
        self.disconnect_handles ()
 
    ##Les vnements :
        
    def on_update (self,  affine):
        dia.CanvasNode.on_update (self, affine)
        for shape in self._shapes:
            shape.request_update () 

    def on_get_shape_iter (self):
	return 0

    def on_shape_next (self, iter):
        if iter < len (self._shapes) - 1:
            return iter + 1
        else:
            return None
        if iter is None:
            return 0

    def on_shape_value (self, iter):
	if iter is None:
	    return dia.CanvasNode.on_get_shape_value (self, iter)
        else:
            return self._shapes[iter]

    def on_point (self, x, y):
	return dia.CanvasNode.on_point (self, x, y)

    def on_move (self, x, y, interactive):
	return dia.CanvasNode.on_move (self, x, y, interactive);

    def on_handle_motion (self, handle, wx, wy, mask):
        return dia.CanvasNode.on_handle_motion (self, handle, wx, wy, mask);

    def on_glue (self, handle, wx, wy):
	ret = dia.CanvasNode.on_glue (self, handle, wx, wy);
	return ret

    # pour CanvasGroupable
    def on_groupable_add (self, item):
	'''Utilis par les enfants durant la construction.'''
	return 0

    def on_groupable_remove (self, item):
        pass

    def on_groupable_get_iter (self):
        return None

    def on_groupable_next (self, iter):
        return None

    def on_groupable_value (self, iter):
        return iter

    def on_groupable_length (self):
        return 1

    def on_groupable_pos (self, item):
        if item == self.text:
	    return 0
	else:
	    return -1

gobject.type_register (VcNode)
dia.set_callbacks (VcNode)
dia.set_groupable (VcNode)
