/* data.c
 * Copyright (C) 2004, 2005 Sylvain Cresto <sylvain.cresto@tiscali.fr>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://www.nongnu.org/graveman/
 *
 */

#include "graveman.h"

/* appele pour chaques entres de la liste */
gboolean foreachfiles(GtkTreeModel *Amodel, GtkTreePath *Apath, GtkTreeIter *Aiter, gpointer Adata)
{
  gint Ltype, Lparenttype;
  GHashTable *Lhash = (GHashTable *)Adata;
  gchar *Lonlyname = NULL, *Lnom = NULL, *Lnomutf8 = NULL;
  gchar *Lonlynameparent = NULL;
  gchar **Ltmpdir = (gchar **) g_hash_table_lookup(Lhash, "tmpdir");  
  GError **Lerror = (GError **) g_hash_table_lookup(Lhash, "gerror");
  gchar Lnewname[10000];
  gchar Lparents[10000], Ltmp[10000];
  GtkTreeIter LparentIter;
  GtkTreePath *Lparentpath;
  gboolean Lreturn = FALSE;

  gtk_tree_model_get(Amodel, Aiter, 0, &Ltype, 2, &Lonlyname, 4, &Lnomutf8, 5, &Lnom, -1);

  while(gtk_events_pending()) gtk_main_iteration();
  if (Ltype == TYPE_DIR || Ltype == TYPE_FILE) {

    *Lparents=*Ltmp=0;
    Lparentpath = gtk_tree_path_copy(Apath);
    while (gtk_tree_path_up(Lparentpath)) {
      if (gtk_tree_model_get_iter(Amodel, &LparentIter, Lparentpath)==FALSE) {
        Lreturn = TRUE;
        break;
      }
      /* on recupere le parent, et on utilise son nom que si c'est
       * un repertoire, sinon on arrete de remonter */
      gtk_tree_model_get(Amodel, &LparentIter, 0, &Lparenttype, 2, &Lonlynameparent, -1);
      if (Lparenttype != TYPE_DIR) break;

      g_snprintf(Ltmp, sizeof(Ltmp)-1, "%s/%s", Lonlynameparent, Lparents);
      strcpy(Lparents, Ltmp);
      g_free(Lonlynameparent);
    }
    gtk_tree_path_free(Lparentpath);

    if (!Lreturn) {
      g_snprintf(Lnewname, sizeof(Lnewname)-1, "%s/%s%s", *Ltmpdir, Lparents, Lonlyname);

      if (Ltype == TYPE_DIR) {
        /* si c'est un repertoire alors on le cree */
      _DEB("creation repertoire [%s] car [%s]", Lnewname, Lnom);
        if (mkdir(Lnewname, 00750)==-1) {
          _WARN("Erreur lors de la creation du repertoire [%s]", Lnewname);
          g_set_error(Lerror, G_FILE_ERROR, g_file_error_from_errno(errno), "%s %s: %s",
            _("Cannot create directory"), Lnewname, g_strerror(errno));
          Lreturn = TRUE;
        }
      } else {
        /* sinon on fais un liens */
      _DEB("creation lien [%s] car [%s]", Lnewname, Lnom);       
        if (symlink(Lnom, Lnewname)==-1) {
          _WARN("Erreur lors de la creation du lien [%s]", Lnewname);
          g_set_error(Lerror, G_FILE_ERROR, g_file_error_from_errno(errno), "%s %s: %s",
            _("Cannot create symlink"), Lnewname, g_strerror(errno));
          Lreturn = TRUE;
        }
      }
    }

  }

  g_free(Lnomutf8);
  g_free(Lnom);
  g_free(Lonlyname);

  return Lreturn;
}

/* preparation pour la gravure, creation du repertorie
 * temporraire et des liens qui vont servir a creer l'image a graver */
gboolean preparedata(GHashTable *Ahash, GError **Aerror)
{
  gchar **Ltmpdir = (gchar **)g_hash_table_lookup(Ahash, "tmpdir");
  GtkLabel *Ltitle = GTK_LABEL(g_hash_table_lookup(Ahash, "gravetitle"));
  GtkTreeModel *LTreeModel = gtk_tree_view_get_model(GTK_TREE_VIEW(g_hash_table_lookup(Ahash, "LISTEDATA")));
  gchar *Lnamedir;
  gboolean Lstatus = TRUE;
  
  g_assert(LTreeModel);

  Lnamedir = g_strdup_printf("%s/%s", conf_get_string_def("tmpdir", "/tmp"), "gravemanXXXXXX");

  gtk_label_set_text(Ltitle, _("Prepare files..."));

  if (!mkdtemp(Lnamedir)) {
    g_set_error(Aerror, G_FILE_ERROR, g_file_error_from_errno(errno), "%s %s: %s", 
             _("Cannot create directory"), Lnamedir, g_strerror(errno));    
    Lstatus = FALSE;
  } else {
    *Ltmpdir = Lnamedir;
    
    /* conversion de chaques fichiers */
    gtk_tree_model_foreach(LTreeModel, foreachfiles, Ahash);
    
    /* si Aerror n'est plus NULL c'est qu'il y a eu une erreur ! */
    if ((GError *)*Aerror) Lstatus = FALSE;
  }

  if (Lstatus == FALSE)
  {
    g_free(Lnamedir);
    *Ltmpdir = NULL;
  }  
  return Lstatus;
}

/*
 * vim:et:ts=8:sts=2:sw=2
 */
