/* graveman.h
 * Copyright (C) 2004, 2005 Sylvain Cresto <scresto@gmail.com>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://www.nongnu.org/graveman/
 *
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <unistd.h>
#include <signal.h>
#include <dirent.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <ctype.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <fcntl.h>
#include <math.h>
#include <glib/gprintf.h>
#include "config.h"
#include "error.h"
/* gi18b-lib.h doit etre inclue APRES config.h ! */
#include <glib/gi18n-lib.h>
#include <glade/glade.h>

#define _BOOLEAN_CONF(valeur) (valeur == TRUE ? "1" : "0")

/* convertire un texte en utf8 */
#define _UTF8(texte) g_locale_to_utf8(texte, -1, NULL, NULL, NULL)
#define _FILEUTF8(texte) g_filename_to_utf8(texte, -1, NULL, NULL, NULL)
/* recupere un nom de fichier de puis de l'utf8 */
#define _FILENAME(texte) g_filename_from_utf8(texte, -1, NULL, NULL, NULL)
/* message warning + affiche errno en utf8 */
#define _WARN(texte, ...) g_warning(texte, ## __VA_ARGS__); \
                          g_warning("%s\n", g_strerror(errno))

/* non null */
#define _NN(valeur) valeur ? valeur : ""

#define _hash() g_hash_table_new(g_str_hash, g_str_equal)
#define _hash_autodestroy() g_hash_table_new_full(g_str_hash, g_str_equal, NULL, g_free)

#define _SWAP_COMBO(key, value) strcpy(key+strlen(key)-strlen("combo"), value)
                          
/* message de debug en utf8 */
#ifdef DEBUG
#define _DEB(texte, ...)  g_log(NULL, G_LOG_LEVEL_DEBUG, texte, ## __VA_ARGS__)
#else
#define _DEB(texte, ...) /* debug */
#endif

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  gtk_widget_set_name(GTK_WIDGET(widget), name); \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  gtk_widget_set_name(GTK_WIDGET(widget), name); \
  g_object_set_data (G_OBJECT (component), name, widget)

#define MAX_SPEED 54

#define TYPE_ALLWRITER 1
#define TYPE_ALL 2
#define TYPE_ISO 4
#define TYPE_DVDWRITER 8

#define TYPE_CD    1
#define TYPE_DIR   2
#define TYPE_FILE  3
#define TYPE_MP3   4
#define TYPE_IMAGEBOOT 5

#define SEARCH_LECTEUR  1
#define SEARCH_PROG     2
#define WRITE_CONFIG    4
#define UPDATE_SIZE     8
#define UPDATE_SAVEONEXIT_VALUE 16

#define MENU_NEW        1
#define MENU_UPDATE     2
#define COMBO_UPDATE    4

/* gestion CD de boot */
#define CDBOOT_NONE     0
#define CDBOOT_IMAGE    1

#define _REMPLISSAGE_VALUE(Ahash, Alist, Asize, Amaxsize, Aprogressbar) \
    { \
      gchar *Lprefix = (!strcmp(glade_get_widget_name(GTK_WIDGET(Alist)), "LISTEDATA") ? "data" : "dvddata"); \
      Asize = (guint64 *)sc_hash_table_lookupv (Ahash, "%ssize", Lprefix); \
      Amaxsize = (guint64 *)sc_hash_table_lookupv (Ahash, "%smaxsize", Lprefix); \
      Aprogressbar = sc_hash_table_lookupv(Ahash, "%ssizebar", Lprefix); \
    }

#define remplirecombo(Acombo, Abasename, Aentry, Adoinit, Aselvalue) remplirecombo_full(Acombo, Abasename, Aentry, Adoinit, Aselvalue, -1)
  
typedef enum {
  PB_UPDATE_AUDIO,
  PB_UPDATE_DATA,
  PB_NONE
} Ttypemajpbar;
  
typedef enum {
  CONF_IGNORE,
  CONF_PROG,
  CONF_DIR,
  CONF_STRING,
  CONF_BOOLEAN
} Ttypeconf;

typedef enum {
  DVD_FORMAT,
  DVD_BLANK,
  DVD_FULLBLANK
} Ttypeformatdvd;

typedef enum {
  WRITE_CD,
  WRITE_DVD
} Ttypeoperation;

#ifdef ENABLE_MP3
  #define MP3 ".mp3"
#endif
#ifdef ENABLE_OGG
  #define OGG ".ogg"
#endif
#define WAV ".wav"

#define _BUF_SIZE 100
#ifndef MAXPATHLEN
  #define MAXPATHLEN 2048
#endif

typedef struct {
  Ttypeconf type;
  gchar *entry;
  gchar *defaultvalue;
  guint level;
} TProgRequis;

/* operation a faire sur une entre de la configuration */
#define CONF_SAVEALWAYS 0
#define CONF_SAVEONEXIT 1
#define CONF_COMBO      16
#define CONF_SPIN       32
#define CONF_CHECK      64

/* type des devices */
#define _OTHER_DEVICE 0
#define _READ_CDR     1
#define _WRITE_CDR    2
#define _WRITE_CDRW   4
#define _WRITE_DUMMY  8
#define _READ_DVD     16
#define _WRITE_DVD    32
#define DRIVE_READER(drive) (drive && (drive->type & _READ_CDR))
#define DRIVE_WRITER(drive) (drive && (drive->type & _WRITE_CDR))
#define DRIVE_DVDREADER(drive) (drive && (drive->type & _READ_DVD))
#define DRIVE_DVDWRITER(drive) (drive && (drive->type & _WRITE_DVD))

 #define DRIVE_CDRW_WRITER(drive) (drive && (drive->type & _WRITE_CDRW))
#define DRIVE_ICONE(drive)  (drive->type & _WRITE_DVD ? GDVDRWpetiteIcone : \
                            (drive->type & _WRITE_CDR ? GCDRWpetiteIcone : \
                            (drive->type & _READ_DVD ? GDVDpetiteIcone : GCDpetiteIcone)))

typedef struct {
  gchar *name;  /* label du lecteur */
  GSList *dev;   /* peripheriques */
  GSList *bus;   /* liste des bus */
  gint actuperiph;
  gint  type;   /* type 15 = graveur cdrw, 1 = lecteur */
  gshort vitesse;
  gshort vitessedvd;
  gboolean manual;  /* ajouter manuelement ou non */
} Tdriveinfo;

typedef struct {
  gchar *detectline;
  gchar *useline;
  gchar *bus;
  gint priority;
} Tsearchdrive;

typedef struct {
  gchar *basecode;
  gchar *label;
  gboolean defaut;
  gint filtre;
} Tmyentry;

typedef struct {
  gulong size;
  gchar *labeldata;
  gchar *labelaudio;
} Tmediaentry;

/* audio.c */
extern gboolean preparetrack(GHashTable *Ahash, GError **Aerror);
extern gchar *make_audio_fileslist(gint Anbrfiles);

/* data.c */
extern gboolean preparedata(GHashTable *Ahash, GError **Aerror);

/* dvdrwformat.c */
extern gboolean perform_format_dvd(GHashTable *Ahash, Ttypeformatdvd Aoperation, GError **Aerror);

/* growisofs.c */
extern gboolean burn_dvd(GHashTable *Ahash, GError **Aerror);

/* images.c */
extern GdkPixbuf *GDirIcone;
extern GdkPixbuf *GFileIcone;
extern GdkPixbuf *GFileImage;
extern GdkPixbuf *GpetiteGraver;
extern GdkPixbuf *GISOpetiteIcone;
extern GdkPixbuf *GGraver;
extern GdkPixbuf *GEraseCdrw;
extern GdkPixbuf *GCDIcone;
extern GdkPixbuf *GAudioIcone;
extern GdkPixbuf *GCDRWIcone;
extern GdkPixbuf *GMenuAudio;
extern GdkPixbuf *GMenuData;
extern GdkPixbuf *GMenuCopy;
extern GdkPixbuf *GMenuOther;
extern GdkPixbuf *GCDpetiteIcone;
extern GdkPixbuf *GCDRWpetiteIcone;
extern GdkPixbuf *GDVDpetiteIcone;
extern GdkPixbuf *GDVDRWpetiteIcone;

/* images.c */
extern void load_all_images();
extern void free_all_images();
extern void load_menu_images(gchar *Lquel);
extern void prepare_menu_images(GHashTable *Ahash);

/* interface.c */
extern GSList *Gmedialist;
extern Tmediaentry Gdefaultmedia[];
extern void remplire_combo_vitesse(GtkComboBox *Acombo, gchar *Alecident, gchar *Aselvalue);
extern void show_graverwindow(GHashTable *Ahash, gchar *Aaction, gchar *Atitle);
extern GtkWidget* create_addfileselection (GtkWindow *AParent);
extern GtkWidget* create_adddirselection (GtkWindow *AParent);
extern GtkMenu *create_gtkpopupmenudata(GtkWidget *Aliste, GHashTable *Ahash);
extern GtkMenu *create_gtkpopupmenuaudio(GtkWidget *Aliste, GHashTable *Ahash);
extern GtkMenu *create_gtkpopupmenudevices(GtkWidget *Aliste, GHashTable *Ahash);
extern GtkMenu *create_gtkpopupmenudisplay(GtkWidget *Aliste, GHashTable *Ahash);
extern GtkMenu *create_gtkpopupmenuformatdvd(GHashTable *Ahash);
extern gboolean gtk_do_eventbuttonpress(GtkWidget *Aliste, GdkEventButton *Aevent, gpointer Adata);
extern GtkWidget* create_addpisteselection (GtkWindow *AParent);
extern GladeXML *create_window_encours(GtkWidget *AParent);
extern GtkWidget* manage_main_window (guint64 *Aaudiolen, guint64 *Aaudiomaxlen,
    guint64 *Adatasize, guint64 *Adatamaxsize, guint64 *Advddatasize, guint64 *Advddatamaxsize);
extern GtkWidget* create_fileselection1 (GtkWindow *AParent, GtkFileChooserAction AType);
extern void about_graveman (void);
extern GHashTable *create_dialog_proprietes (GtkWidget *Aparent);
extern void welcome_to_graveman(void);
extern void switch_pbar_status(GtkProgressBar *Apbar, guint64 Amaxlen, guint64 Acurlen, Ttypemajpbar Aupdatetext);
extern void prepare_combobox_graveur(GladeXML *Axml, GHashTable *Ahash, gchar *Abasename);
extern void prepare_combobox_vitesse(GtkComboBox *Acombobox);
extern void update_combo_graveur(GHashTable *Ahash);
extern void prepare_listedata(GtkTreeView *Atreedata, gchar *Atitle);
extern void prepare_listeaudio(GtkTreeView *Atreeaudio);
extern void prepare_popups(GladeXML *Axml, GHashTable *Ahash);
extern void prepare_disable_when_iso(GHashTable *Ahash, gchar *Abasename, const gchar *Afirst, ...);
extern void prepare_disable_when(GHashTable *Ahash, gchar *Abasename, const gchar *Afirst, ...);
extern void show_erasecdrwwindow(GHashTable *Ahash);
extern void show_fixcdwindow(GHashTable *Ahash);
extern void manage_combobox_devicebus(GtkComboBox *Acombobox, Tdriveinfo *Adrive);
extern GHashTable *create_dialog_edit_device(GtkWidget *Aparent, Tdriveinfo *Adrive);
extern GHashTable *create_dialog_add_device(GtkWidget *Aparent);
extern GHashTable *addmediaformat(GHashTable *Aparent);
extern void manage_interface(GHashTable *Ahash, gint Aaction);
extern void gtk_toggle_top_menu(GtkTreeView *Atopmenu, gpointer Adata);
extern GHashTable *create_dialog_confirm_operation (GtkWidget *Aparent, gchar *Alabel, 
                      gchar *Acheckboxlbl, gboolean Acheckboxstatus);
extern GHashTable *create_dialog_select_dvdoperation (GtkWidget *Aparent);
extern void update_status_bar_display(GHashTable *Ahash);
extern void show_dvdformatwindow(GHashTable *Ahash, gchar *Atitle, Ttypeformatdvd Aoperation);

/* log.c */
extern GQuark graveman_error_quark (void);

/* main.c */
extern GladeXML *Gxml;

/* config.c */
extern TProgRequis Glisteprogrequis[];
extern void config_init();
extern void clean_config();
extern gboolean get_config_file(gint Lmode);
extern gboolean manage_config(GHashTable *Ahash, gshort Aop, GError **Aerror);
extern gint Gfifosize;
extern gchar *conf_get_string(gchar *Anom);
extern gchar *conf_get_string_def(gchar *Anom, gchar *Adefault);
extern gint conf_get_int(gchar *Anom);
extern gboolean conf_get_boolean(gchar *Anom);
extern void restore_last_used_values(GHashTable *Ahash);
extern void conf_store_value(gchar *Aentry, gchar *Avalue);
extern void conf_store_int(gchar *Aentry, gint Avalue);
extern gboolean write_conf(GError **Aerror);
extern void maj_proprietes_prog(GHashTable *Ahash);
extern void remplirecombo_full (GtkComboBox *Acombo, gchar *Abasename, Tmyentry *Aentry, gboolean Adoinit, gchar *Aselvalue, gint Afiltre);
extern void remplirecombograveur(GtkComboBox *Acombo, gint Aquoi, gchar *Aselvalue);
extern void remplirelistegraveur(GtkTreeView *Aliste);
extern gboolean read_config(GError **Aerror);
extern void restore_main_window_pos(GtkWidget *Awindow1);
extern void use_last_dir(GtkFileChooser *Awidget);
extern void save_last_dir(GtkFileChooser *Awidget);
extern gboolean test_version();

/* matos.c */
extern GSList *Glistdrives;
extern void append_this_drive(Tdriveinfo *Adrive);
extern void free_this_drive(Tdriveinfo *Adrive);
extern void free_drives(gboolean Aremovemanu);
extern void insert_or_update_drive(gchar *Adev, gchar *Amarque, gchar *Amodel, gchar *Aquoi, Tsearchdrive *Adrivedesc);
extern void get_current_matos(gboolean *Areadcd, gboolean *Awritecdr, gboolean *Awritecdrw, gboolean *Areaddvd, gboolean *Awritedvd);
extern Tdriveinfo *find_drive(gchar *Aident);
extern gint get_maxspeed(int Anum);
extern gboolean burn_data(GHashTable *Ahash, GError **Aerror);
extern gboolean burn_dvddata(GHashTable *Ahash, GError **Aerror);
extern gboolean burn_audio(GHashTable *Ahash, GError **Aerror);
extern gboolean burn_copy(GHashTable *Ahash, GError **Aerror);
extern gboolean deltempdir(gchar *Ldirpath);
extern void put_devicelabel(Tdriveinfo *Adrive, gchar *Abuf, gint Asizemax);
extern Tdriveinfo *get_drive_cmb(GtkComboBox *Acombo);

/* cdrecord.c */
extern gchar *burn_data_getextrapara(GHashTable *Ahash);
extern int scan_for_drives(GHashTable *Ahash, GError **Aerror);
extern gboolean burn_from_image(gchar *Aop, GHashTable *Ahash, GError **Aerror);
extern gboolean gravepiste(GHashTable *Ahash, GError **Aerror);
extern gboolean maj_drive_info(Tdriveinfo *Adrive, gchar *Adev, GError **Aerror);
extern gboolean perform_erase_cdrw(GHashTable *Ahash, GError **Aerror);
extern gboolean perform_fix_cd(GHashTable *Ahash, GError **Aerror);
extern void eject_cd(gchar *Adev, GError **Aerror);

/* mkisofs.c */
extern gboolean check_mkisofs();
extern gchar *make_image_getextrapara(GHashTable *Ahash, gchar *Aop);
extern gboolean make_iso(GHashTable *Ahash, GError **Aerror);

/* mp3.c */
extern int getMp3Info(gchar *Apath, gchar **Atitle, gchar **Aalbum, gchar **Aartist, guint32 *Alength, GError **Aerror);

/* ogg.c */
extern int getOggInfo(gchar *Apath, gchar **Atitle, gchar **Aalbum, gchar **Aartist, guint32 *Alength, GError **Aerror);

/* tools.c */
extern char *ltrim(char *Abuf);
extern gchar *belleHeure(gchar *Abuf, gchar *Adst);
extern gint sc_strcountv(gchar **Aarray);
extern void sc_strstripv(gchar **Aarray);
extern gchar *get_combo_value(GtkWidget *Acombo);
extern gint get_combo_intvalue(GtkWidget *Acombo);
extern gint make_int(gchar *Abuf);
extern gshort make_short(gchar *Abuf);
extern gchar *sc_realloc_cat(gchar *Asep, gchar *Asrc, gchar *Aplus);
extern gchar *format_length(guint64 Alennbr);
extern gchar *format_size(guint64 Asize);
extern gboolean sc_str_has_casesuffix(gchar *Astr, gchar *Asuffix);
extern gpointer sc_hash_table_lookupv(GHashTable *Ahash, gchar *Akeyformat, ...);
extern gchar * sc_strescape (const gchar *source);
extern void sc_line_data_copy(GtkTreeModel *Amodel, GtkTreeIter *Aiterde, GtkTreeIter *Aitervers);
extern gboolean sc_str_match(gchar *Lpattern, gchar *Lstr);
extern void exit_prog(gint Apid, GError **Aerror, gchar *Adefmsg);
extern gint sc_mkdir(const gchar *Aname, mode_t Amode);

/* readcd.c */
extern gboolean make_image(GHashTable *Ahash, GError **Aerror);
#if 0
extern gboolean copy_on_the_fly(GtkWidget *Awindow1, GtkWidget *Aparent, GError **Aerror);
#endif

/* sox.c */
extern gboolean GsupportMp3;
extern gboolean GsupportOgg;
extern gboolean check_sox();
extern gboolean SoundToCdr(GHashTable *Ahash, gchar *AFichier, gchar *AVers, GError **Aerror);

/* wav.c */
extern gboolean getWavInfo(gchar *Apath, guint32 *Alength, GError **Aerror);

/* support.c */
extern void add_pixmap_directory (const gchar *Adirectory);
extern GtkWidget* create_pixmap (const gchar *Afilename);
extern GdkPixbuf* create_pixbuf (const gchar *Afilename);
extern GtkWidget *glade_to_hash(GladeXML *Axml, GHashTable *Ahash, gchar *Akey);
extern GtkWidget *glade_to_hashv(GladeXML *Axml, GHashTable *Ahash, const gchar *Akeyformat, ...);
extern void glade_to_hash_list(GladeXML *Axml, GHashTable *Ahash, const gchar *Afirst, ...);
extern GtkWidget *sc_glade_xml_get_widgetv(GladeXML *Axml, const gchar *Akeyformat, ...);
extern void set_cursor(GtkWidget *Awindow, GdkCursorType Acursortype);
extern void unset_cursor(GtkWidget *Awindow);

/* callbacks.c */
extern void gtk_devices_edit(GtkWidget *Abtn, gpointer Adata);
extern void gtk_devices_remove(GtkWidget *Abtn, gpointer Adata);
extern void gtk_devices_add(GtkWidget *Abtn, gpointer Adata);
extern gboolean encours_callback(gpointer Adata);
extern void on_about (GtkMenuItem *Amenuitem, gpointer Adata);
extern gboolean on_closeabout (GtkWidget *Awidget, GdkEventButton *Aevent, gpointer Adata);
extern void on_selectgraveur(GtkWidget *Acombo, gpointer Adata);
extern void gtk_file_sel(GtkWidget *Abtn, gpointer Adata);
extern void confirm_erasecdrw (GtkWidget *Abtn, gpointer Adata);
extern void confirm_fixcd (GtkWidget *Abtn, gpointer Adata);
extern void confirm_burn (GtkWidget *Abtn, gpointer Adata);
extern gboolean abort_gravure (GtkWidget *Abtn, gpointer Adata);
extern void gtk_data_addfile(GtkWidget *Abtn, gpointer Adata);
extern void gtk_data_adddirectory(GtkWidget *Abtn, gpointer Adata);
extern void gtk_data_removefiles(GtkWidget *Abtn, gpointer Adata);
extern void gtk_audio_removetrack(GtkWidget *Abtn, gpointer Adata);
extern gboolean gtk_do_eventlisteajoutfichiers(GtkWidget *Lliste, GdkEventButton *AEvent);
extern void gtk_data_renommerelement(GtkWidget *btn, gpointer Adata);
extern void gtk_data_creerrepertoire(GtkWidget *btn, gpointer Adata);
extern void gtk_audio_addtrack(GtkWidget *btn, gpointer Adata);
extern void gtk_data_expandelement(GtkWidget *btn, gpointer Adata);
extern void gonextpage(GtkWidget *Abtn, GtkNotebook *Anotebook);
extern void text_buffer_callback(GtkTextBuffer *Aobj, gpointer Adata);
extern void menu_active_panel(GtkWidget *Amenuitem, gpointer Adata);
extern void gtk_combotext_changed(GtkWidget *Acombo, gpointer Adata);
extern void switchpage(GtkNotebook *Anotebook, GtkNotebookPage *Anotebookpage, guint Apagenum, gpointer Adata);
extern void menu_active_proprietes(GtkWidget *Amenuitem, gpointer Adata);
extern void cherchelecteur(GtkWidget *Aobj, gpointer data);
extern void chercheprog(GtkWidget *Aobj, gpointer data);
extern void abort_encours(GtkWidget *Abtn, gpointer Adata);
extern void menu_quit(GtkWidget *Aobj1, gpointer Adata);
extern void delete_event_quit(GtkWidget *Awidget, GdkEvent *Aevent, gpointer Adata);
extern void delete_event_encours(GtkWidget *Awidget, GdkEvent *Aevent, gpointer Adata);
extern void view_popupmenu_addaudio(GtkWidget *Aliste, GdkEventButton *Aevent, gpointer Adata);
extern void key_popupmenu_addaudio(GtkWidget *Aliste, gpointer Adata);
extern void view_popupmenu_addfile(GtkWidget *Aliste, GdkEventButton *Aevent, gpointer Adata);
extern void key_popupmenu_addfile(GtkWidget *Aliste, gpointer Adata);
extern void view_popupmenu_devices(GtkWidget *Aliste, GdkEventButton *Aevent, gpointer Adata);
extern void key_popupmenu_devices(GtkWidget *Aliste, gpointer Adata);
extern void view_popupmenu_display(GtkWidget *Aliste, GdkEventButton *Aevent, gpointer Adata);
extern void key_popupmenu_display(GtkWidget *Aliste, gpointer Adata);
extern void change_remplissage(GtkWidget *Acombo, gpointer Adata);
extern gboolean on_select_files (GtkTreeSelection *Aselection, GtkTreeModel *Amodel,
                       GtkTreePath *Apath, gboolean Apath_currently_selected, gpointer Adata);
extern void audio_dnd_data_received (GtkWidget *Aliste, GdkDragContext *Acontext, gint Ax, gint Ay, GtkSelectionData *Aseldata, guint Ainfo, guint Atime, gpointer Adata);
extern void data_dnd_data_received (GtkWidget *Aliste, GdkDragContext *Acontext, gint Ax, gint Ay, GtkSelectionData *Aseldata, guint Ainfo, guint Atime, gpointer Adata);
extern void menu_start_new(GtkMenuItem *Amenuitem, gpointer Adata);
extern void on_addmediaformat(GtkWidget *Abtn, gpointer Adata);
extern void update_media_unit(GtkWidget *Acombo, gpointer Adata);
extern gboolean update_media_fields(GtkWidget *Awidget, gpointer Adata);
extern void gtk_def_imageboot(GtkWidget *Abtn, gpointer Adata);
extern gboolean quit_property(GtkWidget *Awidget, GdkEvent *Aevent, gpointer Adata);
extern gboolean on_deleteevent_gravure(GtkWidget *Awidget, GdkEvent *Aevent, gpointer Adata);
extern void gtk_display_switchstatusbar(GtkWidget *Abtn, gpointer Adata);
extern void gtk_display_updatesize(GtkWidget *Abtn, gpointer Adata);
extern void popup_formatdvdrw(GtkWidget *Abtn, gpointer Adata);
extern void gtk_confirm_dvdoperation(GtkWidget *Abtn, gpointer Adata);

/*
 * vim:et:ts=8:sts=2:sw=2
 */
