/* sox.c
 * Copyright (C) 2004, 2005 Sylvain Cresto <sylvain.cresto@tiscali.fr>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://scresto.site.voite.fr/
 *
 */

#include "graveman.h"

/* communication avec sox */

/* transformation fichier son vers piste audio */

/* pour le moment on ne fais pas grand chose dans le callback ...
 * plus tard il y aura une meilleur gestion des erreurs ! */
gboolean sox_callback(GIOChannel *Astd, GIOCondition Acond, gpointer Adata)
{
  GIOStatus Lstatus;
  gboolean *Lcont = (gboolean *) Adata;
  gchar *Lbuffer = NULL;  

  /* fin du callback lorsque l'on recoi un signal comme quoi le pipe est ferme */
  if (Acond == G_IO_HUP || Acond == G_IO_ERR) {
    *Lcont = FALSE;
    return FALSE;
  }

  Lstatus = g_io_channel_read_line(Astd, &Lbuffer, NULL, NULL, NULL);  

  g_free(Lbuffer);

  return TRUE;
}

gboolean SoundToCdr(GHashTable *Ahash, gchar *AFichier, gchar *AVers, GError **Aerror)
{
  gchar *Lcommandline;
  gchar **Lcmd;
  gint *Lpid = (gint *) g_hash_table_lookup(Ahash, "pid");
  gint g_out, g_err, Lnbrarg;
  gchar *Lfic;
  gchar *Lvers;
  GIOChannel *Lcom, *Lcomerr;
  gboolean Lcont = TRUE;
  GIOStatus Lstatus;
  gboolean Lbolstatus;
  guint Lcomevent, Lcomerrevent;

  Lfic = sc_get_filename(AFichier);
  Lvers = sc_get_filename(AVers);
  Lcommandline = g_strdup_printf("%s -V %s \"%s\" \"%s\"", conf_get_string("sox"), conf_get_string("soxpara"), Lfic, Lvers);
  _DEB("execution [%s]\n", Lcommandline);

  Lstatus = g_shell_parse_argv(Lcommandline, &Lnbrarg, &Lcmd, Aerror);
  g_free(Lcommandline);
  if (Lstatus == FALSE) {
    return FALSE;
  }

  Lbolstatus = g_spawn_async_with_pipes(NULL, Lcmd, NULL, /* env argument */
      (GSpawnFlags ) (0),
      NULL, NULL, Lpid, NULL, &g_out, &g_err, Aerror);
  g_strfreev(Lcmd);

  if (Lbolstatus == FALSE) {
    g_warning("ERROR EXECUTION !\n");
    return FALSE;
  }

  Lcom = g_io_channel_unix_new( g_out );
  g_io_channel_set_encoding (Lcom, NULL, NULL);
  g_io_channel_set_flags( Lcom, G_IO_FLAG_NONBLOCK, NULL );
  Lcomevent = g_io_add_watch (Lcom, (G_IO_IN | G_IO_HUP | G_IO_ERR | G_IO_PRI),
					     sox_callback,
					     &Lcont);
  
  Lcomerr = g_io_channel_unix_new( g_err );
  g_io_channel_set_encoding (Lcomerr, NULL, NULL);
  g_io_channel_set_flags( Lcomerr, G_IO_FLAG_NONBLOCK, NULL );
  Lcomerrevent = g_io_add_watch (Lcomerr, (G_IO_IN | G_IO_HUP | G_IO_ERR | G_IO_PRI),
					     sox_callback,
					     &Lcont);  
  while (Lcont) {
    gtk_main_iteration();    
  }
  g_source_remove(Lcomerrevent);
  g_source_remove(Lcomevent);
      
  g_io_channel_shutdown(Lcomerr, FALSE, NULL);
  g_io_channel_unref(Lcomerr);  
  g_io_channel_shutdown(Lcom, FALSE, NULL);
  g_io_channel_unref(Lcom);
  g_spawn_close_pid(*Lpid);
  *Lpid = 0;

  return TRUE;
}

/*
 * vim:et:ts=8:sts=2:sw=2
 */
