/* matos.c
 * Copyright (C) 2004, 2005 Sylvain Cresto <sylvain.cresto@tiscali.fr>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://scresto.site.voite.fr/
 *
 */

/* initialisation des devices */

#include "graveman.h"

Tdrive_info Gldrives[128];
unsigned int Gnumdrives = 0; 

Tdrive_info *findlecteur(gchar *Aname) {
  gint i;
  for (i=0; i < Gnumdrives; i++) {

  _DEB("om compare [%s] et [%s]\n", Aname, Gldrives[i].dev);
    if (!strcmp(Aname, Gldrives[i].dev)) {
      _DEB("ici GL vitesse => %d\n", Gldrives[i].vitesse);
      return &Gldrives[i];
    }
  }

  return NULL;
}

/* operation de copie */
gboolean burn_copy(GHashTable *Ahash, GError **Aerror)
{
  GtkWidget *Llecteur = g_hash_table_lookup(Ahash, "srccopycombo");
  GtkWidget *Lgraveur = g_hash_table_lookup(Ahash, "dstcopycombo");
  GtkEntry *Llecteuriso = GTK_ENTRY(g_hash_table_lookup(Ahash, "srccopybtnvalue"));
  GtkEntry *Lgraveuriso = GTK_ENTRY(g_hash_table_lookup(Ahash, "dstcopybtnvalue"));
  gboolean *Labort = (gboolean *)g_hash_table_lookup(Ahash, "gabort");
  gchar *Lsrc = get_combo_value(Llecteur);
  gchar *Ldst = get_combo_value(Lgraveur);
  gchar *Liso = NULL;
  gchar *Ltxt;
  gboolean Lstatus;
  gboolean Loperationstatus = FALSE;
  gboolean Lsimul = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(g_hash_table_lookup(Ahash, "copysimul")));
  gint Ltodo = gtk_spin_button_get_value(GTK_SPIN_BUTTON(g_hash_table_lookup(Ahash, "nbrcdcopy")));
  gint Ldone = 1;
  gchar *Ltmpdir = NULL;
  const gchar *Lptriso;
_DEB("DEBUT COPIE !! 0");

  if (!strcmp(Lsrc, "iso") && !strcmp(Ldst, "iso")) {
    g_set_error(Aerror, GRAVEMAN_ERROR, _ERR_INAPROPRIATE_MODE, 
      _("Cannot duplicate an iso image to an another iso image with graveman, just copy this file !"));
    return FALSE;
  }

  /* referecement variables */
  g_hash_table_insert(Ahash, "todo", &Ltodo); /* a faire */
  g_hash_table_insert(Ahash, "done", &Ldone); /* fais */
  g_hash_table_insert(Ahash, "operationstatus", &Loperationstatus); /* resultat de l'operation */
  g_hash_table_insert(Ahash, "tmpdir", &Ltmpdir); /* repertoire temporraire */
  g_hash_table_insert(Ahash, "gerror", Aerror);  /* pointeur retour des erreurs */

  if (!strcmp(Lsrc, "iso")) {
    /* copie d'une image vers un cd */
    Lptriso = gtk_entry_get_text(Llecteuriso);
    Liso = _FILENAME(Lptriso);

    /* on test si on a bien acces au fichier iso source */
    if (!*Liso) {
      g_set_error(Aerror, GRAVEMAN_ERROR, _ERR_INAPPROPRIATE_DATA, 
          _("A valid iso image location is required in the \"Duplicate from\" field."));
      Lstatus = FALSE;
    } else if (access(Liso, R_OK + F_OK)==-1) {
      g_set_error(Aerror, G_FILE_ERROR, g_file_error_from_errno(errno), "%s:%s\n%s",
          _("Cannot read iso image source file"),
          Liso, g_strerror(errno));
      Lstatus = FALSE;
    } else {
      g_hash_table_insert(Ahash, "iso", &Liso); /* image iso */
      Lstatus = burn_from_image("copy", Ahash, Aerror);
      g_hash_table_remove(Ahash, "iso");
    }
    g_free(Liso);
  } else if (!strcmp(Ldst, "iso")) {
    /* copie d'un cd vers une image */
    struct stat Lfstat;
    Lptriso = gtk_entry_get_text(Lgraveuriso);
    Liso = _FILENAME(Lptriso);
    /* si le fichier existe deja on demande confirmatation avant de l'ecraser */
    Ltxt = NULL;
    if (!*Liso) {
      g_set_error(Aerror, GRAVEMAN_ERROR, _ERR_INAPPROPRIATE_DATA, 
            _("A valid iso image location is required the \"Duplicate to\" field."));
      Lstatus = FALSE;
    } else if (stat(Liso, &Lfstat) == -1) {
      if (errno != ENOENT) Ltxt = _("Cannot access file");
    } else if (access(Liso, W_OK)==-1) {
      Ltxt = _("Cannot overwrite file");
    }
    if (Ltxt) {
      g_set_error(Aerror, G_FILE_ERROR, g_file_error_from_errno(errno), "%s: %s\n%s",
          Ltxt, Liso, g_strerror(errno));
      Lstatus = FALSE;
    } else {
      g_hash_table_insert(Ahash, "iso", &Liso); /* image iso */
      Lstatus = make_image(Ahash, Aerror);
      g_hash_table_remove(Ahash, "iso");
      g_free(Liso);
    }
  } else {
    gchar *Ltmpdir;
    /* on ajoute une tache pour la lecture, 
     * si il y a simulation alors ajoute une tache a faire */
    Ltodo = Ltodo + 1 + (Lsimul == TRUE ? 1 : 0);
    
      /* copie d'un cd vers un cd
       * on passe quand meme vers une image temporraire pour le moment,
       * c'est trop le bordel sinon ! */
_DEB("DEBUT COPIE !!");
    Ltmpdir = g_strdup_printf("%s/%s", conf_get_string_def("tmpdir", "/tmp"), "gravemanXXXXXX");

    if (!mkdtemp(Ltmpdir)) {
      g_set_error(Aerror, G_FILE_ERROR, g_file_error_from_errno(errno), "%s %s: %s",
              _("Cannot create directory"), Ltmpdir, g_strerror(errno));    
      Lstatus = FALSE;
    } else {
      Ltmpdir = g_realloc(Ltmpdir, strlen(Ltmpdir)+strlen("/tmpiso.raw")+1);
      strcat(Ltmpdir, "/tmpiso.raw");

      g_hash_table_insert(Ahash, "iso", &Ltmpdir); /* image iso */

      /* on copie donc vers l'iso */
      Lstatus = make_image(Ahash, Aerror);
      if (Lstatus == TRUE && *Labort == FALSE) {
        /* et maintenant dans le sens inverse si tout va toujours bien */
        Ldone++;
        Lstatus = burn_from_image("copy", Ahash, Aerror);
      }
      if ((Ltxt=strrchr(Ltmpdir, '/'))) *Ltxt=0;
    
      deltempdir(Ltmpdir);

      g_hash_table_remove(Ahash, "iso");
    }
    g_free(Ltmpdir);
  }

  g_free(Ldst);
  g_free(Lsrc);
  return Lstatus;
}

/* operation gravure cd de donnee */
gboolean burn_data(GHashTable *Ahash, GError **Aerror)
{
  gint Ltodo = gtk_spin_button_get_value(GTK_SPIN_BUTTON(g_hash_table_lookup(Ahash, "nbrcddata")));
  gboolean Lsimul = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(g_hash_table_lookup(Ahash, "datasimul")));
  GtkEntry *Lgraveuriso = GTK_ENTRY(g_hash_table_lookup(Ahash, "dstdatabtnvalue"));
  GtkWidget *Lgraveur = g_hash_table_lookup(Ahash, "dstdatacombo");
  gboolean *Labort = g_hash_table_lookup(Ahash, "gabort");
  gint Ldone = 1;
  gchar *Ldst = get_combo_value(Lgraveur);
  gchar *Ltmpdir = NULL;
  gchar *Lextrapara = NULL;
  gchar *Liso = NULL;
  gboolean Loperationstatus = FALSE;
  gboolean Lstatus;

  g_hash_table_insert(Ahash, "todo", &Ltodo); /* a faire */
  g_hash_table_insert(Ahash, "done", &Ldone); /* fais */
  g_hash_table_insert(Ahash, "operationstatus", &Loperationstatus); /* resultat de l'operation */
  g_hash_table_insert(Ahash, "gerror", Aerror);  /* pointeur retour des erreurs */
  g_hash_table_insert(Ahash, "tmpdir", &Ltmpdir); /* repertoire temporraire */

  /* on retourne dans ltmp le nom du repertoire temporraire utilise pour
   * l'operation */
  Lstatus = preparedata(Ahash, Aerror);
_DEB("ici LDST => %s\n", Ldst);
  if (strcmp(Ldst, "iso")) {
    Liso = g_strdup_printf("%s.iso", Ltmpdir);
    Ltodo=Ltodo+(Lsimul ? 2 : 1); /* + 1 pour l'ecriture de l'image iso et 1 pour la simulation */
  } else {
    Liso = _FILENAME(gtk_entry_get_text(Lgraveuriso));
    Ltodo = 1;
  }
  g_hash_table_insert(Ahash, "iso", &Liso); /* image iso */
  if (Lstatus && *Labort==FALSE) {
    Lextrapara = make_image_getextrapara(Ahash);
    g_hash_table_insert(Ahash, "extrapara", &Lextrapara); /* parametres supplementaires */
    Lstatus = make_iso(Ahash, Aerror);
    g_hash_table_remove(Ahash, "extrapara");
    g_free(Lextrapara);
    if (strcmp(Ldst, "iso") && Lstatus && *Labort==FALSE) {
      /* ici il faut appeler cdrecord ! */
      Lextrapara = burn_data_getextrapara(Ahash);
      g_hash_table_insert(Ahash, "extrapara", &Lextrapara); /* parametres supplementaires */
      Lstatus = burn_from_image("data", Ahash, Aerror);
      g_hash_table_remove(Ahash, "extrapara");
      g_free(Lextrapara);
    }
  }

  deltempdir(Ltmpdir);
  
  if (strcmp(Ldst, "iso") && Liso
      && g_file_test(Liso, G_FILE_TEST_EXISTS + G_FILE_TEST_IS_REGULAR)==TRUE) {
    unlink(Liso);
  }
  g_free(Liso);

  g_hash_table_remove(Ahash, "todo");
  g_hash_table_remove(Ahash, "done"); 
  g_hash_table_remove(Ahash, "tmpdir"); g_free(Ltmpdir);
  g_hash_table_remove(Ahash, "operationstatus"); 
  g_hash_table_remove(Ahash, "gerror");
  g_hash_table_remove(Ahash, "iso");

  return Lstatus;
}

/* operation gravure cd audio */
gboolean burn_audio(GHashTable *Ahash, GError **Aerror)
{
  GtkTreeModel *Ltreemodel = gtk_tree_view_get_model(GTK_TREE_VIEW(g_hash_table_lookup(Ahash, "LISTEAUDIO")));

  gint Ltodo = gtk_tree_model_iter_n_children(Ltreemodel, NULL);
  gint Ldone = 0;
  gchar *Ltmpdir = NULL;
  gboolean Lstatus, Loperationstatus = FALSE;

  g_hash_table_insert(Ahash, "todo", &Ltodo); /* a faire */
  g_hash_table_insert(Ahash, "done", &Ldone); /* fais */
  g_hash_table_insert(Ahash, "operationstatus", &Loperationstatus); /* resultat de l'operation */
  g_hash_table_insert(Ahash, "gerror", Aerror);  /* pointeur retour des erreurs */
  g_hash_table_insert(Ahash, "tmpdir", &Ltmpdir); /* repertoire temporraire */

  if (!preparetrack(Ahash, Aerror)) return FALSE;

  Ldone = 1;

  Lstatus = gravepiste(Ahash, Aerror);

  if (Ltmpdir) {
    _DEB("on free tmpdir !");
    deltempdir(Ltmpdir);

    g_free(Ltmpdir);
  }

  return Lstatus ? TRUE : FALSE;
}

/* on efface le repertoire temporraire */
gboolean deltempdir(gchar *Ldirpath)
{
  gchar *Lfullname;
  DIR *Ldir;
  struct dirent *Lunfic;

  if (!Ldirpath || !*Ldirpath) return TRUE;

  Ldir = opendir(Ldirpath);
  if (!Ldir) {
    g_warning("erreur lors de l'ouverture de [%s]: %s\n", Ldirpath, strerror(errno));
    return FALSE;
  }

  while ((Lunfic = readdir(Ldir))) {
    if (!strcmp(Lunfic->d_name, ".") || !strcmp(Lunfic->d_name, "..")) continue;

    Lfullname = g_strdup_printf("%s/%s", Ldirpath, Lunfic->d_name);

    if (g_file_test(Lfullname, G_FILE_TEST_IS_DIR)) {
      /* on vide le repertoire avant */
      if (FALSE==deltempdir(Lfullname)) return FALSE;
    } else {
      if (unlink(Lfullname)==-1) {
        _WARN("erreur lors de la suppresion de [%s]\n", Lfullname);
      }
    }

    g_free(Lfullname);
  }

  closedir(Ldir);

  _DEB("on efface => %s\n", Ldirpath);
  if (rmdir(Ldirpath)==-1) {
    _WARN("erreur lors de la suppresion du repertoire [%s]: %s\n", Ldirpath, strerror(errno));
    return FALSE;
  }
_DEB("ok fin efface");
  return TRUE;
}

gboolean is_duplicate_drives(gchar *Abustype, gchar *Adev)
{
  gchar Lsearch[64];
  gint i;
  gchar *s;
  gchar Lcmpbuf[64];

  if (strcmp(Abustype, "ATAPI:")) return FALSE;

  g_snprintf(Lsearch, sizeof(Lsearch)-1, "ATA:%s", Adev);
  if ((s=strchr(Lsearch, ':'))) {
    while (g_ascii_isdigit(*(++s))==TRUE) *s='?';
  }

  for (i=0; i < Gnumdrives; i++) {
    g_strlcpy(Lcmpbuf, Gldrives[i].dev, sizeof(Lcmpbuf)-1);
    if ((s=strchr(Lcmpbuf, ':'))) {
      while (g_ascii_isdigit(*(++s))) *s='?';
    }

    if (!strcmp(Lsearch, Lcmpbuf)) return TRUE;
  }

  return FALSE;
}

/*
 * vim:et:ts=8:sts=2:sw=2
 */
