/* mp3.c
 * Copyright (C) 2004, 2005 Sylvain Cresto <sylvain.cresto@tiscali.fr>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://scresto.site.voite.fr/
 *
 */

#include "graveman.h"

#ifdef ENABLE_MP3
#include <id3tag.h>

/* utilisation de la libid3tag pour extraire les informations du fichier mp3
 * on utilise les tags pour en extraire le nom du morceau ainsi que la duree de la chanson,
 * si il n'y a pas de tag correspondant on n'aura donc pas la vraie duree ! */

static gchar *id3_getvalue(struct id3_tag *Atagfile, gchar *Atagname) {
  struct id3_frame *Lframe = id3_tag_findframe(Atagfile, Atagname, 0);
  union id3_field *Lfield;
  const id3_ucs4_t *Lcurval;

  if (!Lframe) return g_strdup("");

  Lfield = id3_frame_field(Lframe, 1);
  if (!Lfield) return g_strdup("");

  Lcurval = id3_field_getstrings(Lfield, 0);
  if (!Lfield) return g_strdup("");

  return id3_ucs4_utf8duplicate(Lcurval);
}

/* utilisation de libidmp3 pour recuperer les informations tel que le nom de l'alum et la longeur
 * ca ne marchera pour le moment qu'avec les tags ID3 v2, mais bon .. */
gboolean getMp3Info(gchar *Apath, gchar **Atitle, gchar **Aalbum, gchar **Aartist, guint32 *Alength, GError **Aerror)
{
  struct id3_file *Lfile;
  struct id3_tag *Ltagfile;
  gchar *Ltmplen;
  gchar *Lbuf = NULL;

  *(Atitle) = *(Aalbum) = *(Aartist) = NULL;
  *(Alength) = 0;

  if (!(Lfile = id3_file_open(Apath, ID3_FILE_MODE_READONLY))) {
    g_set_error(Aerror, G_FILE_ERROR, g_file_error_from_errno(errno), "%s:%s\n%s",
       _("Cannot read file"), Apath, strerror(errno));
    return FALSE;
  }

  if (!(Ltagfile = id3_file_tag(Lfile))) {
    /* le fichier n'a pas forcement de tag ... */
    return TRUE;
  }

  if ((Lbuf = id3_getvalue(Ltagfile, ID3_FRAME_TITLE))) { *(Atitle) = _UTF8(Lbuf); g_free(Lbuf); }
  if ((Lbuf = id3_getvalue(Ltagfile, ID3_FRAME_ALBUM))) { *(Aalbum) = _UTF8(Lbuf); g_free(Lbuf); }
  if ((Lbuf = id3_getvalue(Ltagfile, ID3_FRAME_ARTIST))) { *(Aartist) = _UTF8(Lbuf); g_free(Lbuf); }

  /* on essai TLEN (id3 v2.2 ou TLE sinon (id3 v2.0) */
  Ltmplen = id3_getvalue(Ltagfile, "TLEN");
  if (!*Ltmplen) {
    g_free(Ltmplen);
    Ltmplen = id3_getvalue(Ltagfile, "TLE");
  }
  if (Ltmplen) *(Alength) = (guint32)strtoul(Ltmplen, 0, 10) / 1000;
/*  if (Llentotal) {
    Llentotal /= 1000;
    Lmin = Llentotal / 60;
    Lsec = Llentotal - Lmin*60;
  }*/
  g_free(Ltmplen);
  
/*  *(Alength) = g_strdup_printf("%02d:%02d", Lmin, Lsec);*/

  id3_file_close(Lfile);

  return *(Alength) ? TRUE : FALSE;
}

#endif /* ifdef ENABLE_MP3 */
/*
 * vim:et:ts=8:sts=2:sw=2
 */
