/* tools.c
 * Copyright (C) 2004, 2005 Sylvain Cresto <sylvain.cresto@tiscali.fr>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://scresto.site.voite.fr/
 *
 */

#include "graveman.h"

char *ltrim(char *Abuf)
{
  char *s = Abuf;

  while (*s==' ' || *s==9) s++;	

  return s;
}

gchar *belleHeure(gchar *Abuf, gchar *Adst)
{
  gchar *s = Abuf;
  gchar *d = Adst; 
  gint len = 0;
  while (*s && len++<10) {
    if (isdigit(*s) || *s==':') {
      *(d++)=*(s++);
    } else {
      if (*s=='.') break;
      s++;
    }
  }
  *d=0;

  return Adst;
}

gint sc_strcountv(gchar **Aarray)
{
  gint i = 0;
  
  while (Aarray[i]) i++;
    
  return i;
}

void sc_strstripv(gchar **Aarray)
{
  gint i = 0;
  while (Aarray[i]) g_strstrip(Aarray[i++]);
}

gchar *sc_realloc_cat(gchar *Asep, gchar *Asrc, gchar *Aplus)
{
  gint Llensrc = Asrc ? strlen(Asrc) : 0;
  gint Llenplus = Aplus ? strlen(Aplus) : 0;
  gint Llensep = Aplus && Asep ? strlen(Asep) : 0;

  Asrc = g_realloc(Asrc, (Llensep + Llensrc + Llenplus + 1) * sizeof(gchar));

  if (Llensep)
    strcpy(Asrc + Llensrc, Asep);

  if (Llenplus)
    strcpy(Asrc + Llensrc + Llensep, Aplus);

  return Asrc;
}

gchar *get_combo_value(GtkWidget *Acombo)
{
  GtkTreeModel *Lmodel = gtk_combo_box_get_model(GTK_COMBO_BOX(Acombo));
  GtkTreeIter Liter;
  gchar *Lvalue = NULL;
  if (!gtk_combo_box_get_active_iter(GTK_COMBO_BOX(Acombo), &Liter)) return g_strdup("");

  gtk_tree_model_get(Lmodel, &Liter, 0, &Lvalue, -1);

  return Lvalue;
}

gint make_int(gchar *Abuf)
{
  return *Abuf + (Abuf[1] << 8) + (Abuf[2] << 16) + (Abuf[3] << 24);
}

gshort make_short(gchar *Abuf)
{
  return *Abuf + (Abuf[1] << 8);
}

/* format un nombre en chaine de la forme MM:SS */
gchar *format_length(guint32 Alennbr)
{
   guint Lmin = 0, Lsec = 0;

   Lmin = Alennbr / 60;
   if (Lmin>0) Lsec = Alennbr - (Lmin * 60);

   return g_strdup_printf("%02d:%02d", Lmin, Lsec);
}

/* format un nombre en taille de la forme XX Mo ou XX Ko oo XX octets */
gchar *format_size(guint32 Asize)
{
  guint32 Lko = Asize / 1024;
  gdouble Lreste;
  guint32 Lmo;

  if (Lko < 1) return g_strdup_printf("%d %s", Asize, Asize > 1 ? _("octets") : _("octet"));
  Lmo = Lko / 1024;

  if (Lmo < 1) {
    if (Asize - (Lko * 1024) > 511) Lko++;
    return g_strdup_printf(_("%d K"), Lko);
  }

  Lreste = (Lko - (Lmo * 1024));
  Lreste = Lreste / 1024;
  if (Lreste > 0 && Lreste < 1) {
    return g_strdup_printf(_("%d.%.0f MB"), Lmo, Lreste * 10);
  } else {
    return g_strdup_printf(_("%d MB"), Lmo);
  }
}

gboolean sc_str_has_casesuffix(gchar *Astr, gchar *Asuffix)
{
  gchar *Lpos;
  gchar *Lupsuffix = Asuffix;

  if (!*Astr || !*Asuffix || strlen(Asuffix)>strlen(Astr)) return FALSE;

  Lpos = Astr + (strlen(Astr) - strlen(Asuffix));

  while (*Lpos) {
    if (g_ascii_toupper(*(Lpos)++) != g_ascii_toupper(*(Lupsuffix)++)) return FALSE;
  } 
  
  return TRUE;
}

gpointer sc_hash_table_lookupv(GHashTable *Ahash, gchar *Akeyformat, ...)
{
  va_list Largs;
  gchar *Lkey;
  gpointer Lreturn;

  va_start(Largs, Akeyformat);
  Lkey = g_strdup_vprintf(Akeyformat, Largs);
  va_end(Largs);
  Lreturn = g_hash_table_lookup(Ahash, Lkey);
  
  g_free(Lkey);
  return Lreturn;
}

GtkWidget *sc_glade_xml_get_widgetv(GladeXML *Axml, const gchar *Akeyformat, ...) 
{
  va_list Largs;
  gchar *Lkey;
  GtkWidget *Lreturn;

  va_start(Largs, Akeyformat);
  Lkey = g_strdup_vprintf(Akeyformat, Largs);
  va_end(Largs);
  Lreturn = glade_xml_get_widget(Axml, Lkey);
  g_free(Lkey);

  return Lreturn;
}

gchar *sc_get_filename(gchar *Afilename)
{
  gchar *Ltmp = _FILENAME(Afilename);
  gchar *Lreturn = g_strescape(Ltmp, NULL);
  g_free(Ltmp);

  return Lreturn;
}

void sc_line_data_copy(GtkTreeModel *Amodel, GtkTreeIter *Aiterde, GtkTreeIter *Aitervers);
void sc_line_data_copy(GtkTreeModel *Amodel, GtkTreeIter *Aiterde, GtkTreeIter *Aitervers)
{
  gint Ltype;
  GdkPixbuf *Limg;
  gchar *Lstr1, *Lstr2, *Lstr3;
  guint Lsize;
  GtkTreeIter Lcuriter;
  
  gtk_tree_model_get(Amodel, Aiterde, 0, &Ltype, 1, &Limg, 2, &Lstr1, 3, &Lstr2, 4, &Lstr3, 5, &Lsize, -1);
  gtk_tree_store_set(GTK_TREE_STORE(Amodel), Aitervers, 0, Ltype, 1, Limg, 2, Lstr1, 3, Lstr2, 4, Lstr3, 5, Lsize, -1);

  g_free(Lstr1); g_free(Lstr2); g_free(Lstr3);
  g_object_unref(Limg);

  if (Ltype != TYPE_DIR) return;
  if (gtk_tree_model_iter_children(Amodel, &Lcuriter, Aiterde)) {
    GtkTreeIter Lnewiter;
    do {
      gtk_tree_store_append(GTK_TREE_STORE(Amodel), &Lnewiter, Aitervers); 
      sc_line_data_copy(Amodel, &Lcuriter, &Lnewiter);
    } while (gtk_tree_model_iter_next(Amodel, &Lcuriter));
  }
}

/* comparer une chaine avec gestion des caracteres jokers * et ? */

gboolean sc_str_match(gchar *Lpattern, gchar *Lstr);
gboolean sc_str_match(gchar *Lpattern, gchar *Lstr)
{
	gchar c;
	gchar *s;
  if (!Lpattern || !*Lpattern || !Lstr || !*Lstr) return FALSE;

	while (1) {
		switch (c = *Lpattern++) {
			case 0:
				if (!*Lstr) return TRUE;
				return FALSE;
			case '?':
				if (!*Lstr) return FALSE;
				Lstr++;
        break;
			case '*':
				if (!*Lpattern) return TRUE;
				s = Lstr;
        while (*s) {
					if ((*s == *Lpattern) && sc_str_match(Lpattern, s)) return TRUE;
			  	s++;
				}
        break;
      default:
        if (*Lstr++ != c) return FALSE;
        break;
    }
	}
}

/* vim:et:ts=8:sts=2:sw=2 */
