/* grdesktop - gtk rdesktop frontend
 * Copyright (C) 2002 Thorsten Sauter <tsauter@gmx.net>
 *
 * $grdesktop: grdesktop/src/run.c,v 1.31 2003/11/07 12:41:20 tsauter Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


#include "run.h"

void run_rdesktop() {
	gchar *cmd, *filename;

	if(child_pid != 0) {	/* stop, if we're already running */
		g_warning("Hmm. we should not enter here!");
		return;
	}

	gtk_widget_hide(image_normal);
	gtk_widget_show(image_process);
	gtk_widget_set_sensitive(connect_btn, FALSE);
	gtk_widget_set_sensitive(cancel_btn, FALSE);

	/* create the command string */
	cmd = g_strconcat(g_strdup_printf("%s ",
		COMMANDLINE), NULL);
	if(iSHASH("rdp_protocol") < 1) {
		cmd = g_strconcat(cmd, g_strdup_printf("-4 "), NULL);
	} else {
		cmd = g_strconcat(cmd, g_strdup_printf("-5 "), NULL);
	}
	if(SHASH("username"))
		cmd = g_strconcat(cmd, g_strdup_printf("-u '%s' ",
			SHASH("username")), NULL);
	if(SHASH("password"))
		cmd = g_strconcat(cmd, g_strdup_printf("-p '%s' ",
			SHASH("password")), NULL);
	if(SHASH("domain"))
		cmd = g_strconcat(cmd, g_strdup_printf("-d '%s' ",
			SHASH("domain")), NULL);
	if(SHASH("clientname") && (strlen(SHASH("clientname")) > 0))
		cmd = g_strconcat(cmd, g_strdup_printf("-n '%s' ",
			SHASH("clientname")), NULL);
	if(SHASH("geometry"))
		cmd = g_strconcat(cmd, screenCommand(), NULL);
	if(iSHASH("rdp_protocol") > 0) { /* disable, it's not supported by the RDP version */
		if(iSHASH("colorsize"))
			cmd = g_strconcat(cmd, colorCommand(), NULL);
	}
	if(SHASH("keymap"))
		cmd = g_strconcat(cmd, keymapCommand(), NULL);
	if((iSHASH("runprog")) && (SHASH("program")))
		cmd = g_strconcat(cmd, g_strdup_printf("-s '%s' ",
			SHASH("program")), NULL);
	if((iSHASH("runprog")) && (SHASH("ppath")))
		cmd = g_strconcat(cmd, g_strdup_printf("-c '%s' ",
			SHASH("ppath")), NULL);
	if(iSHASH("bitmapupd"))
		cmd = g_strconcat(cmd, g_strdup("-b "), NULL);
	if(iSHASH("motionevt"))
		cmd = g_strconcat(cmd, g_strdup("-m "), NULL);
	if(iSHASH("hidewmdecoration") == TRUE)
		cmd = g_strconcat(cmd, g_strdup("-D "), NULL);
	if(iSHASH("noencryption") == TRUE)
		cmd = g_strconcat(cmd, g_strdup("-e "), NULL);
	if(iSHASH("wmkeybindings") == TRUE)
		cmd = g_strconcat(cmd, g_strdup("-K "), NULL);
	if(iSHASH("rdp_protocol") > 0) { /* disable, it's not supported by the RDP version */
		if(iSHASH("attconsole") == TRUE)
			cmd = g_strconcat(cmd, g_strdup("-0 "), NULL);
	}
	if(SHASH("hostname"))
		cmd = g_strconcat(cmd, g_strdup_printf("-T 'grdesktop: %s' ",
			SHASH("hostname")), NULL);
	cmd = g_strconcat(cmd, g_strdup(SHASH("hostname")), NULL);

#ifdef _DEBUG_
	g_warning(cmd);
#endif

	/* first flush the gtk queue */
	while(gtk_events_pending())
		gtk_main_iteration();

	/* fork and start the rdesktop app */
	child_pid = fork();
	if(child_pid == 0) {
		gint ret;

#ifdef _DEBUG_
		g_warning("Starting rdesktop thread...");
#endif

		filename = g_strdup_printf("/tmp/grdesktop-%d.log", getpid());
		ret = system(g_strdup_printf("%s 1>%s 2>&1", cmd, filename));
#ifdef _DEBUG_
		g_warning("rdesktop returned: %d", ret);
		g_warning("Finished rdesktop thread");
#endif

		/* fix an error with return codes from rdesktop */
#ifdef _DEBUG_
		g_warning("Trying to exit with %d", ret);
#endif
		if(ret <= 255)
			_exit(ret);
		_exit(255);
	}

	/* unhide the main windows */
	gtk_widget_hide(window_main);
#ifdef _DEBUG_
	g_warning("Hiding window!");
#endif

}

void sig_child() {
	pid_t pid;
	gint state;
	gchar *filename;

	while((pid = waitpid(-1, &state, WNOHANG)) > 0) {
#ifdef _DEBUG_
		g_warning("Got SIGCHLD signal: %d", pid);
#endif

		child_pid = 0;		/* reset the child pid */

#ifdef _DEBUG_
		g_warning("Unhide main window!");
#endif
		gtk_widget_show(image_normal);
		gtk_widget_hide(image_process);
		gtk_widget_set_sensitive(connect_btn, TRUE);
		gtk_widget_set_sensitive(cancel_btn, TRUE);
		gtk_widget_show(window_main);

		/* print error dialog of needed */
		if(WIFEXITED(state) != 0) {
			if(WEXITSTATUS(state) != 0) {
				g_warning("rdesktop-Child exited with: %d", WEXITSTATUS(state));
			}
		} else {
			gnome_error_dialog(_("rdesktop exited abnormal!"));
		}

		/* delete the existing logfile */
		filename = g_strdup_printf("/tmp/grdesktop-%d.log", pid);
		if(g_file_test(filename, G_FILE_TEST_EXISTS|G_FILE_TEST_IS_REGULAR)) {
#ifdef _DEBUG_
			g_warning("Deleting logfile: %s", filename);
#endif
			if(unlink(filename) != 0)
				g_warning(_("Unable to delete logfile: %s"), filename);
		}

#ifdef _DEBUG_
		g_warning("Save and reload options");
#endif
		loadServers();		/* make sure, we reload the available servers from other clients */
		if(saveServers(SHASH("hostname")) == 0) {
			loadServers();
			gtk_combo_set_popdown_strings(GTK_COMBO(combo_host), hostnames);
			gtk_combo_set_popdown_strings(GTK_COMBO(combo_host2), hostnames);
		}
		saveOptions();
	}
}

