/*
 *  grotto - a roguelike RPG
 *  Copyright (C) 2006 Tobias Heinzen
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
 
#ifndef CHARACTER_HPP
#define CHARACTER_HPP

#include <ncurses.h>
#include <string.h>
#include "tuple.h"
#include "inventory.hpp"
#include "box.hpp" 
#include "skill.h"
#include "map.hpp"

#define	CWINDOW_WIDTH	50
#define CWINDOW_HEIGHT	15

#define BAR_WIDTH		23

#define SKILL_STRENGTH		1
#define SKILL_INTELLIGENCE	2
#define SKILL_ATTACK		3
#define SKILL_MAGIC_OFF		4
#define SKILL_MAGIC_DEF		5

#define ATTACK	1
#define HEAL	2

#define BASE_HEAL	5
#define BASE_MAGIC	5
#define BASE_ATTACK	3

#define COST_MAGIC	1
#define COST_HEAL	2

class CHARACTER
{
	protected:
		void create_bar( struct SKILL skill,char bar[] );
		
	private:
		struct SKILL strength;
		struct SKILL intelligence;
		char *skill_out( struct SKILL skill );
		void recalibrate_hp_and_mp();
		
	public:
		INVENTORY inventory;
		int  dungeon_level;

		struct SKILL hp;
		struct SKILL mp;

		struct SKILL attack;
		struct SKILL magic_offensive;
		struct SKILL magic_defensive;
				
		char *hp_out(); char *mp_out();
		void show();
		void init();
		void update_life( int modifier ); void update_mana( int modifier );
		void fill_hp(); void fill_mp();
		int physical_dmg(); int magical_dmg(); int healing();
		bool has_enough_mana( int magic_action );
		bool is_dead();
		int mana_cost( int action );
		int powerindex();
		
		void learn_skill( int skill );
};

#endif
