/*
 *  grotto - a roguelike RPG
 *  Copyright (C) 2006 Tobias Heinzen
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <stdio.h>

template <typename T, size_t N>
char ( &_ArraySizeHelper( T (&array)[N] ))[N];
#define countof( array ) (sizeof( _ArraySizeHelper( array ) ))

#ifdef GAME_MESSAGES
	char *msg_potion[] = { "You've found a potion flask" };
	char *msg_aether[] = { "You've found a aether flash" };
	char *msg_map[]    = { "Hidden on the floor you found a","piece of a dirty and old map!" };	
	char *msg_use_potion[] = { "The potion flask refills your health!" };
	char *msg_use_aether[] = { "The aether flask refills your mana!" };
#endif

#ifdef FIGHT_MENUES
	char *menu_fight[] = { "Attack!","Magic!","Heal!" };
	#define MENU_FIGHT_ATTACK	1
	#define MENU_FIGHT_MAGIC	2
	#define MENU_FIGHT_HEAL		3
#endif

#ifdef FIGHT_MESSAGES
	char *msg_mana[] = { "Not enough Mana!" };
#endif

#ifdef SELLER_MENUES
	char *menu_seller[] = { "Buy Potion","Buy Aether","Sell Potion","Sell Aether","That's All" };
	#define MENU_SELLER_BPOTION	1
	#define MENU_SELLER_BAETHER 2
	#define MENU_SELLER_SPOTION 3
	#define MENU_SELLER_SAETHER	4
	#define MENU_SELLER_EXIT	5
#endif

#ifdef TRAINER_MENUES
	char *menu_trainer[] = { "Upgrade Weapon","Learn Magic","HP up","MP up","That's it" };
	#define MENU_TRAINER_WEAPON	1
	#define MENU_TRAINER_MAGIC	2
	#define MENU_TRAINER_HP		3
	#define MENU_TRAINER_MP		4
	#define MENU_TRAINER_EXIT	5
#endif

#ifdef WIZARD_MESSAGES
	char *msg_heal[] =  { "I see you have traveled far to see me.","Let me heal your wounds. Relax and","feel the power returning into your body." };
#endif
