/*
 *  grotto - a roguelike RPG
 *  Copyright (C) 2006 Tobias Heinzen
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
 
#include "headers/inventory.hpp"

void INVENTORY::show()
{
	struct TUPLE max; getmaxyx( stdscr,max.y,max.x ); BOX box;
	WINDOW *win = box.create( IWINDOW_WIDTH,IWINDOW_HEIGHT,max.x/2-IWINDOW_WIDTH/2,max.y/2-IWINDOW_HEIGHT/2 );

	mvwprintw( win,1,2,"potion flasks:\t%d",this->potions );
	mvwprintw( win,2,2,"aether flasks:\t%d",this->aethers );
	mvwprintw( win,3,2,"gold:\t\t\t%d",this->gold );	
	mvwprintw( win,IWINDOW_HEIGHT-2,10,"<< press space to continue >>" );

	box.show();
}

void INVENTORY::init()
{
	this->potions = 2; this->aethers = 2; this->gold = 0; 
}

void INVENTORY::potion_update( int modifier )
{
	this->potions += modifier;	
}

void INVENTORY::aether_update( int modifier )
{
	this->aethers += modifier;	
}

void INVENTORY::gold_update( int modifier )
{
	this->gold += modifier;	
}

bool INVENTORY::has_aether()
{
	if( this->aethers <= 0 )
		return false;
	return true;	
}

bool INVENTORY::has_potion()
{
	if( this->potions <= 0 )
		return false;
	return true;	
}
