/*
 *  grotto - a roguelike RPG
 *  Copyright (C) 2006 Tobias Heinzen
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
 
#include <ncurses.h>
#include <time.h>
#include "headers/game.hpp"

int main( int argc,char *argv[] )
{	
	time_t t; time( &t ); srand( t );
	initscr(); clear(); noecho(); cbreak();
	keypad( stdscr,TRUE ); curs_set( 0 ); start_color(); nodelay( stdscr,1 );
	
	init_pair( 1,COLOR_YELLOW,COLOR_BLACK );

	mvprintw( 5,15, " ______  ______  _____  _______ _______  _____"   );
	mvprintw( 6,15, "|  ____ |_____/ |     |    |       |    |     |"  );
	mvprintw( 7,15, "|_____| |    \\_ |_____|    |       |    |_____|" );
	mvprintw( 11,15,"            press space to begin"                 );
	while( getch() != ' ' ); 
		
	GAME game;
	game.mainloop();
		
	endwin(); return 0;
}
