/*
 *  grotto - a roguelike RPG
 *  Copyright (C) 2006 Tobias Heinzen
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
 
#include "headers/map.hpp"

bool MAP::accessable( int x,int y,char map[] )
{
	if( this->player.x == x && this->player.y == y ) return true;
	if( map[x+y*MAP_WIDTH] != TILE_FLOOR ) return false;
	map[x+y*MAP_WIDTH] = '0';
	if( this->accessable( x-1,y,map ) || this->accessable( x+1,y,map ) || this->accessable( x,y-1,map ) || this->accessable( x,y+1,map ) ) return true;
	return false;		
}

struct TUPLE MAP::put_object( char object )
{
	struct TUPLE result;
	while( 1 )
	{
		int x = RANDOM( 1,MAP_WIDTH ),y = RANDOM( 1,MAP_HEIGHT );
		if( MAP( x,y ) == TILE_FLOOR )
		{
			result.x = x; result.y = y; MAP( x,y ) = object;
			break;	
		}
	}
	return result;
}

void MAP::generate()
{
 memset( this->field,TILE_VOID,MAP_WIDTH*MAP_HEIGHT );
 int minsizex = (int)(MAP_WIDTH  / 10 )<2 ? ((int)(MAP_WIDTH  / 5)<4 ? 4 : 2) : (int)(MAP_WIDTH  / 10);
 int minsizey = (int)(MAP_HEIGHT / 10 )<2 ? ((int)(MAP_HEIGHT / 5)<4 ? 4 : 2) : (int)(MAP_HEIGHT / 10);
 int maxsizex = (int)(MAP_WIDTH  / 5);
 int maxsizey = (int)(MAP_HEIGHT / 5);
 for( int i=1;i<(MAP_WIDTH+MAP_HEIGHT)/2;i++ )
 {
 	int rx = RANDOM( minsizex,maxsizex );
 	int ry = RANDOM( minsizey,maxsizey );
 	int cx = RANDOM( 2,MAP_WIDTH-rx  );
 	int cy = RANDOM( 2,MAP_HEIGHT-ry );
 	for( int tx=cx;tx<(cx+rx);tx++ )
 		for( int ty=cy;ty<(cy+ry);ty++ )
 			MAP( tx,ty ) = TILE_FLOOR;	
 }
 
 this->player = this->put_object( TILE_PLAYER );
 
 for( int x=1;x<MAP_WIDTH;x++ )
 	for( int y=1;y<MAP_HEIGHT;y++ )
 	{
 		char map[ MAP_WIDTH*MAP_HEIGHT ]; memcpy( map,this->field,MAP_WIDTH*MAP_HEIGHT );
 		MAP( x,y ) = !this->accessable( x,y,map ) ? TILE_VOID : MAP( x,y );
 	}
 	
 for( int x=1;x<MAP_WIDTH;x++ )
 	for( int y=1;y<MAP_HEIGHT;y++ )
 	{
 		MAP( x,y ) = ((MAP( x+1,y ) == TILE_FLOOR || MAP( x+1,y ) == TILE_PLAYER) && MAP( x,y ) == TILE_VOID) ? TILE_WALL : MAP( x,y );
 		MAP( x,y ) = ((MAP( x-1,y ) == TILE_FLOOR || MAP( x-1,y ) == TILE_PLAYER) && MAP( x,y ) == TILE_VOID) ? TILE_WALL : MAP( x,y );
 		MAP( x,y ) = ((MAP( x,(y+1) ) == TILE_FLOOR || MAP( x,(y+1) ) == TILE_PLAYER) && MAP( x,y ) == TILE_VOID) ? TILE_WALL : MAP( x,y );
 		MAP( x,y ) = ((MAP( x,(y-1) ) == TILE_FLOOR || MAP( x,(y-1) ) == TILE_PLAYER) && MAP( x,y ) == TILE_VOID) ? TILE_WALL : MAP( x,y );
 	}
}

char MAP::get_tile( int position )
{
	return this->field[ position ];	
}

struct TUPLE MAP::get_player()
{
	return this->player;	
}

struct TUPLE MAP::set_player( int x,int y )
{
	MAP( player.x,player.y ) = TILE_FLOOR;
	this->player.x = x; this->player.y = y;
	MAP( player.x,player.y ) = TILE_PLAYER;	
	return this->player;
}

void MAP::draw()
{
	int x,y;
	for( y=x=0;y<MAP_HEIGHT;x=(x+1)%MAP_WIDTH,y+=x==0 )
	{	
		if( this->player.x == x && this->player.y == y ) attron( COLOR_PAIR(1) );
		mvaddch( y,x,MAP(x,y) );
		attroff( COLOR_PAIR(1) );
	}
}
