/*
 *  grotto - a roguelike RPG
 *  Copyright (C) 2006 Tobias Heinzen
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
 
#include "headers/messagebox.hpp"

void MESSAGEBOX::add_line( char *line )
{
	LIST<char *> *temp = &(this->messages);
	while( 1 )
	{
		if( temp->next == NULL ) break;
		temp = temp->next;
	}
	temp->next = new LIST<char *>;
	temp->next->item = line;	
}

void MESSAGEBOX::show()
{
	struct TUPLE max; getmaxyx( stdscr,max.y,max.x ); BOX box;
	WINDOW *win = box.create( MWINDOW_WIDTH,MWINDOW_HEIGHT,max.x/2-MWINDOW_WIDTH/2,max.y/2-MWINDOW_HEIGHT/2 );
	LIST<char *> *temp = &( this->messages );

	while( 1 )
	{
		wclear( win );
		if( temp->next == NULL ) break;
		for( int i=0;i<MWINDOW_HEIGHT-4;++i )
			if( temp->next != NULL )
			{
				temp = temp->next;
				mvwprintw( win,1+i,2,temp->item );	
			}
		mvwprintw( win,MWINDOW_HEIGHT-2,10,"<< press space to continue >>" );
		box.show();
	}
}

void MESSAGEBOX::create( char *message[],int count=1 )
{
	for( int i=0;i<count;++i )
		this->add_line( message[i] );
}

void MESSAGEBOX::clear()
{
	this->messages.next = 0;	
}
