/*
 *  grotto - a roguelike RPG
 *  Copyright (C) 2006 Tobias Heinzen
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
 
#define SELLER_MENUES
#include "headers/lang.h"
#include "headers/seller.hpp"

void SELLER::loop()
{
	clear(); refresh(); MENU menu;

	// preparing menu
	menu.clear();
	for( int i=0;i<(int)countof( menu_seller );++i )
		menu.add_entry( menu_seller[i] );

	while( 1 )
	{	
		BOX box; WINDOW *win = box.create( 40,20,20,0 );
		
		mvwprintw( win,1,2,"Welcome stranger to my shop!" );
		mvwprintw( win,3,2,"I've got some good flasks here." );
		mvwprintw( win,4,6,"potion flask: %d gold",10 );
		mvwprintw( win,5,6,"aether flask: %d gold",10 );
		mvwprintw( win,7,2,"I will also buy the flasks from you," );
		mvwprintw( win,8,2,"if you got any." );
		mvwprintw( win,9,6,"potion flask: %d gold",5  );
		mvwprintw( win,10,6,"aether flask: %d gold",5 );
		mvwprintw( win,12,2,"You have " );
		mvwprintw( win,13,6,"%d potion flasks",this->player->inventory.potions );
		mvwprintw( win,14,6,"%d aether flasks",this->player->inventory.aethers );
		mvwprintw( win,15,6,"%d gold",this->player->inventory.gold );
		box.display();
		 
		menu.show();
		if( menu.selection == MENU_SELLER_BPOTION && this->player->inventory.gold >= 10 )
		{
			this->player->inventory.gold -= 10; this->player->inventory.potions++;	
		}		
		if( menu.selection == MENU_SELLER_BAETHER && this->player->inventory.gold >= 10 )
		{
			this->player->inventory.gold -= 10; this->player->inventory.aethers++;	
		}
		if( menu.selection == MENU_SELLER_SPOTION && this->player->inventory.potions > 0 )
		{
			this->player->inventory.gold += 5; this->player->inventory.potions--;	
		}
		if( menu.selection == MENU_SELLER_SAETHER && this->player->inventory.aethers > 0 )
		{
			this->player->inventory.gold += 5; this->player->inventory.aethers--;	
		}
		if( menu.selection == MENU_SELLER_EXIT ) break;
	}
}

void SELLER::init( CHARACTER *character )
{
	this->player = character;	
}
