/*
 *  grotto - a roguelike RPG
 *  Copyright (C) 2006 Tobias Heinzen
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
 
#define TRAINER_MENUES
#include "headers/lang.h"
#include "headers/trainer.hpp"

void TRAINER::loop()
{
	clear(); refresh(); MENU menu;
	
	// preparing menu
	menu.clear();
	for( int i=0;i<(int)countof( menu_trainer );++i )
		menu.add_entry( menu_trainer[i] );

	while( 1 )
	{
		BOX box; WINDOW *win = box.create( 40,20,20,0 );
			
		mvwprintw( win,1,2,"Welcome stranger! Here to train your" );
		mvwprintw( win,2,2,"muscles?" );
		mvwprintw( win,3,2,"But my services cost!" );
		mvwprintw( win,4,6,"upgrade weapon:\t%d gold",(this->player->attack.modifier+1)*50 );
		mvwprintw( win,5,6,"learn magic:\t%d gold",(this->player->magic_offensive.modifier+1)*50 );
		mvwprintw( win,6,6,"hp up:\t\t%d gold",(this->player->hp.modifier+1)*5 );
		mvwprintw( win,7,6,"mp up:\t\t%d gold",(this->player->mp.modifier+1)*5 );
		mvwprintw( win,12,2,"You have " );
		mvwprintw( win,13,6,"%d gold",this->player->inventory.gold );
		box.display();
	
		menu.show();
		if( menu.selection == MENU_TRAINER_WEAPON && this->player->inventory.gold >= (this->player->attack.modifier+1)*50 )
		{
			this->player->inventory.gold -= (this->player->attack.modifier+1)*50; this->player->attack.modifier++;	
		}
		if( menu.selection == MENU_TRAINER_MAGIC && this->player->inventory.gold >= (this->player->magic_offensive.modifier+1)*50 )
		{
			this->player->inventory.gold -= (this->player->magic_offensive.modifier+1)*50; 
			this->player->magic_offensive.modifier++; this->player->magic_defensive.modifier++;	
		}
		if( menu.selection == MENU_TRAINER_HP && this->player->inventory.gold >= (this->player->hp.modifier+1)*5 )
		{
			this->player->inventory.gold -= (this->player->hp.modifier+1)*5; this->player->hp.modifier++;	
		}
		if( menu.selection == MENU_TRAINER_MP && this->player->inventory.gold >= (this->player->mp.modifier+1)*5 )
		{
			this->player->inventory.gold -= (this->player->mp.modifier+1)*5; this->player->mp.modifier++;	
		}
		if( menu.selection == MENU_TRAINER_EXIT ) break;
	}
	this->player->learn_skill( 0 );
}

void TRAINER::init( CHARACTER *character )
{
	this->player = character;	
}
