/*
 * This file is part of Gterm.
 *
 * Gterm is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Foobar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Foobar; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "config.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>

#include <glib.h>
#include <gdk/gdk.h>
#include <pango/pango.h>

#include <glib/gi18n.h>

#include "settings.h"
#include "defaults.h"


struct Settings cfg; /* Terminal configuration */

/* FIXME: test */
int read_config (gchar *cfile)
{
  GKeyFile *cf;
  gchar *filename;
  struct stat buf;

  /* Set default switches */
  cfg.audible = TRUE;
  cfg.blink = TRUE;
  cfg.login = FALSE;
  cfg.keep = FALSE;
  cfg.sb = TRUE;

  /* Set default command */
  cfg.is_shell = TRUE;
  cfg.cmd = getenv ("SHELL");

  /* Set default colors */
  gdk_color_parse (FOREGROUND, &cfg.fore);
  gdk_color_parse (BACKGROUND, &cfg.back);
  gdk_color_parse (CURSOR, &cfg.cursor);
  cfg.palette = NULL;
  cfg.palsize = 0;

  /* Set default misc */
  cfg.wd = getenv ("HOME"); 
  cfg.locale = NULL;
  cfg.term = TERMINAL;
  cfg.title = _("Terminal");
  cfg.lines = LINES;
  cfg.font = NULL;
  cfg.width = WIDTH;
  cfg.height = HEIGHT;

  cfg.envs = g_hash_table_new (g_str_hash, g_str_equal);

#ifdef USE_MENU
  cfg.menu = NULL;
#endif

  if (cfile == NULL)
    filename = g_build_filename (g_get_user_config_dir (), "gterm", "config", NULL);
  else
    filename = g_strdup (cfile);

  /* Check if file exists */
  if (g_lstat (filename, &buf))
    {
      g_free (filename);
      filename = g_build_filename (g_get_user_config_dir (), "gterm", cfile, NULL);
      if (g_lstat (filename, &buf))
	{
	  g_free (filename);
	  return 1;
	}
    }

  /* Parse config */
  cf = g_key_file_new ();

  if (g_key_file_load_from_file (cf, filename, G_KEY_FILE_NONE, NULL))
    {
      /* Get common settings */
      if (g_key_file_has_group (cf, "Common"))
	{
	  if (g_key_file_has_key (cf, "Common", "Audible", NULL))
	    cfg.audible = g_key_file_get_boolean (cf, "Common", "Audible", NULL);
	  if (g_key_file_has_key (cf, "Common", "Blink", NULL))
	    cfg.blink = g_key_file_get_boolean (cf, "Common", "Blink", NULL);
	  if (g_key_file_has_key (cf, "Common", "Login", NULL))
	    cfg.login = g_key_file_get_boolean (cf, "Common", "Login", NULL);
	  if (g_key_file_has_key (cf, "Common", "Keep", NULL))
	    cfg.keep = g_key_file_get_boolean (cf, "Common", "Keep", NULL);
	  if (g_key_file_has_key (cf, "Common", "Lines", NULL))
	    cfg.lines = g_key_file_get_integer (cf, "Common", "Lines", NULL);
	  if (g_key_file_has_key (cf, "Common", "Scrollbar", NULL))
	    cfg.sb = g_key_file_get_boolean (cf, "Common", "Scrollbar", NULL);
	  if (g_key_file_has_key (cf, "Common", "Locale", NULL))
	    cfg.locale = g_key_file_get_string (cf, "Common", "Locale", NULL);
	  if (g_key_file_has_key (cf, "Common", "Term", NULL))
	    cfg.term = g_key_file_get_string (cf, "Common", "Term", NULL);
	  if (g_key_file_has_key (cf, "Common", "Title", NULL))
	    cfg.title = g_key_file_get_string (cf, "Common", "Title", NULL);
	  if (g_key_file_has_key (cf, "Common", "WorkDir", NULL))
	    cfg.wd = g_key_file_get_string (cf, "Common", "WorkDir", NULL);
	  if (g_key_file_has_key (cf, "Common", "Width", NULL))
	    cfg.width = g_key_file_get_integer (cf, "Common", "Width", NULL);
	  if (g_key_file_has_key (cf, "Common", "Height", NULL))
	    cfg.height = g_key_file_get_integer (cf, "Common", "Height", NULL);
	  if (g_key_file_has_key (cf, "Common", "Command", NULL))
	    {
	      cfg.is_shell = FALSE;
	      cfg.cmd = g_key_file_get_string (cf, "Common", "Command", NULL);
	    }
	}

      /* Get fonts settings */
      if (g_key_file_has_group (cf, "Fonts"))
	{
	  if (g_key_file_has_key (cf, "Fonts", "Font", NULL))
	    {
	      cfg.font = pango_font_description_from_string (g_key_file_get_string 
							      (cf, "Fonts", "Font", NULL));
	      if (cfg.font == NULL)
		cfg.font = pango_font_description_from_string (FONT);
	    }
	}

      /* Get main color settings */
      if (g_key_file_has_group (cf, "Colors"))
	{
	  if (g_key_file_has_key (cf, "Colors", "Fore", NULL))
	    gdk_color_parse (g_key_file_get_string (cf, "Colors", "Fore", NULL),
			     &cfg.fore);
	  if (g_key_file_has_key (cf, "Colors", "Back", NULL))
	    gdk_color_parse (g_key_file_get_string (cf, "Colors", "Back", NULL),
			     &cfg.back);
	  if (g_key_file_has_key (cf, "Colors", "Cursor", NULL))
	    gdk_color_parse (g_key_file_get_string (cf, "Colors", "Cursor", NULL),
			     &cfg.cursor);
	}

      /* Get color palette */
      if (g_key_file_has_group (cf, "Palette"))
	{
	  if (g_key_file_has_key (cf, "Palette", "Size", NULL))
	    {
	      cfg.palsize = g_key_file_get_integer (cf, "Palette", "Size", NULL);
	      if (cfg.palsize == 8 || cfg.palsize == 16 || cfg.palsize == 24 )
		{
		  gchar color[7];
		  int i;

		  cfg.palette = g_malloc (sizeof (GdkColor*) * cfg.palsize);
		  for (i = 0; i < cfg.palsize; i++)
		    {
		      sprintf (color, "Color%d", i); 
		      if (g_key_file_has_key (cf, "Palette", color, NULL))
			{
			  gdk_color_parse (g_key_file_get_string (cf, "Palette", color, NULL),
					   &cfg.palette[i]);
			}
		      else
			{
			  g_printerr (Q_("Color %s undefined\n"), color);
			  g_free (cfg.palette);
			  cfg.palette = NULL;
			  cfg.palsize = 0;
			  break;
			}
		    }
		}
	      else
		{
		  g_printerr (Q_("Wrong palette size\n"));
		  cfg.palsize = 0;
		}
	    }
	}

      /* Get list of enviromnet variables */
      if (g_key_file_has_group (cf, "Environment"))
	{
	  int l, i = 0;
	  gchar **keys = g_key_file_get_keys (cf, "Environment", NULL, NULL);

	  if (keys)
	    {
	      while (keys[i] != NULL)
		{
		  g_hash_table_insert (cfg.envs, keys[i], 
				       g_key_file_get_string (cf, "Environment", keys[i], NULL));
		  i++;
		}
	    }
	}

#ifdef USE_MENU
      if (g_key_file_has_group (cf, "Menus"))
	{
	}
#endif
    }

  g_free (filename);
  g_key_file_free (cf);

  return 0;
}
