/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef __GTK_USERGROUP_H_

#include <gdk/gdk.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

	
#define GTK_TYPE_USERGROUP          (gtk_usergroup_get_type ())
#define GTK_USERGROUP(obj)          GTK_CHECK_CAST (obj, gtk_usergroup_get_type (), GtkUserGroup)
#define GTK_USERGROUP_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gtk_usergroup_get_type (), GtkUserGroupClass)
#define IS_GTK_USERGROUP(obj)       GTK_CHECK_TYPE (obj, gtk_usergroup_get_type ())

	
typedef struct _GtkUserGroup      GtkUserGroup;
typedef struct _GtkUserGroupClass GtkUserGroupClass;

//
struct _GtkUserGroup
{
	GtkDialog dialog;
  
  	//GtkTreeStore *acl_tree;		//To show data of files
	
	
	/* Private */
	GtkWidget *validate_user_widget;
	void (*validate_user_function) (GtkWidget *, gpointer *);
	
	GtkWidget *validate_group_widget;
	void (*validate_group_function) (GtkWidget *, gpointer *);
	
	GtkListStore *list_users;
	GtkWidget    *view_users;
	
	GtkListStore *list_groups;
	GtkWidget    *view_groups;
	
		
	/* public */
	
	
};

struct _GtkUserGroupClass
{
	GtkDialogClass parent_class;

	void (* validate) (GtkUserGroup *gtk_usergroup);
};


GType    gtk_usergoup_get_type (void);
GtkWidget *gtk_usergroup_new     (void);	

//Add the Validate callback function 
void gtk_usergroup_set_validate_user(GtkUserGroup *gtk_usergroup, GtkWidget *widget,
	void *function);
void gtk_usergroup_set_validate_group(GtkUserGroup *gtk_usergroup, GtkWidget *widget,
	void *function);

void gtk_usergroup_hide_users(GtkUserGroup *gtk_usergroup);

#ifdef __cplusplus
}
#endif /* __cplusplus */
	
#endif

